#ifndef _XewText_h
#define _XewText_h
/*
** Copyright 1992-1995 by Markku Savela and
**	Technical Research Centre of Finland
*/

#include <X11/Xmu/Converters.h>
#include <X11/Xew/Basic.h>

/* Parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 alignment           XeAlignment        XeAlignment     XeAlignment_START
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 columnWidth         ColumnWidth	Dimension	0
 contentFile         ContentFile        String          NULL
 contentLength       ContentLength      long            Computed from content
 contentOffset       ContentOffset      long            0
 contentStream       ContentStream      FILE *          NULL
 contentString       ContentString      Pointer         NULL
 cursor              Cursor             Cursor          None
 destroyCallback     Callback		Pointer		NULL
 exportFormat        ExportFormat       XeTextExport    XeTextExport_ODIF
 firstLineOffset     Offset             int             0
 fonts               XeFonts            XeFont *        NULL
 format              Format             Boolean         False
 frameBottomRendition FrameRendition    XeFrameBorder   1-pixel solid line
 frameBottomContrast FrameBottomContrast int            40
 frameLeftRendition  FrameRendition     XeFrameBorder   1-pixel solid line
 frameRightRendition FrameRendition     XeFrameBorder   1-pixel solid line
 frameTopContrast    FrameTopContrast   int             20
 frameTopRendition   FrameRendition     XeFrameBorder   1-pixel solid line
 graphicRendition    Rendition          String          NULL
 height		     Height		Dimension	0
 indentation         Offset             Dimension       0
 initialState        Sequence           String          NULL
 itemization         Itemization        XeItemization * NULL
 kerningOffset       KerningOffset      Dimension *     NULL
 layoutCallback      LayoutCallback     Pointer         NULL
 lineLayoutTable     LineLayoutTable    XeTabStop *     NULL
 lineSpacing         LineSpacing        Dimension       Computed from font
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 proportional        Proportional       Boolean         False
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0

*/

typedef enum 
    {
	XeAlignment_NONE = 0,
	XeAlignment_START = 1,
	XeAlignment_END = 2,
	XeAlignment_CENTER = 3,
	XeAlignment_JUSTIFIED = 4,
	XeAlignment_AROUND = 5,
	XeAlignment_START_FILL = 5,	/* == AROUND! */
	XeAlignment_END_FILL = 6,
	XeAlignment_CENTER_FILL = 7,
    } XeAlignment;

/*
** XeTextExport
**	Defines the valid values for the exportFormat resource. This
**	resource selects the format for the exported selections,
**	XeTextGetString and XeTextSaveAsFile. In selections, the formats
**	are mapped to target atoms
**
**		XeTextExport_STRING*	<-> STRING
**		XeTextExport_ODIF*	<-> COMPOUND_TEXT, STRING
**
**	If exportFormat is XeTextExport_STRING*, the widget will only
**	recognize STRING target; if XeTextExport_ODIF*, the widget will
**	recognize both STRING and COMPOUND_TEXT, and the ODIF variants
**	are returned as COMPOUND_TEXT.
**
**	The 'formatted' variants will include the line breaks caused
**	by possible word/line breaking algorithms. Source variant includes
**	only original "hard" line breaks. The 'formatted processable'
**	includes both source text and layout generated information
**	delimited by <SOS>..<ST> controls (as defined in ODA standard).
**
** NOTE: The numeric values have been designed (and are used) such that
**		value & 1 => include formatted information
**		value & 2 => produce ODIF (COMPOUND_TEXT)
**		value & 4 => produce ODIF <SOS> <ST> enclosings for layout
**				control functions
*/
typedef enum
    {
	XeTextExport_STRING = 0,	/* 0, Latin1 source text */
	XeTextExport_STRING_F = 1,	/* 1, Latin1 formatted text */
	XeTextExport_ODIF = 2,		/* 2, COMPOUND_TEXT source text */
	XeTextExport_ODIF_F = 3,	/* 3, COMPOUND_TEXT formatted text */
	XeTextExport_ODIF_FP = 7	/* 7, ODIF formatted processable */
    } XeTextExport;

#define XeTextExportFormatted(f) ((f)&1)
#define XeTextExportOdif(f) ((f)&2)

typedef struct XeFontListRec *XeFontList; /* Defined in TextFont.c */

typedef struct XeFont
    {
	int font_size;
	XeFontList font_list;
    } XeFont;

typedef struct XeItemization
    {
	int identifier_alignment;
	int identifier_start_offset;
	int identifier_end_offset;
    } XeItemization;

/*
** XeTabStop
**	XtNlineLayoutTable is a pointer to an array of XeTabStop. The
**	last entry of the array must have negative value as a tabulation
**	reference.
*/
typedef struct XeTabStop
    {
	int reference;
	int position;
	int alignment;
	char alignment_string[4]; /* Currently only 3 chars can be used */
    } XeTabStop;

/*
** XeTextInsertContext
**	(Defined in TextImport)
*/
typedef struct XeTextInsertContextRec *XeTextInsertContext;
/*
** XeTextTag
*/
typedef XtPointer XeTextTag;

/*
** XeTextLayoutCallbackData
**	is the data supplied for the callbacks generated by the
**	layout process. This callback is made via XtNlayoutCallback.
*/
typedef struct XeTextLayoutCallbackData
    {
	int reason;		/* == XeCR_LAYOUT_CHANGE_TAG ==
				** == XeCR_LAYOUT_BEGIN_LINE ==
				*/
	XeTextTag previous;	/* Previous tag value */
	XeTextTag current;	/* The new current tag value */
	XeTextInsertContext context; /* Insert context for the feed */
	int (*feed)		/* feed(context, string, length) */
		(
#if NeedFunctionPrototypes
		 XeTextInsertContext, char *, long
#endif
		 );
    } XeTextLayoutCallbackData;

/* New fields */
#define XtNalignment "alignment"
#define XtCAlignment "Alignment"
#define XtRXeAlignment "XeAlignment"
#define XtNexportFormat "exportFormat"
#define XtCExportFormat "ExportFormat"
#define XtRXeTextExport "XeTextExport"
#define XtNfonts "fonts"
#define XtCFonts "Fonts"
#define XtRXeFonts "XeFonts"
#define XtNfirstLineOffset "firstLineOffset"
#define XtCOffset "Offset"
#define XtNformat "format"
#define XtCFormat "Format"
#define XtNframedRendition "framedRendition"
#ifndef XtNinitialState
#define XtNinitialState "initialState"
#endif
#define XtCSequence "Sequence"
#define XtNgraphicRendition "graphicRendition"
#define XtCRendition "Rendition"
#define XtNitemization "itemization"
#define XtCItemization "Itemization"
#define XtRXeItemization "XeItemization"
#define XtNkerningOffset "kerningOffset"
#define XtCKerningOffset "KerningOffset"
#define XtRKerningOffset "XeKerningOffset"
#define XtNlineLayoutTable "lineLayoutTable"
#define XtCLineLayoutTable "LineLayoutTable"
#define XtRXeLineLayoutTable "XeLineLayoutTable"
#define XtNlineSpacing "lineSpacing"
#define XtCLineSpacing "LineSpacing"
#define XtNindentation "indentation"
#define XtCIndentation "Indentation"
#define XtNproportional "proportional"
#define XtCProportional "Proportional"
#define XtNcolumnWidth "columnWidth"
#define XtCColumnWidth "ColumnWidth"
#define XtNlayoutCallback "layoutCallback"
#define XtCLayoutCallback "LayoutCallback"

/* 'framed rendition' control */

#define XtNframeTopContrast "frameTopContrast"
#define XtCFrameTopContrast "FrameTopContrast"
#define XtNframeBottomContrast "frameBottomContrast"
#define XtCFrameBottomContrast "FrameBottomContrast"
#define XtNframeInvertShadow "frameInvertShadow"
#define XtCFrameInvertShadow "FrameInvertShadow"
#define XtNframeBottomRendition "frameBottomRendition"
#define XtNframeTopRendition "frameTopRendition"
#define XtNframeLeftRendition "frameLeftRendition"
#define XtNframeRightRendition "frameRightRendition"
#define XtCFrameRendition "FrameRendition"

/* Class record constants */

extern WidgetClass xeTextWidgetClass;

typedef struct _XeTextClassRec *XeTextWidgetClass;
typedef struct _XeTextRec      *XeTextWidget;

_XFUNCPROTOBEGIN
/*
** XeTextLayout
**	Run all of the widget content trough the layout process and
**	redisplay the new content.
*/
void XeTextLayout
	(
#if NeedFunctionPrototypes
	 Widget
#endif
	 );
_XFUNCPROTOEND
#endif


