/*
** RasterImport module for importing raster images into
** Xew internal format. This module is a generic switching
** point to different format specific import functions and
** is a place for common actions necessary for import.
**
** Copyright 1992,1993,1994 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xew/RasterP.h>
#include "ImageTools.h"
#include "RasterImport.h"
#include "RasterTIFF.h"
#include "RasterGIF.h"
#include "RasterJPEG.h"
#include "RasterPBM.h"
/* Start of addition made by barberjd (Jim Barber) 15th March 1994 */
#include "RasterRLE.h"
/* End of addition made by barberjd */


#include "bitmaps/Importfailure"

/*
** ImportFailImage
**	Just create a very simple place holder. THe only purpose of this
**	is to avoid the zero width/height termination of the application.
*/
static XeRawImage *ImportFailImage(w)
XeRasterWidget w;
    {
	XeRawImage *raw = _XeCreateRawImage(1);

	if (raw)
	    {
		raw->class = XeImageClass_BILEVEL;
		w->raster.raster_width = raw->width = Importfailure_width;
		w->raster.raster_height = raw->height = Importfailure_height;
		raw->invert_image = True;
		raw->lsbit_first = True;
		raw->samples_per_pixel = 1;
		raw->bits_per_sample = 1;
		raw->bits_per_component = 1;
		raw->bytes_per_line = (raw->width + 7) / 8;
		raw->data = Importfailure_bits;
		raw->channel[0].addr = raw->data;
		raw->channel[0].line = raw->bytes_per_line;
		raw->channel[0].inc = 1;
		raw->channel[0].w = raw->width;
		raw->channel[0].h = raw->height;
	    }
	return raw;
    }


void XeRasterImport(w)
XeRasterWidget w;
    {
	XeRasterImageCallbackData data;

	_XeDestroyRawImage(w->raster.raw_image);
	switch (w->basic.content_format)
	    {
	    case XeContentFormat_TIFF:
		w->raster.raw_image = XeImport_TIFF(w);
		break;
	    case XeContentFormat_GIF:
		w->raster.raw_image = XeImport_GIF(w);
		break;
	    case XeContentFormat_JPEG:
		w->raster.raw_image = XeImport_JPEG(w);
		break;
	    case XeContentFormat_PBM:
		w->raster.raw_image = XeImport_PBM(w);
		break;
/* Start of addition made by barberjd (Jim Barber) 15th March 1994 */
	    case XeContentFormat_RLE:
		w->raster.raw_image = XeImport_RLE(w);
		break;
/* End of addition made by barberjd */
	    default:
		/*
		** Give error message for all unsupported formats, except
		** for UNKNOWN (UNKNOWN can be used by applications to 
		** dynamically generate the image at callback).
		*/
		XeWidgetWarningMsg
			((Widget)w, "formatNotSupported",
			 "Raster widget does not support this format",
			 (String *)NULL, 0);
		/* Fall through to UNKNOWN */
	    case XeContentFormat_UNKNOWN:
		w->raster.raw_image = NULL;
		break;
	    }
	
	if (w->raster.raw_image)
	    {
		/* Just make width and height visible as resources */
		data.width = w->raster.raster_width =
			w->raster.raw_image->width;
		data.height = w->raster.raster_height =
			w->raster.raw_image->height;
	    }
	else
		data.width = data.height = 0; /* No Raw IMAGE! */
	data.reason = XeCR_RASTER_IMAGE;
	XtCallCallbackList
		((Widget)w, w->basic.notify_callbacks, (XtPointer)&data);
	if (!w->raster.raw_image)
		w->raster.raw_image = ImportFailImage(w);
    }

