#ifndef _XewFrameP_h
#define _XewFrameP_h
/*
** Copyright 1994 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <X11/Xew/BasicP.h>
#include <X11/Xew/Frame.h>
#include <X11/Xew/FrameSupport.h>
#ifdef USING_MOTIF_122
#include <Xm/ManagerP.h>
#endif

/*
** XeFrameLayoutInfo
**	an internal temporary structure to aid the computation
**	of the layout of the children (defined in Frame.c).
*/
typedef struct XeFrameLayoutInfoRec *XeFrameLayoutInfo;

typedef struct _XeFrameClassPart
    {
	int foo;
    } XeFrameClassPart;

typedef struct _XeFrameClassRec
    {
	CoreClassPart core_class;
	CompositeClassPart composite_class;
	ConstraintClassPart constraint_class;
#ifdef USING_MOTIF_122
        XmManagerClassPart manager_class;
#endif
	XeBasicClassPart basic_class;
	XeFrameClassPart frame_class;
    } XeFrameClassRec;

extern XeFrameClassRec xeFrameClassRec;

typedef struct
    {
	/* Resources */
	XeFrameBorderP border[4];	/* trailing, leading, right, left */
	XeFrameDimension dimension[2];	/* horizontal, vertical */
	int layout_path;		/* Allow only 0, 90, 180 or 270 */
	Boolean invert_shadow;		/* Invert shadow borders */
	int shadow_contrast[2];		/* top, bottom */
	XtCallbackList overflow_callbacks;

	/* Private state */

	GC gc;			/* For drawing borders */
	XeFrameBorderP line;	/* Indicate current parameters of the gc */
	XeFrameLayoutInfo layout_info;
    } XeFramePart;

typedef struct _XeFrameRec
    {
	CorePart core;
	CompositePart composite;
	ConstraintPart constraint;
#ifdef USING_MOTIF_122
        XmManagerPart  manager;
#endif
	XeBasicPart basic;
	XeFramePart frame;
    } XeFrameRec;

#endif

