/*
 * Copyright(c) 1992 Bell Communications Research, Inc. (Bellcore)
 *                        All rights reserved
 * Permission to use, copy, modify and distribute this material for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of Bellcore not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * Bellcore.
 *
 * BELLCORE MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL BELLCORE OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES RELAT-
 * ING TO THE SOFTWARE.
 */

#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xbae/Matrix.h>

/*
 * Dynamically expand the matrix when tabbing past the last row or column.
 */


void TraverseCB();

int
main(argc, argv)
int argc;
char *argv[];
{
    Widget toplevel, mw;
    XtAppContext app;
#ifdef USE_EDITRES
    extern void _XEditResCheckMessages();
#endif

    toplevel = XtVaAppInitialize(&app, "Dynamic",
				 NULL, 0,
				 &argc, argv,
				 NULL,
				 NULL);
#ifdef USE_EDITRES
    XtAddEventHandler( toplevel, (EventMask)0, True,
                       _XEditResCheckMessages, NULL);
#endif

    mw = XtVaCreateManagedWidget("mw",
				 xbaeMatrixWidgetClass,	toplevel,
				 NULL);
    XtAddCallback(mw, XmNtraverseCellCallback, TraverseCB, NULL);

    XtRealizeWidget(toplevel);
    XtAppMainLoop(app);
    /*NOTREACHED*/
    return 0;
}

/* ARGSUSED */
void
TraverseCB(w, client_data, call_data)
Widget w;
XtPointer client_data;
XbaeMatrixTraverseCellCallbackStruct *call_data;
{
    static XrmQuark QRight = NULLQUARK;
    static XrmQuark QDown = NULLQUARK;

    /*
     * Get the Quarks we care about
     */
    if (QRight == NULLQUARK) {
	QRight = XrmStringToQuark("Right");
	QDown = XrmStringToQuark("Down");
    }

    /*
     * If we are moving down, and we are at the last row, add a new row
     * and traverse to it.
     */
    if (call_data->qparam == QDown &&
	call_data->row == call_data->num_rows - 1) {
	XbaeMatrixAddRows(w, call_data->num_rows, NULL, NULL, NULL, 1);
	call_data->next_row = call_data->num_rows;
	call_data->next_column = call_data->column;
    }
    /*
     * If we are moving right, and we are at the last column, add a new column
     * and traverse to it.
     */
    else if (call_data->qparam == QRight &&
	call_data->column == call_data->num_columns - 1) {
	short width = 10;
	XbaeMatrixAddColumns(w, call_data->num_columns, NULL, NULL,
			     &width, NULL, NULL, NULL, NULL, 1);
	call_data->next_column = call_data->num_columns;
	call_data->next_row = call_data->row;
    }
}


