/* 
 * tkIntPlatStubs.c --
 *
 *	This file contains the wrapper functions for the platform dependent
 *	unsupported Tk API.
 *
 * Copyright (c) 1998-1999 by Scriptics Corporation.
 * All rights reserved.
 *
 * RCS: @(#) $Id: tkIntPlatStubs.c,v 1.2.2.1 1999/03/10 07:13:42 stanton Exp $
 */

#include "tkInt.h"
#include "tkPort.h"

#ifdef __WIN32__
#include "tkWinInt.h"
#endif

#include "tkIntPlatDecls.h"

/*
 * WARNING: This file is automatically generated by the tools/genStubs.tcl
 * script.  Any modifications to the function declarations below should be made
 * in the generic/tkInt.decls script.
 */

/* !BEGIN!: Do not edit below this line. */

/*
 * Exported stub functions:
 */

#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
/* Slot 0 */
void
TkCreateXEventSource()
{
    (tkIntPlatStubsPtr->tkCreateXEventSource)();
}

/* Slot 1 */
void
TkFreeWindowId(dispPtr, w)
    TkDisplay * dispPtr;
    Window w;
{
    (tkIntPlatStubsPtr->tkFreeWindowId)(dispPtr, w);
}

/* Slot 2 */
void
TkInitXId(dispPtr)
    TkDisplay * dispPtr;
{
    (tkIntPlatStubsPtr->tkInitXId)(dispPtr);
}

/* Slot 3 */
int
TkpCmapStressed(tkwin, colormap)
    Tk_Window tkwin;
    Colormap colormap;
{
    return (tkIntPlatStubsPtr->tkpCmapStressed)(tkwin, colormap);
}

/* Slot 4 */
void
TkpSync(display)
    Display * display;
{
    (tkIntPlatStubsPtr->tkpSync)(display);
}

/* Slot 5 */
Window
TkUnixContainerId(winPtr)
    TkWindow * winPtr;
{
    return (tkIntPlatStubsPtr->tkUnixContainerId)(winPtr);
}

/* Slot 6 */
int
TkUnixDoOneXEvent(timePtr)
    Tcl_Time * timePtr;
{
    return (tkIntPlatStubsPtr->tkUnixDoOneXEvent)(timePtr);
}

/* Slot 7 */
void
TkUnixSetMenubar(tkwin, menubar)
    Tk_Window tkwin;
    Tk_Window menubar;
{
    (tkIntPlatStubsPtr->tkUnixSetMenubar)(tkwin, menubar);
}

#endif /* UNIX */
#ifdef __WIN32__
/* Slot 0 */
char *
TkAlignImageData(image, alignment, bitOrder)
    XImage * image;
    int alignment;
    int bitOrder;
{
    return (tkIntPlatStubsPtr->tkAlignImageData)(image, alignment, bitOrder);
}

/* Slot 1 */
void
TkClipBox(rgn, rect_return)
    TkRegion rgn;
    XRectangle* rect_return;
{
    (tkIntPlatStubsPtr->tkClipBox)(rgn, rect_return);
}

/* Slot 2 */
TkRegion
TkCreateRegion()
{
    return (tkIntPlatStubsPtr->tkCreateRegion)();
}

/* Slot 3 */
void
TkDestroyRegion(rgn)
    TkRegion rgn;
{
    (tkIntPlatStubsPtr->tkDestroyRegion)(rgn);
}

/* Slot 4 */
void
TkGenerateActivateEvents(winPtr, active)
    TkWindow * winPtr;
    int active;
{
    (tkIntPlatStubsPtr->tkGenerateActivateEvents)(winPtr, active);
}

/* Slot 5 */
void
TkIntersectRegion(sra, srcb, dr_return)
    TkRegion sra;
    TkRegion srcb;
    TkRegion dr_return;
{
    (tkIntPlatStubsPtr->tkIntersectRegion)(sra, srcb, dr_return);
}

/* Slot 6 */
unsigned long
TkpGetMS()
{
    return (tkIntPlatStubsPtr->tkpGetMS)();
}

/* Slot 7 */
void
TkPointerDeadWindow(winPtr)
    TkWindow * winPtr;
{
    (tkIntPlatStubsPtr->tkPointerDeadWindow)(winPtr);
}

/* Slot 8 */
void
TkpPrintWindowId(buf, window)
    char * buf;
    Window window;
{
    (tkIntPlatStubsPtr->tkpPrintWindowId)(buf, window);
}

/* Slot 9 */
int
TkpScanWindowId(interp, string, idPtr)
    Tcl_Interp * interp;
    char * string;
    int * idPtr;
{
    return (tkIntPlatStubsPtr->tkpScanWindowId)(interp, string, idPtr);
}

/* Slot 10 */
void
TkpSetCapture(winPtr)
    TkWindow * winPtr;
{
    (tkIntPlatStubsPtr->tkpSetCapture)(winPtr);
}

/* Slot 11 */
void
TkpSetCursor(cursor)
    TkpCursor cursor;
{
    (tkIntPlatStubsPtr->tkpSetCursor)(cursor);
}

/* Slot 12 */
void
TkpWmSetState(winPtr, state)
    TkWindow * winPtr;
    int state;
{
    (tkIntPlatStubsPtr->tkpWmSetState)(winPtr, state);
}

/* Slot 13 */
int
TkRectInRegion(rgn, x, y, width, height)
    TkRegion rgn;
    int x;
    int y;
    unsigned int width;
    unsigned int height;
{
    return (tkIntPlatStubsPtr->tkRectInRegion)(rgn, x, y, width, height);
}

/* Slot 14 */
void
TkSetPixmapColormap(pixmap, colormap)
    Pixmap pixmap;
    Colormap colormap;
{
    (tkIntPlatStubsPtr->tkSetPixmapColormap)(pixmap, colormap);
}

/* Slot 15 */
void
TkSetRegion(display, gc, rgn)
    Display* display;
    GC gc;
    TkRegion rgn;
{
    (tkIntPlatStubsPtr->tkSetRegion)(display, gc, rgn);
}

/* Slot 16 */
void
TkUnionRectWithRegion(rect, src, dr_return)
    XRectangle* rect;
    TkRegion src;
    TkRegion dr_return;
{
    (tkIntPlatStubsPtr->tkUnionRectWithRegion)(rect, src, dr_return);
}

/* Slot 17 */
void
TkWinCancelMouseTimer()
{
    (tkIntPlatStubsPtr->tkWinCancelMouseTimer)();
}

/* Slot 18 */
void
TkWinClipboardRender(dispPtr, format)
    TkDisplay * dispPtr;
    UINT format;
{
    (tkIntPlatStubsPtr->tkWinClipboardRender)(dispPtr, format);
}

/* Slot 19 */
LRESULT
TkWinEmbeddedEventProc(hwnd, message, wParam, lParam)
    HWND hwnd;
    UINT message;
    WPARAM wParam;
    LPARAM lParam;
{
    return (tkIntPlatStubsPtr->tkWinEmbeddedEventProc)(hwnd, message, wParam, lParam);
}

/* Slot 20 */
void
TkWinFillRect(dc, x, y, width, height, pixel)
    HDC dc;
    int x;
    int y;
    int width;
    int height;
    int pixel;
{
    (tkIntPlatStubsPtr->tkWinFillRect)(dc, x, y, width, height, pixel);
}

/* Slot 21 */
COLORREF
TkWinGetBorderPixels(tkwin, border, which)
    Tk_Window tkwin;
    Tk_3DBorder border;
    int which;
{
    return (tkIntPlatStubsPtr->tkWinGetBorderPixels)(tkwin, border, which);
}

/* Slot 22 */
HDC
TkWinGetDrawableDC(display, d, state)
    Display * display;
    Drawable d;
    TkWinDCState* state;
{
    return (tkIntPlatStubsPtr->tkWinGetDrawableDC)(display, d, state);
}

/* Slot 23 */
int
TkWinGetModifierState()
{
    return (tkIntPlatStubsPtr->tkWinGetModifierState)();
}

/* Slot 24 */
HPALETTE
TkWinGetSystemPalette()
{
    return (tkIntPlatStubsPtr->tkWinGetSystemPalette)();
}

/* Slot 25 */
HWND
TkWinGetWrapperWindow(tkwin)
    Tk_Window tkwin;
{
    return (tkIntPlatStubsPtr->tkWinGetWrapperWindow)(tkwin);
}

/* Slot 26 */
int
TkWinHandleMenuEvent(phwnd, pMessage, pwParam, plParam, plResult)
    HWND * phwnd;
    UINT * pMessage;
    WPARAM * pwParam;
    LPARAM * plParam;
    LRESULT * plResult;
{
    return (tkIntPlatStubsPtr->tkWinHandleMenuEvent)(phwnd, pMessage, pwParam, plParam, plResult);
}

/* Slot 27 */
int
TkWinIndexOfColor(colorPtr)
    XColor * colorPtr;
{
    return (tkIntPlatStubsPtr->tkWinIndexOfColor)(colorPtr);
}

/* Slot 28 */
void
TkWinReleaseDrawableDC(d, hdc, state)
    Drawable d;
    HDC hdc;
    TkWinDCState* state;
{
    (tkIntPlatStubsPtr->tkWinReleaseDrawableDC)(d, hdc, state);
}

/* Slot 29 */
LRESULT
TkWinResendEvent(wndproc, hwnd, eventPtr)
    WNDPROC wndproc;
    HWND hwnd;
    XEvent * eventPtr;
{
    return (tkIntPlatStubsPtr->tkWinResendEvent)(wndproc, hwnd, eventPtr);
}

/* Slot 30 */
HPALETTE
TkWinSelectPalette(dc, colormap)
    HDC dc;
    Colormap colormap;
{
    return (tkIntPlatStubsPtr->tkWinSelectPalette)(dc, colormap);
}

/* Slot 31 */
void
TkWinSetMenu(tkwin, hMenu)
    Tk_Window tkwin;
    HMENU hMenu;
{
    (tkIntPlatStubsPtr->tkWinSetMenu)(tkwin, hMenu);
}

/* Slot 32 */
void
TkWinSetWindowPos(hwnd, siblingHwnd, pos)
    HWND hwnd;
    HWND siblingHwnd;
    int pos;
{
    (tkIntPlatStubsPtr->tkWinSetWindowPos)(hwnd, siblingHwnd, pos);
}

/* Slot 33 */
void
TkWinWmCleanup(hInstance)
    HINSTANCE hInstance;
{
    (tkIntPlatStubsPtr->tkWinWmCleanup)(hInstance);
}

/* Slot 34 */
void
TkWinXCleanup(hInstance)
    HINSTANCE hInstance;
{
    (tkIntPlatStubsPtr->tkWinXCleanup)(hInstance);
}

/* Slot 35 */
void
TkWinXInit(hInstance)
    HINSTANCE hInstance;
{
    (tkIntPlatStubsPtr->tkWinXInit)(hInstance);
}

/* Slot 36 */
void
TkWinSetForegroundWindow(winPtr)
    TkWindow * winPtr;
{
    (tkIntPlatStubsPtr->tkWinSetForegroundWindow)(winPtr);
}

/* Slot 37 */
void
TkWinDialogDebug(debug)
    int debug;
{
    (tkIntPlatStubsPtr->tkWinDialogDebug)(debug);
}

/* Slot 38 */
Tcl_Obj *
TkWinGetMenuSystemDefault(tkwin, dbName, className)
    Tk_Window tkwin;
    char * dbName;
    char * className;
{
    return (tkIntPlatStubsPtr->tkWinGetMenuSystemDefault)(tkwin, dbName, className);
}

/* Slot 39 */
int
TkWinGetPlatformId()
{
    return (tkIntPlatStubsPtr->tkWinGetPlatformId)();
}

#endif /* __WIN32__ */
#ifdef MAC_TCL
/* Slot 0 */
void
TkClipBox(rgn, rect_return)
    TkRegion rgn;
    XRectangle* rect_return;
{
    (tkIntPlatStubsPtr->tkClipBox)(rgn, rect_return);
}

/* Slot 1 */
TkRegion
TkCreateRegion()
{
    return (tkIntPlatStubsPtr->tkCreateRegion)();
}

/* Slot 2 */
void
TkDestroyRegion(rgn)
    TkRegion rgn;
{
    (tkIntPlatStubsPtr->tkDestroyRegion)(rgn);
}

/* Slot 3 */
void
TkGenerateActivateEvents(winPtr, active)
    TkWindow * winPtr;
    int active;
{
    (tkIntPlatStubsPtr->tkGenerateActivateEvents)(winPtr, active);
}

/* Slot 4 */
void
TkIntersectRegion(sra, srcb, dr_return)
    TkRegion sra;
    TkRegion srcb;
    TkRegion dr_return;
{
    (tkIntPlatStubsPtr->tkIntersectRegion)(sra, srcb, dr_return);
}

/* Slot 5 */
Pixmap
TkpCreateNativeBitmap(display, source)
    Display * display;
    char * source;
{
    return (tkIntPlatStubsPtr->tkpCreateNativeBitmap)(display, source);
}

/* Slot 6 */
void
TkpDefineNativeBitmaps()
{
    (tkIntPlatStubsPtr->tkpDefineNativeBitmaps)();
}

/* Slot 7 */
unsigned long
TkpGetMS()
{
    return (tkIntPlatStubsPtr->tkpGetMS)();
}

/* Slot 8 */
Pixmap
TkpGetNativeAppBitmap(display, name, width, height)
    Display * display;
    char * name;
    int * width;
    int * height;
{
    return (tkIntPlatStubsPtr->tkpGetNativeAppBitmap)(display, name, width, height);
}

/* Slot 9 */
void
TkPointerDeadWindow(winPtr)
    TkWindow * winPtr;
{
    (tkIntPlatStubsPtr->tkPointerDeadWindow)(winPtr);
}

/* Slot 10 */
void
TkpSetCapture(winPtr)
    TkWindow * winPtr;
{
    (tkIntPlatStubsPtr->tkpSetCapture)(winPtr);
}

/* Slot 11 */
void
TkpSetCursor(cursor)
    TkpCursor cursor;
{
    (tkIntPlatStubsPtr->tkpSetCursor)(cursor);
}

/* Slot 12 */
void
TkpWmSetState(winPtr, state)
    TkWindow * winPtr;
    int state;
{
    (tkIntPlatStubsPtr->tkpWmSetState)(winPtr, state);
}

/* Slot 13 */
int
TkRectInRegion(rgn, x, y, width, height)
    TkRegion rgn;
    int x;
    int y;
    unsigned int width;
    unsigned int height;
{
    return (tkIntPlatStubsPtr->tkRectInRegion)(rgn, x, y, width, height);
}

/* Slot 14 */
void
TkSetRegion(display, gc, rgn)
    Display* display;
    GC gc;
    TkRegion rgn;
{
    (tkIntPlatStubsPtr->tkSetRegion)(display, gc, rgn);
}

/* Slot 15 */
void
TkUnionRectWithRegion(rect, src, dr_return)
    XRectangle* rect;
    TkRegion src;
    TkRegion dr_return;
{
    (tkIntPlatStubsPtr->tkUnionRectWithRegion)(rect, src, dr_return);
}

/* Slot 16 */
int
HandleWMEvent(theEvent)
    EventRecord * theEvent;
{
    return (tkIntPlatStubsPtr->handleWMEvent)(theEvent);
}

/* Slot 17 */
void
TkAboutDlg()
{
    (tkIntPlatStubsPtr->tkAboutDlg)();
}

/* Slot 18 */
void
TkCreateMacEventSource()
{
    (tkIntPlatStubsPtr->tkCreateMacEventSource)();
}

/* Slot 19 */
void
TkFontList(interp, display)
    Tcl_Interp * interp;
    Display * display;
{
    (tkIntPlatStubsPtr->tkFontList)(interp, display);
}

/* Slot 20 */
Window
TkGetTransientMaster(winPtr)
    TkWindow * winPtr;
{
    return (tkIntPlatStubsPtr->tkGetTransientMaster)(winPtr);
}

/* Slot 21 */
int
TkGenerateButtonEvent(x, y, window, state)
    int x;
    int y;
    Window window;
    unsigned int state;
{
    return (tkIntPlatStubsPtr->tkGenerateButtonEvent)(x, y, window, state);
}

/* Slot 22 */
int
TkGetCharPositions(font_struct, string, count, buffer)
    XFontStruct * font_struct;
    char * string;
    int count;
    short * buffer;
{
    return (tkIntPlatStubsPtr->tkGetCharPositions)(font_struct, string, count, buffer);
}

/* Slot 23 */
void
TkGenWMDestroyEvent(tkwin)
    Tk_Window tkwin;
{
    (tkIntPlatStubsPtr->tkGenWMDestroyEvent)(tkwin);
}

/* Slot 24 */
void
TkGenWMConfigureEvent(tkwin, x, y, width, height, flags)
    Tk_Window tkwin;
    int x;
    int y;
    int width;
    int height;
    int flags;
{
    (tkIntPlatStubsPtr->tkGenWMConfigureEvent)(tkwin, x, y, width, height, flags);
}

/* Slot 25 */
unsigned int
TkMacButtonKeyState()
{
    return (tkIntPlatStubsPtr->tkMacButtonKeyState)();
}

/* Slot 26 */
void
TkMacClearMenubarActive()
{
    (tkIntPlatStubsPtr->tkMacClearMenubarActive)();
}

/* Slot 27 */
int
TkMacConvertEvent(eventPtr)
    EventRecord * eventPtr;
{
    return (tkIntPlatStubsPtr->tkMacConvertEvent)(eventPtr);
}

/* Slot 28 */
int
TkMacDispatchMenuEvent(menuID, index)
    int menuID;
    int index;
{
    return (tkIntPlatStubsPtr->tkMacDispatchMenuEvent)(menuID, index);
}

/* Slot 29 */
void
TkMacInstallCursor(resizeOverride)
    int resizeOverride;
{
    (tkIntPlatStubsPtr->tkMacInstallCursor)(resizeOverride);
}

/* Slot 30 */
int
TkMacConvertTkEvent(eventPtr, window)
    EventRecord * eventPtr;
    Window window;
{
    return (tkIntPlatStubsPtr->tkMacConvertTkEvent)(eventPtr, window);
}

/* Slot 31 */
void
TkMacHandleTearoffMenu()
{
    (tkIntPlatStubsPtr->tkMacHandleTearoffMenu)();
}

/* Slot 32 */
void
tkMacInstallMWConsole(interp)
    Tcl_Interp * interp;
{
    (tkIntPlatStubsPtr->tkMacInstallMWConsole)(interp);
}

/* Slot 33 */
void
TkMacInvalClipRgns(winPtr)
    TkWindow * winPtr;
{
    (tkIntPlatStubsPtr->tkMacInvalClipRgns)(winPtr);
}

/* Slot 34 */
void
TkMacDoHLEvent(theEvent)
    EventRecord * theEvent;
{
    (tkIntPlatStubsPtr->tkMacDoHLEvent)(theEvent);
}

/* Slot 35 */
void
TkMacFontInfo(fontId, family, style, size)
    Font fontId;
    short * family;
    short * style;
    short * size;
{
    (tkIntPlatStubsPtr->tkMacFontInfo)(fontId, family, style, size);
}

/* Slot 36 */
Time
TkMacGenerateTime()
{
    return (tkIntPlatStubsPtr->tkMacGenerateTime)();
}

/* Slot 37 */
GWorldPtr
TkMacGetDrawablePort(drawable)
    Drawable drawable;
{
    return (tkIntPlatStubsPtr->tkMacGetDrawablePort)(drawable);
}

/* Slot 38 */
TkWindow *
TkMacGetScrollbarGrowWindow(winPtr)
    TkWindow * winPtr;
{
    return (tkIntPlatStubsPtr->tkMacGetScrollbarGrowWindow)(winPtr);
}

/* Slot 39 */
Window
TkMacGetXWindow(macWinPtr)
    WindowRef macWinPtr;
{
    return (tkIntPlatStubsPtr->tkMacGetXWindow)(macWinPtr);
}

/* Slot 40 */
int
TkMacGrowToplevel(whichWindow, start)
    WindowRef whichWindow;
    Point start;
{
    return (tkIntPlatStubsPtr->tkMacGrowToplevel)(whichWindow, start);
}

/* Slot 41 */
void
TkMacHandleMenuSelect(mResult, optionKeyPressed)
    long mResult;
    int optionKeyPressed;
{
    (tkIntPlatStubsPtr->tkMacHandleMenuSelect)(mResult, optionKeyPressed);
}

/* Slot 42 */
int
TkMacHaveAppearance()
{
    return (tkIntPlatStubsPtr->tkMacHaveAppearance)();
}

/* Slot 43 */
void
TkMacInitAppleEvents(interp)
    Tcl_Interp * interp;
{
    (tkIntPlatStubsPtr->tkMacInitAppleEvents)(interp);
}

/* Slot 44 */
void
TkMacInitMenus(interp)
    Tcl_Interp * interp;
{
    (tkIntPlatStubsPtr->tkMacInitMenus)(interp);
}

/* Slot 45 */
void
TkMacInvalidateWindow(macWin, flag)
    MacDrawable * macWin;
    int flag;
{
    (tkIntPlatStubsPtr->tkMacInvalidateWindow)(macWin, flag);
}

/* Slot 46 */
int
TkMacIsCharacterMissing(tkfont, searchChar)
    Tk_Font tkfont;
    unsigned int searchChar;
{
    return (tkIntPlatStubsPtr->tkMacIsCharacterMissing)(tkfont, searchChar);
}

/* Slot 47 */
void
TkMacMakeRealWindowExist(winPtr)
    TkWindow * winPtr;
{
    (tkIntPlatStubsPtr->tkMacMakeRealWindowExist)(winPtr);
}

/* Slot 48 */
BitMapPtr
TkMacMakeStippleMap(d1, d2)
    Drawable d1;
    Drawable d2;
{
    return (tkIntPlatStubsPtr->tkMacMakeStippleMap)(d1, d2);
}

/* Slot 49 */
void
TkMacMenuClick()
{
    (tkIntPlatStubsPtr->tkMacMenuClick)();
}

/* Slot 50 */
void
TkMacRegisterOffScreenWindow(window, portPtr)
    Window window;
    GWorldPtr portPtr;
{
    (tkIntPlatStubsPtr->tkMacRegisterOffScreenWindow)(window, portPtr);
}

/* Slot 51 */
int
TkMacResizable(winPtr)
    TkWindow * winPtr;
{
    return (tkIntPlatStubsPtr->tkMacResizable)(winPtr);
}

/* Slot 52 */
void
TkMacSetEmbedRgn(winPtr, rgn)
    TkWindow * winPtr;
    RgnHandle rgn;
{
    (tkIntPlatStubsPtr->tkMacSetEmbedRgn)(winPtr, rgn);
}

/* Slot 53 */
void
TkMacSetHelpMenuItemCount()
{
    (tkIntPlatStubsPtr->tkMacSetHelpMenuItemCount)();
}

/* Slot 54 */
void
TkMacSetScrollbarGrow(winPtr, flag)
    TkWindow * winPtr;
    int flag;
{
    (tkIntPlatStubsPtr->tkMacSetScrollbarGrow)(winPtr, flag);
}

/* Slot 55 */
void
TkMacSetUpClippingRgn(drawable)
    Drawable drawable;
{
    (tkIntPlatStubsPtr->tkMacSetUpClippingRgn)(drawable);
}

/* Slot 56 */
void
TkMacSetUpGraphicsPort(gc)
    GC gc;
{
    (tkIntPlatStubsPtr->tkMacSetUpGraphicsPort)(gc);
}

/* Slot 57 */
void
TkMacUpdateClipRgn(winPtr)
    TkWindow * winPtr;
{
    (tkIntPlatStubsPtr->tkMacUpdateClipRgn)(winPtr);
}

/* Slot 58 */
void
TkMacUnregisterMacWindow(portPtr)
    GWorldPtr portPtr;
{
    (tkIntPlatStubsPtr->tkMacUnregisterMacWindow)(portPtr);
}

/* Slot 59 */
int
TkMacUseMenuID(macID)
    short macID;
{
    return (tkIntPlatStubsPtr->tkMacUseMenuID)(macID);
}

/* Slot 60 */
RgnHandle
TkMacVisableClipRgn(winPtr)
    TkWindow * winPtr;
{
    return (tkIntPlatStubsPtr->tkMacVisableClipRgn)(winPtr);
}

/* Slot 61 */
void
TkMacWinBounds(winPtr, geometry)
    TkWindow * winPtr;
    Rect * geometry;
{
    (tkIntPlatStubsPtr->tkMacWinBounds)(winPtr, geometry);
}

/* Slot 62 */
void
TkMacWindowOffset(wRef, xOffset, yOffset)
    WindowRef wRef;
    int * xOffset;
    int * yOffset;
{
    (tkIntPlatStubsPtr->tkMacWindowOffset)(wRef, xOffset, yOffset);
}

/* Slot 63 */
void
TkResumeClipboard()
{
    (tkIntPlatStubsPtr->tkResumeClipboard)();
}

/* Slot 64 */
int
TkSetMacColor(pixel, macColor)
    unsigned long pixel;
    RGBColor * macColor;
{
    return (tkIntPlatStubsPtr->tkSetMacColor)(pixel, macColor);
}

/* Slot 65 */
void
TkSetWMName(winPtr, titleUid)
    TkWindow * winPtr;
    Tk_Uid titleUid;
{
    (tkIntPlatStubsPtr->tkSetWMName)(winPtr, titleUid);
}

/* Slot 66 */
void
TkSuspendClipboard()
{
    (tkIntPlatStubsPtr->tkSuspendClipboard)();
}

/* Slot 67 */
int
TkWMGrowToplevel(whichWindow, start)
    WindowRef whichWindow;
    Point start;
{
    return (tkIntPlatStubsPtr->tkWMGrowToplevel)(whichWindow, start);
}

/* Slot 68 */
int
TkMacZoomToplevel(whichWindow, where, zoomPart)
    WindowPtr whichWindow;
    Point where;
    short zoomPart;
{
    return (tkIntPlatStubsPtr->tkMacZoomToplevel)(whichWindow, where, zoomPart);
}

/* Slot 69 */
Tk_Window
Tk_TopCoordsToWindow(tkwin, rootX, rootY, newX, newY)
    Tk_Window tkwin;
    int rootX;
    int rootY;
    int * newX;
    int * newY;
{
    return (tkIntPlatStubsPtr->tk_TopCoordsToWindow)(tkwin, rootX, rootY, newX, newY);
}

/* Slot 70 */
MacDrawable *
TkMacContainerId(winPtr)
    TkWindow * winPtr;
{
    return (tkIntPlatStubsPtr->tkMacContainerId)(winPtr);
}

/* Slot 71 */
MacDrawable *
TkMacGetHostToplevel(winPtr)
    TkWindow * winPtr;
{
    return (tkIntPlatStubsPtr->tkMacGetHostToplevel)(winPtr);
}

#endif /* MAC_TCL */

/* !END!: Do not edit above this line. */
