'\"
'\" Copyright (c) 1993-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: catch.n,v 1.1.2.2 1998/11/09 22:52:44 stanton Exp $
'\" 
.so man.macros
.TH catch n "8.0" Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
catch \- Evaluate script and trap exceptional returns
.SH SYNOPSIS
\fBcatch\fI script \fR?\fIvarName\fR?
.BE

.SH DESCRIPTION
.PP
The \fBcatch\fR command may be used to prevent errors from aborting command
interpretation.  \fBCatch\fR calls the Tcl interpreter recursively to
execute \fIscript\fR, and always returns without raising an error,
regardless of any errors that might occur while executing \fIscript\fR.
.PP
If \fIscript\fR raises an error, \fBcatch\fR will return a non-zero integer
value corresponding to one of the exceptional return codes (see tcl.h
for the definitions of code values).  If the \fIvarName\fR argument is
given, then the variable it names is set to the error message from
interpreting \fIscript\fR.
.PP
If \fIscript\fR does not raise an error, \fBcatch\fR will return 0
(TCL_OK) and set the variable to the value returned from \fIscript\fR.
.PP
Note that \fBcatch\fR catches all exceptions, including those
generated by \fBbreak\fR and \fBcontinue\fR as well as errors.

.SH EXAMPLE

\fBcatch\fR may be used in an \fBif\fR to branch based on the success
of a script.

.DS
.CS
if { [catch {open $someFile w} fid] } {
    puts stderr "Could not open $someFile for writing\\n$fid"
    exit 1
}
.CE
.DE

.SH KEYWORDS
catch, error
