/*
 * tclDecls.h --
 *
 *	Declarations of functions in the platform independent public Tcl API.
 *
 * Copyright (c) 1998-1999 by Scriptics Corporation.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: @(#) $Id: tclDecls.h,v 1.3.2.7 1999/03/14 18:56:07 stanton Exp $
 */

#ifndef _TCLDECLS
#define _TCLDECLS

/*
 * WARNING: This file is automatically generated by the tools/genStubs.tcl
 * script.  Any modifications to the function declarations below should be made
 * in the generic/tcl.decls script.
 */

/* !BEGIN!: Do not edit below this line. */

/*
 * Exported function declarations:
 */

/* 0 */
EXTERN int		Tcl_PkgProvideEx _ANSI_ARGS_((Tcl_Interp * interp, 
				char * name, char * version, 
				ClientData clientData));
/* 1 */
EXTERN char *		Tcl_PkgRequireEx _ANSI_ARGS_((Tcl_Interp * interp, 
				char * name, char * version, int exact, 
				ClientData * clientDataPtr));
/* 2 */
EXTERN void		Tcl_Panic _ANSI_ARGS_(TCL_VARARGS(char *,format));
/* 3 */
EXTERN char *		Tcl_Alloc _ANSI_ARGS_((unsigned int size));
/* 4 */
EXTERN void		Tcl_Free _ANSI_ARGS_((char * ptr));
/* 5 */
EXTERN char *		Tcl_Realloc _ANSI_ARGS_((char * ptr, 
				unsigned int size));
/* 6 */
EXTERN char *		Tcl_DbCkalloc _ANSI_ARGS_((unsigned int size, 
				char * file, int line));
/* 7 */
EXTERN int		Tcl_DbCkfree _ANSI_ARGS_((char * ptr, char * file, 
				int line));
/* 8 */
EXTERN char *		Tcl_DbCkrealloc _ANSI_ARGS_((char * ptr, 
				unsigned int size, char * file, int line));
#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
/* 9 */
EXTERN void		Tcl_CreateFileHandler _ANSI_ARGS_((int fd, int mask, 
				Tcl_FileProc * proc, ClientData clientData));
#endif /* UNIX */
#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
/* 10 */
EXTERN void		Tcl_DeleteFileHandler _ANSI_ARGS_((int fd));
#endif /* UNIX */
/* 11 */
EXTERN void		Tcl_SetTimer _ANSI_ARGS_((Tcl_Time * timePtr));
/* 12 */
EXTERN void		Tcl_Sleep _ANSI_ARGS_((int ms));
/* 13 */
EXTERN int		Tcl_WaitForEvent _ANSI_ARGS_((Tcl_Time * timePtr));
/* 14 */
EXTERN int		Tcl_AppendAllObjTypes _ANSI_ARGS_((
				Tcl_Interp * interp, Tcl_Obj * objPtr));
/* 15 */
EXTERN void		Tcl_AppendStringsToObj _ANSI_ARGS_(TCL_VARARGS(Tcl_Obj *,objPtr));
/* 16 */
EXTERN void		Tcl_AppendToObj _ANSI_ARGS_((Tcl_Obj * objPtr, 
				char * bytes, int length));
/* 17 */
EXTERN Tcl_Obj *	Tcl_ConcatObj _ANSI_ARGS_((int objc, 
				Tcl_Obj *CONST objv[]));
/* 18 */
EXTERN int		Tcl_ConvertToType _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * objPtr, Tcl_ObjType * typePtr));
/* 19 */
EXTERN void		Tcl_DbDecrRefCount _ANSI_ARGS_((Tcl_Obj * objPtr, 
				char * file, int line));
/* 20 */
EXTERN void		Tcl_DbIncrRefCount _ANSI_ARGS_((Tcl_Obj * objPtr, 
				char * file, int line));
/* 21 */
EXTERN int		Tcl_DbIsShared _ANSI_ARGS_((Tcl_Obj * objPtr, 
				char * file, int line));
/* 22 */
EXTERN Tcl_Obj *	Tcl_DbNewBooleanObj _ANSI_ARGS_((int boolValue, 
				char * file, int line));
/* 23 */
EXTERN Tcl_Obj *	Tcl_DbNewByteArrayObj _ANSI_ARGS_((
				unsigned char * bytes, int length, 
				char * file, int line));
/* 24 */
EXTERN Tcl_Obj *	Tcl_DbNewDoubleObj _ANSI_ARGS_((double doubleValue, 
				char * file, int line));
/* 25 */
EXTERN Tcl_Obj *	Tcl_DbNewListObj _ANSI_ARGS_((int objc, 
				Tcl_Obj *CONST objv[], char * file, int line));
/* 26 */
EXTERN Tcl_Obj *	Tcl_DbNewLongObj _ANSI_ARGS_((long longValue, 
				char * file, int line));
/* 27 */
EXTERN Tcl_Obj *	Tcl_DbNewObj _ANSI_ARGS_((char * file, int line));
/* 28 */
EXTERN Tcl_Obj *	Tcl_DbNewStringObj _ANSI_ARGS_((CONST char * bytes, 
				int length, char * file, int line));
/* 29 */
EXTERN Tcl_Obj *	Tcl_DuplicateObj _ANSI_ARGS_((Tcl_Obj * objPtr));
/* 30 */
EXTERN void		TclFreeObj _ANSI_ARGS_((Tcl_Obj * objPtr));
/* 31 */
EXTERN int		Tcl_GetBoolean _ANSI_ARGS_((Tcl_Interp * interp, 
				char * string, int * boolPtr));
/* 32 */
EXTERN int		Tcl_GetBooleanFromObj _ANSI_ARGS_((
				Tcl_Interp * interp, Tcl_Obj * objPtr, 
				int * boolPtr));
/* 33 */
EXTERN unsigned char *	Tcl_GetByteArrayFromObj _ANSI_ARGS_((
				Tcl_Obj * objPtr, int * lengthPtr));
/* 34 */
EXTERN int		Tcl_GetDouble _ANSI_ARGS_((Tcl_Interp * interp, 
				char * string, double * doublePtr));
/* 35 */
EXTERN int		Tcl_GetDoubleFromObj _ANSI_ARGS_((
				Tcl_Interp * interp, Tcl_Obj * objPtr, 
				double * doublePtr));
/* 36 */
EXTERN int		Tcl_GetIndexFromObj _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * objPtr, char ** tablePtr, 
				char * msg, int flags, int * indexPtr));
/* 37 */
EXTERN int		Tcl_GetInt _ANSI_ARGS_((Tcl_Interp * interp, 
				char * string, int * intPtr));
/* 38 */
EXTERN int		Tcl_GetIntFromObj _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * objPtr, int * intPtr));
/* 39 */
EXTERN int		Tcl_GetLongFromObj _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * objPtr, long * longPtr));
/* 40 */
EXTERN Tcl_ObjType *	Tcl_GetObjType _ANSI_ARGS_((char * typeName));
/* 41 */
EXTERN char *		Tcl_GetStringFromObj _ANSI_ARGS_((Tcl_Obj * objPtr, 
				int * lengthPtr));
/* 42 */
EXTERN void		Tcl_InvalidateStringRep _ANSI_ARGS_((
				Tcl_Obj * objPtr));
/* 43 */
EXTERN int		Tcl_ListObjAppendList _ANSI_ARGS_((
				Tcl_Interp * interp, Tcl_Obj * listPtr, 
				Tcl_Obj * elemListPtr));
/* 44 */
EXTERN int		Tcl_ListObjAppendElement _ANSI_ARGS_((
				Tcl_Interp * interp, Tcl_Obj * listPtr, 
				Tcl_Obj * objPtr));
/* 45 */
EXTERN int		Tcl_ListObjGetElements _ANSI_ARGS_((
				Tcl_Interp * interp, Tcl_Obj * listPtr, 
				int * objcPtr, Tcl_Obj *** objvPtr));
/* 46 */
EXTERN int		Tcl_ListObjIndex _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * listPtr, int index, 
				Tcl_Obj ** objPtrPtr));
/* 47 */
EXTERN int		Tcl_ListObjLength _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * listPtr, int * intPtr));
/* 48 */
EXTERN int		Tcl_ListObjReplace _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * listPtr, int first, int count, 
				int objc, Tcl_Obj *CONST objv[]));
/* 49 */
EXTERN Tcl_Obj *	Tcl_NewBooleanObj _ANSI_ARGS_((int boolValue));
/* 50 */
EXTERN Tcl_Obj *	Tcl_NewByteArrayObj _ANSI_ARGS_((
				unsigned char * bytes, int length));
/* 51 */
EXTERN Tcl_Obj *	Tcl_NewDoubleObj _ANSI_ARGS_((double doubleValue));
/* 52 */
EXTERN Tcl_Obj *	Tcl_NewIntObj _ANSI_ARGS_((int intValue));
/* 53 */
EXTERN Tcl_Obj *	Tcl_NewListObj _ANSI_ARGS_((int objc, 
				Tcl_Obj *CONST objv[]));
/* 54 */
EXTERN Tcl_Obj *	Tcl_NewLongObj _ANSI_ARGS_((long longValue));
/* 55 */
EXTERN Tcl_Obj *	Tcl_NewObj _ANSI_ARGS_((void));
/* 56 */
EXTERN Tcl_Obj *	Tcl_NewStringObj _ANSI_ARGS_((CONST char * bytes, 
				int length));
/* 57 */
EXTERN void		Tcl_SetBooleanObj _ANSI_ARGS_((Tcl_Obj * objPtr, 
				int boolValue));
/* 58 */
EXTERN unsigned char *	Tcl_SetByteArrayLength _ANSI_ARGS_((Tcl_Obj * objPtr, 
				int length));
/* 59 */
EXTERN void		Tcl_SetByteArrayObj _ANSI_ARGS_((Tcl_Obj * objPtr, 
				unsigned char * bytes, int length));
/* 60 */
EXTERN void		Tcl_SetDoubleObj _ANSI_ARGS_((Tcl_Obj * objPtr, 
				double doubleValue));
/* 61 */
EXTERN void		Tcl_SetIntObj _ANSI_ARGS_((Tcl_Obj * objPtr, 
				int intValue));
/* 62 */
EXTERN void		Tcl_SetListObj _ANSI_ARGS_((Tcl_Obj * objPtr, 
				int objc, Tcl_Obj *CONST objv[]));
/* 63 */
EXTERN void		Tcl_SetLongObj _ANSI_ARGS_((Tcl_Obj * objPtr, 
				long longValue));
/* 64 */
EXTERN void		Tcl_SetObjLength _ANSI_ARGS_((Tcl_Obj * objPtr, 
				int length));
/* 65 */
EXTERN void		Tcl_SetStringObj _ANSI_ARGS_((Tcl_Obj * objPtr, 
				char * bytes, int length));
/* 66 */
EXTERN void		Tcl_AddErrorInfo _ANSI_ARGS_((Tcl_Interp * interp, 
				CONST char * message));
/* 67 */
EXTERN void		Tcl_AddObjErrorInfo _ANSI_ARGS_((Tcl_Interp * interp, 
				CONST char * message, int length));
/* 68 */
EXTERN void		Tcl_AllowExceptions _ANSI_ARGS_((Tcl_Interp * interp));
/* 69 */
EXTERN void		Tcl_AppendElement _ANSI_ARGS_((Tcl_Interp * interp, 
				CONST char * string));
/* 70 */
EXTERN void		Tcl_AppendResult _ANSI_ARGS_(TCL_VARARGS(Tcl_Interp *,interp));
/* 71 */
EXTERN Tcl_AsyncHandler	 Tcl_AsyncCreate _ANSI_ARGS_((Tcl_AsyncProc * proc, 
				ClientData clientData));
/* 72 */
EXTERN void		Tcl_AsyncDelete _ANSI_ARGS_((Tcl_AsyncHandler async));
/* 73 */
EXTERN int		Tcl_AsyncInvoke _ANSI_ARGS_((Tcl_Interp * interp, 
				int code));
/* 74 */
EXTERN void		Tcl_AsyncMark _ANSI_ARGS_((Tcl_AsyncHandler async));
/* 75 */
EXTERN int		Tcl_AsyncReady _ANSI_ARGS_((void));
/* 76 */
EXTERN void		Tcl_BackgroundError _ANSI_ARGS_((Tcl_Interp * interp));
/* 77 */
EXTERN char		Tcl_Backslash _ANSI_ARGS_((CONST char * src, 
				int * readPtr));
/* 78 */
EXTERN int		Tcl_BadChannelOption _ANSI_ARGS_((
				Tcl_Interp * interp, char * optionName, 
				char * optionList));
/* 79 */
EXTERN void		Tcl_CallWhenDeleted _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_InterpDeleteProc * proc, 
				ClientData clientData));
/* 80 */
EXTERN void		Tcl_CancelIdleCall _ANSI_ARGS_((
				Tcl_IdleProc * idleProc, 
				ClientData clientData));
/* 81 */
EXTERN int		Tcl_Close _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Channel chan));
/* 82 */
EXTERN int		Tcl_CommandComplete _ANSI_ARGS_((char * cmd));
/* 83 */
EXTERN char *		Tcl_Concat _ANSI_ARGS_((int argc, char ** argv));
/* 84 */
EXTERN int		Tcl_ConvertElement _ANSI_ARGS_((CONST char * src, 
				char * dst, int flags));
/* 85 */
EXTERN int		Tcl_ConvertCountedElement _ANSI_ARGS_((
				CONST char * src, int length, char * dst, 
				int flags));
/* 86 */
EXTERN int		Tcl_CreateAlias _ANSI_ARGS_((Tcl_Interp * slave, 
				char * slaveCmd, Tcl_Interp * target, 
				char * targetCmd, int argc, char ** argv));
/* 87 */
EXTERN int		Tcl_CreateAliasObj _ANSI_ARGS_((Tcl_Interp * slave, 
				char * slaveCmd, Tcl_Interp * target, 
				char * targetCmd, int objc, 
				Tcl_Obj *CONST objv[]));
/* 88 */
EXTERN Tcl_Channel	Tcl_CreateChannel _ANSI_ARGS_((
				Tcl_ChannelType * typePtr, char * chanName, 
				ClientData instanceData, int mask));
/* 89 */
EXTERN void		Tcl_CreateChannelHandler _ANSI_ARGS_((
				Tcl_Channel chan, int mask, 
				Tcl_ChannelProc * proc, 
				ClientData clientData));
/* 90 */
EXTERN void		Tcl_CreateCloseHandler _ANSI_ARGS_((Tcl_Channel chan, 
				Tcl_CloseProc * proc, ClientData clientData));
/* 91 */
EXTERN Tcl_Command	Tcl_CreateCommand _ANSI_ARGS_((Tcl_Interp * interp, 
				char * cmdName, Tcl_CmdProc * proc, 
				ClientData clientData, 
				Tcl_CmdDeleteProc * deleteProc));
/* 92 */
EXTERN void		Tcl_CreateEventSource _ANSI_ARGS_((
				Tcl_EventSetupProc * setupProc, 
				Tcl_EventCheckProc * checkProc, 
				ClientData clientData));
/* 93 */
EXTERN void		Tcl_CreateExitHandler _ANSI_ARGS_((
				Tcl_ExitProc * proc, ClientData clientData));
/* 94 */
EXTERN Tcl_Interp *	Tcl_CreateInterp _ANSI_ARGS_((void));
/* 95 */
EXTERN void		Tcl_CreateMathFunc _ANSI_ARGS_((Tcl_Interp * interp, 
				char * name, int numArgs, 
				Tcl_ValueType * argTypes, 
				Tcl_MathProc * proc, ClientData clientData));
/* 96 */
EXTERN Tcl_Command	Tcl_CreateObjCommand _ANSI_ARGS_((
				Tcl_Interp * interp, char * cmdName, 
				Tcl_ObjCmdProc * proc, ClientData clientData, 
				Tcl_CmdDeleteProc * deleteProc));
/* 97 */
EXTERN Tcl_Interp *	Tcl_CreateSlave _ANSI_ARGS_((Tcl_Interp * interp, 
				char * slaveName, int isSafe));
/* 98 */
EXTERN Tcl_TimerToken	Tcl_CreateTimerHandler _ANSI_ARGS_((int milliseconds, 
				Tcl_TimerProc * proc, ClientData clientData));
/* 99 */
EXTERN Tcl_Trace	Tcl_CreateTrace _ANSI_ARGS_((Tcl_Interp * interp, 
				int level, Tcl_CmdTraceProc * proc, 
				ClientData clientData));
/* 100 */
EXTERN void		Tcl_DeleteAssocData _ANSI_ARGS_((Tcl_Interp * interp, 
				char * name));
/* 101 */
EXTERN void		Tcl_DeleteChannelHandler _ANSI_ARGS_((
				Tcl_Channel chan, Tcl_ChannelProc * proc, 
				ClientData clientData));
/* 102 */
EXTERN void		Tcl_DeleteCloseHandler _ANSI_ARGS_((Tcl_Channel chan, 
				Tcl_CloseProc * proc, ClientData clientData));
/* 103 */
EXTERN int		Tcl_DeleteCommand _ANSI_ARGS_((Tcl_Interp * interp, 
				char * cmdName));
/* 104 */
EXTERN int		Tcl_DeleteCommandFromToken _ANSI_ARGS_((
				Tcl_Interp * interp, Tcl_Command command));
/* 105 */
EXTERN void		Tcl_DeleteEvents _ANSI_ARGS_((
				Tcl_EventDeleteProc * proc, 
				ClientData clientData));
/* 106 */
EXTERN void		Tcl_DeleteEventSource _ANSI_ARGS_((
				Tcl_EventSetupProc * setupProc, 
				Tcl_EventCheckProc * checkProc, 
				ClientData clientData));
/* 107 */
EXTERN void		Tcl_DeleteExitHandler _ANSI_ARGS_((
				Tcl_ExitProc * proc, ClientData clientData));
/* 108 */
EXTERN void		Tcl_DeleteHashEntry _ANSI_ARGS_((
				Tcl_HashEntry * entryPtr));
/* 109 */
EXTERN void		Tcl_DeleteHashTable _ANSI_ARGS_((
				Tcl_HashTable * tablePtr));
/* 110 */
EXTERN void		Tcl_DeleteInterp _ANSI_ARGS_((Tcl_Interp * interp));
/* 111 */
EXTERN void		Tcl_DetachPids _ANSI_ARGS_((int numPids, 
				Tcl_Pid * pidPtr));
/* 112 */
EXTERN void		Tcl_DeleteTimerHandler _ANSI_ARGS_((
				Tcl_TimerToken token));
/* 113 */
EXTERN void		Tcl_DeleteTrace _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Trace trace));
/* 114 */
EXTERN void		Tcl_DontCallWhenDeleted _ANSI_ARGS_((
				Tcl_Interp * interp, 
				Tcl_InterpDeleteProc * proc, 
				ClientData clientData));
/* 115 */
EXTERN int		Tcl_DoOneEvent _ANSI_ARGS_((int flags));
/* 116 */
EXTERN void		Tcl_DoWhenIdle _ANSI_ARGS_((Tcl_IdleProc * proc, 
				ClientData clientData));
/* 117 */
EXTERN char *		Tcl_DStringAppend _ANSI_ARGS_((Tcl_DString * dsPtr, 
				CONST char * string, int length));
/* 118 */
EXTERN char *		Tcl_DStringAppendElement _ANSI_ARGS_((
				Tcl_DString * dsPtr, CONST char * string));
/* 119 */
EXTERN void		Tcl_DStringEndSublist _ANSI_ARGS_((
				Tcl_DString * dsPtr));
/* 120 */
EXTERN void		Tcl_DStringFree _ANSI_ARGS_((Tcl_DString * dsPtr));
/* 121 */
EXTERN void		Tcl_DStringGetResult _ANSI_ARGS_((
				Tcl_Interp * interp, Tcl_DString * dsPtr));
/* 122 */
EXTERN void		Tcl_DStringInit _ANSI_ARGS_((Tcl_DString * dsPtr));
/* 123 */
EXTERN void		Tcl_DStringResult _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_DString * dsPtr));
/* 124 */
EXTERN void		Tcl_DStringSetLength _ANSI_ARGS_((
				Tcl_DString * dsPtr, int length));
/* 125 */
EXTERN void		Tcl_DStringStartSublist _ANSI_ARGS_((
				Tcl_DString * dsPtr));
/* 126 */
EXTERN int		Tcl_Eof _ANSI_ARGS_((Tcl_Channel chan));
/* 127 */
EXTERN char *		Tcl_ErrnoId _ANSI_ARGS_((void));
/* 128 */
EXTERN char *		Tcl_ErrnoMsg _ANSI_ARGS_((int err));
/* 129 */
EXTERN int		Tcl_Eval _ANSI_ARGS_((Tcl_Interp * interp, 
				char * string));
/* 130 */
EXTERN int		Tcl_EvalFile _ANSI_ARGS_((Tcl_Interp * interp, 
				char * fileName));
/* 131 */
EXTERN int		Tcl_EvalObj _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * objPtr));
/* 132 */
EXTERN void		Tcl_EventuallyFree _ANSI_ARGS_((
				ClientData clientData, 
				Tcl_FreeProc * freeProc));
/* 133 */
EXTERN void		Tcl_Exit _ANSI_ARGS_((int status));
/* 134 */
EXTERN int		Tcl_ExposeCommand _ANSI_ARGS_((Tcl_Interp * interp, 
				char * hiddenCmdToken, char * cmdName));
/* 135 */
EXTERN int		Tcl_ExprBoolean _ANSI_ARGS_((Tcl_Interp * interp, 
				char * string, int * ptr));
/* 136 */
EXTERN int		Tcl_ExprBooleanObj _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * objPtr, int * ptr));
/* 137 */
EXTERN int		Tcl_ExprDouble _ANSI_ARGS_((Tcl_Interp * interp, 
				char * string, double * ptr));
/* 138 */
EXTERN int		Tcl_ExprDoubleObj _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * objPtr, double * ptr));
/* 139 */
EXTERN int		Tcl_ExprLong _ANSI_ARGS_((Tcl_Interp * interp, 
				char * string, long * ptr));
/* 140 */
EXTERN int		Tcl_ExprLongObj _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * objPtr, long * ptr));
/* 141 */
EXTERN int		Tcl_ExprObj _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * objPtr, Tcl_Obj ** resultPtrPtr));
/* 142 */
EXTERN int		Tcl_ExprString _ANSI_ARGS_((Tcl_Interp * interp, 
				char * string));
/* 143 */
EXTERN void		Tcl_Finalize _ANSI_ARGS_((void));
/* 144 */
EXTERN void		Tcl_FindExecutable _ANSI_ARGS_((CONST char * argv0));
/* 145 */
EXTERN Tcl_HashEntry *	Tcl_FirstHashEntry _ANSI_ARGS_((
				Tcl_HashTable * tablePtr, 
				Tcl_HashSearch * searchPtr));
/* 146 */
EXTERN int		Tcl_Flush _ANSI_ARGS_((Tcl_Channel chan));
/* 147 */
EXTERN void		Tcl_FreeResult _ANSI_ARGS_((Tcl_Interp * interp));
/* 148 */
EXTERN int		Tcl_GetAlias _ANSI_ARGS_((Tcl_Interp * interp, 
				char * slaveCmd, 
				Tcl_Interp ** targetInterpPtr, 
				char ** targetCmdPtr, int * argcPtr, 
				char *** argvPtr));
/* 149 */
EXTERN int		Tcl_GetAliasObj _ANSI_ARGS_((Tcl_Interp * interp, 
				char * slaveCmd, 
				Tcl_Interp ** targetInterpPtr, 
				char ** targetCmdPtr, int * objcPtr, 
				Tcl_Obj *** objv));
/* 150 */
EXTERN ClientData	Tcl_GetAssocData _ANSI_ARGS_((Tcl_Interp * interp, 
				char * name, Tcl_InterpDeleteProc ** procPtr));
/* 151 */
EXTERN Tcl_Channel	Tcl_GetChannel _ANSI_ARGS_((Tcl_Interp * interp, 
				char * chanName, int * modePtr));
/* 152 */
EXTERN int		Tcl_GetChannelBufferSize _ANSI_ARGS_((
				Tcl_Channel chan));
/* 153 */
EXTERN int		Tcl_GetChannelHandle _ANSI_ARGS_((Tcl_Channel chan, 
				int direction, ClientData * handlePtr));
/* 154 */
EXTERN ClientData	Tcl_GetChannelInstanceData _ANSI_ARGS_((
				Tcl_Channel chan));
/* 155 */
EXTERN int		Tcl_GetChannelMode _ANSI_ARGS_((Tcl_Channel chan));
/* 156 */
EXTERN char *		Tcl_GetChannelName _ANSI_ARGS_((Tcl_Channel chan));
/* 157 */
EXTERN int		Tcl_GetChannelOption _ANSI_ARGS_((
				Tcl_Interp * interp, Tcl_Channel chan, 
				char * optionName, Tcl_DString * dsPtr));
/* 158 */
EXTERN Tcl_ChannelType * Tcl_GetChannelType _ANSI_ARGS_((Tcl_Channel chan));
/* 159 */
EXTERN int		Tcl_GetCommandInfo _ANSI_ARGS_((Tcl_Interp * interp, 
				char * cmdName, Tcl_CmdInfo * infoPtr));
/* 160 */
EXTERN char *		Tcl_GetCommandName _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Command command));
/* 161 */
EXTERN int		Tcl_GetErrno _ANSI_ARGS_((void));
/* 162 */
EXTERN char *		Tcl_GetHostName _ANSI_ARGS_((void));
/* 163 */
EXTERN int		Tcl_GetInterpPath _ANSI_ARGS_((
				Tcl_Interp * askInterp, 
				Tcl_Interp * slaveInterp));
/* 164 */
EXTERN Tcl_Interp *	Tcl_GetMaster _ANSI_ARGS_((Tcl_Interp * interp));
/* 165 */
EXTERN CONST char *	Tcl_GetNameOfExecutable _ANSI_ARGS_((void));
/* 166 */
EXTERN Tcl_Obj *	Tcl_GetObjResult _ANSI_ARGS_((Tcl_Interp * interp));
#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
/* 167 */
EXTERN int		Tcl_GetOpenFile _ANSI_ARGS_((Tcl_Interp * interp, 
				char * string, int write, int checkUsage, 
				ClientData * filePtr));
#endif /* UNIX */
/* 168 */
EXTERN Tcl_PathType	Tcl_GetPathType _ANSI_ARGS_((char * path));
/* 169 */
EXTERN int		Tcl_Gets _ANSI_ARGS_((Tcl_Channel chan, 
				Tcl_DString * dsPtr));
/* 170 */
EXTERN int		Tcl_GetsObj _ANSI_ARGS_((Tcl_Channel chan, 
				Tcl_Obj * objPtr));
/* 171 */
EXTERN int		Tcl_GetServiceMode _ANSI_ARGS_((void));
/* 172 */
EXTERN Tcl_Interp *	Tcl_GetSlave _ANSI_ARGS_((Tcl_Interp * interp, 
				char * slaveName));
/* 173 */
EXTERN Tcl_Channel	Tcl_GetStdChannel _ANSI_ARGS_((int type));
/* 174 */
EXTERN char *		Tcl_GetStringResult _ANSI_ARGS_((Tcl_Interp * interp));
/* 175 */
EXTERN char *		Tcl_GetVar _ANSI_ARGS_((Tcl_Interp * interp, 
				char * varName, int flags));
/* 176 */
EXTERN char *		Tcl_GetVar2 _ANSI_ARGS_((Tcl_Interp * interp, 
				char * part1, char * part2, int flags));
/* 177 */
EXTERN int		Tcl_GlobalEval _ANSI_ARGS_((Tcl_Interp * interp, 
				char * command));
/* 178 */
EXTERN int		Tcl_GlobalEvalObj _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * objPtr));
/* 179 */
EXTERN int		Tcl_HideCommand _ANSI_ARGS_((Tcl_Interp * interp, 
				char * cmdName, char * hiddenCmdToken));
/* 180 */
EXTERN int		Tcl_Init _ANSI_ARGS_((Tcl_Interp * interp));
/* 181 */
EXTERN void		Tcl_InitHashTable _ANSI_ARGS_((
				Tcl_HashTable * tablePtr, int keyType));
/* 182 */
EXTERN int		Tcl_InputBlocked _ANSI_ARGS_((Tcl_Channel chan));
/* 183 */
EXTERN int		Tcl_InputBuffered _ANSI_ARGS_((Tcl_Channel chan));
/* 184 */
EXTERN int		Tcl_InterpDeleted _ANSI_ARGS_((Tcl_Interp * interp));
/* 185 */
EXTERN int		Tcl_IsSafe _ANSI_ARGS_((Tcl_Interp * interp));
/* 186 */
EXTERN char *		Tcl_JoinPath _ANSI_ARGS_((int argc, char ** argv, 
				Tcl_DString * resultPtr));
/* 187 */
EXTERN int		Tcl_LinkVar _ANSI_ARGS_((Tcl_Interp * interp, 
				char * varName, char * addr, int type));
/* Slot 188 is reserved */
/* 189 */
EXTERN Tcl_Channel	Tcl_MakeFileChannel _ANSI_ARGS_((ClientData handle, 
				int mode));
/* 190 */
EXTERN int		Tcl_MakeSafe _ANSI_ARGS_((Tcl_Interp * interp));
/* 191 */
EXTERN Tcl_Channel	Tcl_MakeTcpClientChannel _ANSI_ARGS_((
				ClientData tcpSocket));
/* 192 */
EXTERN char *		Tcl_Merge _ANSI_ARGS_((int argc, char ** argv));
/* 193 */
EXTERN Tcl_HashEntry *	Tcl_NextHashEntry _ANSI_ARGS_((
				Tcl_HashSearch * searchPtr));
/* 194 */
EXTERN void		Tcl_NotifyChannel _ANSI_ARGS_((Tcl_Channel channel, 
				int mask));
/* 195 */
EXTERN Tcl_Obj *	Tcl_ObjGetVar2 _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * part1Ptr, Tcl_Obj * part2Ptr, 
				int flags));
/* 196 */
EXTERN Tcl_Obj *	Tcl_ObjSetVar2 _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * part1Ptr, Tcl_Obj * part2Ptr, 
				Tcl_Obj * newValuePtr, int flags));
/* 197 */
EXTERN Tcl_Channel	Tcl_OpenCommandChannel _ANSI_ARGS_((
				Tcl_Interp * interp, int argc, char ** argv, 
				int flags));
/* 198 */
EXTERN Tcl_Channel	Tcl_OpenFileChannel _ANSI_ARGS_((Tcl_Interp * interp, 
				char * fileName, char * modeString, 
				int permissions));
/* 199 */
EXTERN Tcl_Channel	Tcl_OpenTcpClient _ANSI_ARGS_((Tcl_Interp * interp, 
				int port, char * address, char * myaddr, 
				int myport, int async));
/* 200 */
EXTERN Tcl_Channel	Tcl_OpenTcpServer _ANSI_ARGS_((Tcl_Interp * interp, 
				int port, char * host, 
				Tcl_TcpAcceptProc * acceptProc, 
				ClientData callbackData));
/* 201 */
EXTERN void		Tcl_Preserve _ANSI_ARGS_((ClientData data));
/* 202 */
EXTERN void		Tcl_PrintDouble _ANSI_ARGS_((Tcl_Interp * interp, 
				double value, char * dst));
/* 203 */
EXTERN int		Tcl_PutEnv _ANSI_ARGS_((CONST char * string));
/* 204 */
EXTERN char *		Tcl_PosixError _ANSI_ARGS_((Tcl_Interp * interp));
/* 205 */
EXTERN void		Tcl_QueueEvent _ANSI_ARGS_((Tcl_Event * evPtr, 
				Tcl_QueuePosition position));
/* 206 */
EXTERN int		Tcl_Read _ANSI_ARGS_((Tcl_Channel chan, 
				char * bufPtr, int toRead));
/* 207 */
EXTERN void		Tcl_ReapDetachedProcs _ANSI_ARGS_((void));
/* 208 */
EXTERN int		Tcl_RecordAndEval _ANSI_ARGS_((Tcl_Interp * interp, 
				char * cmd, int flags));
/* 209 */
EXTERN int		Tcl_RecordAndEvalObj _ANSI_ARGS_((
				Tcl_Interp * interp, Tcl_Obj * cmdPtr, 
				int flags));
/* 210 */
EXTERN void		Tcl_RegisterChannel _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Channel chan));
/* 211 */
EXTERN void		Tcl_RegisterObjType _ANSI_ARGS_((
				Tcl_ObjType * typePtr));
/* 212 */
EXTERN Tcl_RegExp	Tcl_RegExpCompile _ANSI_ARGS_((Tcl_Interp * interp, 
				char * string));
/* 213 */
EXTERN int		Tcl_RegExpExec _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_RegExp regexp, CONST char * string, 
				CONST char * start));
/* 214 */
EXTERN int		Tcl_RegExpMatch _ANSI_ARGS_((Tcl_Interp * interp, 
				char * string, char * pattern));
/* 215 */
EXTERN void		Tcl_RegExpRange _ANSI_ARGS_((Tcl_RegExp regexp, 
				int index, char ** startPtr, char ** endPtr));
/* 216 */
EXTERN void		Tcl_Release _ANSI_ARGS_((ClientData clientData));
/* 217 */
EXTERN void		Tcl_ResetResult _ANSI_ARGS_((Tcl_Interp * interp));
/* 218 */
EXTERN int		Tcl_ScanElement _ANSI_ARGS_((CONST char * string, 
				int * flagPtr));
/* 219 */
EXTERN int		Tcl_ScanCountedElement _ANSI_ARGS_((
				CONST char * string, int length, 
				int * flagPtr));
/* 220 */
EXTERN int		Tcl_Seek _ANSI_ARGS_((Tcl_Channel chan, int offset, 
				int mode));
/* 221 */
EXTERN int		Tcl_ServiceAll _ANSI_ARGS_((void));
/* 222 */
EXTERN int		Tcl_ServiceEvent _ANSI_ARGS_((int flags));
/* 223 */
EXTERN void		Tcl_SetAssocData _ANSI_ARGS_((Tcl_Interp * interp, 
				char * name, Tcl_InterpDeleteProc * proc, 
				ClientData clientData));
/* 224 */
EXTERN void		Tcl_SetChannelBufferSize _ANSI_ARGS_((
				Tcl_Channel chan, int sz));
/* 225 */
EXTERN int		Tcl_SetChannelOption _ANSI_ARGS_((
				Tcl_Interp * interp, Tcl_Channel chan, 
				char * optionName, char * newValue));
/* 226 */
EXTERN int		Tcl_SetCommandInfo _ANSI_ARGS_((Tcl_Interp * interp, 
				char * cmdName, Tcl_CmdInfo * infoPtr));
/* 227 */
EXTERN void		Tcl_SetErrno _ANSI_ARGS_((int err));
/* 228 */
EXTERN void		Tcl_SetErrorCode _ANSI_ARGS_(TCL_VARARGS(Tcl_Interp *,interp));
/* 229 */
EXTERN void		Tcl_SetMaxBlockTime _ANSI_ARGS_((Tcl_Time * timePtr));
/* 230 */
EXTERN void		Tcl_SetPanicProc _ANSI_ARGS_((
				Tcl_PanicProc * panicProc));
/* 231 */
EXTERN int		Tcl_SetRecursionLimit _ANSI_ARGS_((
				Tcl_Interp * interp, int depth));
/* 232 */
EXTERN void		Tcl_SetResult _ANSI_ARGS_((Tcl_Interp * interp, 
				char * string, Tcl_FreeProc * freeProc));
/* 233 */
EXTERN int		Tcl_SetServiceMode _ANSI_ARGS_((int mode));
/* 234 */
EXTERN void		Tcl_SetObjErrorCode _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * errorObjPtr));
/* 235 */
EXTERN void		Tcl_SetObjResult _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * resultObjPtr));
/* 236 */
EXTERN void		Tcl_SetStdChannel _ANSI_ARGS_((Tcl_Channel channel, 
				int type));
/* 237 */
EXTERN char *		Tcl_SetVar _ANSI_ARGS_((Tcl_Interp * interp, 
				char * varName, char * newValue, int flags));
/* 238 */
EXTERN char *		Tcl_SetVar2 _ANSI_ARGS_((Tcl_Interp * interp, 
				char * part1, char * part2, char * newValue, 
				int flags));
/* 239 */
EXTERN char *		Tcl_SignalId _ANSI_ARGS_((int sig));
/* 240 */
EXTERN char *		Tcl_SignalMsg _ANSI_ARGS_((int sig));
/* 241 */
EXTERN void		Tcl_SourceRCFile _ANSI_ARGS_((Tcl_Interp * interp));
/* 242 */
EXTERN int		Tcl_SplitList _ANSI_ARGS_((Tcl_Interp * interp, 
				CONST char * list, int * argcPtr, 
				char *** argvPtr));
/* 243 */
EXTERN void		Tcl_SplitPath _ANSI_ARGS_((CONST char * path, 
				int * argcPtr, char *** argvPtr));
/* 244 */
EXTERN void		Tcl_StaticPackage _ANSI_ARGS_((Tcl_Interp * interp, 
				char * pkgName, 
				Tcl_PackageInitProc * initProc, 
				Tcl_PackageInitProc * safeInitProc));
/* 245 */
EXTERN int		Tcl_StringMatch _ANSI_ARGS_((CONST char * string, 
				CONST char * pattern));
/* 246 */
EXTERN int		Tcl_Tell _ANSI_ARGS_((Tcl_Channel chan));
/* 247 */
EXTERN int		Tcl_TraceVar _ANSI_ARGS_((Tcl_Interp * interp, 
				char * varName, int flags, 
				Tcl_VarTraceProc * proc, 
				ClientData clientData));
/* 248 */
EXTERN int		Tcl_TraceVar2 _ANSI_ARGS_((Tcl_Interp * interp, 
				char * part1, char * part2, int flags, 
				Tcl_VarTraceProc * proc, 
				ClientData clientData));
/* 249 */
EXTERN char *		Tcl_TranslateFileName _ANSI_ARGS_((
				Tcl_Interp * interp, char * name, 
				Tcl_DString * bufferPtr));
/* 250 */
EXTERN int		Tcl_Ungets _ANSI_ARGS_((Tcl_Channel chan, char * str, 
				int len, int atHead));
/* 251 */
EXTERN void		Tcl_UnlinkVar _ANSI_ARGS_((Tcl_Interp * interp, 
				char * varName));
/* 252 */
EXTERN int		Tcl_UnregisterChannel _ANSI_ARGS_((
				Tcl_Interp * interp, Tcl_Channel chan));
/* 253 */
EXTERN int		Tcl_UnsetVar _ANSI_ARGS_((Tcl_Interp * interp, 
				char * varName, int flags));
/* 254 */
EXTERN int		Tcl_UnsetVar2 _ANSI_ARGS_((Tcl_Interp * interp, 
				char * part1, char * part2, int flags));
/* 255 */
EXTERN void		Tcl_UntraceVar _ANSI_ARGS_((Tcl_Interp * interp, 
				char * varName, int flags, 
				Tcl_VarTraceProc * proc, 
				ClientData clientData));
/* 256 */
EXTERN void		Tcl_UntraceVar2 _ANSI_ARGS_((Tcl_Interp * interp, 
				char * part1, char * part2, int flags, 
				Tcl_VarTraceProc * proc, 
				ClientData clientData));
/* 257 */
EXTERN void		Tcl_UpdateLinkedVar _ANSI_ARGS_((Tcl_Interp * interp, 
				char * varName));
/* 258 */
EXTERN int		Tcl_UpVar _ANSI_ARGS_((Tcl_Interp * interp, 
				char * frameName, char * varName, 
				char * localName, int flags));
/* 259 */
EXTERN int		Tcl_UpVar2 _ANSI_ARGS_((Tcl_Interp * interp, 
				char * frameName, char * part1, char * part2, 
				char * localName, int flags));
/* 260 */
EXTERN int		Tcl_VarEval _ANSI_ARGS_(TCL_VARARGS(Tcl_Interp *,interp));
/* 261 */
EXTERN ClientData	Tcl_VarTraceInfo _ANSI_ARGS_((Tcl_Interp * interp, 
				char * varName, int flags, 
				Tcl_VarTraceProc * procPtr, 
				ClientData prevClientData));
/* 262 */
EXTERN ClientData	Tcl_VarTraceInfo2 _ANSI_ARGS_((Tcl_Interp * interp, 
				char * part1, char * part2, int flags, 
				Tcl_VarTraceProc * procPtr, 
				ClientData prevClientData));
/* 263 */
EXTERN int		Tcl_Write _ANSI_ARGS_((Tcl_Channel chan, char * s, 
				int slen));
/* 264 */
EXTERN void		Tcl_WrongNumArgs _ANSI_ARGS_((Tcl_Interp * interp, 
				int objc, Tcl_Obj *CONST objv[], 
				char * message));
/* 265 */
EXTERN int		Tcl_DumpActiveMemory _ANSI_ARGS_((char * fileName));
/* 266 */
EXTERN void		Tcl_ValidateAllMemory _ANSI_ARGS_((char * file, 
				int line));
/* 267 */
EXTERN void		Tcl_AppendResultVA _ANSI_ARGS_((Tcl_Interp * interp, 
				va_list argList));
/* 268 */
EXTERN void		Tcl_AppendStringsToObjVA _ANSI_ARGS_((
				Tcl_Obj * objPtr, va_list argList));
/* 269 */
EXTERN char *		Tcl_HashStats _ANSI_ARGS_((Tcl_HashTable * tablePtr));
/* 270 */
EXTERN char *		Tcl_ParseVar _ANSI_ARGS_((Tcl_Interp * interp, 
				char * string, char ** termPtr));
/* 271 */
EXTERN char *		Tcl_PkgPresent _ANSI_ARGS_((Tcl_Interp * interp, 
				char * name, char * version, int exact));
/* 272 */
EXTERN char *		Tcl_PkgPresentEx _ANSI_ARGS_((Tcl_Interp * interp, 
				char * name, char * version, int exact, 
				ClientData * clientDataPtr));
/* 273 */
EXTERN int		Tcl_PkgProvide _ANSI_ARGS_((Tcl_Interp * interp, 
				char * name, char * version));
/* 274 */
EXTERN char *		Tcl_PkgRequire _ANSI_ARGS_((Tcl_Interp * interp, 
				char * name, char * version, int exact));
/* 275 */
EXTERN void		Tcl_SetErrorCodeVA _ANSI_ARGS_((Tcl_Interp * interp, 
				va_list argList));
/* 276 */
EXTERN int		Tcl_VarEvalVA _ANSI_ARGS_((Tcl_Interp * interp, 
				va_list argList));
/* 277 */
EXTERN Tcl_Pid		Tcl_WaitPid _ANSI_ARGS_((Tcl_Pid pid, int * statPtr, 
				int options));
/* 278 */
EXTERN void		Tcl_PanicVA _ANSI_ARGS_((char * format, 
				va_list argList));
/* 279 */
EXTERN void		Tcl_GetVersion _ANSI_ARGS_((int * major, int * minor, 
				int * patchLevel, int * type));
/* Slot 280 is reserved */
/* Slot 281 is reserved */
/* Slot 282 is reserved */
/* Slot 283 is reserved */
/* Slot 284 is reserved */
/* Slot 285 is reserved */
/* 286 */
EXTERN void		Tcl_AppendObjToObj _ANSI_ARGS_((Tcl_Obj * objPtr, 
				Tcl_Obj * appendObjPtr));
/* 287 */
EXTERN Tcl_Encoding	Tcl_CreateEncoding _ANSI_ARGS_((
				Tcl_EncodingType * typePtr));
/* 288 */
EXTERN void		Tcl_CreateThreadExitHandler _ANSI_ARGS_((
				Tcl_ExitProc * proc, ClientData clientData));
/* 289 */
EXTERN void		Tcl_DeleteThreadExitHandler _ANSI_ARGS_((
				Tcl_ExitProc * proc, ClientData clientData));
/* 290 */
EXTERN void		Tcl_DiscardResult _ANSI_ARGS_((
				Tcl_SavedResult * statePtr));
/* 291 */
EXTERN int		Tcl_EvalEx _ANSI_ARGS_((Tcl_Interp * interp, 
				char * script, int numBytes, int flags));
/* 292 */
EXTERN int		Tcl_EvalObjv _ANSI_ARGS_((Tcl_Interp * interp, 
				int objc, Tcl_Obj *CONST objv[], int flags));
/* 293 */
EXTERN int		Tcl_EvalObjEx _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * objPtr, int flags));
/* 294 */
EXTERN void		Tcl_ExitThread _ANSI_ARGS_((int status));
/* 295 */
EXTERN int		Tcl_ExternalToUtf _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Encoding encoding, CONST char * src, 
				int srcLen, int flags, 
				Tcl_EncodingState * statePtr, char * dst, 
				int dstLen, int * srcReadPtr, 
				int * dstWrotePtr, int * dstCharsPtr));
/* 296 */
EXTERN char *		Tcl_ExternalToUtfDString _ANSI_ARGS_((
				Tcl_Encoding encoding, CONST char * src, 
				int srcLen, Tcl_DString * dsPtr));
/* 297 */
EXTERN void		Tcl_FinalizeThread _ANSI_ARGS_((void));
/* 298 */
EXTERN void		Tcl_FinalizeNotifier _ANSI_ARGS_((
				ClientData clientData));
/* 299 */
EXTERN void		Tcl_FreeEncoding _ANSI_ARGS_((Tcl_Encoding encoding));
/* 300 */
EXTERN Tcl_ThreadId	Tcl_GetCurrentThread _ANSI_ARGS_((void));
/* 301 */
EXTERN Tcl_Encoding	Tcl_GetEncoding _ANSI_ARGS_((Tcl_Interp * interp, 
				CONST char * name));
/* 302 */
EXTERN char *		Tcl_GetEncodingName _ANSI_ARGS_((
				Tcl_Encoding encoding));
/* 303 */
EXTERN void		Tcl_GetEncodingNames _ANSI_ARGS_((
				Tcl_Interp * interp));
/* 304 */
EXTERN int		Tcl_GetIndexFromObjStruct _ANSI_ARGS_((
				Tcl_Interp * interp, Tcl_Obj * objPtr, 
				char ** tablePtr, int offset, char * msg, 
				int flags, int * indexPtr));
/* 305 */
EXTERN VOID *		Tcl_GetThreadData _ANSI_ARGS_((
				Tcl_ThreadDataKey * keyPtr, int size));
/* 306 */
EXTERN Tcl_Obj *	Tcl_GetVar2Ex _ANSI_ARGS_((Tcl_Interp * interp, 
				char * part1, char * part2, int flags));
/* 307 */
EXTERN ClientData	Tcl_InitNotifier _ANSI_ARGS_((void));
/* 308 */
EXTERN void		Tcl_MutexLock _ANSI_ARGS_((Tcl_Mutex * mutexPtr));
/* 309 */
EXTERN void		Tcl_MutexUnlock _ANSI_ARGS_((Tcl_Mutex * mutexPtr));
/* 310 */
EXTERN void		Tcl_ConditionNotify _ANSI_ARGS_((
				Tcl_Condition * condPtr));
/* 311 */
EXTERN void		Tcl_ConditionWait _ANSI_ARGS_((
				Tcl_Condition * condPtr, 
				Tcl_Mutex * mutexPtr, Tcl_Time * timePtr));
/* 312 */
EXTERN int		Tcl_NumUtfChars _ANSI_ARGS_((CONST char * src, 
				int len));
/* 313 */
EXTERN int		Tcl_ReadChars _ANSI_ARGS_((Tcl_Channel channel, 
				Tcl_Obj * objPtr, int charsToRead, 
				int appendFlag));
/* 314 */
EXTERN void		Tcl_RestoreResult _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_SavedResult * statePtr));
/* 315 */
EXTERN void		Tcl_SaveResult _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_SavedResult * statePtr));
/* 316 */
EXTERN int		Tcl_SetSystemEncoding _ANSI_ARGS_((
				Tcl_Interp * interp, CONST char * name));
/* 317 */
EXTERN Tcl_Obj *	Tcl_SetVar2Ex _ANSI_ARGS_((Tcl_Interp * interp, 
				char * part1, char * part2, 
				Tcl_Obj * newValuePtr, int flags));
/* 318 */
EXTERN void		Tcl_ThreadAlert _ANSI_ARGS_((Tcl_ThreadId threadId));
/* 319 */
EXTERN void		Tcl_ThreadQueueEvent _ANSI_ARGS_((
				Tcl_ThreadId threadId, Tcl_Event* evPtr, 
				Tcl_QueuePosition position));
/* 320 */
EXTERN Tcl_UniChar	Tcl_UniCharAtIndex _ANSI_ARGS_((CONST char * src, 
				int index));
/* 321 */
EXTERN Tcl_UniChar	Tcl_UniCharToLower _ANSI_ARGS_((int ch));
/* 322 */
EXTERN Tcl_UniChar	Tcl_UniCharToTitle _ANSI_ARGS_((int ch));
/* 323 */
EXTERN Tcl_UniChar	Tcl_UniCharToUpper _ANSI_ARGS_((int ch));
/* 324 */
EXTERN int		Tcl_UniCharToUtf _ANSI_ARGS_((int ch, char * buf));
/* 325 */
EXTERN char *		Tcl_UtfAtIndex _ANSI_ARGS_((CONST char * src, 
				int index));
/* 326 */
EXTERN int		Tcl_UtfCharComplete _ANSI_ARGS_((CONST char * src, 
				int len));
/* 327 */
EXTERN int		Tcl_UtfBackslash _ANSI_ARGS_((CONST char * src, 
				int * readPtr, char * dst));
/* 328 */
EXTERN char *		Tcl_UtfFindFirst _ANSI_ARGS_((CONST char * src, 
				int ch));
/* 329 */
EXTERN char *		Tcl_UtfFindLast _ANSI_ARGS_((CONST char * src, 
				int ch));
/* 330 */
EXTERN char *		Tcl_UtfNext _ANSI_ARGS_((CONST char * src));
/* 331 */
EXTERN char *		Tcl_UtfPrev _ANSI_ARGS_((CONST char * src, 
				CONST char * start));
/* 332 */
EXTERN int		Tcl_UtfToExternal _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Encoding encoding, CONST char * src, 
				int srcLen, int flags, 
				Tcl_EncodingState * statePtr, char * dst, 
				int dstLen, int * srcReadPtr, 
				int * dstWrotePtr, int * dstCharsPtr));
/* 333 */
EXTERN char *		Tcl_UtfToExternalDString _ANSI_ARGS_((
				Tcl_Encoding encoding, CONST char * src, 
				int srcLen, Tcl_DString * dsPtr));
/* 334 */
EXTERN int		Tcl_UtfToLower _ANSI_ARGS_((char * src));
/* 335 */
EXTERN int		Tcl_UtfToTitle _ANSI_ARGS_((char * src));
/* 336 */
EXTERN int		Tcl_UtfToUniChar _ANSI_ARGS_((CONST char * src, 
				Tcl_UniChar * chPtr));
/* 337 */
EXTERN int		Tcl_UtfToUpper _ANSI_ARGS_((char * src));
/* 338 */
EXTERN int		Tcl_WriteChars _ANSI_ARGS_((Tcl_Channel chan, 
				CONST char * src, int srcLen));
/* 339 */
EXTERN int		Tcl_WriteObj _ANSI_ARGS_((Tcl_Channel chan, 
				Tcl_Obj * objPtr));
/* 340 */
EXTERN char *		Tcl_GetString _ANSI_ARGS_((Tcl_Obj * objPtr));
/* 341 */
EXTERN char *		Tcl_GetDefaultEncodingDir _ANSI_ARGS_((void));
/* 342 */
EXTERN void		Tcl_SetDefaultEncodingDir _ANSI_ARGS_((char * path));

typedef struct TclStubHooks {
    struct TclPlatStubs *tclPlatStubs;
    struct TclIntStubs *tclIntStubs;
    struct TclIntPlatStubs *tclIntPlatStubs;
} TclStubHooks;

typedef struct TclStubs {
    int magic;
    struct TclStubHooks *hooks;

    int (*tcl_PkgProvideEx) _ANSI_ARGS_((Tcl_Interp * interp, char * name, char * version, ClientData clientData)); /* 0 */
    char * (*tcl_PkgRequireEx) _ANSI_ARGS_((Tcl_Interp * interp, char * name, char * version, int exact, ClientData * clientDataPtr)); /* 1 */
    void (*tcl_Panic) _ANSI_ARGS_(TCL_VARARGS(char *,format)); /* 2 */
    char * (*tcl_Alloc) _ANSI_ARGS_((unsigned int size)); /* 3 */
    void (*tcl_Free) _ANSI_ARGS_((char * ptr)); /* 4 */
    char * (*tcl_Realloc) _ANSI_ARGS_((char * ptr, unsigned int size)); /* 5 */
    char * (*tcl_DbCkalloc) _ANSI_ARGS_((unsigned int size, char * file, int line)); /* 6 */
    int (*tcl_DbCkfree) _ANSI_ARGS_((char * ptr, char * file, int line)); /* 7 */
    char * (*tcl_DbCkrealloc) _ANSI_ARGS_((char * ptr, unsigned int size, char * file, int line)); /* 8 */
#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
    void (*tcl_CreateFileHandler) _ANSI_ARGS_((int fd, int mask, Tcl_FileProc * proc, ClientData clientData)); /* 9 */
#endif /* UNIX */
#ifdef __WIN32__
    void *reserved9;
#endif /* __WIN32__ */
#ifdef MAC_TCL
    void *reserved9;
#endif /* MAC_TCL */
#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
    void (*tcl_DeleteFileHandler) _ANSI_ARGS_((int fd)); /* 10 */
#endif /* UNIX */
#ifdef __WIN32__
    void *reserved10;
#endif /* __WIN32__ */
#ifdef MAC_TCL
    void *reserved10;
#endif /* MAC_TCL */
    void (*tcl_SetTimer) _ANSI_ARGS_((Tcl_Time * timePtr)); /* 11 */
    void (*tcl_Sleep) _ANSI_ARGS_((int ms)); /* 12 */
    int (*tcl_WaitForEvent) _ANSI_ARGS_((Tcl_Time * timePtr)); /* 13 */
    int (*tcl_AppendAllObjTypes) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr)); /* 14 */
    void (*tcl_AppendStringsToObj) _ANSI_ARGS_(TCL_VARARGS(Tcl_Obj *,objPtr)); /* 15 */
    void (*tcl_AppendToObj) _ANSI_ARGS_((Tcl_Obj * objPtr, char * bytes, int length)); /* 16 */
    Tcl_Obj * (*tcl_ConcatObj) _ANSI_ARGS_((int objc, Tcl_Obj *CONST objv[])); /* 17 */
    int (*tcl_ConvertToType) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr, Tcl_ObjType * typePtr)); /* 18 */
    void (*tcl_DbDecrRefCount) _ANSI_ARGS_((Tcl_Obj * objPtr, char * file, int line)); /* 19 */
    void (*tcl_DbIncrRefCount) _ANSI_ARGS_((Tcl_Obj * objPtr, char * file, int line)); /* 20 */
    int (*tcl_DbIsShared) _ANSI_ARGS_((Tcl_Obj * objPtr, char * file, int line)); /* 21 */
    Tcl_Obj * (*tcl_DbNewBooleanObj) _ANSI_ARGS_((int boolValue, char * file, int line)); /* 22 */
    Tcl_Obj * (*tcl_DbNewByteArrayObj) _ANSI_ARGS_((unsigned char * bytes, int length, char * file, int line)); /* 23 */
    Tcl_Obj * (*tcl_DbNewDoubleObj) _ANSI_ARGS_((double doubleValue, char * file, int line)); /* 24 */
    Tcl_Obj * (*tcl_DbNewListObj) _ANSI_ARGS_((int objc, Tcl_Obj *CONST objv[], char * file, int line)); /* 25 */
    Tcl_Obj * (*tcl_DbNewLongObj) _ANSI_ARGS_((long longValue, char * file, int line)); /* 26 */
    Tcl_Obj * (*tcl_DbNewObj) _ANSI_ARGS_((char * file, int line)); /* 27 */
    Tcl_Obj * (*tcl_DbNewStringObj) _ANSI_ARGS_((CONST char * bytes, int length, char * file, int line)); /* 28 */
    Tcl_Obj * (*tcl_DuplicateObj) _ANSI_ARGS_((Tcl_Obj * objPtr)); /* 29 */
    void (*tclFreeObj) _ANSI_ARGS_((Tcl_Obj * objPtr)); /* 30 */
    int (*tcl_GetBoolean) _ANSI_ARGS_((Tcl_Interp * interp, char * string, int * boolPtr)); /* 31 */
    int (*tcl_GetBooleanFromObj) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr, int * boolPtr)); /* 32 */
    unsigned char * (*tcl_GetByteArrayFromObj) _ANSI_ARGS_((Tcl_Obj * objPtr, int * lengthPtr)); /* 33 */
    int (*tcl_GetDouble) _ANSI_ARGS_((Tcl_Interp * interp, char * string, double * doublePtr)); /* 34 */
    int (*tcl_GetDoubleFromObj) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr, double * doublePtr)); /* 35 */
    int (*tcl_GetIndexFromObj) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr, char ** tablePtr, char * msg, int flags, int * indexPtr)); /* 36 */
    int (*tcl_GetInt) _ANSI_ARGS_((Tcl_Interp * interp, char * string, int * intPtr)); /* 37 */
    int (*tcl_GetIntFromObj) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr, int * intPtr)); /* 38 */
    int (*tcl_GetLongFromObj) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr, long * longPtr)); /* 39 */
    Tcl_ObjType * (*tcl_GetObjType) _ANSI_ARGS_((char * typeName)); /* 40 */
    char * (*tcl_GetStringFromObj) _ANSI_ARGS_((Tcl_Obj * objPtr, int * lengthPtr)); /* 41 */
    void (*tcl_InvalidateStringRep) _ANSI_ARGS_((Tcl_Obj * objPtr)); /* 42 */
    int (*tcl_ListObjAppendList) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * listPtr, Tcl_Obj * elemListPtr)); /* 43 */
    int (*tcl_ListObjAppendElement) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * listPtr, Tcl_Obj * objPtr)); /* 44 */
    int (*tcl_ListObjGetElements) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * listPtr, int * objcPtr, Tcl_Obj *** objvPtr)); /* 45 */
    int (*tcl_ListObjIndex) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * listPtr, int index, Tcl_Obj ** objPtrPtr)); /* 46 */
    int (*tcl_ListObjLength) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * listPtr, int * intPtr)); /* 47 */
    int (*tcl_ListObjReplace) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * listPtr, int first, int count, int objc, Tcl_Obj *CONST objv[])); /* 48 */
    Tcl_Obj * (*tcl_NewBooleanObj) _ANSI_ARGS_((int boolValue)); /* 49 */
    Tcl_Obj * (*tcl_NewByteArrayObj) _ANSI_ARGS_((unsigned char * bytes, int length)); /* 50 */
    Tcl_Obj * (*tcl_NewDoubleObj) _ANSI_ARGS_((double doubleValue)); /* 51 */
    Tcl_Obj * (*tcl_NewIntObj) _ANSI_ARGS_((int intValue)); /* 52 */
    Tcl_Obj * (*tcl_NewListObj) _ANSI_ARGS_((int objc, Tcl_Obj *CONST objv[])); /* 53 */
    Tcl_Obj * (*tcl_NewLongObj) _ANSI_ARGS_((long longValue)); /* 54 */
    Tcl_Obj * (*tcl_NewObj) _ANSI_ARGS_((void)); /* 55 */
    Tcl_Obj * (*tcl_NewStringObj) _ANSI_ARGS_((CONST char * bytes, int length)); /* 56 */
    void (*tcl_SetBooleanObj) _ANSI_ARGS_((Tcl_Obj * objPtr, int boolValue)); /* 57 */
    unsigned char * (*tcl_SetByteArrayLength) _ANSI_ARGS_((Tcl_Obj * objPtr, int length)); /* 58 */
    void (*tcl_SetByteArrayObj) _ANSI_ARGS_((Tcl_Obj * objPtr, unsigned char * bytes, int length)); /* 59 */
    void (*tcl_SetDoubleObj) _ANSI_ARGS_((Tcl_Obj * objPtr, double doubleValue)); /* 60 */
    void (*tcl_SetIntObj) _ANSI_ARGS_((Tcl_Obj * objPtr, int intValue)); /* 61 */
    void (*tcl_SetListObj) _ANSI_ARGS_((Tcl_Obj * objPtr, int objc, Tcl_Obj *CONST objv[])); /* 62 */
    void (*tcl_SetLongObj) _ANSI_ARGS_((Tcl_Obj * objPtr, long longValue)); /* 63 */
    void (*tcl_SetObjLength) _ANSI_ARGS_((Tcl_Obj * objPtr, int length)); /* 64 */
    void (*tcl_SetStringObj) _ANSI_ARGS_((Tcl_Obj * objPtr, char * bytes, int length)); /* 65 */
    void (*tcl_AddErrorInfo) _ANSI_ARGS_((Tcl_Interp * interp, CONST char * message)); /* 66 */
    void (*tcl_AddObjErrorInfo) _ANSI_ARGS_((Tcl_Interp * interp, CONST char * message, int length)); /* 67 */
    void (*tcl_AllowExceptions) _ANSI_ARGS_((Tcl_Interp * interp)); /* 68 */
    void (*tcl_AppendElement) _ANSI_ARGS_((Tcl_Interp * interp, CONST char * string)); /* 69 */
    void (*tcl_AppendResult) _ANSI_ARGS_(TCL_VARARGS(Tcl_Interp *,interp)); /* 70 */
    Tcl_AsyncHandler (*tcl_AsyncCreate) _ANSI_ARGS_((Tcl_AsyncProc * proc, ClientData clientData)); /* 71 */
    void (*tcl_AsyncDelete) _ANSI_ARGS_((Tcl_AsyncHandler async)); /* 72 */
    int (*tcl_AsyncInvoke) _ANSI_ARGS_((Tcl_Interp * interp, int code)); /* 73 */
    void (*tcl_AsyncMark) _ANSI_ARGS_((Tcl_AsyncHandler async)); /* 74 */
    int (*tcl_AsyncReady) _ANSI_ARGS_((void)); /* 75 */
    void (*tcl_BackgroundError) _ANSI_ARGS_((Tcl_Interp * interp)); /* 76 */
    char (*tcl_Backslash) _ANSI_ARGS_((CONST char * src, int * readPtr)); /* 77 */
    int (*tcl_BadChannelOption) _ANSI_ARGS_((Tcl_Interp * interp, char * optionName, char * optionList)); /* 78 */
    void (*tcl_CallWhenDeleted) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_InterpDeleteProc * proc, ClientData clientData)); /* 79 */
    void (*tcl_CancelIdleCall) _ANSI_ARGS_((Tcl_IdleProc * idleProc, ClientData clientData)); /* 80 */
    int (*tcl_Close) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Channel chan)); /* 81 */
    int (*tcl_CommandComplete) _ANSI_ARGS_((char * cmd)); /* 82 */
    char * (*tcl_Concat) _ANSI_ARGS_((int argc, char ** argv)); /* 83 */
    int (*tcl_ConvertElement) _ANSI_ARGS_((CONST char * src, char * dst, int flags)); /* 84 */
    int (*tcl_ConvertCountedElement) _ANSI_ARGS_((CONST char * src, int length, char * dst, int flags)); /* 85 */
    int (*tcl_CreateAlias) _ANSI_ARGS_((Tcl_Interp * slave, char * slaveCmd, Tcl_Interp * target, char * targetCmd, int argc, char ** argv)); /* 86 */
    int (*tcl_CreateAliasObj) _ANSI_ARGS_((Tcl_Interp * slave, char * slaveCmd, Tcl_Interp * target, char * targetCmd, int objc, Tcl_Obj *CONST objv[])); /* 87 */
    Tcl_Channel (*tcl_CreateChannel) _ANSI_ARGS_((Tcl_ChannelType * typePtr, char * chanName, ClientData instanceData, int mask)); /* 88 */
    void (*tcl_CreateChannelHandler) _ANSI_ARGS_((Tcl_Channel chan, int mask, Tcl_ChannelProc * proc, ClientData clientData)); /* 89 */
    void (*tcl_CreateCloseHandler) _ANSI_ARGS_((Tcl_Channel chan, Tcl_CloseProc * proc, ClientData clientData)); /* 90 */
    Tcl_Command (*tcl_CreateCommand) _ANSI_ARGS_((Tcl_Interp * interp, char * cmdName, Tcl_CmdProc * proc, ClientData clientData, Tcl_CmdDeleteProc * deleteProc)); /* 91 */
    void (*tcl_CreateEventSource) _ANSI_ARGS_((Tcl_EventSetupProc * setupProc, Tcl_EventCheckProc * checkProc, ClientData clientData)); /* 92 */
    void (*tcl_CreateExitHandler) _ANSI_ARGS_((Tcl_ExitProc * proc, ClientData clientData)); /* 93 */
    Tcl_Interp * (*tcl_CreateInterp) _ANSI_ARGS_((void)); /* 94 */
    void (*tcl_CreateMathFunc) _ANSI_ARGS_((Tcl_Interp * interp, char * name, int numArgs, Tcl_ValueType * argTypes, Tcl_MathProc * proc, ClientData clientData)); /* 95 */
    Tcl_Command (*tcl_CreateObjCommand) _ANSI_ARGS_((Tcl_Interp * interp, char * cmdName, Tcl_ObjCmdProc * proc, ClientData clientData, Tcl_CmdDeleteProc * deleteProc)); /* 96 */
    Tcl_Interp * (*tcl_CreateSlave) _ANSI_ARGS_((Tcl_Interp * interp, char * slaveName, int isSafe)); /* 97 */
    Tcl_TimerToken (*tcl_CreateTimerHandler) _ANSI_ARGS_((int milliseconds, Tcl_TimerProc * proc, ClientData clientData)); /* 98 */
    Tcl_Trace (*tcl_CreateTrace) _ANSI_ARGS_((Tcl_Interp * interp, int level, Tcl_CmdTraceProc * proc, ClientData clientData)); /* 99 */
    void (*tcl_DeleteAssocData) _ANSI_ARGS_((Tcl_Interp * interp, char * name)); /* 100 */
    void (*tcl_DeleteChannelHandler) _ANSI_ARGS_((Tcl_Channel chan, Tcl_ChannelProc * proc, ClientData clientData)); /* 101 */
    void (*tcl_DeleteCloseHandler) _ANSI_ARGS_((Tcl_Channel chan, Tcl_CloseProc * proc, ClientData clientData)); /* 102 */
    int (*tcl_DeleteCommand) _ANSI_ARGS_((Tcl_Interp * interp, char * cmdName)); /* 103 */
    int (*tcl_DeleteCommandFromToken) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Command command)); /* 104 */
    void (*tcl_DeleteEvents) _ANSI_ARGS_((Tcl_EventDeleteProc * proc, ClientData clientData)); /* 105 */
    void (*tcl_DeleteEventSource) _ANSI_ARGS_((Tcl_EventSetupProc * setupProc, Tcl_EventCheckProc * checkProc, ClientData clientData)); /* 106 */
    void (*tcl_DeleteExitHandler) _ANSI_ARGS_((Tcl_ExitProc * proc, ClientData clientData)); /* 107 */
    void (*tcl_DeleteHashEntry) _ANSI_ARGS_((Tcl_HashEntry * entryPtr)); /* 108 */
    void (*tcl_DeleteHashTable) _ANSI_ARGS_((Tcl_HashTable * tablePtr)); /* 109 */
    void (*tcl_DeleteInterp) _ANSI_ARGS_((Tcl_Interp * interp)); /* 110 */
    void (*tcl_DetachPids) _ANSI_ARGS_((int numPids, Tcl_Pid * pidPtr)); /* 111 */
    void (*tcl_DeleteTimerHandler) _ANSI_ARGS_((Tcl_TimerToken token)); /* 112 */
    void (*tcl_DeleteTrace) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Trace trace)); /* 113 */
    void (*tcl_DontCallWhenDeleted) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_InterpDeleteProc * proc, ClientData clientData)); /* 114 */
    int (*tcl_DoOneEvent) _ANSI_ARGS_((int flags)); /* 115 */
    void (*tcl_DoWhenIdle) _ANSI_ARGS_((Tcl_IdleProc * proc, ClientData clientData)); /* 116 */
    char * (*tcl_DStringAppend) _ANSI_ARGS_((Tcl_DString * dsPtr, CONST char * string, int length)); /* 117 */
    char * (*tcl_DStringAppendElement) _ANSI_ARGS_((Tcl_DString * dsPtr, CONST char * string)); /* 118 */
    void (*tcl_DStringEndSublist) _ANSI_ARGS_((Tcl_DString * dsPtr)); /* 119 */
    void (*tcl_DStringFree) _ANSI_ARGS_((Tcl_DString * dsPtr)); /* 120 */
    void (*tcl_DStringGetResult) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_DString * dsPtr)); /* 121 */
    void (*tcl_DStringInit) _ANSI_ARGS_((Tcl_DString * dsPtr)); /* 122 */
    void (*tcl_DStringResult) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_DString * dsPtr)); /* 123 */
    void (*tcl_DStringSetLength) _ANSI_ARGS_((Tcl_DString * dsPtr, int length)); /* 124 */
    void (*tcl_DStringStartSublist) _ANSI_ARGS_((Tcl_DString * dsPtr)); /* 125 */
    int (*tcl_Eof) _ANSI_ARGS_((Tcl_Channel chan)); /* 126 */
    char * (*tcl_ErrnoId) _ANSI_ARGS_((void)); /* 127 */
    char * (*tcl_ErrnoMsg) _ANSI_ARGS_((int err)); /* 128 */
    int (*tcl_Eval) _ANSI_ARGS_((Tcl_Interp * interp, char * string)); /* 129 */
    int (*tcl_EvalFile) _ANSI_ARGS_((Tcl_Interp * interp, char * fileName)); /* 130 */
    int (*tcl_EvalObj) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr)); /* 131 */
    void (*tcl_EventuallyFree) _ANSI_ARGS_((ClientData clientData, Tcl_FreeProc * freeProc)); /* 132 */
    void (*tcl_Exit) _ANSI_ARGS_((int status)); /* 133 */
    int (*tcl_ExposeCommand) _ANSI_ARGS_((Tcl_Interp * interp, char * hiddenCmdToken, char * cmdName)); /* 134 */
    int (*tcl_ExprBoolean) _ANSI_ARGS_((Tcl_Interp * interp, char * string, int * ptr)); /* 135 */
    int (*tcl_ExprBooleanObj) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr, int * ptr)); /* 136 */
    int (*tcl_ExprDouble) _ANSI_ARGS_((Tcl_Interp * interp, char * string, double * ptr)); /* 137 */
    int (*tcl_ExprDoubleObj) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr, double * ptr)); /* 138 */
    int (*tcl_ExprLong) _ANSI_ARGS_((Tcl_Interp * interp, char * string, long * ptr)); /* 139 */
    int (*tcl_ExprLongObj) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr, long * ptr)); /* 140 */
    int (*tcl_ExprObj) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr, Tcl_Obj ** resultPtrPtr)); /* 141 */
    int (*tcl_ExprString) _ANSI_ARGS_((Tcl_Interp * interp, char * string)); /* 142 */
    void (*tcl_Finalize) _ANSI_ARGS_((void)); /* 143 */
    void (*tcl_FindExecutable) _ANSI_ARGS_((CONST char * argv0)); /* 144 */
    Tcl_HashEntry * (*tcl_FirstHashEntry) _ANSI_ARGS_((Tcl_HashTable * tablePtr, Tcl_HashSearch * searchPtr)); /* 145 */
    int (*tcl_Flush) _ANSI_ARGS_((Tcl_Channel chan)); /* 146 */
    void (*tcl_FreeResult) _ANSI_ARGS_((Tcl_Interp * interp)); /* 147 */
    int (*tcl_GetAlias) _ANSI_ARGS_((Tcl_Interp * interp, char * slaveCmd, Tcl_Interp ** targetInterpPtr, char ** targetCmdPtr, int * argcPtr, char *** argvPtr)); /* 148 */
    int (*tcl_GetAliasObj) _ANSI_ARGS_((Tcl_Interp * interp, char * slaveCmd, Tcl_Interp ** targetInterpPtr, char ** targetCmdPtr, int * objcPtr, Tcl_Obj *** objv)); /* 149 */
    ClientData (*tcl_GetAssocData) _ANSI_ARGS_((Tcl_Interp * interp, char * name, Tcl_InterpDeleteProc ** procPtr)); /* 150 */
    Tcl_Channel (*tcl_GetChannel) _ANSI_ARGS_((Tcl_Interp * interp, char * chanName, int * modePtr)); /* 151 */
    int (*tcl_GetChannelBufferSize) _ANSI_ARGS_((Tcl_Channel chan)); /* 152 */
    int (*tcl_GetChannelHandle) _ANSI_ARGS_((Tcl_Channel chan, int direction, ClientData * handlePtr)); /* 153 */
    ClientData (*tcl_GetChannelInstanceData) _ANSI_ARGS_((Tcl_Channel chan)); /* 154 */
    int (*tcl_GetChannelMode) _ANSI_ARGS_((Tcl_Channel chan)); /* 155 */
    char * (*tcl_GetChannelName) _ANSI_ARGS_((Tcl_Channel chan)); /* 156 */
    int (*tcl_GetChannelOption) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Channel chan, char * optionName, Tcl_DString * dsPtr)); /* 157 */
    Tcl_ChannelType * (*tcl_GetChannelType) _ANSI_ARGS_((Tcl_Channel chan)); /* 158 */
    int (*tcl_GetCommandInfo) _ANSI_ARGS_((Tcl_Interp * interp, char * cmdName, Tcl_CmdInfo * infoPtr)); /* 159 */
    char * (*tcl_GetCommandName) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Command command)); /* 160 */
    int (*tcl_GetErrno) _ANSI_ARGS_((void)); /* 161 */
    char * (*tcl_GetHostName) _ANSI_ARGS_((void)); /* 162 */
    int (*tcl_GetInterpPath) _ANSI_ARGS_((Tcl_Interp * askInterp, Tcl_Interp * slaveInterp)); /* 163 */
    Tcl_Interp * (*tcl_GetMaster) _ANSI_ARGS_((Tcl_Interp * interp)); /* 164 */
    CONST char * (*tcl_GetNameOfExecutable) _ANSI_ARGS_((void)); /* 165 */
    Tcl_Obj * (*tcl_GetObjResult) _ANSI_ARGS_((Tcl_Interp * interp)); /* 166 */
#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
    int (*tcl_GetOpenFile) _ANSI_ARGS_((Tcl_Interp * interp, char * string, int write, int checkUsage, ClientData * filePtr)); /* 167 */
#endif /* UNIX */
#ifdef __WIN32__
    void *reserved167;
#endif /* __WIN32__ */
#ifdef MAC_TCL
    void *reserved167;
#endif /* MAC_TCL */
    Tcl_PathType (*tcl_GetPathType) _ANSI_ARGS_((char * path)); /* 168 */
    int (*tcl_Gets) _ANSI_ARGS_((Tcl_Channel chan, Tcl_DString * dsPtr)); /* 169 */
    int (*tcl_GetsObj) _ANSI_ARGS_((Tcl_Channel chan, Tcl_Obj * objPtr)); /* 170 */
    int (*tcl_GetServiceMode) _ANSI_ARGS_((void)); /* 171 */
    Tcl_Interp * (*tcl_GetSlave) _ANSI_ARGS_((Tcl_Interp * interp, char * slaveName)); /* 172 */
    Tcl_Channel (*tcl_GetStdChannel) _ANSI_ARGS_((int type)); /* 173 */
    char * (*tcl_GetStringResult) _ANSI_ARGS_((Tcl_Interp * interp)); /* 174 */
    char * (*tcl_GetVar) _ANSI_ARGS_((Tcl_Interp * interp, char * varName, int flags)); /* 175 */
    char * (*tcl_GetVar2) _ANSI_ARGS_((Tcl_Interp * interp, char * part1, char * part2, int flags)); /* 176 */
    int (*tcl_GlobalEval) _ANSI_ARGS_((Tcl_Interp * interp, char * command)); /* 177 */
    int (*tcl_GlobalEvalObj) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr)); /* 178 */
    int (*tcl_HideCommand) _ANSI_ARGS_((Tcl_Interp * interp, char * cmdName, char * hiddenCmdToken)); /* 179 */
    int (*tcl_Init) _ANSI_ARGS_((Tcl_Interp * interp)); /* 180 */
    void (*tcl_InitHashTable) _ANSI_ARGS_((Tcl_HashTable * tablePtr, int keyType)); /* 181 */
    int (*tcl_InputBlocked) _ANSI_ARGS_((Tcl_Channel chan)); /* 182 */
    int (*tcl_InputBuffered) _ANSI_ARGS_((Tcl_Channel chan)); /* 183 */
    int (*tcl_InterpDeleted) _ANSI_ARGS_((Tcl_Interp * interp)); /* 184 */
    int (*tcl_IsSafe) _ANSI_ARGS_((Tcl_Interp * interp)); /* 185 */
    char * (*tcl_JoinPath) _ANSI_ARGS_((int argc, char ** argv, Tcl_DString * resultPtr)); /* 186 */
    int (*tcl_LinkVar) _ANSI_ARGS_((Tcl_Interp * interp, char * varName, char * addr, int type)); /* 187 */
    void *reserved188;
    Tcl_Channel (*tcl_MakeFileChannel) _ANSI_ARGS_((ClientData handle, int mode)); /* 189 */
    int (*tcl_MakeSafe) _ANSI_ARGS_((Tcl_Interp * interp)); /* 190 */
    Tcl_Channel (*tcl_MakeTcpClientChannel) _ANSI_ARGS_((ClientData tcpSocket)); /* 191 */
    char * (*tcl_Merge) _ANSI_ARGS_((int argc, char ** argv)); /* 192 */
    Tcl_HashEntry * (*tcl_NextHashEntry) _ANSI_ARGS_((Tcl_HashSearch * searchPtr)); /* 193 */
    void (*tcl_NotifyChannel) _ANSI_ARGS_((Tcl_Channel channel, int mask)); /* 194 */
    Tcl_Obj * (*tcl_ObjGetVar2) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * part1Ptr, Tcl_Obj * part2Ptr, int flags)); /* 195 */
    Tcl_Obj * (*tcl_ObjSetVar2) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * part1Ptr, Tcl_Obj * part2Ptr, Tcl_Obj * newValuePtr, int flags)); /* 196 */
    Tcl_Channel (*tcl_OpenCommandChannel) _ANSI_ARGS_((Tcl_Interp * interp, int argc, char ** argv, int flags)); /* 197 */
    Tcl_Channel (*tcl_OpenFileChannel) _ANSI_ARGS_((Tcl_Interp * interp, char * fileName, char * modeString, int permissions)); /* 198 */
    Tcl_Channel (*tcl_OpenTcpClient) _ANSI_ARGS_((Tcl_Interp * interp, int port, char * address, char * myaddr, int myport, int async)); /* 199 */
    Tcl_Channel (*tcl_OpenTcpServer) _ANSI_ARGS_((Tcl_Interp * interp, int port, char * host, Tcl_TcpAcceptProc * acceptProc, ClientData callbackData)); /* 200 */
    void (*tcl_Preserve) _ANSI_ARGS_((ClientData data)); /* 201 */
    void (*tcl_PrintDouble) _ANSI_ARGS_((Tcl_Interp * interp, double value, char * dst)); /* 202 */
    int (*tcl_PutEnv) _ANSI_ARGS_((CONST char * string)); /* 203 */
    char * (*tcl_PosixError) _ANSI_ARGS_((Tcl_Interp * interp)); /* 204 */
    void (*tcl_QueueEvent) _ANSI_ARGS_((Tcl_Event * evPtr, Tcl_QueuePosition position)); /* 205 */
    int (*tcl_Read) _ANSI_ARGS_((Tcl_Channel chan, char * bufPtr, int toRead)); /* 206 */
    void (*tcl_ReapDetachedProcs) _ANSI_ARGS_((void)); /* 207 */
    int (*tcl_RecordAndEval) _ANSI_ARGS_((Tcl_Interp * interp, char * cmd, int flags)); /* 208 */
    int (*tcl_RecordAndEvalObj) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * cmdPtr, int flags)); /* 209 */
    void (*tcl_RegisterChannel) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Channel chan)); /* 210 */
    void (*tcl_RegisterObjType) _ANSI_ARGS_((Tcl_ObjType * typePtr)); /* 211 */
    Tcl_RegExp (*tcl_RegExpCompile) _ANSI_ARGS_((Tcl_Interp * interp, char * string)); /* 212 */
    int (*tcl_RegExpExec) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_RegExp regexp, CONST char * string, CONST char * start)); /* 213 */
    int (*tcl_RegExpMatch) _ANSI_ARGS_((Tcl_Interp * interp, char * string, char * pattern)); /* 214 */
    void (*tcl_RegExpRange) _ANSI_ARGS_((Tcl_RegExp regexp, int index, char ** startPtr, char ** endPtr)); /* 215 */
    void (*tcl_Release) _ANSI_ARGS_((ClientData clientData)); /* 216 */
    void (*tcl_ResetResult) _ANSI_ARGS_((Tcl_Interp * interp)); /* 217 */
    int (*tcl_ScanElement) _ANSI_ARGS_((CONST char * string, int * flagPtr)); /* 218 */
    int (*tcl_ScanCountedElement) _ANSI_ARGS_((CONST char * string, int length, int * flagPtr)); /* 219 */
    int (*tcl_Seek) _ANSI_ARGS_((Tcl_Channel chan, int offset, int mode)); /* 220 */
    int (*tcl_ServiceAll) _ANSI_ARGS_((void)); /* 221 */
    int (*tcl_ServiceEvent) _ANSI_ARGS_((int flags)); /* 222 */
    void (*tcl_SetAssocData) _ANSI_ARGS_((Tcl_Interp * interp, char * name, Tcl_InterpDeleteProc * proc, ClientData clientData)); /* 223 */
    void (*tcl_SetChannelBufferSize) _ANSI_ARGS_((Tcl_Channel chan, int sz)); /* 224 */
    int (*tcl_SetChannelOption) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Channel chan, char * optionName, char * newValue)); /* 225 */
    int (*tcl_SetCommandInfo) _ANSI_ARGS_((Tcl_Interp * interp, char * cmdName, Tcl_CmdInfo * infoPtr)); /* 226 */
    void (*tcl_SetErrno) _ANSI_ARGS_((int err)); /* 227 */
    void (*tcl_SetErrorCode) _ANSI_ARGS_(TCL_VARARGS(Tcl_Interp *,interp)); /* 228 */
    void (*tcl_SetMaxBlockTime) _ANSI_ARGS_((Tcl_Time * timePtr)); /* 229 */
    void (*tcl_SetPanicProc) _ANSI_ARGS_((Tcl_PanicProc * panicProc)); /* 230 */
    int (*tcl_SetRecursionLimit) _ANSI_ARGS_((Tcl_Interp * interp, int depth)); /* 231 */
    void (*tcl_SetResult) _ANSI_ARGS_((Tcl_Interp * interp, char * string, Tcl_FreeProc * freeProc)); /* 232 */
    int (*tcl_SetServiceMode) _ANSI_ARGS_((int mode)); /* 233 */
    void (*tcl_SetObjErrorCode) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * errorObjPtr)); /* 234 */
    void (*tcl_SetObjResult) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * resultObjPtr)); /* 235 */
    void (*tcl_SetStdChannel) _ANSI_ARGS_((Tcl_Channel channel, int type)); /* 236 */
    char * (*tcl_SetVar) _ANSI_ARGS_((Tcl_Interp * interp, char * varName, char * newValue, int flags)); /* 237 */
    char * (*tcl_SetVar2) _ANSI_ARGS_((Tcl_Interp * interp, char * part1, char * part2, char * newValue, int flags)); /* 238 */
    char * (*tcl_SignalId) _ANSI_ARGS_((int sig)); /* 239 */
    char * (*tcl_SignalMsg) _ANSI_ARGS_((int sig)); /* 240 */
    void (*tcl_SourceRCFile) _ANSI_ARGS_((Tcl_Interp * interp)); /* 241 */
    int (*tcl_SplitList) _ANSI_ARGS_((Tcl_Interp * interp, CONST char * list, int * argcPtr, char *** argvPtr)); /* 242 */
    void (*tcl_SplitPath) _ANSI_ARGS_((CONST char * path, int * argcPtr, char *** argvPtr)); /* 243 */
    void (*tcl_StaticPackage) _ANSI_ARGS_((Tcl_Interp * interp, char * pkgName, Tcl_PackageInitProc * initProc, Tcl_PackageInitProc * safeInitProc)); /* 244 */
    int (*tcl_StringMatch) _ANSI_ARGS_((CONST char * string, CONST char * pattern)); /* 245 */
    int (*tcl_Tell) _ANSI_ARGS_((Tcl_Channel chan)); /* 246 */
    int (*tcl_TraceVar) _ANSI_ARGS_((Tcl_Interp * interp, char * varName, int flags, Tcl_VarTraceProc * proc, ClientData clientData)); /* 247 */
    int (*tcl_TraceVar2) _ANSI_ARGS_((Tcl_Interp * interp, char * part1, char * part2, int flags, Tcl_VarTraceProc * proc, ClientData clientData)); /* 248 */
    char * (*tcl_TranslateFileName) _ANSI_ARGS_((Tcl_Interp * interp, char * name, Tcl_DString * bufferPtr)); /* 249 */
    int (*tcl_Ungets) _ANSI_ARGS_((Tcl_Channel chan, char * str, int len, int atHead)); /* 250 */
    void (*tcl_UnlinkVar) _ANSI_ARGS_((Tcl_Interp * interp, char * varName)); /* 251 */
    int (*tcl_UnregisterChannel) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Channel chan)); /* 252 */
    int (*tcl_UnsetVar) _ANSI_ARGS_((Tcl_Interp * interp, char * varName, int flags)); /* 253 */
    int (*tcl_UnsetVar2) _ANSI_ARGS_((Tcl_Interp * interp, char * part1, char * part2, int flags)); /* 254 */
    void (*tcl_UntraceVar) _ANSI_ARGS_((Tcl_Interp * interp, char * varName, int flags, Tcl_VarTraceProc * proc, ClientData clientData)); /* 255 */
    void (*tcl_UntraceVar2) _ANSI_ARGS_((Tcl_Interp * interp, char * part1, char * part2, int flags, Tcl_VarTraceProc * proc, ClientData clientData)); /* 256 */
    void (*tcl_UpdateLinkedVar) _ANSI_ARGS_((Tcl_Interp * interp, char * varName)); /* 257 */
    int (*tcl_UpVar) _ANSI_ARGS_((Tcl_Interp * interp, char * frameName, char * varName, char * localName, int flags)); /* 258 */
    int (*tcl_UpVar2) _ANSI_ARGS_((Tcl_Interp * interp, char * frameName, char * part1, char * part2, char * localName, int flags)); /* 259 */
    int (*tcl_VarEval) _ANSI_ARGS_(TCL_VARARGS(Tcl_Interp *,interp)); /* 260 */
    ClientData (*tcl_VarTraceInfo) _ANSI_ARGS_((Tcl_Interp * interp, char * varName, int flags, Tcl_VarTraceProc * procPtr, ClientData prevClientData)); /* 261 */
    ClientData (*tcl_VarTraceInfo2) _ANSI_ARGS_((Tcl_Interp * interp, char * part1, char * part2, int flags, Tcl_VarTraceProc * procPtr, ClientData prevClientData)); /* 262 */
    int (*tcl_Write) _ANSI_ARGS_((Tcl_Channel chan, char * s, int slen)); /* 263 */
    void (*tcl_WrongNumArgs) _ANSI_ARGS_((Tcl_Interp * interp, int objc, Tcl_Obj *CONST objv[], char * message)); /* 264 */
    int (*tcl_DumpActiveMemory) _ANSI_ARGS_((char * fileName)); /* 265 */
    void (*tcl_ValidateAllMemory) _ANSI_ARGS_((char * file, int line)); /* 266 */
    void (*tcl_AppendResultVA) _ANSI_ARGS_((Tcl_Interp * interp, va_list argList)); /* 267 */
    void (*tcl_AppendStringsToObjVA) _ANSI_ARGS_((Tcl_Obj * objPtr, va_list argList)); /* 268 */
    char * (*tcl_HashStats) _ANSI_ARGS_((Tcl_HashTable * tablePtr)); /* 269 */
    char * (*tcl_ParseVar) _ANSI_ARGS_((Tcl_Interp * interp, char * string, char ** termPtr)); /* 270 */
    char * (*tcl_PkgPresent) _ANSI_ARGS_((Tcl_Interp * interp, char * name, char * version, int exact)); /* 271 */
    char * (*tcl_PkgPresentEx) _ANSI_ARGS_((Tcl_Interp * interp, char * name, char * version, int exact, ClientData * clientDataPtr)); /* 272 */
    int (*tcl_PkgProvide) _ANSI_ARGS_((Tcl_Interp * interp, char * name, char * version)); /* 273 */
    char * (*tcl_PkgRequire) _ANSI_ARGS_((Tcl_Interp * interp, char * name, char * version, int exact)); /* 274 */
    void (*tcl_SetErrorCodeVA) _ANSI_ARGS_((Tcl_Interp * interp, va_list argList)); /* 275 */
    int (*tcl_VarEvalVA) _ANSI_ARGS_((Tcl_Interp * interp, va_list argList)); /* 276 */
    Tcl_Pid (*tcl_WaitPid) _ANSI_ARGS_((Tcl_Pid pid, int * statPtr, int options)); /* 277 */
    void (*tcl_PanicVA) _ANSI_ARGS_((char * format, va_list argList)); /* 278 */
    void (*tcl_GetVersion) _ANSI_ARGS_((int * major, int * minor, int * patchLevel, int * type)); /* 279 */
    void *reserved280;
    void *reserved281;
    void *reserved282;
    void *reserved283;
    void *reserved284;
    void *reserved285;
    void (*tcl_AppendObjToObj) _ANSI_ARGS_((Tcl_Obj * objPtr, Tcl_Obj * appendObjPtr)); /* 286 */
    Tcl_Encoding (*tcl_CreateEncoding) _ANSI_ARGS_((Tcl_EncodingType * typePtr)); /* 287 */
    void (*tcl_CreateThreadExitHandler) _ANSI_ARGS_((Tcl_ExitProc * proc, ClientData clientData)); /* 288 */
    void (*tcl_DeleteThreadExitHandler) _ANSI_ARGS_((Tcl_ExitProc * proc, ClientData clientData)); /* 289 */
    void (*tcl_DiscardResult) _ANSI_ARGS_((Tcl_SavedResult * statePtr)); /* 290 */
    int (*tcl_EvalEx) _ANSI_ARGS_((Tcl_Interp * interp, char * script, int numBytes, int flags)); /* 291 */
    int (*tcl_EvalObjv) _ANSI_ARGS_((Tcl_Interp * interp, int objc, Tcl_Obj *CONST objv[], int flags)); /* 292 */
    int (*tcl_EvalObjEx) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr, int flags)); /* 293 */
    void (*tcl_ExitThread) _ANSI_ARGS_((int status)); /* 294 */
    int (*tcl_ExternalToUtf) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Encoding encoding, CONST char * src, int srcLen, int flags, Tcl_EncodingState * statePtr, char * dst, int dstLen, int * srcReadPtr, int * dstWrotePtr, int * dstCharsPtr)); /* 295 */
    char * (*tcl_ExternalToUtfDString) _ANSI_ARGS_((Tcl_Encoding encoding, CONST char * src, int srcLen, Tcl_DString * dsPtr)); /* 296 */
    void (*tcl_FinalizeThread) _ANSI_ARGS_((void)); /* 297 */
    void (*tcl_FinalizeNotifier) _ANSI_ARGS_((ClientData clientData)); /* 298 */
    void (*tcl_FreeEncoding) _ANSI_ARGS_((Tcl_Encoding encoding)); /* 299 */
    Tcl_ThreadId (*tcl_GetCurrentThread) _ANSI_ARGS_((void)); /* 300 */
    Tcl_Encoding (*tcl_GetEncoding) _ANSI_ARGS_((Tcl_Interp * interp, CONST char * name)); /* 301 */
    char * (*tcl_GetEncodingName) _ANSI_ARGS_((Tcl_Encoding encoding)); /* 302 */
    void (*tcl_GetEncodingNames) _ANSI_ARGS_((Tcl_Interp * interp)); /* 303 */
    int (*tcl_GetIndexFromObjStruct) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr, char ** tablePtr, int offset, char * msg, int flags, int * indexPtr)); /* 304 */
    VOID * (*tcl_GetThreadData) _ANSI_ARGS_((Tcl_ThreadDataKey * keyPtr, int size)); /* 305 */
    Tcl_Obj * (*tcl_GetVar2Ex) _ANSI_ARGS_((Tcl_Interp * interp, char * part1, char * part2, int flags)); /* 306 */
    ClientData (*tcl_InitNotifier) _ANSI_ARGS_((void)); /* 307 */
    void (*tcl_MutexLock) _ANSI_ARGS_((Tcl_Mutex * mutexPtr)); /* 308 */
    void (*tcl_MutexUnlock) _ANSI_ARGS_((Tcl_Mutex * mutexPtr)); /* 309 */
    void (*tcl_ConditionNotify) _ANSI_ARGS_((Tcl_Condition * condPtr)); /* 310 */
    void (*tcl_ConditionWait) _ANSI_ARGS_((Tcl_Condition * condPtr, Tcl_Mutex * mutexPtr, Tcl_Time * timePtr)); /* 311 */
    int (*tcl_NumUtfChars) _ANSI_ARGS_((CONST char * src, int len)); /* 312 */
    int (*tcl_ReadChars) _ANSI_ARGS_((Tcl_Channel channel, Tcl_Obj * objPtr, int charsToRead, int appendFlag)); /* 313 */
    void (*tcl_RestoreResult) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_SavedResult * statePtr)); /* 314 */
    void (*tcl_SaveResult) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_SavedResult * statePtr)); /* 315 */
    int (*tcl_SetSystemEncoding) _ANSI_ARGS_((Tcl_Interp * interp, CONST char * name)); /* 316 */
    Tcl_Obj * (*tcl_SetVar2Ex) _ANSI_ARGS_((Tcl_Interp * interp, char * part1, char * part2, Tcl_Obj * newValuePtr, int flags)); /* 317 */
    void (*tcl_ThreadAlert) _ANSI_ARGS_((Tcl_ThreadId threadId)); /* 318 */
    void (*tcl_ThreadQueueEvent) _ANSI_ARGS_((Tcl_ThreadId threadId, Tcl_Event* evPtr, Tcl_QueuePosition position)); /* 319 */
    Tcl_UniChar (*tcl_UniCharAtIndex) _ANSI_ARGS_((CONST char * src, int index)); /* 320 */
    Tcl_UniChar (*tcl_UniCharToLower) _ANSI_ARGS_((int ch)); /* 321 */
    Tcl_UniChar (*tcl_UniCharToTitle) _ANSI_ARGS_((int ch)); /* 322 */
    Tcl_UniChar (*tcl_UniCharToUpper) _ANSI_ARGS_((int ch)); /* 323 */
    int (*tcl_UniCharToUtf) _ANSI_ARGS_((int ch, char * buf)); /* 324 */
    char * (*tcl_UtfAtIndex) _ANSI_ARGS_((CONST char * src, int index)); /* 325 */
    int (*tcl_UtfCharComplete) _ANSI_ARGS_((CONST char * src, int len)); /* 326 */
    int (*tcl_UtfBackslash) _ANSI_ARGS_((CONST char * src, int * readPtr, char * dst)); /* 327 */
    char * (*tcl_UtfFindFirst) _ANSI_ARGS_((CONST char * src, int ch)); /* 328 */
    char * (*tcl_UtfFindLast) _ANSI_ARGS_((CONST char * src, int ch)); /* 329 */
    char * (*tcl_UtfNext) _ANSI_ARGS_((CONST char * src)); /* 330 */
    char * (*tcl_UtfPrev) _ANSI_ARGS_((CONST char * src, CONST char * start)); /* 331 */
    int (*tcl_UtfToExternal) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Encoding encoding, CONST char * src, int srcLen, int flags, Tcl_EncodingState * statePtr, char * dst, int dstLen, int * srcReadPtr, int * dstWrotePtr, int * dstCharsPtr)); /* 332 */
    char * (*tcl_UtfToExternalDString) _ANSI_ARGS_((Tcl_Encoding encoding, CONST char * src, int srcLen, Tcl_DString * dsPtr)); /* 333 */
    int (*tcl_UtfToLower) _ANSI_ARGS_((char * src)); /* 334 */
    int (*tcl_UtfToTitle) _ANSI_ARGS_((char * src)); /* 335 */
    int (*tcl_UtfToUniChar) _ANSI_ARGS_((CONST char * src, Tcl_UniChar * chPtr)); /* 336 */
    int (*tcl_UtfToUpper) _ANSI_ARGS_((char * src)); /* 337 */
    int (*tcl_WriteChars) _ANSI_ARGS_((Tcl_Channel chan, CONST char * src, int srcLen)); /* 338 */
    int (*tcl_WriteObj) _ANSI_ARGS_((Tcl_Channel chan, Tcl_Obj * objPtr)); /* 339 */
    char * (*tcl_GetString) _ANSI_ARGS_((Tcl_Obj * objPtr)); /* 340 */
    char * (*tcl_GetDefaultEncodingDir) _ANSI_ARGS_((void)); /* 341 */
    void (*tcl_SetDefaultEncodingDir) _ANSI_ARGS_((char * path)); /* 342 */
} TclStubs;

extern TclStubs *tclStubsPtr;

#if defined(USE_TCL_STUBS) && !defined(USE_TCL_STUB_PROCS)

/*
 * Inline function declarations:
 */

#ifndef Tcl_PkgProvideEx
#define Tcl_PkgProvideEx(interp, name, version, clientData) \
	(tclStubsPtr->tcl_PkgProvideEx)(interp, name, version, clientData) /* 0 */
#endif
#ifndef Tcl_PkgRequireEx
#define Tcl_PkgRequireEx(interp, name, version, exact, clientDataPtr) \
	(tclStubsPtr->tcl_PkgRequireEx)(interp, name, version, exact, clientDataPtr) /* 1 */
#endif
#ifndef Tcl_Panic
#define Tcl_Panic \
	(tclStubsPtr->tcl_Panic) /* 2 */
#endif
#ifndef Tcl_Alloc
#define Tcl_Alloc(size) \
	(tclStubsPtr->tcl_Alloc)(size) /* 3 */
#endif
#ifndef Tcl_Free
#define Tcl_Free(ptr) \
	(tclStubsPtr->tcl_Free)(ptr) /* 4 */
#endif
#ifndef Tcl_Realloc
#define Tcl_Realloc(ptr, size) \
	(tclStubsPtr->tcl_Realloc)(ptr, size) /* 5 */
#endif
#ifndef Tcl_DbCkalloc
#define Tcl_DbCkalloc(size, file, line) \
	(tclStubsPtr->tcl_DbCkalloc)(size, file, line) /* 6 */
#endif
#ifndef Tcl_DbCkfree
#define Tcl_DbCkfree(ptr, file, line) \
	(tclStubsPtr->tcl_DbCkfree)(ptr, file, line) /* 7 */
#endif
#ifndef Tcl_DbCkrealloc
#define Tcl_DbCkrealloc(ptr, size, file, line) \
	(tclStubsPtr->tcl_DbCkrealloc)(ptr, size, file, line) /* 8 */
#endif
#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
#ifndef Tcl_CreateFileHandler
#define Tcl_CreateFileHandler(fd, mask, proc, clientData) \
	(tclStubsPtr->tcl_CreateFileHandler)(fd, mask, proc, clientData) /* 9 */
#endif
#endif /* UNIX */
#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
#ifndef Tcl_DeleteFileHandler
#define Tcl_DeleteFileHandler(fd) \
	(tclStubsPtr->tcl_DeleteFileHandler)(fd) /* 10 */
#endif
#endif /* UNIX */
#ifndef Tcl_SetTimer
#define Tcl_SetTimer(timePtr) \
	(tclStubsPtr->tcl_SetTimer)(timePtr) /* 11 */
#endif
#ifndef Tcl_Sleep
#define Tcl_Sleep(ms) \
	(tclStubsPtr->tcl_Sleep)(ms) /* 12 */
#endif
#ifndef Tcl_WaitForEvent
#define Tcl_WaitForEvent(timePtr) \
	(tclStubsPtr->tcl_WaitForEvent)(timePtr) /* 13 */
#endif
#ifndef Tcl_AppendAllObjTypes
#define Tcl_AppendAllObjTypes(interp, objPtr) \
	(tclStubsPtr->tcl_AppendAllObjTypes)(interp, objPtr) /* 14 */
#endif
#ifndef Tcl_AppendStringsToObj
#define Tcl_AppendStringsToObj \
	(tclStubsPtr->tcl_AppendStringsToObj) /* 15 */
#endif
#ifndef Tcl_AppendToObj
#define Tcl_AppendToObj(objPtr, bytes, length) \
	(tclStubsPtr->tcl_AppendToObj)(objPtr, bytes, length) /* 16 */
#endif
#ifndef Tcl_ConcatObj
#define Tcl_ConcatObj(objc, objv) \
	(tclStubsPtr->tcl_ConcatObj)(objc, objv) /* 17 */
#endif
#ifndef Tcl_ConvertToType
#define Tcl_ConvertToType(interp, objPtr, typePtr) \
	(tclStubsPtr->tcl_ConvertToType)(interp, objPtr, typePtr) /* 18 */
#endif
#ifndef Tcl_DbDecrRefCount
#define Tcl_DbDecrRefCount(objPtr, file, line) \
	(tclStubsPtr->tcl_DbDecrRefCount)(objPtr, file, line) /* 19 */
#endif
#ifndef Tcl_DbIncrRefCount
#define Tcl_DbIncrRefCount(objPtr, file, line) \
	(tclStubsPtr->tcl_DbIncrRefCount)(objPtr, file, line) /* 20 */
#endif
#ifndef Tcl_DbIsShared
#define Tcl_DbIsShared(objPtr, file, line) \
	(tclStubsPtr->tcl_DbIsShared)(objPtr, file, line) /* 21 */
#endif
#ifndef Tcl_DbNewBooleanObj
#define Tcl_DbNewBooleanObj(boolValue, file, line) \
	(tclStubsPtr->tcl_DbNewBooleanObj)(boolValue, file, line) /* 22 */
#endif
#ifndef Tcl_DbNewByteArrayObj
#define Tcl_DbNewByteArrayObj(bytes, length, file, line) \
	(tclStubsPtr->tcl_DbNewByteArrayObj)(bytes, length, file, line) /* 23 */
#endif
#ifndef Tcl_DbNewDoubleObj
#define Tcl_DbNewDoubleObj(doubleValue, file, line) \
	(tclStubsPtr->tcl_DbNewDoubleObj)(doubleValue, file, line) /* 24 */
#endif
#ifndef Tcl_DbNewListObj
#define Tcl_DbNewListObj(objc, objv, file, line) \
	(tclStubsPtr->tcl_DbNewListObj)(objc, objv, file, line) /* 25 */
#endif
#ifndef Tcl_DbNewLongObj
#define Tcl_DbNewLongObj(longValue, file, line) \
	(tclStubsPtr->tcl_DbNewLongObj)(longValue, file, line) /* 26 */
#endif
#ifndef Tcl_DbNewObj
#define Tcl_DbNewObj(file, line) \
	(tclStubsPtr->tcl_DbNewObj)(file, line) /* 27 */
#endif
#ifndef Tcl_DbNewStringObj
#define Tcl_DbNewStringObj(bytes, length, file, line) \
	(tclStubsPtr->tcl_DbNewStringObj)(bytes, length, file, line) /* 28 */
#endif
#ifndef Tcl_DuplicateObj
#define Tcl_DuplicateObj(objPtr) \
	(tclStubsPtr->tcl_DuplicateObj)(objPtr) /* 29 */
#endif
#ifndef TclFreeObj
#define TclFreeObj(objPtr) \
	(tclStubsPtr->tclFreeObj)(objPtr) /* 30 */
#endif
#ifndef Tcl_GetBoolean
#define Tcl_GetBoolean(interp, string, boolPtr) \
	(tclStubsPtr->tcl_GetBoolean)(interp, string, boolPtr) /* 31 */
#endif
#ifndef Tcl_GetBooleanFromObj
#define Tcl_GetBooleanFromObj(interp, objPtr, boolPtr) \
	(tclStubsPtr->tcl_GetBooleanFromObj)(interp, objPtr, boolPtr) /* 32 */
#endif
#ifndef Tcl_GetByteArrayFromObj
#define Tcl_GetByteArrayFromObj(objPtr, lengthPtr) \
	(tclStubsPtr->tcl_GetByteArrayFromObj)(objPtr, lengthPtr) /* 33 */
#endif
#ifndef Tcl_GetDouble
#define Tcl_GetDouble(interp, string, doublePtr) \
	(tclStubsPtr->tcl_GetDouble)(interp, string, doublePtr) /* 34 */
#endif
#ifndef Tcl_GetDoubleFromObj
#define Tcl_GetDoubleFromObj(interp, objPtr, doublePtr) \
	(tclStubsPtr->tcl_GetDoubleFromObj)(interp, objPtr, doublePtr) /* 35 */
#endif
#ifndef Tcl_GetIndexFromObj
#define Tcl_GetIndexFromObj(interp, objPtr, tablePtr, msg, flags, indexPtr) \
	(tclStubsPtr->tcl_GetIndexFromObj)(interp, objPtr, tablePtr, msg, flags, indexPtr) /* 36 */
#endif
#ifndef Tcl_GetInt
#define Tcl_GetInt(interp, string, intPtr) \
	(tclStubsPtr->tcl_GetInt)(interp, string, intPtr) /* 37 */
#endif
#ifndef Tcl_GetIntFromObj
#define Tcl_GetIntFromObj(interp, objPtr, intPtr) \
	(tclStubsPtr->tcl_GetIntFromObj)(interp, objPtr, intPtr) /* 38 */
#endif
#ifndef Tcl_GetLongFromObj
#define Tcl_GetLongFromObj(interp, objPtr, longPtr) \
	(tclStubsPtr->tcl_GetLongFromObj)(interp, objPtr, longPtr) /* 39 */
#endif
#ifndef Tcl_GetObjType
#define Tcl_GetObjType(typeName) \
	(tclStubsPtr->tcl_GetObjType)(typeName) /* 40 */
#endif
#ifndef Tcl_GetStringFromObj
#define Tcl_GetStringFromObj(objPtr, lengthPtr) \
	(tclStubsPtr->tcl_GetStringFromObj)(objPtr, lengthPtr) /* 41 */
#endif
#ifndef Tcl_InvalidateStringRep
#define Tcl_InvalidateStringRep(objPtr) \
	(tclStubsPtr->tcl_InvalidateStringRep)(objPtr) /* 42 */
#endif
#ifndef Tcl_ListObjAppendList
#define Tcl_ListObjAppendList(interp, listPtr, elemListPtr) \
	(tclStubsPtr->tcl_ListObjAppendList)(interp, listPtr, elemListPtr) /* 43 */
#endif
#ifndef Tcl_ListObjAppendElement
#define Tcl_ListObjAppendElement(interp, listPtr, objPtr) \
	(tclStubsPtr->tcl_ListObjAppendElement)(interp, listPtr, objPtr) /* 44 */
#endif
#ifndef Tcl_ListObjGetElements
#define Tcl_ListObjGetElements(interp, listPtr, objcPtr, objvPtr) \
	(tclStubsPtr->tcl_ListObjGetElements)(interp, listPtr, objcPtr, objvPtr) /* 45 */
#endif
#ifndef Tcl_ListObjIndex
#define Tcl_ListObjIndex(interp, listPtr, index, objPtrPtr) \
	(tclStubsPtr->tcl_ListObjIndex)(interp, listPtr, index, objPtrPtr) /* 46 */
#endif
#ifndef Tcl_ListObjLength
#define Tcl_ListObjLength(interp, listPtr, intPtr) \
	(tclStubsPtr->tcl_ListObjLength)(interp, listPtr, intPtr) /* 47 */
#endif
#ifndef Tcl_ListObjReplace
#define Tcl_ListObjReplace(interp, listPtr, first, count, objc, objv) \
	(tclStubsPtr->tcl_ListObjReplace)(interp, listPtr, first, count, objc, objv) /* 48 */
#endif
#ifndef Tcl_NewBooleanObj
#define Tcl_NewBooleanObj(boolValue) \
	(tclStubsPtr->tcl_NewBooleanObj)(boolValue) /* 49 */
#endif
#ifndef Tcl_NewByteArrayObj
#define Tcl_NewByteArrayObj(bytes, length) \
	(tclStubsPtr->tcl_NewByteArrayObj)(bytes, length) /* 50 */
#endif
#ifndef Tcl_NewDoubleObj
#define Tcl_NewDoubleObj(doubleValue) \
	(tclStubsPtr->tcl_NewDoubleObj)(doubleValue) /* 51 */
#endif
#ifndef Tcl_NewIntObj
#define Tcl_NewIntObj(intValue) \
	(tclStubsPtr->tcl_NewIntObj)(intValue) /* 52 */
#endif
#ifndef Tcl_NewListObj
#define Tcl_NewListObj(objc, objv) \
	(tclStubsPtr->tcl_NewListObj)(objc, objv) /* 53 */
#endif
#ifndef Tcl_NewLongObj
#define Tcl_NewLongObj(longValue) \
	(tclStubsPtr->tcl_NewLongObj)(longValue) /* 54 */
#endif
#ifndef Tcl_NewObj
#define Tcl_NewObj() \
	(tclStubsPtr->tcl_NewObj)() /* 55 */
#endif
#ifndef Tcl_NewStringObj
#define Tcl_NewStringObj(bytes, length) \
	(tclStubsPtr->tcl_NewStringObj)(bytes, length) /* 56 */
#endif
#ifndef Tcl_SetBooleanObj
#define Tcl_SetBooleanObj(objPtr, boolValue) \
	(tclStubsPtr->tcl_SetBooleanObj)(objPtr, boolValue) /* 57 */
#endif
#ifndef Tcl_SetByteArrayLength
#define Tcl_SetByteArrayLength(objPtr, length) \
	(tclStubsPtr->tcl_SetByteArrayLength)(objPtr, length) /* 58 */
#endif
#ifndef Tcl_SetByteArrayObj
#define Tcl_SetByteArrayObj(objPtr, bytes, length) \
	(tclStubsPtr->tcl_SetByteArrayObj)(objPtr, bytes, length) /* 59 */
#endif
#ifndef Tcl_SetDoubleObj
#define Tcl_SetDoubleObj(objPtr, doubleValue) \
	(tclStubsPtr->tcl_SetDoubleObj)(objPtr, doubleValue) /* 60 */
#endif
#ifndef Tcl_SetIntObj
#define Tcl_SetIntObj(objPtr, intValue) \
	(tclStubsPtr->tcl_SetIntObj)(objPtr, intValue) /* 61 */
#endif
#ifndef Tcl_SetListObj
#define Tcl_SetListObj(objPtr, objc, objv) \
	(tclStubsPtr->tcl_SetListObj)(objPtr, objc, objv) /* 62 */
#endif
#ifndef Tcl_SetLongObj
#define Tcl_SetLongObj(objPtr, longValue) \
	(tclStubsPtr->tcl_SetLongObj)(objPtr, longValue) /* 63 */
#endif
#ifndef Tcl_SetObjLength
#define Tcl_SetObjLength(objPtr, length) \
	(tclStubsPtr->tcl_SetObjLength)(objPtr, length) /* 64 */
#endif
#ifndef Tcl_SetStringObj
#define Tcl_SetStringObj(objPtr, bytes, length) \
	(tclStubsPtr->tcl_SetStringObj)(objPtr, bytes, length) /* 65 */
#endif
#ifndef Tcl_AddErrorInfo
#define Tcl_AddErrorInfo(interp, message) \
	(tclStubsPtr->tcl_AddErrorInfo)(interp, message) /* 66 */
#endif
#ifndef Tcl_AddObjErrorInfo
#define Tcl_AddObjErrorInfo(interp, message, length) \
	(tclStubsPtr->tcl_AddObjErrorInfo)(interp, message, length) /* 67 */
#endif
#ifndef Tcl_AllowExceptions
#define Tcl_AllowExceptions(interp) \
	(tclStubsPtr->tcl_AllowExceptions)(interp) /* 68 */
#endif
#ifndef Tcl_AppendElement
#define Tcl_AppendElement(interp, string) \
	(tclStubsPtr->tcl_AppendElement)(interp, string) /* 69 */
#endif
#ifndef Tcl_AppendResult
#define Tcl_AppendResult \
	(tclStubsPtr->tcl_AppendResult) /* 70 */
#endif
#ifndef Tcl_AsyncCreate
#define Tcl_AsyncCreate(proc, clientData) \
	(tclStubsPtr->tcl_AsyncCreate)(proc, clientData) /* 71 */
#endif
#ifndef Tcl_AsyncDelete
#define Tcl_AsyncDelete(async) \
	(tclStubsPtr->tcl_AsyncDelete)(async) /* 72 */
#endif
#ifndef Tcl_AsyncInvoke
#define Tcl_AsyncInvoke(interp, code) \
	(tclStubsPtr->tcl_AsyncInvoke)(interp, code) /* 73 */
#endif
#ifndef Tcl_AsyncMark
#define Tcl_AsyncMark(async) \
	(tclStubsPtr->tcl_AsyncMark)(async) /* 74 */
#endif
#ifndef Tcl_AsyncReady
#define Tcl_AsyncReady() \
	(tclStubsPtr->tcl_AsyncReady)() /* 75 */
#endif
#ifndef Tcl_BackgroundError
#define Tcl_BackgroundError(interp) \
	(tclStubsPtr->tcl_BackgroundError)(interp) /* 76 */
#endif
#ifndef Tcl_Backslash
#define Tcl_Backslash(src, readPtr) \
	(tclStubsPtr->tcl_Backslash)(src, readPtr) /* 77 */
#endif
#ifndef Tcl_BadChannelOption
#define Tcl_BadChannelOption(interp, optionName, optionList) \
	(tclStubsPtr->tcl_BadChannelOption)(interp, optionName, optionList) /* 78 */
#endif
#ifndef Tcl_CallWhenDeleted
#define Tcl_CallWhenDeleted(interp, proc, clientData) \
	(tclStubsPtr->tcl_CallWhenDeleted)(interp, proc, clientData) /* 79 */
#endif
#ifndef Tcl_CancelIdleCall
#define Tcl_CancelIdleCall(idleProc, clientData) \
	(tclStubsPtr->tcl_CancelIdleCall)(idleProc, clientData) /* 80 */
#endif
#ifndef Tcl_Close
#define Tcl_Close(interp, chan) \
	(tclStubsPtr->tcl_Close)(interp, chan) /* 81 */
#endif
#ifndef Tcl_CommandComplete
#define Tcl_CommandComplete(cmd) \
	(tclStubsPtr->tcl_CommandComplete)(cmd) /* 82 */
#endif
#ifndef Tcl_Concat
#define Tcl_Concat(argc, argv) \
	(tclStubsPtr->tcl_Concat)(argc, argv) /* 83 */
#endif
#ifndef Tcl_ConvertElement
#define Tcl_ConvertElement(src, dst, flags) \
	(tclStubsPtr->tcl_ConvertElement)(src, dst, flags) /* 84 */
#endif
#ifndef Tcl_ConvertCountedElement
#define Tcl_ConvertCountedElement(src, length, dst, flags) \
	(tclStubsPtr->tcl_ConvertCountedElement)(src, length, dst, flags) /* 85 */
#endif
#ifndef Tcl_CreateAlias
#define Tcl_CreateAlias(slave, slaveCmd, target, targetCmd, argc, argv) \
	(tclStubsPtr->tcl_CreateAlias)(slave, slaveCmd, target, targetCmd, argc, argv) /* 86 */
#endif
#ifndef Tcl_CreateAliasObj
#define Tcl_CreateAliasObj(slave, slaveCmd, target, targetCmd, objc, objv) \
	(tclStubsPtr->tcl_CreateAliasObj)(slave, slaveCmd, target, targetCmd, objc, objv) /* 87 */
#endif
#ifndef Tcl_CreateChannel
#define Tcl_CreateChannel(typePtr, chanName, instanceData, mask) \
	(tclStubsPtr->tcl_CreateChannel)(typePtr, chanName, instanceData, mask) /* 88 */
#endif
#ifndef Tcl_CreateChannelHandler
#define Tcl_CreateChannelHandler(chan, mask, proc, clientData) \
	(tclStubsPtr->tcl_CreateChannelHandler)(chan, mask, proc, clientData) /* 89 */
#endif
#ifndef Tcl_CreateCloseHandler
#define Tcl_CreateCloseHandler(chan, proc, clientData) \
	(tclStubsPtr->tcl_CreateCloseHandler)(chan, proc, clientData) /* 90 */
#endif
#ifndef Tcl_CreateCommand
#define Tcl_CreateCommand(interp, cmdName, proc, clientData, deleteProc) \
	(tclStubsPtr->tcl_CreateCommand)(interp, cmdName, proc, clientData, deleteProc) /* 91 */
#endif
#ifndef Tcl_CreateEventSource
#define Tcl_CreateEventSource(setupProc, checkProc, clientData) \
	(tclStubsPtr->tcl_CreateEventSource)(setupProc, checkProc, clientData) /* 92 */
#endif
#ifndef Tcl_CreateExitHandler
#define Tcl_CreateExitHandler(proc, clientData) \
	(tclStubsPtr->tcl_CreateExitHandler)(proc, clientData) /* 93 */
#endif
#ifndef Tcl_CreateInterp
#define Tcl_CreateInterp() \
	(tclStubsPtr->tcl_CreateInterp)() /* 94 */
#endif
#ifndef Tcl_CreateMathFunc
#define Tcl_CreateMathFunc(interp, name, numArgs, argTypes, proc, clientData) \
	(tclStubsPtr->tcl_CreateMathFunc)(interp, name, numArgs, argTypes, proc, clientData) /* 95 */
#endif
#ifndef Tcl_CreateObjCommand
#define Tcl_CreateObjCommand(interp, cmdName, proc, clientData, deleteProc) \
	(tclStubsPtr->tcl_CreateObjCommand)(interp, cmdName, proc, clientData, deleteProc) /* 96 */
#endif
#ifndef Tcl_CreateSlave
#define Tcl_CreateSlave(interp, slaveName, isSafe) \
	(tclStubsPtr->tcl_CreateSlave)(interp, slaveName, isSafe) /* 97 */
#endif
#ifndef Tcl_CreateTimerHandler
#define Tcl_CreateTimerHandler(milliseconds, proc, clientData) \
	(tclStubsPtr->tcl_CreateTimerHandler)(milliseconds, proc, clientData) /* 98 */
#endif
#ifndef Tcl_CreateTrace
#define Tcl_CreateTrace(interp, level, proc, clientData) \
	(tclStubsPtr->tcl_CreateTrace)(interp, level, proc, clientData) /* 99 */
#endif
#ifndef Tcl_DeleteAssocData
#define Tcl_DeleteAssocData(interp, name) \
	(tclStubsPtr->tcl_DeleteAssocData)(interp, name) /* 100 */
#endif
#ifndef Tcl_DeleteChannelHandler
#define Tcl_DeleteChannelHandler(chan, proc, clientData) \
	(tclStubsPtr->tcl_DeleteChannelHandler)(chan, proc, clientData) /* 101 */
#endif
#ifndef Tcl_DeleteCloseHandler
#define Tcl_DeleteCloseHandler(chan, proc, clientData) \
	(tclStubsPtr->tcl_DeleteCloseHandler)(chan, proc, clientData) /* 102 */
#endif
#ifndef Tcl_DeleteCommand
#define Tcl_DeleteCommand(interp, cmdName) \
	(tclStubsPtr->tcl_DeleteCommand)(interp, cmdName) /* 103 */
#endif
#ifndef Tcl_DeleteCommandFromToken
#define Tcl_DeleteCommandFromToken(interp, command) \
	(tclStubsPtr->tcl_DeleteCommandFromToken)(interp, command) /* 104 */
#endif
#ifndef Tcl_DeleteEvents
#define Tcl_DeleteEvents(proc, clientData) \
	(tclStubsPtr->tcl_DeleteEvents)(proc, clientData) /* 105 */
#endif
#ifndef Tcl_DeleteEventSource
#define Tcl_DeleteEventSource(setupProc, checkProc, clientData) \
	(tclStubsPtr->tcl_DeleteEventSource)(setupProc, checkProc, clientData) /* 106 */
#endif
#ifndef Tcl_DeleteExitHandler
#define Tcl_DeleteExitHandler(proc, clientData) \
	(tclStubsPtr->tcl_DeleteExitHandler)(proc, clientData) /* 107 */
#endif
#ifndef Tcl_DeleteHashEntry
#define Tcl_DeleteHashEntry(entryPtr) \
	(tclStubsPtr->tcl_DeleteHashEntry)(entryPtr) /* 108 */
#endif
#ifndef Tcl_DeleteHashTable
#define Tcl_DeleteHashTable(tablePtr) \
	(tclStubsPtr->tcl_DeleteHashTable)(tablePtr) /* 109 */
#endif
#ifndef Tcl_DeleteInterp
#define Tcl_DeleteInterp(interp) \
	(tclStubsPtr->tcl_DeleteInterp)(interp) /* 110 */
#endif
#ifndef Tcl_DetachPids
#define Tcl_DetachPids(numPids, pidPtr) \
	(tclStubsPtr->tcl_DetachPids)(numPids, pidPtr) /* 111 */
#endif
#ifndef Tcl_DeleteTimerHandler
#define Tcl_DeleteTimerHandler(token) \
	(tclStubsPtr->tcl_DeleteTimerHandler)(token) /* 112 */
#endif
#ifndef Tcl_DeleteTrace
#define Tcl_DeleteTrace(interp, trace) \
	(tclStubsPtr->tcl_DeleteTrace)(interp, trace) /* 113 */
#endif
#ifndef Tcl_DontCallWhenDeleted
#define Tcl_DontCallWhenDeleted(interp, proc, clientData) \
	(tclStubsPtr->tcl_DontCallWhenDeleted)(interp, proc, clientData) /* 114 */
#endif
#ifndef Tcl_DoOneEvent
#define Tcl_DoOneEvent(flags) \
	(tclStubsPtr->tcl_DoOneEvent)(flags) /* 115 */
#endif
#ifndef Tcl_DoWhenIdle
#define Tcl_DoWhenIdle(proc, clientData) \
	(tclStubsPtr->tcl_DoWhenIdle)(proc, clientData) /* 116 */
#endif
#ifndef Tcl_DStringAppend
#define Tcl_DStringAppend(dsPtr, string, length) \
	(tclStubsPtr->tcl_DStringAppend)(dsPtr, string, length) /* 117 */
#endif
#ifndef Tcl_DStringAppendElement
#define Tcl_DStringAppendElement(dsPtr, string) \
	(tclStubsPtr->tcl_DStringAppendElement)(dsPtr, string) /* 118 */
#endif
#ifndef Tcl_DStringEndSublist
#define Tcl_DStringEndSublist(dsPtr) \
	(tclStubsPtr->tcl_DStringEndSublist)(dsPtr) /* 119 */
#endif
#ifndef Tcl_DStringFree
#define Tcl_DStringFree(dsPtr) \
	(tclStubsPtr->tcl_DStringFree)(dsPtr) /* 120 */
#endif
#ifndef Tcl_DStringGetResult
#define Tcl_DStringGetResult(interp, dsPtr) \
	(tclStubsPtr->tcl_DStringGetResult)(interp, dsPtr) /* 121 */
#endif
#ifndef Tcl_DStringInit
#define Tcl_DStringInit(dsPtr) \
	(tclStubsPtr->tcl_DStringInit)(dsPtr) /* 122 */
#endif
#ifndef Tcl_DStringResult
#define Tcl_DStringResult(interp, dsPtr) \
	(tclStubsPtr->tcl_DStringResult)(interp, dsPtr) /* 123 */
#endif
#ifndef Tcl_DStringSetLength
#define Tcl_DStringSetLength(dsPtr, length) \
	(tclStubsPtr->tcl_DStringSetLength)(dsPtr, length) /* 124 */
#endif
#ifndef Tcl_DStringStartSublist
#define Tcl_DStringStartSublist(dsPtr) \
	(tclStubsPtr->tcl_DStringStartSublist)(dsPtr) /* 125 */
#endif
#ifndef Tcl_Eof
#define Tcl_Eof(chan) \
	(tclStubsPtr->tcl_Eof)(chan) /* 126 */
#endif
#ifndef Tcl_ErrnoId
#define Tcl_ErrnoId() \
	(tclStubsPtr->tcl_ErrnoId)() /* 127 */
#endif
#ifndef Tcl_ErrnoMsg
#define Tcl_ErrnoMsg(err) \
	(tclStubsPtr->tcl_ErrnoMsg)(err) /* 128 */
#endif
#ifndef Tcl_Eval
#define Tcl_Eval(interp, string) \
	(tclStubsPtr->tcl_Eval)(interp, string) /* 129 */
#endif
#ifndef Tcl_EvalFile
#define Tcl_EvalFile(interp, fileName) \
	(tclStubsPtr->tcl_EvalFile)(interp, fileName) /* 130 */
#endif
#ifndef Tcl_EvalObj
#define Tcl_EvalObj(interp, objPtr) \
	(tclStubsPtr->tcl_EvalObj)(interp, objPtr) /* 131 */
#endif
#ifndef Tcl_EventuallyFree
#define Tcl_EventuallyFree(clientData, freeProc) \
	(tclStubsPtr->tcl_EventuallyFree)(clientData, freeProc) /* 132 */
#endif
#ifndef Tcl_Exit
#define Tcl_Exit(status) \
	(tclStubsPtr->tcl_Exit)(status) /* 133 */
#endif
#ifndef Tcl_ExposeCommand
#define Tcl_ExposeCommand(interp, hiddenCmdToken, cmdName) \
	(tclStubsPtr->tcl_ExposeCommand)(interp, hiddenCmdToken, cmdName) /* 134 */
#endif
#ifndef Tcl_ExprBoolean
#define Tcl_ExprBoolean(interp, string, ptr) \
	(tclStubsPtr->tcl_ExprBoolean)(interp, string, ptr) /* 135 */
#endif
#ifndef Tcl_ExprBooleanObj
#define Tcl_ExprBooleanObj(interp, objPtr, ptr) \
	(tclStubsPtr->tcl_ExprBooleanObj)(interp, objPtr, ptr) /* 136 */
#endif
#ifndef Tcl_ExprDouble
#define Tcl_ExprDouble(interp, string, ptr) \
	(tclStubsPtr->tcl_ExprDouble)(interp, string, ptr) /* 137 */
#endif
#ifndef Tcl_ExprDoubleObj
#define Tcl_ExprDoubleObj(interp, objPtr, ptr) \
	(tclStubsPtr->tcl_ExprDoubleObj)(interp, objPtr, ptr) /* 138 */
#endif
#ifndef Tcl_ExprLong
#define Tcl_ExprLong(interp, string, ptr) \
	(tclStubsPtr->tcl_ExprLong)(interp, string, ptr) /* 139 */
#endif
#ifndef Tcl_ExprLongObj
#define Tcl_ExprLongObj(interp, objPtr, ptr) \
	(tclStubsPtr->tcl_ExprLongObj)(interp, objPtr, ptr) /* 140 */
#endif
#ifndef Tcl_ExprObj
#define Tcl_ExprObj(interp, objPtr, resultPtrPtr) \
	(tclStubsPtr->tcl_ExprObj)(interp, objPtr, resultPtrPtr) /* 141 */
#endif
#ifndef Tcl_ExprString
#define Tcl_ExprString(interp, string) \
	(tclStubsPtr->tcl_ExprString)(interp, string) /* 142 */
#endif
#ifndef Tcl_Finalize
#define Tcl_Finalize() \
	(tclStubsPtr->tcl_Finalize)() /* 143 */
#endif
#ifndef Tcl_FindExecutable
#define Tcl_FindExecutable(argv0) \
	(tclStubsPtr->tcl_FindExecutable)(argv0) /* 144 */
#endif
#ifndef Tcl_FirstHashEntry
#define Tcl_FirstHashEntry(tablePtr, searchPtr) \
	(tclStubsPtr->tcl_FirstHashEntry)(tablePtr, searchPtr) /* 145 */
#endif
#ifndef Tcl_Flush
#define Tcl_Flush(chan) \
	(tclStubsPtr->tcl_Flush)(chan) /* 146 */
#endif
#ifndef Tcl_FreeResult
#define Tcl_FreeResult(interp) \
	(tclStubsPtr->tcl_FreeResult)(interp) /* 147 */
#endif
#ifndef Tcl_GetAlias
#define Tcl_GetAlias(interp, slaveCmd, targetInterpPtr, targetCmdPtr, argcPtr, argvPtr) \
	(tclStubsPtr->tcl_GetAlias)(interp, slaveCmd, targetInterpPtr, targetCmdPtr, argcPtr, argvPtr) /* 148 */
#endif
#ifndef Tcl_GetAliasObj
#define Tcl_GetAliasObj(interp, slaveCmd, targetInterpPtr, targetCmdPtr, objcPtr, objv) \
	(tclStubsPtr->tcl_GetAliasObj)(interp, slaveCmd, targetInterpPtr, targetCmdPtr, objcPtr, objv) /* 149 */
#endif
#ifndef Tcl_GetAssocData
#define Tcl_GetAssocData(interp, name, procPtr) \
	(tclStubsPtr->tcl_GetAssocData)(interp, name, procPtr) /* 150 */
#endif
#ifndef Tcl_GetChannel
#define Tcl_GetChannel(interp, chanName, modePtr) \
	(tclStubsPtr->tcl_GetChannel)(interp, chanName, modePtr) /* 151 */
#endif
#ifndef Tcl_GetChannelBufferSize
#define Tcl_GetChannelBufferSize(chan) \
	(tclStubsPtr->tcl_GetChannelBufferSize)(chan) /* 152 */
#endif
#ifndef Tcl_GetChannelHandle
#define Tcl_GetChannelHandle(chan, direction, handlePtr) \
	(tclStubsPtr->tcl_GetChannelHandle)(chan, direction, handlePtr) /* 153 */
#endif
#ifndef Tcl_GetChannelInstanceData
#define Tcl_GetChannelInstanceData(chan) \
	(tclStubsPtr->tcl_GetChannelInstanceData)(chan) /* 154 */
#endif
#ifndef Tcl_GetChannelMode
#define Tcl_GetChannelMode(chan) \
	(tclStubsPtr->tcl_GetChannelMode)(chan) /* 155 */
#endif
#ifndef Tcl_GetChannelName
#define Tcl_GetChannelName(chan) \
	(tclStubsPtr->tcl_GetChannelName)(chan) /* 156 */
#endif
#ifndef Tcl_GetChannelOption
#define Tcl_GetChannelOption(interp, chan, optionName, dsPtr) \
	(tclStubsPtr->tcl_GetChannelOption)(interp, chan, optionName, dsPtr) /* 157 */
#endif
#ifndef Tcl_GetChannelType
#define Tcl_GetChannelType(chan) \
	(tclStubsPtr->tcl_GetChannelType)(chan) /* 158 */
#endif
#ifndef Tcl_GetCommandInfo
#define Tcl_GetCommandInfo(interp, cmdName, infoPtr) \
	(tclStubsPtr->tcl_GetCommandInfo)(interp, cmdName, infoPtr) /* 159 */
#endif
#ifndef Tcl_GetCommandName
#define Tcl_GetCommandName(interp, command) \
	(tclStubsPtr->tcl_GetCommandName)(interp, command) /* 160 */
#endif
#ifndef Tcl_GetErrno
#define Tcl_GetErrno() \
	(tclStubsPtr->tcl_GetErrno)() /* 161 */
#endif
#ifndef Tcl_GetHostName
#define Tcl_GetHostName() \
	(tclStubsPtr->tcl_GetHostName)() /* 162 */
#endif
#ifndef Tcl_GetInterpPath
#define Tcl_GetInterpPath(askInterp, slaveInterp) \
	(tclStubsPtr->tcl_GetInterpPath)(askInterp, slaveInterp) /* 163 */
#endif
#ifndef Tcl_GetMaster
#define Tcl_GetMaster(interp) \
	(tclStubsPtr->tcl_GetMaster)(interp) /* 164 */
#endif
#ifndef Tcl_GetNameOfExecutable
#define Tcl_GetNameOfExecutable() \
	(tclStubsPtr->tcl_GetNameOfExecutable)() /* 165 */
#endif
#ifndef Tcl_GetObjResult
#define Tcl_GetObjResult(interp) \
	(tclStubsPtr->tcl_GetObjResult)(interp) /* 166 */
#endif
#if !defined(__WIN32__) && !defined(MAC_TCL) /* UNIX */
#ifndef Tcl_GetOpenFile
#define Tcl_GetOpenFile(interp, string, write, checkUsage, filePtr) \
	(tclStubsPtr->tcl_GetOpenFile)(interp, string, write, checkUsage, filePtr) /* 167 */
#endif
#endif /* UNIX */
#ifndef Tcl_GetPathType
#define Tcl_GetPathType(path) \
	(tclStubsPtr->tcl_GetPathType)(path) /* 168 */
#endif
#ifndef Tcl_Gets
#define Tcl_Gets(chan, dsPtr) \
	(tclStubsPtr->tcl_Gets)(chan, dsPtr) /* 169 */
#endif
#ifndef Tcl_GetsObj
#define Tcl_GetsObj(chan, objPtr) \
	(tclStubsPtr->tcl_GetsObj)(chan, objPtr) /* 170 */
#endif
#ifndef Tcl_GetServiceMode
#define Tcl_GetServiceMode() \
	(tclStubsPtr->tcl_GetServiceMode)() /* 171 */
#endif
#ifndef Tcl_GetSlave
#define Tcl_GetSlave(interp, slaveName) \
	(tclStubsPtr->tcl_GetSlave)(interp, slaveName) /* 172 */
#endif
#ifndef Tcl_GetStdChannel
#define Tcl_GetStdChannel(type) \
	(tclStubsPtr->tcl_GetStdChannel)(type) /* 173 */
#endif
#ifndef Tcl_GetStringResult
#define Tcl_GetStringResult(interp) \
	(tclStubsPtr->tcl_GetStringResult)(interp) /* 174 */
#endif
#ifndef Tcl_GetVar
#define Tcl_GetVar(interp, varName, flags) \
	(tclStubsPtr->tcl_GetVar)(interp, varName, flags) /* 175 */
#endif
#ifndef Tcl_GetVar2
#define Tcl_GetVar2(interp, part1, part2, flags) \
	(tclStubsPtr->tcl_GetVar2)(interp, part1, part2, flags) /* 176 */
#endif
#ifndef Tcl_GlobalEval
#define Tcl_GlobalEval(interp, command) \
	(tclStubsPtr->tcl_GlobalEval)(interp, command) /* 177 */
#endif
#ifndef Tcl_GlobalEvalObj
#define Tcl_GlobalEvalObj(interp, objPtr) \
	(tclStubsPtr->tcl_GlobalEvalObj)(interp, objPtr) /* 178 */
#endif
#ifndef Tcl_HideCommand
#define Tcl_HideCommand(interp, cmdName, hiddenCmdToken) \
	(tclStubsPtr->tcl_HideCommand)(interp, cmdName, hiddenCmdToken) /* 179 */
#endif
#ifndef Tcl_Init
#define Tcl_Init(interp) \
	(tclStubsPtr->tcl_Init)(interp) /* 180 */
#endif
#ifndef Tcl_InitHashTable
#define Tcl_InitHashTable(tablePtr, keyType) \
	(tclStubsPtr->tcl_InitHashTable)(tablePtr, keyType) /* 181 */
#endif
#ifndef Tcl_InputBlocked
#define Tcl_InputBlocked(chan) \
	(tclStubsPtr->tcl_InputBlocked)(chan) /* 182 */
#endif
#ifndef Tcl_InputBuffered
#define Tcl_InputBuffered(chan) \
	(tclStubsPtr->tcl_InputBuffered)(chan) /* 183 */
#endif
#ifndef Tcl_InterpDeleted
#define Tcl_InterpDeleted(interp) \
	(tclStubsPtr->tcl_InterpDeleted)(interp) /* 184 */
#endif
#ifndef Tcl_IsSafe
#define Tcl_IsSafe(interp) \
	(tclStubsPtr->tcl_IsSafe)(interp) /* 185 */
#endif
#ifndef Tcl_JoinPath
#define Tcl_JoinPath(argc, argv, resultPtr) \
	(tclStubsPtr->tcl_JoinPath)(argc, argv, resultPtr) /* 186 */
#endif
#ifndef Tcl_LinkVar
#define Tcl_LinkVar(interp, varName, addr, type) \
	(tclStubsPtr->tcl_LinkVar)(interp, varName, addr, type) /* 187 */
#endif
/* Slot 188 is reserved */
#ifndef Tcl_MakeFileChannel
#define Tcl_MakeFileChannel(handle, mode) \
	(tclStubsPtr->tcl_MakeFileChannel)(handle, mode) /* 189 */
#endif
#ifndef Tcl_MakeSafe
#define Tcl_MakeSafe(interp) \
	(tclStubsPtr->tcl_MakeSafe)(interp) /* 190 */
#endif
#ifndef Tcl_MakeTcpClientChannel
#define Tcl_MakeTcpClientChannel(tcpSocket) \
	(tclStubsPtr->tcl_MakeTcpClientChannel)(tcpSocket) /* 191 */
#endif
#ifndef Tcl_Merge
#define Tcl_Merge(argc, argv) \
	(tclStubsPtr->tcl_Merge)(argc, argv) /* 192 */
#endif
#ifndef Tcl_NextHashEntry
#define Tcl_NextHashEntry(searchPtr) \
	(tclStubsPtr->tcl_NextHashEntry)(searchPtr) /* 193 */
#endif
#ifndef Tcl_NotifyChannel
#define Tcl_NotifyChannel(channel, mask) \
	(tclStubsPtr->tcl_NotifyChannel)(channel, mask) /* 194 */
#endif
#ifndef Tcl_ObjGetVar2
#define Tcl_ObjGetVar2(interp, part1Ptr, part2Ptr, flags) \
	(tclStubsPtr->tcl_ObjGetVar2)(interp, part1Ptr, part2Ptr, flags) /* 195 */
#endif
#ifndef Tcl_ObjSetVar2
#define Tcl_ObjSetVar2(interp, part1Ptr, part2Ptr, newValuePtr, flags) \
	(tclStubsPtr->tcl_ObjSetVar2)(interp, part1Ptr, part2Ptr, newValuePtr, flags) /* 196 */
#endif
#ifndef Tcl_OpenCommandChannel
#define Tcl_OpenCommandChannel(interp, argc, argv, flags) \
	(tclStubsPtr->tcl_OpenCommandChannel)(interp, argc, argv, flags) /* 197 */
#endif
#ifndef Tcl_OpenFileChannel
#define Tcl_OpenFileChannel(interp, fileName, modeString, permissions) \
	(tclStubsPtr->tcl_OpenFileChannel)(interp, fileName, modeString, permissions) /* 198 */
#endif
#ifndef Tcl_OpenTcpClient
#define Tcl_OpenTcpClient(interp, port, address, myaddr, myport, async) \
	(tclStubsPtr->tcl_OpenTcpClient)(interp, port, address, myaddr, myport, async) /* 199 */
#endif
#ifndef Tcl_OpenTcpServer
#define Tcl_OpenTcpServer(interp, port, host, acceptProc, callbackData) \
	(tclStubsPtr->tcl_OpenTcpServer)(interp, port, host, acceptProc, callbackData) /* 200 */
#endif
#ifndef Tcl_Preserve
#define Tcl_Preserve(data) \
	(tclStubsPtr->tcl_Preserve)(data) /* 201 */
#endif
#ifndef Tcl_PrintDouble
#define Tcl_PrintDouble(interp, value, dst) \
	(tclStubsPtr->tcl_PrintDouble)(interp, value, dst) /* 202 */
#endif
#ifndef Tcl_PutEnv
#define Tcl_PutEnv(string) \
	(tclStubsPtr->tcl_PutEnv)(string) /* 203 */
#endif
#ifndef Tcl_PosixError
#define Tcl_PosixError(interp) \
	(tclStubsPtr->tcl_PosixError)(interp) /* 204 */
#endif
#ifndef Tcl_QueueEvent
#define Tcl_QueueEvent(evPtr, position) \
	(tclStubsPtr->tcl_QueueEvent)(evPtr, position) /* 205 */
#endif
#ifndef Tcl_Read
#define Tcl_Read(chan, bufPtr, toRead) \
	(tclStubsPtr->tcl_Read)(chan, bufPtr, toRead) /* 206 */
#endif
#ifndef Tcl_ReapDetachedProcs
#define Tcl_ReapDetachedProcs() \
	(tclStubsPtr->tcl_ReapDetachedProcs)() /* 207 */
#endif
#ifndef Tcl_RecordAndEval
#define Tcl_RecordAndEval(interp, cmd, flags) \
	(tclStubsPtr->tcl_RecordAndEval)(interp, cmd, flags) /* 208 */
#endif
#ifndef Tcl_RecordAndEvalObj
#define Tcl_RecordAndEvalObj(interp, cmdPtr, flags) \
	(tclStubsPtr->tcl_RecordAndEvalObj)(interp, cmdPtr, flags) /* 209 */
#endif
#ifndef Tcl_RegisterChannel
#define Tcl_RegisterChannel(interp, chan) \
	(tclStubsPtr->tcl_RegisterChannel)(interp, chan) /* 210 */
#endif
#ifndef Tcl_RegisterObjType
#define Tcl_RegisterObjType(typePtr) \
	(tclStubsPtr->tcl_RegisterObjType)(typePtr) /* 211 */
#endif
#ifndef Tcl_RegExpCompile
#define Tcl_RegExpCompile(interp, string) \
	(tclStubsPtr->tcl_RegExpCompile)(interp, string) /* 212 */
#endif
#ifndef Tcl_RegExpExec
#define Tcl_RegExpExec(interp, regexp, string, start) \
	(tclStubsPtr->tcl_RegExpExec)(interp, regexp, string, start) /* 213 */
#endif
#ifndef Tcl_RegExpMatch
#define Tcl_RegExpMatch(interp, string, pattern) \
	(tclStubsPtr->tcl_RegExpMatch)(interp, string, pattern) /* 214 */
#endif
#ifndef Tcl_RegExpRange
#define Tcl_RegExpRange(regexp, index, startPtr, endPtr) \
	(tclStubsPtr->tcl_RegExpRange)(regexp, index, startPtr, endPtr) /* 215 */
#endif
#ifndef Tcl_Release
#define Tcl_Release(clientData) \
	(tclStubsPtr->tcl_Release)(clientData) /* 216 */
#endif
#ifndef Tcl_ResetResult
#define Tcl_ResetResult(interp) \
	(tclStubsPtr->tcl_ResetResult)(interp) /* 217 */
#endif
#ifndef Tcl_ScanElement
#define Tcl_ScanElement(string, flagPtr) \
	(tclStubsPtr->tcl_ScanElement)(string, flagPtr) /* 218 */
#endif
#ifndef Tcl_ScanCountedElement
#define Tcl_ScanCountedElement(string, length, flagPtr) \
	(tclStubsPtr->tcl_ScanCountedElement)(string, length, flagPtr) /* 219 */
#endif
#ifndef Tcl_Seek
#define Tcl_Seek(chan, offset, mode) \
	(tclStubsPtr->tcl_Seek)(chan, offset, mode) /* 220 */
#endif
#ifndef Tcl_ServiceAll
#define Tcl_ServiceAll() \
	(tclStubsPtr->tcl_ServiceAll)() /* 221 */
#endif
#ifndef Tcl_ServiceEvent
#define Tcl_ServiceEvent(flags) \
	(tclStubsPtr->tcl_ServiceEvent)(flags) /* 222 */
#endif
#ifndef Tcl_SetAssocData
#define Tcl_SetAssocData(interp, name, proc, clientData) \
	(tclStubsPtr->tcl_SetAssocData)(interp, name, proc, clientData) /* 223 */
#endif
#ifndef Tcl_SetChannelBufferSize
#define Tcl_SetChannelBufferSize(chan, sz) \
	(tclStubsPtr->tcl_SetChannelBufferSize)(chan, sz) /* 224 */
#endif
#ifndef Tcl_SetChannelOption
#define Tcl_SetChannelOption(interp, chan, optionName, newValue) \
	(tclStubsPtr->tcl_SetChannelOption)(interp, chan, optionName, newValue) /* 225 */
#endif
#ifndef Tcl_SetCommandInfo
#define Tcl_SetCommandInfo(interp, cmdName, infoPtr) \
	(tclStubsPtr->tcl_SetCommandInfo)(interp, cmdName, infoPtr) /* 226 */
#endif
#ifndef Tcl_SetErrno
#define Tcl_SetErrno(err) \
	(tclStubsPtr->tcl_SetErrno)(err) /* 227 */
#endif
#ifndef Tcl_SetErrorCode
#define Tcl_SetErrorCode \
	(tclStubsPtr->tcl_SetErrorCode) /* 228 */
#endif
#ifndef Tcl_SetMaxBlockTime
#define Tcl_SetMaxBlockTime(timePtr) \
	(tclStubsPtr->tcl_SetMaxBlockTime)(timePtr) /* 229 */
#endif
#ifndef Tcl_SetPanicProc
#define Tcl_SetPanicProc(panicProc) \
	(tclStubsPtr->tcl_SetPanicProc)(panicProc) /* 230 */
#endif
#ifndef Tcl_SetRecursionLimit
#define Tcl_SetRecursionLimit(interp, depth) \
	(tclStubsPtr->tcl_SetRecursionLimit)(interp, depth) /* 231 */
#endif
#ifndef Tcl_SetResult
#define Tcl_SetResult(interp, string, freeProc) \
	(tclStubsPtr->tcl_SetResult)(interp, string, freeProc) /* 232 */
#endif
#ifndef Tcl_SetServiceMode
#define Tcl_SetServiceMode(mode) \
	(tclStubsPtr->tcl_SetServiceMode)(mode) /* 233 */
#endif
#ifndef Tcl_SetObjErrorCode
#define Tcl_SetObjErrorCode(interp, errorObjPtr) \
	(tclStubsPtr->tcl_SetObjErrorCode)(interp, errorObjPtr) /* 234 */
#endif
#ifndef Tcl_SetObjResult
#define Tcl_SetObjResult(interp, resultObjPtr) \
	(tclStubsPtr->tcl_SetObjResult)(interp, resultObjPtr) /* 235 */
#endif
#ifndef Tcl_SetStdChannel
#define Tcl_SetStdChannel(channel, type) \
	(tclStubsPtr->tcl_SetStdChannel)(channel, type) /* 236 */
#endif
#ifndef Tcl_SetVar
#define Tcl_SetVar(interp, varName, newValue, flags) \
	(tclStubsPtr->tcl_SetVar)(interp, varName, newValue, flags) /* 237 */
#endif
#ifndef Tcl_SetVar2
#define Tcl_SetVar2(interp, part1, part2, newValue, flags) \
	(tclStubsPtr->tcl_SetVar2)(interp, part1, part2, newValue, flags) /* 238 */
#endif
#ifndef Tcl_SignalId
#define Tcl_SignalId(sig) \
	(tclStubsPtr->tcl_SignalId)(sig) /* 239 */
#endif
#ifndef Tcl_SignalMsg
#define Tcl_SignalMsg(sig) \
	(tclStubsPtr->tcl_SignalMsg)(sig) /* 240 */
#endif
#ifndef Tcl_SourceRCFile
#define Tcl_SourceRCFile(interp) \
	(tclStubsPtr->tcl_SourceRCFile)(interp) /* 241 */
#endif
#ifndef Tcl_SplitList
#define Tcl_SplitList(interp, list, argcPtr, argvPtr) \
	(tclStubsPtr->tcl_SplitList)(interp, list, argcPtr, argvPtr) /* 242 */
#endif
#ifndef Tcl_SplitPath
#define Tcl_SplitPath(path, argcPtr, argvPtr) \
	(tclStubsPtr->tcl_SplitPath)(path, argcPtr, argvPtr) /* 243 */
#endif
#ifndef Tcl_StaticPackage
#define Tcl_StaticPackage(interp, pkgName, initProc, safeInitProc) \
	(tclStubsPtr->tcl_StaticPackage)(interp, pkgName, initProc, safeInitProc) /* 244 */
#endif
#ifndef Tcl_StringMatch
#define Tcl_StringMatch(string, pattern) \
	(tclStubsPtr->tcl_StringMatch)(string, pattern) /* 245 */
#endif
#ifndef Tcl_Tell
#define Tcl_Tell(chan) \
	(tclStubsPtr->tcl_Tell)(chan) /* 246 */
#endif
#ifndef Tcl_TraceVar
#define Tcl_TraceVar(interp, varName, flags, proc, clientData) \
	(tclStubsPtr->tcl_TraceVar)(interp, varName, flags, proc, clientData) /* 247 */
#endif
#ifndef Tcl_TraceVar2
#define Tcl_TraceVar2(interp, part1, part2, flags, proc, clientData) \
	(tclStubsPtr->tcl_TraceVar2)(interp, part1, part2, flags, proc, clientData) /* 248 */
#endif
#ifndef Tcl_TranslateFileName
#define Tcl_TranslateFileName(interp, name, bufferPtr) \
	(tclStubsPtr->tcl_TranslateFileName)(interp, name, bufferPtr) /* 249 */
#endif
#ifndef Tcl_Ungets
#define Tcl_Ungets(chan, str, len, atHead) \
	(tclStubsPtr->tcl_Ungets)(chan, str, len, atHead) /* 250 */
#endif
#ifndef Tcl_UnlinkVar
#define Tcl_UnlinkVar(interp, varName) \
	(tclStubsPtr->tcl_UnlinkVar)(interp, varName) /* 251 */
#endif
#ifndef Tcl_UnregisterChannel
#define Tcl_UnregisterChannel(interp, chan) \
	(tclStubsPtr->tcl_UnregisterChannel)(interp, chan) /* 252 */
#endif
#ifndef Tcl_UnsetVar
#define Tcl_UnsetVar(interp, varName, flags) \
	(tclStubsPtr->tcl_UnsetVar)(interp, varName, flags) /* 253 */
#endif
#ifndef Tcl_UnsetVar2
#define Tcl_UnsetVar2(interp, part1, part2, flags) \
	(tclStubsPtr->tcl_UnsetVar2)(interp, part1, part2, flags) /* 254 */
#endif
#ifndef Tcl_UntraceVar
#define Tcl_UntraceVar(interp, varName, flags, proc, clientData) \
	(tclStubsPtr->tcl_UntraceVar)(interp, varName, flags, proc, clientData) /* 255 */
#endif
#ifndef Tcl_UntraceVar2
#define Tcl_UntraceVar2(interp, part1, part2, flags, proc, clientData) \
	(tclStubsPtr->tcl_UntraceVar2)(interp, part1, part2, flags, proc, clientData) /* 256 */
#endif
#ifndef Tcl_UpdateLinkedVar
#define Tcl_UpdateLinkedVar(interp, varName) \
	(tclStubsPtr->tcl_UpdateLinkedVar)(interp, varName) /* 257 */
#endif
#ifndef Tcl_UpVar
#define Tcl_UpVar(interp, frameName, varName, localName, flags) \
	(tclStubsPtr->tcl_UpVar)(interp, frameName, varName, localName, flags) /* 258 */
#endif
#ifndef Tcl_UpVar2
#define Tcl_UpVar2(interp, frameName, part1, part2, localName, flags) \
	(tclStubsPtr->tcl_UpVar2)(interp, frameName, part1, part2, localName, flags) /* 259 */
#endif
#ifndef Tcl_VarEval
#define Tcl_VarEval \
	(tclStubsPtr->tcl_VarEval) /* 260 */
#endif
#ifndef Tcl_VarTraceInfo
#define Tcl_VarTraceInfo(interp, varName, flags, procPtr, prevClientData) \
	(tclStubsPtr->tcl_VarTraceInfo)(interp, varName, flags, procPtr, prevClientData) /* 261 */
#endif
#ifndef Tcl_VarTraceInfo2
#define Tcl_VarTraceInfo2(interp, part1, part2, flags, procPtr, prevClientData) \
	(tclStubsPtr->tcl_VarTraceInfo2)(interp, part1, part2, flags, procPtr, prevClientData) /* 262 */
#endif
#ifndef Tcl_Write
#define Tcl_Write(chan, s, slen) \
	(tclStubsPtr->tcl_Write)(chan, s, slen) /* 263 */
#endif
#ifndef Tcl_WrongNumArgs
#define Tcl_WrongNumArgs(interp, objc, objv, message) \
	(tclStubsPtr->tcl_WrongNumArgs)(interp, objc, objv, message) /* 264 */
#endif
#ifndef Tcl_DumpActiveMemory
#define Tcl_DumpActiveMemory(fileName) \
	(tclStubsPtr->tcl_DumpActiveMemory)(fileName) /* 265 */
#endif
#ifndef Tcl_ValidateAllMemory
#define Tcl_ValidateAllMemory(file, line) \
	(tclStubsPtr->tcl_ValidateAllMemory)(file, line) /* 266 */
#endif
#ifndef Tcl_AppendResultVA
#define Tcl_AppendResultVA(interp, argList) \
	(tclStubsPtr->tcl_AppendResultVA)(interp, argList) /* 267 */
#endif
#ifndef Tcl_AppendStringsToObjVA
#define Tcl_AppendStringsToObjVA(objPtr, argList) \
	(tclStubsPtr->tcl_AppendStringsToObjVA)(objPtr, argList) /* 268 */
#endif
#ifndef Tcl_HashStats
#define Tcl_HashStats(tablePtr) \
	(tclStubsPtr->tcl_HashStats)(tablePtr) /* 269 */
#endif
#ifndef Tcl_ParseVar
#define Tcl_ParseVar(interp, string, termPtr) \
	(tclStubsPtr->tcl_ParseVar)(interp, string, termPtr) /* 270 */
#endif
#ifndef Tcl_PkgPresent
#define Tcl_PkgPresent(interp, name, version, exact) \
	(tclStubsPtr->tcl_PkgPresent)(interp, name, version, exact) /* 271 */
#endif
#ifndef Tcl_PkgPresentEx
#define Tcl_PkgPresentEx(interp, name, version, exact, clientDataPtr) \
	(tclStubsPtr->tcl_PkgPresentEx)(interp, name, version, exact, clientDataPtr) /* 272 */
#endif
#ifndef Tcl_PkgProvide
#define Tcl_PkgProvide(interp, name, version) \
	(tclStubsPtr->tcl_PkgProvide)(interp, name, version) /* 273 */
#endif
#ifndef Tcl_PkgRequire
#define Tcl_PkgRequire(interp, name, version, exact) \
	(tclStubsPtr->tcl_PkgRequire)(interp, name, version, exact) /* 274 */
#endif
#ifndef Tcl_SetErrorCodeVA
#define Tcl_SetErrorCodeVA(interp, argList) \
	(tclStubsPtr->tcl_SetErrorCodeVA)(interp, argList) /* 275 */
#endif
#ifndef Tcl_VarEvalVA
#define Tcl_VarEvalVA(interp, argList) \
	(tclStubsPtr->tcl_VarEvalVA)(interp, argList) /* 276 */
#endif
#ifndef Tcl_WaitPid
#define Tcl_WaitPid(pid, statPtr, options) \
	(tclStubsPtr->tcl_WaitPid)(pid, statPtr, options) /* 277 */
#endif
#ifndef Tcl_PanicVA
#define Tcl_PanicVA(format, argList) \
	(tclStubsPtr->tcl_PanicVA)(format, argList) /* 278 */
#endif
#ifndef Tcl_GetVersion
#define Tcl_GetVersion(major, minor, patchLevel, type) \
	(tclStubsPtr->tcl_GetVersion)(major, minor, patchLevel, type) /* 279 */
#endif
/* Slot 280 is reserved */
/* Slot 281 is reserved */
/* Slot 282 is reserved */
/* Slot 283 is reserved */
/* Slot 284 is reserved */
/* Slot 285 is reserved */
#ifndef Tcl_AppendObjToObj
#define Tcl_AppendObjToObj(objPtr, appendObjPtr) \
	(tclStubsPtr->tcl_AppendObjToObj)(objPtr, appendObjPtr) /* 286 */
#endif
#ifndef Tcl_CreateEncoding
#define Tcl_CreateEncoding(typePtr) \
	(tclStubsPtr->tcl_CreateEncoding)(typePtr) /* 287 */
#endif
#ifndef Tcl_CreateThreadExitHandler
#define Tcl_CreateThreadExitHandler(proc, clientData) \
	(tclStubsPtr->tcl_CreateThreadExitHandler)(proc, clientData) /* 288 */
#endif
#ifndef Tcl_DeleteThreadExitHandler
#define Tcl_DeleteThreadExitHandler(proc, clientData) \
	(tclStubsPtr->tcl_DeleteThreadExitHandler)(proc, clientData) /* 289 */
#endif
#ifndef Tcl_DiscardResult
#define Tcl_DiscardResult(statePtr) \
	(tclStubsPtr->tcl_DiscardResult)(statePtr) /* 290 */
#endif
#ifndef Tcl_EvalEx
#define Tcl_EvalEx(interp, script, numBytes, flags) \
	(tclStubsPtr->tcl_EvalEx)(interp, script, numBytes, flags) /* 291 */
#endif
#ifndef Tcl_EvalObjv
#define Tcl_EvalObjv(interp, objc, objv, flags) \
	(tclStubsPtr->tcl_EvalObjv)(interp, objc, objv, flags) /* 292 */
#endif
#ifndef Tcl_EvalObjEx
#define Tcl_EvalObjEx(interp, objPtr, flags) \
	(tclStubsPtr->tcl_EvalObjEx)(interp, objPtr, flags) /* 293 */
#endif
#ifndef Tcl_ExitThread
#define Tcl_ExitThread(status) \
	(tclStubsPtr->tcl_ExitThread)(status) /* 294 */
#endif
#ifndef Tcl_ExternalToUtf
#define Tcl_ExternalToUtf(interp, encoding, src, srcLen, flags, statePtr, dst, dstLen, srcReadPtr, dstWrotePtr, dstCharsPtr) \
	(tclStubsPtr->tcl_ExternalToUtf)(interp, encoding, src, srcLen, flags, statePtr, dst, dstLen, srcReadPtr, dstWrotePtr, dstCharsPtr) /* 295 */
#endif
#ifndef Tcl_ExternalToUtfDString
#define Tcl_ExternalToUtfDString(encoding, src, srcLen, dsPtr) \
	(tclStubsPtr->tcl_ExternalToUtfDString)(encoding, src, srcLen, dsPtr) /* 296 */
#endif
#ifndef Tcl_FinalizeThread
#define Tcl_FinalizeThread() \
	(tclStubsPtr->tcl_FinalizeThread)() /* 297 */
#endif
#ifndef Tcl_FinalizeNotifier
#define Tcl_FinalizeNotifier(clientData) \
	(tclStubsPtr->tcl_FinalizeNotifier)(clientData) /* 298 */
#endif
#ifndef Tcl_FreeEncoding
#define Tcl_FreeEncoding(encoding) \
	(tclStubsPtr->tcl_FreeEncoding)(encoding) /* 299 */
#endif
#ifndef Tcl_GetCurrentThread
#define Tcl_GetCurrentThread() \
	(tclStubsPtr->tcl_GetCurrentThread)() /* 300 */
#endif
#ifndef Tcl_GetEncoding
#define Tcl_GetEncoding(interp, name) \
	(tclStubsPtr->tcl_GetEncoding)(interp, name) /* 301 */
#endif
#ifndef Tcl_GetEncodingName
#define Tcl_GetEncodingName(encoding) \
	(tclStubsPtr->tcl_GetEncodingName)(encoding) /* 302 */
#endif
#ifndef Tcl_GetEncodingNames
#define Tcl_GetEncodingNames(interp) \
	(tclStubsPtr->tcl_GetEncodingNames)(interp) /* 303 */
#endif
#ifndef Tcl_GetIndexFromObjStruct
#define Tcl_GetIndexFromObjStruct(interp, objPtr, tablePtr, offset, msg, flags, indexPtr) \
	(tclStubsPtr->tcl_GetIndexFromObjStruct)(interp, objPtr, tablePtr, offset, msg, flags, indexPtr) /* 304 */
#endif
#ifndef Tcl_GetThreadData
#define Tcl_GetThreadData(keyPtr, size) \
	(tclStubsPtr->tcl_GetThreadData)(keyPtr, size) /* 305 */
#endif
#ifndef Tcl_GetVar2Ex
#define Tcl_GetVar2Ex(interp, part1, part2, flags) \
	(tclStubsPtr->tcl_GetVar2Ex)(interp, part1, part2, flags) /* 306 */
#endif
#ifndef Tcl_InitNotifier
#define Tcl_InitNotifier() \
	(tclStubsPtr->tcl_InitNotifier)() /* 307 */
#endif
#ifndef Tcl_MutexLock
#define Tcl_MutexLock(mutexPtr) \
	(tclStubsPtr->tcl_MutexLock)(mutexPtr) /* 308 */
#endif
#ifndef Tcl_MutexUnlock
#define Tcl_MutexUnlock(mutexPtr) \
	(tclStubsPtr->tcl_MutexUnlock)(mutexPtr) /* 309 */
#endif
#ifndef Tcl_ConditionNotify
#define Tcl_ConditionNotify(condPtr) \
	(tclStubsPtr->tcl_ConditionNotify)(condPtr) /* 310 */
#endif
#ifndef Tcl_ConditionWait
#define Tcl_ConditionWait(condPtr, mutexPtr, timePtr) \
	(tclStubsPtr->tcl_ConditionWait)(condPtr, mutexPtr, timePtr) /* 311 */
#endif
#ifndef Tcl_NumUtfChars
#define Tcl_NumUtfChars(src, len) \
	(tclStubsPtr->tcl_NumUtfChars)(src, len) /* 312 */
#endif
#ifndef Tcl_ReadChars
#define Tcl_ReadChars(channel, objPtr, charsToRead, appendFlag) \
	(tclStubsPtr->tcl_ReadChars)(channel, objPtr, charsToRead, appendFlag) /* 313 */
#endif
#ifndef Tcl_RestoreResult
#define Tcl_RestoreResult(interp, statePtr) \
	(tclStubsPtr->tcl_RestoreResult)(interp, statePtr) /* 314 */
#endif
#ifndef Tcl_SaveResult
#define Tcl_SaveResult(interp, statePtr) \
	(tclStubsPtr->tcl_SaveResult)(interp, statePtr) /* 315 */
#endif
#ifndef Tcl_SetSystemEncoding
#define Tcl_SetSystemEncoding(interp, name) \
	(tclStubsPtr->tcl_SetSystemEncoding)(interp, name) /* 316 */
#endif
#ifndef Tcl_SetVar2Ex
#define Tcl_SetVar2Ex(interp, part1, part2, newValuePtr, flags) \
	(tclStubsPtr->tcl_SetVar2Ex)(interp, part1, part2, newValuePtr, flags) /* 317 */
#endif
#ifndef Tcl_ThreadAlert
#define Tcl_ThreadAlert(threadId) \
	(tclStubsPtr->tcl_ThreadAlert)(threadId) /* 318 */
#endif
#ifndef Tcl_ThreadQueueEvent
#define Tcl_ThreadQueueEvent(threadId, evPtr, position) \
	(tclStubsPtr->tcl_ThreadQueueEvent)(threadId, evPtr, position) /* 319 */
#endif
#ifndef Tcl_UniCharAtIndex
#define Tcl_UniCharAtIndex(src, index) \
	(tclStubsPtr->tcl_UniCharAtIndex)(src, index) /* 320 */
#endif
#ifndef Tcl_UniCharToLower
#define Tcl_UniCharToLower(ch) \
	(tclStubsPtr->tcl_UniCharToLower)(ch) /* 321 */
#endif
#ifndef Tcl_UniCharToTitle
#define Tcl_UniCharToTitle(ch) \
	(tclStubsPtr->tcl_UniCharToTitle)(ch) /* 322 */
#endif
#ifndef Tcl_UniCharToUpper
#define Tcl_UniCharToUpper(ch) \
	(tclStubsPtr->tcl_UniCharToUpper)(ch) /* 323 */
#endif
#ifndef Tcl_UniCharToUtf
#define Tcl_UniCharToUtf(ch, buf) \
	(tclStubsPtr->tcl_UniCharToUtf)(ch, buf) /* 324 */
#endif
#ifndef Tcl_UtfAtIndex
#define Tcl_UtfAtIndex(src, index) \
	(tclStubsPtr->tcl_UtfAtIndex)(src, index) /* 325 */
#endif
#ifndef Tcl_UtfCharComplete
#define Tcl_UtfCharComplete(src, len) \
	(tclStubsPtr->tcl_UtfCharComplete)(src, len) /* 326 */
#endif
#ifndef Tcl_UtfBackslash
#define Tcl_UtfBackslash(src, readPtr, dst) \
	(tclStubsPtr->tcl_UtfBackslash)(src, readPtr, dst) /* 327 */
#endif
#ifndef Tcl_UtfFindFirst
#define Tcl_UtfFindFirst(src, ch) \
	(tclStubsPtr->tcl_UtfFindFirst)(src, ch) /* 328 */
#endif
#ifndef Tcl_UtfFindLast
#define Tcl_UtfFindLast(src, ch) \
	(tclStubsPtr->tcl_UtfFindLast)(src, ch) /* 329 */
#endif
#ifndef Tcl_UtfNext
#define Tcl_UtfNext(src) \
	(tclStubsPtr->tcl_UtfNext)(src) /* 330 */
#endif
#ifndef Tcl_UtfPrev
#define Tcl_UtfPrev(src, start) \
	(tclStubsPtr->tcl_UtfPrev)(src, start) /* 331 */
#endif
#ifndef Tcl_UtfToExternal
#define Tcl_UtfToExternal(interp, encoding, src, srcLen, flags, statePtr, dst, dstLen, srcReadPtr, dstWrotePtr, dstCharsPtr) \
	(tclStubsPtr->tcl_UtfToExternal)(interp, encoding, src, srcLen, flags, statePtr, dst, dstLen, srcReadPtr, dstWrotePtr, dstCharsPtr) /* 332 */
#endif
#ifndef Tcl_UtfToExternalDString
#define Tcl_UtfToExternalDString(encoding, src, srcLen, dsPtr) \
	(tclStubsPtr->tcl_UtfToExternalDString)(encoding, src, srcLen, dsPtr) /* 333 */
#endif
#ifndef Tcl_UtfToLower
#define Tcl_UtfToLower(src) \
	(tclStubsPtr->tcl_UtfToLower)(src) /* 334 */
#endif
#ifndef Tcl_UtfToTitle
#define Tcl_UtfToTitle(src) \
	(tclStubsPtr->tcl_UtfToTitle)(src) /* 335 */
#endif
#ifndef Tcl_UtfToUniChar
#define Tcl_UtfToUniChar(src, chPtr) \
	(tclStubsPtr->tcl_UtfToUniChar)(src, chPtr) /* 336 */
#endif
#ifndef Tcl_UtfToUpper
#define Tcl_UtfToUpper(src) \
	(tclStubsPtr->tcl_UtfToUpper)(src) /* 337 */
#endif
#ifndef Tcl_WriteChars
#define Tcl_WriteChars(chan, src, srcLen) \
	(tclStubsPtr->tcl_WriteChars)(chan, src, srcLen) /* 338 */
#endif
#ifndef Tcl_WriteObj
#define Tcl_WriteObj(chan, objPtr) \
	(tclStubsPtr->tcl_WriteObj)(chan, objPtr) /* 339 */
#endif
#ifndef Tcl_GetString
#define Tcl_GetString(objPtr) \
	(tclStubsPtr->tcl_GetString)(objPtr) /* 340 */
#endif
#ifndef Tcl_GetDefaultEncodingDir
#define Tcl_GetDefaultEncodingDir() \
	(tclStubsPtr->tcl_GetDefaultEncodingDir)() /* 341 */
#endif
#ifndef Tcl_SetDefaultEncodingDir
#define Tcl_SetDefaultEncodingDir(path) \
	(tclStubsPtr->tcl_SetDefaultEncodingDir)(path) /* 342 */
#endif

#endif /* defined(USE_TCL_STUBS) && !defined(USE_TCL_STUB_PROCS) */

/* !END!: Do not edit above this line. */

#endif /* _TCLDECLS */

