'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" SCCS: @(#) lsort.n 1.6 96/03/25 20:20:27
'\" 
.so man.macros
.TH lsort n 7.0 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
lsort \- Sort the elements of a list
.SH SYNOPSIS
\fBlsort \fR?\fIswitches\fR? \fIlist\fR
.BE

.SH DESCRIPTION
.PP
This command sorts the elements of \fIlist\fR, returning a new
list in sorted order.  By default ASCII sorting is used with
the result returned in increasing order.
.VS
However, any of the
following switches may be specified before \fIlist\fR to
control the sorting process (unique abbreviations are accepted):
.TP 20
\fB\-ascii\fR
Use string comparison with ASCII collation order.  This is
the default.
.TP 20
\fB\-integer\fR
Convert list elements to integers and use integer comparison.
.TP 20
\fB\-real\fR
Convert list elements to floating-point values and use floating
comparison.
.TP 20
\fB\-command\0\fIcommand\fR
Use \fIcommand\fR as a comparison command.
To compare two elements, evaluate a Tcl script consisting of
\fIcommand\fR with the two elements appended as additional
arguments.  The script should return an integer less than,
equal to, or greater than zero if the first element is to
be considered less than, equal to, or greater than the second,
respectively.
.TP 20
\fB\-increasing\fR
Sort the list in increasing order (``smallest'' items first).
This is the default.
.TP 20
\fB\-decreasing\fR
Sort the list in decreasing order (``largest'' items first).
.VE

.SH KEYWORDS
element, list, order, sort
