proc cgi_unquote_input80 {buf} {
    # rewrite "+" back to space
    regsub -all {\+} $buf { } buf
    # protect \ $ [ " for finishing eval
    regsub -all {([\\[\"$])} $buf {\\\1} buf
    # replace line delimiters with newlines
    regsub -all -nocase "%0d%0a" $buf "\n" buf
    # prepare to process all %-escapes 
    regsub -all -nocase {%([a-f0-9][a-f0-9])} $buf {[format %c 0x\1]} buf
    # process %-escapes and undo all protection
    eval return \"$buf\"
}
proc cgi_unquote_input82 {buf} {
    # rewrite "+" back to space
    # protect \ from quoting another '\'
    # replace line delimiters with newlines
    set buf [string map -nocase [list + { } "\\" "\\\\" %0d%0a \n] $buf]
    # prepare to process all %-escapes
    regsub -all -nocase {%([a-f0-9][a-f0-9])} $buf {\\u00\1} buf
    # process \u unicode mapped chars
    return [subst -novar -nocommand $buf]
}
package require http
set data [::http::formatQuery [info body cgi_unquote_input82]]

cgi_unquote_input80 $data
