/*
 * emu.r --
 *
 *	This file creates resources used by the exampleA package.
 *
 * Copyright (c) 1997 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#include <Types.r>
#include <SysTypes.r>


#define VU_LIBRARY_RESOURCES 5000

/*
 * The folowing include and defines help construct
 * the version string.
 */

#include "version.h"

#define RELEASE_LEVEL final		/* alpha, beta, or final */
#define FINAL 1				/* Change to 1 if final version. */

#if FINAL
#   define MINOR_VERSION (VU_MINOR_VERSION * 16) + VU_RELEASE_SERIAL
#else
#   define MINOR_VERSION VU_MINOR_VERSION * 16
#endif

#define RELEASE_CODE 0x00

resource 'vers' (1) {
	VU_MAJOR_VERSION, MINOR_VERSION,
	RELEASE_LEVEL, 0x00, verUS,
	VU_PATCH_LEVEL,
	VU_PATCH_LEVEL ", by Jeffrey Hobbs."
};

resource 'vers' (2) {
	VU_MAJOR_VERSION, MINOR_VERSION,
	RELEASE_LEVEL, 0x00, verUS,
	VU_PATCH_LEVEL,
	"Vu " VU_PATCH_LEVEL "  1995-2001"
};

/*
 * The -16397 string will be displayed by Finder when a user
 * tries to open the shared library. The string should
 * give the user a little detail about the library's capabilities
 * and enough information to install the library in the correct location.  
 */
resource 'STR ' (-16397, purgeable) {
	"vu Library\n\n"
	"This library provides the vu widgets to"
	"Tcl/Tk programs.  To work properly, it "
	"should be placed in the Tool Command Language folder "
	"within the Extensions folder."
};


data 'TEXT' (4000,"pkgIndex",purgeable, preload) {
	"# Tcl package index file, version 1.0\n"
	"package ifneeded vu " VU_VERSION " [list load [file join $dir vu[info sharedlibextension]] vu]\n"
};

data 'TEXT' (VU_LIBRARY_RESOURCES, "vu.tcl", purgeable) {
"namespace eval ::vu {\n"
/*"    foreach file [list combobox.tcl dial.tcl spinbox.tcl] {\n"*/
"    foreach file [list dial.tcl spinbox.tcl] {\n"
"	    namespace inscope :: [list source -rsrc $file]\n"
"	}\n"
"    namespace export -clear {[a-z]*}\n"
"\n"
"    proc ::vu::CancelRepeat {} {\n"
"	variable Priv\n"
"	if {[info exists Priv(afterId)]} {\n"
"	    after cancel $Priv(afterId)\n"
"	    set Priv(afterId) {}\n"
"	}\n"
"    }\n"
"    proc ::vu::GetSelection {w {sel PRIMARY}} {\n"
"	if {[catch {selection get -displayof $w -selection $sel} txt]} {\n"
"	    return -code error \"could not find default selection\"\n"
"	} else {\n"
"	    return $txt\n"
"	}\n"
"    }\n"
"}\n"
}; 

read 'TEXT' (VU_LIBRARY_RESOURCES + 1, "dial.tcl", purgeable) "dial.tcl";
read 'TEXT' (VU_LIBRARY_RESOURCES + 2, "spinbox.tcl", purgeable) "spinbox.tcl";
/*read 'TEXT' (VU_LIBRARY_RESOURCES + 3, "combobox.tcl", purgeable) "combobox.tcl";*/
