#!/bin/sh
# the next line restarts using wish \
	exec wish "$0" ${1+"$@"}

# canvSticker2.tcl
#
# Modified from original demo
#
# jeff at hobbs org, crrw@gmx.de
#
# RCS: @(#) $Id: canvSticker2.tcl,v 1.2 2005/07/12 23:17:07 hobbs Exp $
#

source [file join [file dirname [info script]] load.tcl]
eval destroy [winfo children .]
raise .

pack [canvas .c]
if {[catch {.c create sticker 0 0 10 10} st]} {
    tk_messageBox -type ok -title "No sticker Item" \
	    -message "This build of vu does not include the sticker item"
    destroy .c
    return
} else {
    destroy .c
}

#---
#--- set STRING {{x0 y0 x1 y1} {...text...} {resize point: center}

lappend  STRING_STI {10 10 180 180} "Sticker \u00E4\u00F6\u00FC\u00DF\u0040\u00B2\u00B3\u00BC\u00BD\u00BE" center
lappend  STRING_TEX {210 210} 	    "Text    \u00E4\u00F6\u00FC\u00DF\u0040\u00B2\u00B3\u00BC\u00BD\u00BE" center

puts $STRING_STI

set FONT {Helvetica 24 bold}

#---GUI
pack [canvas .c -width 400 -height 400 -bg aquamarine3]

#---CRRW Use the technique of eval the coord ...
set sti [eval .c create sticker [lindex $STRING_STI 0]]
.c itemconf $sti                \
        -anchor center          \
        -bar    black           \
        -color  red            \
        -fill   {}              \
        -font   $FONT           \
        -lefttrunc  0           \
        -outline {}             \
        -relheight  0.0         \
        -relwidth   0.0         \
        -relx       0.0         \
        -rely       0.0         \
        -space       0          \
        -stipple  {}            \
        -tags     sti           \
        -text     [lindex $STRING_STI 1]  \
        -width    0             \
        -orient vertical        \
        -minwidth  0            \
        -minheight 0            \
        -maxwidth  32767        \
        -maxheight 32767

set tex [eval .c create text [lindex $STRING_TEX 0]]
.c itemconf $tex                \
	-activefill {}		\
	-activestipple {}	\
	-anchor  center		\
	-disabledfill {}	\
	-disabledstipple {}	\
	-fill	red		\
	-font	$FONT		\
	-justify  left		\
	-offset	0,0		\
	-state  {}		\
	-stipple {}		\
	-tags	{tex}		\
	-text  [lindex $STRING_TEX 1] \
	-width  0


#---BINDINGS
bind .  <2> {
    .c itemco $sti -orient horizontal
    .c itemco $tex -width 0		;# horizontal
}
bind .  <3> {
    .c itemco $sti -orient vertical
    .c itemco $tex -width 1		;# top down
}

bind .  <p> {
    .c postscript -file DEMO.ps
    puts "DEMO.ps printed"
}
bind .  <q> { exit }
