#include "tkgsWin.h"
#include "tkgsWinInt.h"

/*
 * Prototypes for procedures defined later in this file:
 */

static TkGS_FreeInternalRepProc		FreeWinDrawableIntRep;


/*
 * Win32 Drawable Obj type
 */

/* Object type */
TkGS_ObjType WinDrawableType = {
    "WinDrawable",
    NULL,				/* Base type, initialized at runtime */

    FreeWinDrawableIntRep,		/* freeIntRepProc */
    NULL				/* setFromAnyProc */
					/* NULL means immutable */
};
TkGS_ObjType *WinDrawableTypePtr = &WinDrawableType;

/* Object type procs */

static void
FreeWinDrawableIntRep(intRepPtr)
    TkGS_InternalRep *intRepPtr;
{
    /* Release the HDC, HPEN and HBRUSH */
    if (WinDrawable_HDC(intRepPtr)) {
	ReleaseDC(WinDrawable_HWND(intRepPtr), WinDrawable_HDC(intRepPtr));
    }
    if (WinDrawable_HPEN(intRepPtr) != NULL) {
	DeleteObject(WinDrawable_HPEN(intRepPtr));
    }
    if (WinDrawable_HBRUSH(intRepPtr) != NULL) {
	DeleteObject(WinDrawable_HBRUSH(intRepPtr));
    }

    /* Free the allocated memory */
    ckfree((char *) WinDrawable_InternalRep(intRepPtr));
}


HPEN
WinTkGS_GetPenFromDrawable(interp, d)
    Tcl_Interp *interp;
    TkGS_Drawable d;
{
    register TkGS_GCValues *gcValues = &TkGSDrawable_GCValues(d);
    register TkGS_InternalRep *intRepPtr 
	= TkGS_FindInternalRep((TkGS_Obj *) d, &WinDrawableType);

    /* 
     * Create a Pen with the given Drawable foreground and lineWidth if needed
     */

    if (WinDrawable_HPEN(intRepPtr) == NULL) {
	unsigned short r, g, b;

	if (gcValues->lineWidth == 0) {
	    /* Thin line: use the foreground color pen */
	    return WinTkGS_GetPenFromColor(interp, gcValues->foreground);
	}

	/* Wide line: create a new pen */
	TkGS_GetRGBColorValues(gcValues->foreground, &r, &g, &b);
	WinDrawable_HPEN(intRepPtr) = CreatePen(PS_SOLID, 
				gcValues->lineWidth, 
				RGB(r>>8, g>>8, b>>8));
    }
    return WinDrawable_HPEN(intRepPtr);
}


HBRUSH
WinTkGS_GetBrushFromDrawable(interp, d)
    Tcl_Interp *interp;
    TkGS_Drawable d;
{
    register TkGS_GCValues *gcValues = &TkGSDrawable_GCValues(d);
    register TkGS_InternalRep *intRepPtr 
	= TkGS_FindInternalRep((TkGS_Obj *) d, &WinDrawableType);

    /* 
     * Create a solid Brush with the given Drawable foreground if needed
     */

    if (WinDrawable_HBRUSH(intRepPtr) == NULL) {
	/* Use the foreground color brush */
	return WinTkGS_GetBrushFromColor(interp, gcValues->foreground);
    }
    return WinDrawable_HBRUSH(intRepPtr);
}
