#----------------------------------------------------------------------
# makefile.gnu --
#
#       Cygwin makefile for Tix.
#
#       This makefile builds the Tix DLL and EXE files. You can also
#       use this makefile to install Tix in your local machine (see
#       common.mak) for details.
#
# Copyright (c) 2000-2001 Tix Project Group.
#
# See the file "license.terms" for information on usage and
# redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# $Id: makefile.gnu,v 1.7 2001/03/03 08:55:51 ioilam Exp $
#----------------------------------------------------------------------


#----------------------------------------------------------------------
# Notes on cygwin tools:
#
#	This makefile has been tested with a Cygwin installation
#	downloaded from www.cygwin.com around 12/30/2000. It may not
#	work with older Cygwin installations.
#
#	Tool versions tested:
#
#	gcc: 2.95.2-6 19991024 (cygwin experimental)
#	ld: 2.10.91 (with BFD 2.10.91)
#	bash: 2.04.5(12)-release (i686-pc-cygwin)
#	make: 3.79.1
#	windres: 2.10.91
#----------------------------------------------------------------------

######################################################################
# Customization section:
#
#	Normally you shouldn't modify this file directory to customize
#	the make procedure. See README.txt in this directory for a better
#	way.
#
######################################################################

# Where the Tcl and Tk. They must be in the same directory

ifndef SRC_ROOT
SRC_ROOT	= $(shell cd ../..; pwd)
endif

# Where Cygwin is installed. Use the Cygwin notation like //c/cygwin instead
# of c:\cygwin

ifndef CYG_ROOT
CYG_ROOT	= //c/cygwin
endif

# Set the TCL version. The TK version are assumed to be equal. The default
# is 8.3.2.

ifndef TCL_MAJOR
TCL_MAJOR	= 8
endif
ifndef TCL_MINOR
TCL_MINOR	= 3
endif
ifndef TCL_PATCH
TCL_PATCH	= 2
endif

TK_MAJOR	= $(TCL_MAJOR)
TK_MINOR	= $(TCL_MINOR)
TK_PATCH	= $(TCL_PATCH)

# Uncomment the following if you had compiled Tcl with debugging symbols

ifndef TCL_DBGX
#TCL_DBGX	= d
endif

# Uncomment the following if you had compiled Tk with debugging symbols

ifndef TK_DBGX
#TK_DBGX	= d
endif

# Comment this out if you don't want to compile with stubs

ifndef USESTUBS
USESTUBS	= 1
endif

# Comment this out if you want to compile with debugging symbols

ifndef NODEBUG
NODEBUG		= 1
endif

# Where the Tcl binary installation is located. Make sure you use
# the 8.3 directory name instead of "C:\Program Files\Tcl"
#
ifndef TCL_INSTALL_DIR
TCL_INSTALL_DIR         = //C/Progra~1/Tcl
endif

# Where to install Tix. 

ifndef INSTALL_DIR
INSTALL_DIR             = $(TCL_INSTALL_DIR)
endif

# Comment the following out if you want to use the Tcl/Tk .lib files from
# their source directories.

ifndef USE_TCL_BINARY_DISTRO
USE_TCL_BINARY_DISTRO	= 1
endif

######################################################################
# Do not modify below this line
######################################################################

######################################################################
# Development tool specific definitions
######################################################################

#
# Build tools
#

CC   		= gcc
DLL_CFLAGS	= 
DLLTOOL 	= dlltool
NM		= nm
RC   		= windres

RMDIR		= rmdir
MKDIR		= mkdir -p
RM		= rm

#
# C flags
#

ifeq ("$(NODEBUG)", "1")
DBG_CFLAGS	= -O
else
DBG_CFLAGS	= -g
endif

#
# Link flags
#

TIX_IMPORT_LIBS = -lmsvcrt -ladvapi32 -luser32 -lgdi32 -lcomdlg32 \
		  -lkernel32

# TODO: do we want dlltool to pick an offset for us, or do we really want to
# use the evil 666?
TIX_DLL_LDFLAGS = $(TIX_IMPORT_LIBS) \
		  -Wl,--subsystem,windows \
		  -Wl,-e,_DllMain@12 \
		  -Wl,--image-base,0x66600000

######################################################################
# Project specific definitions
######################################################################

TIX_MAJOR	= 8
TIX_MINOR	= 2
TIX_PATCH	= 0

ROOT            = ..
WINDIR          = $(ROOT)/win
GENERICDIR      = $(ROOT)/generic
DOTVERSION      = $(TIX_MAJOR).$(TIX_MINOR)

#
# Choose to build with stubs or not
#

ifeq ("$(TCL_MAJOR).$(TCL_MINOR)", "8.0")

#
# Tcl 8.0 does not support stubs
#

STUBS_CFLAGS	= 
DLLDEPENDS	= $(TK_LIB) $(TCL_LIB) 

else

#
# Tcl 8.1 or later support stubs
#

ifeq ("$(USESTUBS)", "1")
STUBS_CFLAGS	= -DUSE_TCL_STUBS=1 -DUSE_TK_STUBS=1
DLLDEPENDS	= $(TK_STUBLIB) $(TCL_STUBLIB) 
else
STUBS_CFLAGS	=
DLLDEPENDS	= $(TK_LIB) $(TCL_LIB) 
endif

endif

#
# Debugging options and where to output .o and .dll files
#

ifeq ("$(NODEBUG)", "1")
DBGX    	=
TMPDIR 		= Release
else
DBGX 		= d
TMPDIR 		= Debug
endif

#
# File and dir names for Tcl
#

ifeq ("$(TCL_DBGX)", "d")
TCL_TMPDIR	= Debug
else
TCL_TMPDIR	= Release
endif

ifeq ("$(TCL_PATCH)", "")
TCL_DIR		= $(SRC_ROOT)/tcl$(TCL_MAJOR).$(TCL_MINOR)
else
TCL_DIR		= $(SRC_ROOT)/tcl$(TCL_MAJOR).$(TCL_MINOR).$(TCL_PATCH)
endif

ifeq ("$(USE_TCL_BINARY_DISTRO)", "1")
TCL_LIBDIR	= $(TCL_INSTALL_DIR)/lib
TCL_BINDIR	= $(TCL_INSTALL_DIR)/bin
else
TCL_LIBDIR      = $(TCL_DIR)/win/$(TCL_TMPDIR)
TCL_BINDIR      = $(TCL_DIR)/win/$(TCL_TMPDIR)
endif

TCL_LIB  	= $(TCL_LIBDIR)/tcl$(TCL_MAJOR)$(TCL_MINOR)$(TCL_DBGX).lib
TCL_STUBLIB  	= $(TCL_LIBDIR)/tclstub$(TCL_MAJOR)$(TCL_MINOR)$(TCL_DBGX).lib
TCLSH_EXE	= $(TCL_BINDIR)/tclsh$(TCL_MAJOR)$(TCL_MINOR)$(TCL_DBGX).exe

#
# File and dir names for Tk
#

ifeq ("$(TK_DBGX)", "d")
TK_TMPDIR	= Debug
else
TK_TMPDIR	= Release
endif

ifeq ("$(TK_PATCH)", "")
TK_DIR		= $(SRC_ROOT)/tk$(TK_MAJOR).$(TK_MINOR)
else
TK_DIR		= $(SRC_ROOT)/tk$(TK_MAJOR).$(TK_MINOR).$(TK_PATCH)
endif


ifeq ("$(USE_TCL_BINARY_DISTRO)", "1")
TK_LIBDIR	= $(TCL_INSTALL_DIR)/lib
else
TK_LIBDIR       = $(TK_DIR)/win/$(TK_TMPDIR)
endif

TK_LIB  	= $(TK_LIBDIR)/tk$(TK_MAJOR)$(TK_MINOR)$(TK_DBGX).lib
TK_STUBLIB  	= $(TK_LIBDIR)/tkstub$(TK_MAJOR)$(TK_MINOR)$(TK_DBGX).lib

#
# File and dir names for Tix
#

TIX_LIB		= $(TMPDIR)/tix$(TIX_MAJOR)$(TIX_MINOR)$(DBGX).lib
TIX_DLL		= $(TMPDIR)/tix$(TIX_MAJOR)$(TIX_MINOR)$(DBGX).dll
TIX_DLL_NAME    = tix$(TIX_MAJOR)$(TIX_MINOR)$(DBGX).dll
TIX_EXE		= $(TMPDIR)/tixwish$(TIX_MAJOR)$(TIX_MINOR)$(DBGX).exe
TIX_EXE_C	= $(TMPDIR)/tixwishc$(TIX_MAJOR)$(TIX_MINOR)$(DBGX).exe
TIX_PKGIDX	= $(TMPDIR)/pkgIndex.tcl.src

TIX_DEFINES     = -D__WIN32__ 
TIX_INCLUDES 	= -I$(ROOT)/win -I$(ROOT)/generic \
		  -I$(TK_DIR)/generic -I$(TK_DIR)/win -I$(TK_DIR)/xlib \
		  -I$(TCL_DIR)/generic -I$(TCL_DIR)/win \
		  -I$(CYG_ROOT)/usr/include/mingw
TIX_CFLAGS      = $(TIX_INCLUDES) $(TIX_DEFINES) $(DLL_CFLAGS) $(DBG_CFLAGS)

######################################################################
# Project specific targets
######################################################################

vpath %.c  $(ROOT)/win $(ROOT)/generic

all: $(TMPDIR) $(TIX_DLL) $(TIX_EXE_C) $(TIX_EXE) $(TIX_PKGIDX) license.txt \
	 RelNotes.txt

$(TMPDIR):
	-$(MKDIR) $@

#
# Object files
#

TIX_DLL_OBJS = \
	$(TMPDIR)/tixClass.o    \
	$(TMPDIR)/tixCmds.o     \
	$(TMPDIR)/tixCompat.o   \
	$(TMPDIR)/tixDiImg.o    \
	$(TMPDIR)/tixDiITxt.o   \
	$(TMPDIR)/tixDiStyle.o  \
	$(TMPDIR)/tixDItem.o    \
	$(TMPDIR)/tixDiText.o   \
	$(TMPDIR)/tixDiWin.o    \
	$(TMPDIR)/tixError.o    \
	$(TMPDIR)/tixForm.o     \
	$(TMPDIR)/tixFormMisc.o \
	$(TMPDIR)/tixGeometry.o \
	$(TMPDIR)/tixGrid.o     \
	$(TMPDIR)/tixGrData.o   \
	$(TMPDIR)/tixGrRC.o     \
	$(TMPDIR)/tixGrFmt.o    \
	$(TMPDIR)/tixGrSel.o    \
	$(TMPDIR)/tixGrUtl.o    \
	$(TMPDIR)/tixHLCol.o    \
	$(TMPDIR)/tixHLHdr.o    \
	$(TMPDIR)/tixHLInd.o    \
	$(TMPDIR)/tixHList.o    \
	$(TMPDIR)/tixImgCmp.o   \
	$(TMPDIR)/tixImgXpm.o   \
	$(TMPDIR)/tixInit.o     \
	$(TMPDIR)/tixList.o     \
	$(TMPDIR)/tixMethod.o   \
	$(TMPDIR)/tixNBFrame.o  \
	$(TMPDIR)/tixOption.o   \
	$(TMPDIR)/tixSmpLs.o    \
	$(TMPDIR)/tixScroll.o   \
	$(TMPDIR)/tixTList.o    \
	$(TMPDIR)/tixUtils.o    \
	$(TMPDIR)/tixWCmpt.o    \
	$(TMPDIR)/tixWidget.o   \
	$(TMPDIR)/tixWinDraw.o  \
	$(TMPDIR)/tixWinXpm.o   \
	$(TMPDIR)/tixWinWm.o

TIX_EXE_OBJS = \
	$(TMPDIR)/tixAppInit.o \
	$(TMPDIR)/winMain.o    \
        $(TMPDIR)/tixwish_res.o

TIX_EXE_C_OBJS = \
	$(TMPDIR)/tixAppInit_c.o \
	$(TMPDIR)/winMain.o     \
        $(TMPDIR)/tixwishc_res.o

#
# .EXE and .DLL files
#

$(TMPDIR)/tixcyg.def: $(TIX_DLL_OBJS)
	echo 'EXPORTS' > tmp.def
	for o in $(TIX_DLL_OBJS); do \
	    $(NM) --extern-only --defined-only $$o | \
		sed -e 's/[^ ]* [^ ]* //' -e 's/^_//' | \
		fgrep -v DllEntryPoint | \
		fgrep -v DllMain | \
		fgrep -v impure_ptr | \
		fgrep -v _real@ \
	    >> tmp.def; \
	done
	mv tmp.def $(TMPDIR)/tixcyg.def

# (ToDo) $(TIX_DLL) doesn't have resources to define its icon, etc.
#
# NOTE: these 6 steps are *really* necessary to build the DLL. Do
# not modify unless you understand how cygwin works.
$(TIX_DLL): $(TIX_DLL_OBJS) $(TMPDIR)/tixcyg.def $(TMPDIR)/tixdll_res.o
	-$(RM) -f $(TIX_DLL)
	$(CC) -s -nostartfiles -Wl,--base-file,tix.base -Wl,--dll \
		-o $(TIX_DLL) $(TIX_DLL_OBJS) $(DLLDEPENDS) \
		$(TIX_DLL_LDFLAGS) 
	$(DLLTOOL) --as=$(AS) --dllname $(TIX_DLL_NAME) \
		--def $(TMPDIR)/tixcyg.def --base-file tix.base \
		--output-exp tix.exp
	$(CC) -s -nostartfiles -Wl,--base-file,tix.base -Wl,tix.exp \
		-Wl,-dll -o $(TIX_DLL) $(TIX_DLL_OBJS) \
		$(DLLDEPENDS) $(TIX_DLL_LDFLAGS)
	$(DLLTOOL) --as=$(AS) --dllname $(TIX_DLL_NAME) \
		--def $(TMPDIR)/tixcyg.def --base-file tix.base \
		--output-exp tix.exp
	$(CC) -nostartfiles -Wl,tix.exp -Wl,--dll -o $(TIX_DLL) \
		$(TIX_DLL_OBJS) $(DLLDEPENDS) $(TIX_DLL_LDFLAGS) \
                $(TMPDIR)/tixdll_res.o
	$(DLLTOOL) --as=$(AS) --dllname $(TIX_DLL_NAME) \
		--def $(TMPDIR)/tixcyg.def --output-lib $(TIX_LIB)

#
# GUI-based tixwish
#

$(TIX_EXE): $(TIX_EXE_OBJS) $(TIX_DLL)
	$(CC) $(TIX_EXE_OBJS) $(TIX_LIB) \
		$(TK_LIB) $(TCL_LIB) $(TIX_IMPORT_LIBS) \
		-Wl,--subsystem,windows \
		-o $@
	@echo "... ignore any warnings above about _WinMainCRTStartup. It's OK"
#
# Console-based tixwish: this is normally used for development purpose
# only -- it always pops up the "DOS window", where all Tcl stdio goes.
#

$(TIX_EXE_C): $(TIX_EXE_C_OBJS) $(TIX_DLL)
	$(CC) $(TIX_EXE_C_OBJS) $(TIX_LIB) \
		$(TK_LIB) $(TCL_LIB) $(TIX_IMPORT_LIBS) \
		-Wl,--subsystem,console \
		-o $@

$(TIX_PKGIDX): make_pkgIndex.tcl makefile.gnu
	env TCL_LIBRARY=`cygpath -w $(TCL_DIR)/library` \
	    $(TCLSH_EXE) make_pkgIndex.tcl $@ $(TIX_DLL) $(DOTVERSION)

license.txt: ../license.terms
	$(TCLSH_EXE) $(ROOT)/tools/unix2dos.tcl < ../license.terms > $@

RelNotes.txt: ../RelNotes.txt
	$(TCLSH_EXE) $(ROOT)/tools/unix2dos.tcl < ../RelNotes.txt > $@

#
# Implicit rules
#

$(TMPDIR)/%.o: %.c
	$(CC) $(TIX_CFLAGS) $(STUBS_CFLAGS) -DBUILD_tix -c $< -o $@

$(TMPDIR)/tixwish_res.o: rc/tixwish.rc
	$(RC) \
		--include-dir $(GENERICDIR) \
		--include-dir $(TK_DIR)/generic \
		--include-dir $(TK_DIR)/win \
		--include-dir $(TK_DIR)/xlib \
		--include-dir $(TCL_DIR)/generic \
		--include-dir ./rc \
		$< $@

$(TMPDIR)/tixwishc_res.o: rc/tixwishc.rc
	$(RC) \
		--include-dir $(GENERICDIR) \
		--include-dir $(TK_DIR)/generic \
		--include-dir $(TK_DIR)/win \
		--include-dir $(TK_DIR)/xlib \
		--include-dir $(TCL_DIR)/generic \
		--include-dir ./rc \
		$< $@

$(TMPDIR)/tixdll_res.o: rc/tixdll.rc
	$(RC) \
		--include-dir $(GENERICDIR) \
		--include-dir $(TK_DIR)/generic \
		--include-dir $(TK_DIR)/win \
		--include-dir $(TK_DIR)/xlib \
		--include-dir $(TCL_DIR)/generic \
		--include-dir ./rc \
		$< $@

#
# Special rules for building winMain.o
#
$(TMPDIR)/winMain.o: $(TK_DIR)/win/winMain.c
	env TCL_LIBRARY=`cygpath -w $(TCL_DIR)/library` \
	    $(TCLSH_EXE) patch_win_main.tcl \
	        `cygpath -w $(TK_DIR)/win/winMain.c` \
	 	winMain_patch.c
	$(CC) $(TIX_CFLAGS) -o $@ \
		-c winMain_patch.c

$(TMPDIR)/tixAppInit.o: $(GENERICDIR)/tixAppInit.c
	$(CC) $(TIX_CFLAGS) -DNO_MAIN -DGUI_MODE_APP \
		-o $@ -c $(GENERICDIR)/tixAppInit.c

$(TMPDIR)/tixAppInit_c.o: $(GENERICDIR)/tixAppInit.c
	$(CC) $(TIX_CFLAGS) -DNO_MAIN -o $@ -c $(GENERICDIR)/tixAppInit.c

######################################################################
# Test:
######################################################################
oldtest:
	@echo "===================================================="
	@echo "running old-style tests"
	@echo "===================================================="
	env TCL_LIBRARY=`cygpath -w $(TCL_DIR)/library` \
            TK_LIBRARY=`cygpath -w $(TK_DIR)/library` \
            TIX_LIBRARY=`cygpath -w $(ROOT)/library` \
        $(TIX_EXE_C) ../tests/Driver.tcl

newtest:
	@echo "===================================================="
	@echo "running new-style tests"
	@echo "===================================================="
	env TCL_LIBRARY=`cygpath -w $(TCL_DIR)/library` \
            TK_LIBRARY=`cygpath -w $(TK_DIR)/library` \
            TIX_LIBRARY=`cygpath -w $(ROOT)/library` \
        $(TIX_EXE_C) ../tests/all.tcl

test: oldtest newtest

rundemos:
	env TCL_LIBRARY=`cygpath -w $(TCL_DIR)/library` \
            TK_LIBRARY=`cygpath -w $(TK_DIR)/library` \
            TIX_LIBRARY=`cygpath -w $(ROOT)/library` \
        $(TIX_EXE_C) ../demos/widget

######################################################################
# Clean up
######################################################################

clean:
	-$(RM) -f winMain_patch.c
	-$(RM) -f $(TIX_LIB)
	-$(RM) -f $(TIX_DLL)
	-$(RM) -f $(TIX_EXE)
	-$(RM) -f $(TIX_EXE_C)
	-$(RM) -f $(TIX_PKGIDX)
	-$(RM) -f $(TMPDIR)/*.o
	-$(RM) -f $(TMPDIR)/*.exp
	-$(RM) -f $(TMPDIR)/*.def
	-$(RM) -f $(TMPDIR)/*.pch
	-$(RM) -f $(TMPDIR)/*.pdb
	-$(RM) -f $(TMPDIR)/*.lib
	-$(RM) -f $(TMPDIR)/*.exe
	-$(RM) -f tix.base tix.exp license.txt RelNotes.txt
	-$(RM) -f *~

distclean: clean
	-$(RM) -f Debug/*
	-$(RM) -f Release/*
	-$(RMDIR) Debug
	-$(RMDIR) Release


######################################################################
# Install
######################################################################

BIN_INSTALL_DIR	        = $(INSTALL_DIR)/bin
LIB_INSTALL_DIR	        = $(INSTALL_DIR)/lib
SCRIPT_INSTALL_DIR	= $(INSTALL_DIR)/lib/tix$(DOTVERSION)
INCLUDE_INSTALL_DIR	= $(INSTALL_DIR)/include

install: all install-binaries install-libraries

install-binaries:
	-@$(MKDIR) `cygpath -w $(INSTALL_DIR)`
	-@$(MKDIR) `cygpath -w $(BIN_INSTALL_DIR)`
	-@$(MKDIR) `cygpath -w $(LIB_INSTALL_DIR)`
	@echo installing $(TIX_DLL)
	@cp $(TIX_DLL) $(BIN_INSTALL_DIR)
	@echo installing $(TIX_EXE)
	@cp $(TIX_EXE) $(BIN_INSTALL_DIR)
	@echo installing $(TIX_EXE_C)
	@cp $(TIX_EXE_C) $(BIN_INSTALL_DIR)
	@echo installing $(TIX_LIB)
	@cp $(TIX_LIB) $(LIB_INSTALL_DIR)

install-libraries:
	@echo installing library files
	-@$(MKDIR) `cygpath -w $(LIB_INSTALL_DIR)`
	-@$(MKDIR) `cygpath -w $(SCRIPT_INSTALL_DIR)`
	-@$(MKDIR) `cygpath -w $(SCRIPT_INSTALL_DIR)/pref`
	-@$(MKDIR) `cygpath -w $(SCRIPT_INSTALL_DIR)/bitmaps`
	-@$(MKDIR) `cygpath -w $(SCRIPT_INSTALL_DIR)/demos`
	-@$(MKDIR) `cygpath -w $(SCRIPT_INSTALL_DIR)/demos/bitmaps`
	-@$(MKDIR) `cygpath -w $(SCRIPT_INSTALL_DIR)/demos/samples`
	xcopy `cygpath -w $(ROOT)/library`          \
	      `cygpath -w $(SCRIPT_INSTALL_DIR)`
	cp    $(TIX_PKGIDX)                         \
	      $(SCRIPT_INSTALL_DIR)/pkgIndex.tcl
	xcopy `cygpath -w $(ROOT)/library/pref`     \
	      `cygpath -w $(SCRIPT_INSTALL_DIR)/pref`
	xcopy `cygpath -w $(ROOT)/library/bitmaps`  \
	      `cygpath -w $(SCRIPT_INSTALL_DIR)/bitmaps`
	xcopy `cygpath -w $(ROOT)/demos`            \
	      `cygpath -w $(SCRIPT_INSTALL_DIR)/demos`
	xcopy `cygpath -w $(ROOT)/demos/samples`    \
	      `cygpath -w $(SCRIPT_INSTALL_DIR)/demos/samples`
	xcopy `cygpath -w $(ROOT)/demos/bitmaps`    \
	      `cygpath -w $(SCRIPT_INSTALL_DIR)/demos/bitmaps`

include common.mak
