'\"
'\" $Id: pixmap.n,v 1.4 2001/02/09 06:32:28 ioilam Exp $
'\"
'\"
'\" Copyright (c) 1993-1999 Ioi Kim Lam.
'\" Copyright (c) 2000-2001 Tix Project Group.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" The file man.macros and some of the macros used by this file are
'\" copyrighted: (c) 1990 The Regents of the University of California.
'\"              (c) 1994-1995 Sun Microsystems, Inc.
'\" The license terms of the Tcl/Tk distrobution are in the file
'\" license.tcl.
.so man.macros
.TH pixmap n 4.0 Tix "Tix Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
pixmap \- image type for the XPM file format.
.SH SYNOPSIS
\fBimage create pixmap \fR?\fIname\fR? ?\fIoptions\fR?
.BE

.SH DESCRIPTION
.PP
XPM is a popular X Window image file format for storing color icons.
The \fBpixmap\fR image type defined by the \fBTix\fR library can be
used to create color images using XPM files.

.SH "CREATING PIXMAPS"
.PP
Like all images, pixmaps are created using the \fBimage create\fR
command. Pixmaps support the following \fIoptions\fR:
.TP
\fB\-data \fIstring\fR
'\"
Specifies the contents of the source pixmap as a string.  The string
must adhere to the XPM file format (e.g., as generated by the
\fBpixmap(1)\fR program). If both the \fB\-data\fR and \fB\-file\fR
options are specified, the \fB\-data\fR option takes precedence.
Please note that the XPM file parsing code in the xpm library is
extremely fragile. The first line of the string must be "\fB/* XPM
*/\fR" or otherwise a segmatation fault will be caused.
'\"
.TP
\fB\-file \fIname\fR
'\"
\fIname\fR gives the name of a file whose contents define the source
pixmap.  The file must adhere to the XPM file format (e.g., as
generated by the \fBpixmap(1)\fR program).
'\"
.SH "IMAGE COMMAND"
.PP
When a pixmap image is created, Tk also creates a new command whose
name is the same as the image.  This command may be used to invoke
various operations on the image.  It has the following general form:
.RS
.CS
\fIimageName option \fR?\fIarg arg ...\fR?
.CE
.RE
\fIOption\fR and the \fIarg\fRs
'\"
determine the exact behavior of the command. The following
commands are possible for pixmap images:
.TP
\fIimageName \fBcget\fR \fIoption\fR
'\"
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may have any of the values accepted by the
\fBimage create pixmap\fR command.
.TP
\fIimageName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR? 
'\"
Query or modify the configuration options for the image. If no
\fIoption\fR is specified, returns a list describing all of the
available options for \fIimageName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given option(s) to have the given value(s); in this case
the command returns an empty string.  \fIOption\fR may have any of the
values accepted by the \fBimage create pixmap\fR command.
.SH KEYWORDS
pixmap, image, XPM


