'\"
'\" Copyright (c) 1998 by Scriptics Corporation.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: lic.n,v 1.1 2000/06/21 00:06:43 welch Exp $
'\" 
.so man.macros

.TH lic 1 "" TclPro "Licence Keys"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
lic, licgen \- Modules to support license key generation and parsing
.SH SYNOPSIS
\fBpackage require licgen\fP
.br
\fBlicgen::genkey \fIcustid\fP \fIprodid\fP \fIversion\fP \fIexpires\fP
.br
\fBlicgen::savekey \fIkey\fP
.br
\fBpackage require lic\fP
.br
\fBlic::init \fIversion\fP
.br
\fBlic::parsekey \fIkey\fP
.br
\fBpackage require licgui\fP
.br
\fBlicgui::dialog ?\fItoplevel\fP?
.BE

.SH DESCRIPTION
.PP
Use \fBlicgen::genkey\fP to generate license keys.  The key
encodes a customer ID, a product ID, a version number, and an
expiration date.  It includes some noise bits and a hash value so
it is computationally hard to forge license keys.
The keys are encoded in a 32 character alphabet of digits
and uppercase letters.  The first character of a key is a key format type,
which is "1" in the current version.
The key is a string of these characters broken by dashes for readability.
The dashes are ignored by \fBlic::parsekey\fP.
.PP
This key format 
has the following limitations:
.TP 15
\fIcustid\fP
The customer ID is stored in 24 bits.
.TP 15
\fIprodid\fP
The product ID is stored in 12 bits.
.TP 15
\fIversion\fP
The version must be in the format of A.B.C, where each of A, B, and C
are limited to 15 or less (4 bits).
.TP 15
\fIexpires\fP
This is a clock seconds value, (e.g., as returned from clock scan).
The special value of 0 means "never expires".  The year is kept
in a 12 bit field so these keys cannot be used after the year 4095.
.PP
The \fBlicgen::savekey\fP command is used to save a generated key into
the proper place in the registry or the file system.  This is meant
to be used by the installer.  Once the key is saved, it can be
found with \fBlic::init\fP during application startup.
.PP
The \fBlic::init\fP command locates the installed key and
tests it against the \fIversion\fP and the expiration date.
The \fIversion\fP should be the version number of the product
that is "compiled in" at the factory.
If the key passes all the tests, then the expiration date in
clock seconds is returned.  The return value of 0 means the
key does not have an expiration date.  This command raises an
error if the key is missing, malformed, or expired.
This uses \fBlic::parsekey\fP to verify the key.
.PP
The \fBlic::parsekey\fP command is used to verify and parse a key value
presumably generated by \fBlicgen::genkey\fP.
If the key is not valid it raises an error.
Otherwise it returns a list of names and values, where the names
are 
.B custid,
.B prodid,
.B version,
and
.B expires.
The values associated with custid and prodid are integers.
The version is in the form of A.B.C.
The expires value is a date in the form mm/dd/yyyy or the
keyword "never".
.PP
The \fBlicgui::dialog\fP procedure is used to display a dialog
that the user can enter the key with.  It does some simple
pre-processing of characters like mapping them to uppercase
and mapping big O to digit 0, and little l to digit 1.
It returns the result, or error, from 
.B lic::parsekey.
.SH EXAMPLE
.DS
% licgen::genkey 1 1 1.0.0 [clock scan "now + 31 days"]
.br
1201-0113-0021-0FM2-VRFA
.br
% lic::parsekey 1201-0113-0021-0FM2-VRFA
.br
custid 1 prodid 1 version 1.0.0 date 7/26/1998
.DE


.SH KEYWORDS
license key
