/*****************************************************************************
 *
 *  File: kt2c.h
 *  Core of the Kanga Tcl-to-C converter.
 *
 *****************************************************************************
 *
 *  Copyright (c) 2000 David Cuthbert / Kanga International Group.
 *  All rights reserved.
 *
 *  Permission to use, copy, modify, distribute and sell this software
 *  and its documentation for any purpose is hereby granted without fee,
 *  provided that the above copyright notice appear in all copies and
 *  that both that copyright notice and this permission notice appear
 *  in supporting documentation.  The author(s) make no representations
 *  about the suitability of this software for any purpose.  It is 
 *  provided "as is" without express or implied warranty.
 *
 *****************************************************************************/

#if !defined(KT2C_H)
#define KT2C_H

#include "kt2c_platform.h"
#include "vm.h"
#include "tcl.h"
#include "tclCompile.h"

typedef struct Kanga_CodeAccum {
    Tcl_Interp    *original;
    Tcl_Interp    *interp;
    Tcl_Obj       *code;
    Tcl_Obj       *header;
    ByteCode      *bc;
    char          *procName;
    int            procNameLength;
    char          *mangledProcName;
    int            mangledProcNameLength;
    char          *escapedProcName;
    int            escapedProcNameLength;
    Proc          *procPtr;
    Namespace     *nsPtr;

    Kanga_VarState *literalState;

    /* Number of instructions in the bytecode */
    int            numInstructions;

    /* Virtual machine state.  An array of size (# of instructions), where
     * each element reveals the known state of each stack and scalar entry
     * before executing the instruction.
     */
    Kanga_InstrState *instrState;

    /* Offset to instruction index map.  Given an offset, this tells you which
     * instruction it is in the vmState array.
     */
    Tcl_HashTable  offset2Index;
} Kanga_CodeAccum;

/* Methods */
Kanga_CodeAccum *
Kanga_CodeAccum_Create(Tcl_Interp *interp, char *procName);

void
Kanga_CodeAccum_Delete(Kanga_CodeAccum *ca);

int Kanga_Bytecode2C(ClientData dummy,       /* Not used. */
		     Tcl_Interp *interp,     /* Current interpreter. */
		     int objc,               /* Number of arguments. */
		     Tcl_Obj *const objv[]); /* Argument objects. */

int Kanga_CpuTime(ClientData dummy,       /* Not used. */
		  Tcl_Interp *interp,     /* Current interpreter. */
		  int objc,               /* Number of arguments. */
		  Tcl_Obj *const objv[]); /* Argument objects. */

#endif
