tcltest::test 4.5.4-1 { final variable must be definitly assigned } {
    compile [saveas T4541.java {
class T4541 {
    final int val;
}
    }]
} FAIL

tcltest::test 4.5.4-2 { final variable must be definitly assigned } {
    compile [saveas T4542.java {
class T4542 {
    final int val = 0;
}
    }]
} PASS

tcltest::test 4.5.4-3 { final variable must be definitly assigned } {
    compile [saveas T4543.java {
class T4543 {
    final int val;

    T4543() { val = 0; }
}
    }]
} PASS

tcltest::test 4.5.4-4 { final variable can only be assigned to once } {
    compile [saveas T4544.java {
class T4544 {
    final int val = 0;

    T4544() { val = 1; }
}
    }]
} FAIL


tcltest::test 4.5.4-5 { final variable must be assigned before it can be used } {
    compile [saveas T4545.java {
class T4545 {
    final int val;

    T4545() { int tmp = val; }
}
    }]
} FAIL

tcltest::test 4.5.4-6 { blank final variable must be assigned in every constructor } {
    compile [saveas T4546.java {
class T4546 {
    final int val;

    T4546() { val = 0; }
    T4546(int foo) { }
}
    }]
} FAIL

tcltest::test 4.5.4-7 { a final variable can reference an Object, the
        reference can not change but the object being referenced can change } {
    compile [saveas T4547.java {
class T4547 {
    final StringBuffer sbuf = new StringBuffer();

    void append() {
        sbuf.append("nuggy");
    }
}
    }]
} PASS

tcltest::test 4.5.4-8 { a final variable can reference an array, the
        elements of the array can be modified } {
    compile [saveas T4548.java {
class T4548 {
    final Object[] objarr = {new Object(), new Object()};

    void swap() {
        Object tmp = objarr[0];
        objarr[0] = objarr[1];
        objarr[1] = tmp;
    }
}
    }]
} PASS
