proc sql_open {args} { return [eval sql open $args] }
proc sql_run {args} { return [eval sql run $args] }
proc sql_fetch {args} { return [eval sql fetch $args] }
proc sql_close {args} { return [eval sql close $args] }
proc sql_exists {args} { return [eval sql exists $args] }
proc sql_reopen {args} { return [eval sql reopen $args] }
proc sql_explain {args} { return [eval sql explain $args] }
proc sql_geterror {args} { return [eval sql geterror $args] }
proc sqlca {args} { return [eval sql sqlca $args] }
proc sqlda {args} { return [eval sql sqlda $args] }
proc sqld {args} { return [eval sql sqld $args] }
proc sql_database {args} { return [eval sql database $args] }
proc sql_getdatabase {args} { return [eval sql getdatabase $args] }
proc sql_finish {args} { return [eval sql finish $args] }
proc sql_colnames {fd in} {
	set colnames {}
	for {set i 0} {$i < [sql sqld $fd $in]} {incr i} {
		lappend colnames [lindex [sql sqlda $fd $in $i] 3]
	}
	return $colnames
}
proc sql_coltypes {fd in} {
	set coltypes {}
	for {set i 0} {$i < [sql sqld $fd $in]} {incr i} {
		lappend coltypes [lindex [sql sqlda $fd $in $i] 7]
	}
	return $coltypes
}
proc sql_charlen {fd in} {
	set charlen {}
	for {set i 0} {$i < [sql sqld $fd $in]} {incr i} {
		lappend charlen [lindex [sql sqlda $fd $in $i] 1]
	}
	return $charlen
}
proc sql_dblen {fd in} {
	set dblen {}
	for {set i 0} {$i < [sql sqld $fd $in]} {incr i} {
		lappend dblen [lindex [sql sqlda $fd $in $i] 9]
	}
	return $dblen
}
proc sql_error {} {
	set s [sql sqlca]
	set cd [lindex $s 0]
	if {$cd == 0} {
		return ""
	}
	format "%d: [lindex $s 5]" $cd [lindex $s 1]
}
proc sql_error_num {} {
	lindex [sql sqlca] 0
}
proc sql_isam_error {} {
	set s [sql sqlca]
	set cd [lindex [lindex $s 3] 1]
	if {$cd == 0} {
		return ""
	}
	format "%d: [lindex $s 6]" $cd
}
proc isam_error_num {} {
	lindex [lindex [sql sqlca] 3] 1
}
proc sql_get_rowid {} {
	lindex [lindex [sql sqlca] 3] 5
}
proc sql_get_serial {} {
	lindex [lindex [sql sqlca] 3] 1
}
proc sql_get_numrows {} {
	lindex [lindex [sql sqlca] 3] 2
}
proc sql_get_estrows {} {
	lindex [lindex [sql sqlca] 3] 0
}
proc sql_get_erroffset {} {
	lindex [lindex [sql sqlca] 3] 4
}
proc sql_one {args} {
	set fd [eval sql open $args]
	set line [sql fetch $fd]
	sql close $fd
	return $line
}
proc sql_onetrim {args} {
	set fd [eval sql open $args]
	set line [sql fetch $fd 1]
	sql close $fd
	return $line
}
proc sql_all {args} {
	set arglist {}
	set fd [eval sql open $args]
	while {[set line [sql fetch $fd]] != ""} {
		lappend arglist $line
	}
	sql close $fd
	return $arglist
}
proc sql_alltrim {args} {
	set arglist {}
	set fd [eval sql open $args]
	while {[set line [sql fetch $fd 1]] != ""} {
		lappend arglist $line
	}
	sql close $fd
	return $arglist
}
proc sql_convert_text {str} {
	set len [string length $str]
	set out ""
	for {set i 0} {$i < $len} {incr i} {
		set s1 [string toupper [string index $str $i]]
		incr i
		set s2 [string toupper [string index $str $i]]
		if {$s1 >= "A"} {
			switch $s1 {
				"A"		{set s1 10}
				"B"		{set s1 11}
				"C"		{set s1 12}
				"D"		{set s1 13}
				"E"		{set s1 14}
				"F"		{set s1 15}
				default {error "Invalid format character $s1"}
			}
		}
		if {$s2 >= "A"} {
			switch $s2 {
				"A"		{set s2 10}
				"B"		{set s2 11}
				"C"		{set s2 12}
				"D"		{set s2 13}
				"E"		{set s2 14}
				"F"		{set s2 15}
				default {error "Invalid format character $s2"}
			}
		}
		append out [format "%c" [expr $s1*16+$s2]]
	}
	return $out
}
