
load isql.so

set ok [ sql database stores ]
if { $ok != 0 } { puts stdout [ sql geterror ]; exit 1 }

puts stdout "sqlca:"
puts stdout [ sql sqlca ]

puts stdout "set explain on"
sql run { set explain on }


set q [ sql open "SELECT * FROM Customer WHERE Customer_num = ?" 101 ]

puts stdout "sql explain $q"
sql explain $q

set data [ sql fetch $q ]
puts stdout $data

set n [ sql sqld $q 1 ]
puts stdout "sqld  - in:  $n"
for { set i 0 } { $i < $n } { incr i } {
	puts stdout "sqlda - $i:  [ sql sqlda $q 1 $i ]"
}

set n [ sql sqld $q 0 ]
puts stdout "sqld  - out: $n"
for { set i 0 } { $i < $n } { incr i } {
	puts stdout "sqlda - $i:  [ sql sqlda $q 0 $i ]"
}

sql reopen $q 111
set data [ sql fetch $q 1 ]
puts stdout $data

set n [ sql exists customer customer_num 122 { state != 'CA' } ]
puts stdout "customer.customer_num = 122 and state != 'CA': $n"

sql run { set explain off }

puts stdout "database name: [ sql getdatabase ]"

sql finish
puts OK
