/*
 * test.cpp --
 *
 *	Test program for e4XML package.
 *
 *	Authors: Jacob Levy and Jean-Claude Wippler.
 *		 jyl@best.com	jcw@equi4.com
 *
 *	Copyright: JYL Software, Inc., (c) 2000-2003.
 */

#include <stdlib.h>
#include "e4xml.h"

extern "C" int
main(int ac, char **av)
{
    e4_XMLParser *p;
    FILE *fp = NULL;
    const char *nm;
    char buf[4096];
    int len;

    /*
     * Get the file descriptor to read from.
     */

    if (ac < 2) {
	fp = stdin;
    } else if (strcmp(av[1], "-") == 0) {
        fp = stdin;
    } else {
	fp = fopen(av[1], "rb");
    }
    if (fp == NULL) {
        fprintf(stderr, "Could not obtain input file. Aborting.\n");
        exit(99);
    }

    /*
     * Now open the storage and get the root node.
     */

    if (ac < 3) {
        nm = "foo.db";
    } else {
	nm = av[2];
    }

    e4_Storage s(nm, E4_METAKIT);
    e4_Node n;

    if (!s.IsValid()) {
	fprintf(stderr, "Storage \"%s\" is invalid. Aborting.\n");
	exit(99);
    }
    if (!s.GetRootNode(n) || (!n.IsValid())) {
	fprintf(stderr, "Could not obtain root node, Aborting.\n");
	exit(99);
    }
    p = new e4_XMLParser(n);
    while (true) {
	len = fread((void *) buf, 1, 4096, fp);
	if (len < 0) {
	    goto end;
	}
	if (!p->Parse(buf, (size_t) len)) {
	    fprintf(stderr, "Error: %s\n", p->ErrorString());
	    goto end;
	}
    }
end:
    delete p;

    n = invalidNode;

    s.Commit();

    if (ac > 1) {
	fclose(fp);
    }

    return 0;
}
