/*
 * testdstring.cpp --
 *
 * Tests of the e4_DString class.
 *
 * Copyright (c) 2000-2003, JYL Software Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE, EVEN IF
 * JYL SOFTWARE INC. IS MADE AWARE OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#ifndef	_WIN32
#include <unistd.h>
#endif
#include "test.h"

static int
test_dstring1()
{
   e4_DString *ds;

   ds = new e4_DString();
   delete ds;

   return 0;
}

static int
test_dstring2()
{
    e4_DString *ds;
    char *res;

    ds = new e4_DString();
    ds->Append("hello", -1);
    res = ds->Get();
    if (strcmp(res, "hello") != 0) {
	fprintf(stderr, "test dstring2 failed (step 1)\n");
	return 2;
    }
    delete ds;

    return 0;
}

static int
test_dstring3()
{
    e4_DString *ds;
    char *res;

    ds = new e4_DString();
    ds->Append("hello", -1);
    ds->Append(", ", -1);
    ds->Append("goodbye", -1);
    res = ds->Get();
    if (strcmp(res, "hello, goodbye") != 0) {
	fprintf(stderr, "test dstring3 failed (step 1)\n");
	return 3;
    }
    delete ds;

    return 0;
}

static int
test_dstring4()
{
    e4_DString *ds;
    char *res;

    ds = new e4_DString();
    res = ds->Get();
    if (res != NULL) {
	fprintf(stderr, "test dstring4 failed (step 1)\n");
	return 4;
    }
    ds->Append("hello", -1);
    res = ds->Get();
    if (res == NULL) {
	fprintf(stderr, "test dstring4 failed (step 2)\n");
	return 4;
    }
    if (strcmp(res, "hello") != 0) {
	fprintf(stderr, "test dstring4 failed (step 3)\n");
	return 4;
    }
    ds->Append(", ", -1);
    res = ds->Get();
    if (res == NULL) {
	fprintf(stderr, "test dstring4 failed (step 4)\n");
	return 4;
    }
    if (strcmp(res, "hello, ") != 0) {
	fprintf(stderr, "test dstring4 failed (step 5)\n");
	return 4;
    }
    ds->Append("goodbye", -1);
    res = ds->Get();
    if (res == NULL) {
	fprintf(stderr, "test dstring4 failed (step 6)\n");
	return 4;
    }
    if (strcmp(res, "hello, goodbye") != 0) {
	fprintf(stderr, "test dstring4 failed (step 7)\n");
	return 4;
    }
    delete ds;

    return 0;
}

static int
test_dstring5()
{
    e4_DString *ds;
    char *res;

    ds = new e4_DString();
    res = ds->Get();
    if (res != NULL) {
	fprintf(stderr, "test dstring5 failed (step 1)\n");
	return 5;
    }
    ds->Append("hello", -1);
    res = ds->Get();
    if (res == NULL) {
	fprintf(stderr, "test dstring5 failed (step 2)\n");
	return 5;
    }
    if (strcmp(res, "hello") != 0) {
	fprintf(stderr, "test dstring5 failed (step 3)\n");
	return 5;
    }
    ds->Append(", ", -1);
    res = ds->Get();
    if (res == NULL) {
	fprintf(stderr, "test dstring5 failed (step 4)\n");
	return 5;
    }
    if (strcmp(res, "hello, ") != 0) {
	fprintf(stderr, "test dstring5 failed (step 5)\n");
	return 5;
    }
    ds->Append("goodbye", -1);
    res = ds->Get();
    if (res == NULL) {
	fprintf(stderr, "test dstring5 failed (step 6)\n");
	return 5;
    }
    if (strcmp(res, "hello, goodbye") != 0) {
	fprintf(stderr, "test dstring5 failed (step 7)\n");
	return 5;
    }
    ds->SetLength(0);
    res = ds->Get();
    if (res != NULL) {
	fprintf(stderr, "test dstring5 failed (step 8)\n");
	return 5;
    }
    ds->SetLength(5);
    if ((res != NULL) || (ds->Length() != 0)) {
	fprintf(stderr, "test dstring5 failed (step 9)\n");
	return 5;
    }
    ds->Append("hello", -1);
    if (ds->Length() != 5) {
	fprintf(stderr, "test dstring5 failed (step 10)\n");
	return 5;
    }
    res = ds->Get();
    if (res == NULL) {
	fprintf(stderr, "test dstring5 failed (step 11)\n");
	return 5;
    }
    if (strcmp(res, "hello") != 0) {
	fprintf(stderr, "test dstring5 failed (step 12)\n");
	return 5;
    }
    ds->SetLength(3);
    res = ds->Get();
    if ((res == NULL) || (ds->Length() != 3)) {
	fprintf(stderr, "test dstring5 failed (step 13)\n");
	return 5;
    }
    if (strcmp(res, "hel") != 0) {
	fprintf(stderr, "test dstring5 failed (step 14)\n");
	return 5;
    }
    delete ds;

    return 0;
}

int
test_dstring()
{
    int result = 0;

    fprintf(stderr, "Running e4_DString tests: ");
    result = test_dstring1();
    if (result != 0) {
	return result;
    }
    fprintf(stderr, ".");
    result = test_dstring2();
    if (result != 0) {
	return result;
    }
    fprintf(stderr, ".");
    result = test_dstring3();
    if (result != 0) {
	return result;
    }
    fprintf(stderr, ".");
    result = test_dstring4();
    if (result != 0) {
	return result;
    }
    fprintf(stderr, ".");
    result = test_dstring5();
    if (result != 0) {
	return result;
    }
    fprintf(stderr, ".\n");
    
    return 0;
}
