#/bin/csh -f
#
# This shell script may be of use to build e4Graph and all the packages
# it depends on. The script expects the following directory structure:
#
#   dirc/e4graph-version
#	/tcl-version
#	/expat-version
#	/metakt-version
#
# In other words, all depended-upon packages' sources are found in the
# same directory as where the e4Graph sources are.
#
# Run this script with 'csh build_everything.csh'
#
# Copyright (c) 2000-2001, JYL Software Inc.
# 
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
# 
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE, EVEN IF
# JYL SOFTWARE INC. IS MADE AWARE OF THE POSSIBILITY OF SUCH DAMAGE.

# INSTALLCOMP:
#
# The directory where everything will be installed. Change it to where you
# want to install the products of building everything.

set SRCCOMP=`pwd`/../..
set INSTALLCOMP=$SRCCOMP/install

# What versions of all packages are we going to build:

set TCLVERSION=tcl8.4.4
set PYTHONVERSION=Python-2.2.3
set MKTVERSION=metakit-2.4.9.2
set EXPVERSION=expat-1.95.7
set E4GVERSION=e4graph-1.0a11

# Which make to use:

set MAKE=gmake

# You should not have to change anything below this line

set TCLSRC=$SRCCOMP/$TCLVERSION
set TCLBLD=$TCLSRC/unix

set PYTSRC=$SRCCOMP/$PYTHONVERSION
set PYTBLD=$PYTSRC

set MKTSRC=$SRCCOMP/$MKTVERSION
set MKTBLD=$MKTSRC/builds

set EXPSRC=$SRCCOMP/$EXPVERSION

set E4GSRC=$SRCCOMP/$E4GVERSION
set E4GBLD=$E4GSRC/all

# Now just go through, configure and build everything

echo cleaning up previous install
yes | /bin/rm -rf ../../install
echo making in $TCLBLD
cd $TCLBLD
/bin/rm -f config.status config.cache config.log
./configure --prefix=`pwd`/../../install
$MAKE distclean
/bin/rm -f config.status config.cache config.log
./configure --prefix=`pwd`/../../install
$MAKE install
echo making in $PYTBLD
cd $PYTBLD
/bin/rm -f config.status config.cache config.log
./configure --prefix=`pwd`/../install
$MAKE clean install
echo making in $MKTBLD
cd $MKTBLD
/bin/rm -f config.status config.cache config.log
../unix/configure --prefix=`pwd`/../../install
$MAKE clean install
echo making in $EXPSRC
cd $EXPSRC
/bin/rm -f config.status config.cache config.log
./configure --prefix=`pwd`/../install
$MAKE clean install
echo making in $E4GBLD
cd $E4GBLD
/bin/rm -f config.status config.cache config.log
autoconf
./configure --enable-tcl --enable-xml --enable-java --enable-python --prefix=`pwd`/../../install
$MAKE clean install



