
# Test switches
#
# -before, -after, -node for "insert" operation
#

if {[info procs test] != "test"} {
    source defs
}

if [file exists ../library] {
    set blt_library ../library
}

#set VERBOSE 1

test datatable.1 {tree no args} {
    list [catch {blt::tree} msg] $msg
} {1 {wrong # args: should be one of...
  blt::tree create ?name?
  blt::tree destroy name...
  blt::tree names ?pattern?...}}

test datatable.2 {tree create #auto} {
    list [catch {blt::tree create #auto} msg] $msg
} {0 ::tree0}

test datatable.3 {tree create #auto.suffix} {
    list [catch {blt::tree create #auto.suffix} msg] $msg
} {0 ::tree0.suffix}

test datatable.4 {tree create prefix.#auto} {
    list [catch {blt::tree create prefix.#auto} msg] $msg
} {0 ::prefix.tree0}

test datatable.5 {tree create prefix.#auto.suffix} {
    list [catch {blt::tree create prefix.#auto.suffix} msg] $msg
} {0 ::prefix.tree0.suffix}

test datatable.6 {tree create prefix.#auto.suffix.#auto} {
    list [catch {blt::tree create prefix.#auto.suffix.#auto} msg] $msg
} {0 ::prefix.tree0.suffix.#auto}

test datatable.7 {tree destroy [tree names *tree0*]} {
    list [catch {eval blt::tree destroy [blt::tree names *tree0*]} msg] $msg
} {0 {}}

test datatable.8 {create} {
    list [catch {blt::tree create} msg] $msg
} {0 ::tree0}

test datatable.9 {create} {
    list [catch {blt::tree create} msg] $msg
} {0 ::tree1}

test datatable.10 {create fred} {
    list [catch {blt::tree create fred} msg] $msg
} {0 ::fred}

test datatable.11 {create fred} {
    list [catch {blt::tree create fred} msg] $msg
} {1 {a command "::fred" already exists}}

test datatable.12 {create if} {
    list [catch {blt::tree create if} msg] $msg
} {1 {a command "::if" already exists}}

test datatable.13 {tree create (bad namespace)} {
    list [catch {blt::tree create badName::fred} msg] $msg
} {1 {unknown namespace "badName"}}

test datatable.14 {tree create (wrong # args)} {
    list [catch {blt::tree create a b} msg] $msg
} {1 {wrong # args: should be "blt::tree create ?name?"}}

test datatable.15 {tree names} {
    list [catch {blt::tree names} msg] [lsort $msg]
} {0 {::fred ::tree0 ::tree1}}

test datatable.16 {tree names pattern)} {
    list [catch {blt::tree names ::tree*} msg] [lsort $msg]
} {0 {::tree0 ::tree1}}

test datatable.17 {tree names badPattern)} {
    list [catch {blt::tree names badPattern*} msg] $msg
} {0 {}}

test datatable.18 {tree names pattern arg (wrong # args)} {
    list [catch {blt::tree names pattern arg} msg] $msg
} {1 {wrong # args: should be "blt::tree names ?pattern?..."}}

test datatable.19 {tree destroy (wrong # args)} {
    list [catch {blt::tree destroy} msg] $msg
} {1 {wrong # args: should be "blt::tree destroy name..."}}

test datatable.20 {tree destroy badTree} {
    list [catch {blt::tree destroy badTree} msg] $msg
} {1 {can't find a tree named "badTree"}}

test datatable.21 {tree destroy fred} {
    list [catch {blt::tree destroy fred} msg] $msg
} {0 {}}

test datatable.22 {tree destroy tree0 tree1} {
    list [catch {blt::tree destroy tree0 tree1} msg] $msg
} {0 {}}

test datatable.23 {create} {
    list [catch {blt::tree create} msg] $msg
} {0 ::tree0}

test datatable.24 {tree0} {
    list [catch {tree0} msg] $msg
} {1 {wrong # args: should be one of...
  tree0 ancestor node1 node2
  tree0 apply node ?switches?
  tree0 attach ?tree?
  tree0 children node ?first? ?last?
  tree0 copy parent ?tree? node ?switches?
  tree0 degree node
  tree0 delete node ?node...?
  tree0 depth node
  tree0 dump node
  tree0 dumpfile node fileName
  tree0 exists node ?key?
  tree0 find node ?switches?
  tree0 findchild node label
  tree0 firstchild node
  tree0 get node ?key? ?defaultValue?
  tree0 import node data ?switches?
  tree0 importfile node fileName ?switches?
  tree0 index label|list
  tree0 insert parent ?switches?
  tree0 is oper args...
  tree0 keys node ?node...?
  tree0 label node ?newLabel?
  tree0 lastchild node
  tree0 move node newParent ?switches?
  tree0 next node
  tree0 nextsibling node
  tree0 notify args...
  tree0 parent node
  tree0 parsepath node string ?separator?
  tree0 path node
  tree0 position ?switches? node...
  tree0 previous node
  tree0 prevsibling node
  tree0 restore node data ?switches?
  tree0 restorefile node fileName ?switches?
  tree0 root 
  tree0 set node ?key value...?
  tree0 size node
  tree0 sort node ?flags...?
  tree0 tag args...
  tree0 trace args...
  tree0 type node key
  tree0 unset node ?key...?
  tree0 values node ?key?}}

test datatable.25 {tree0 badOp} {
    list [catch {tree0 badOp} msg] $msg
} {1 {bad operation "badOp": should be one of...
  tree0 ancestor node1 node2
  tree0 apply node ?switches?
  tree0 attach ?tree?
  tree0 children node ?first? ?last?
  tree0 copy parent ?tree? node ?switches?
  tree0 degree node
  tree0 delete node ?node...?
  tree0 depth node
  tree0 dump node
  tree0 dumpfile node fileName
  tree0 exists node ?key?
  tree0 find node ?switches?
  tree0 findchild node label
  tree0 firstchild node
  tree0 get node ?key? ?defaultValue?
  tree0 import node data ?switches?
  tree0 importfile node fileName ?switches?
  tree0 index label|list
  tree0 insert parent ?switches?
  tree0 is oper args...
  tree0 keys node ?node...?
  tree0 label node ?newLabel?
  tree0 lastchild node
  tree0 move node newParent ?switches?
  tree0 next node
  tree0 nextsibling node
  tree0 notify args...
  tree0 parent node
  tree0 parsepath node string ?separator?
  tree0 path node
  tree0 position ?switches? node...
  tree0 previous node
  tree0 prevsibling node
  tree0 restore node data ?switches?
  tree0 restorefile node fileName ?switches?
  tree0 root 
  tree0 set node ?key value...?
  tree0 size node
  tree0 sort node ?flags...?
  tree0 tag args...
  tree0 trace args...
  tree0 type node key
  tree0 unset node ?key...?
  tree0 values node ?key?}}

test datatable.26 {tree0 insert (wrong # args)} {
    list [catch {tree0 insert} msg] $msg
} {1 {wrong # args: should be "tree0 insert parent ?switches?"}}

test datatable.27 {tree0 insert badParent} {
    list [catch {tree0 insert badParent} msg] $msg
} {1 {can't find tag or id "badParent" in ::tree0}}

test datatable.28 {tree0 insert 1000} {
    list [catch {tree0 insert 1000} msg] $msg
} {1 {can't find tag or id "1000" in ::tree0}}

test datatable.29 {tree0 insert 0} {
    list [catch {tree0 insert 0} msg] $msg
} {0 1}

test datatable.30 {tree0 insert 0} {
    list [catch {tree0 insert 0} msg] $msg
} {0 2}

test datatable.31 {tree0 insert root} {
    list [catch {tree0 insert root} msg] $msg
} {0 3}

test datatable.32 {tree0 insert all} {
    list [catch {tree0 insert all} msg] $msg
} {1 {more than one node tagged as "all"}}

test datatable.33 {tree0 insert 0 -at badPosition} {
    list [catch {tree0 insert 0 -at badPosition} msg] $msg
} {1 {expected integer but got "badPosition"}}

test datatable.34 {tree0 insert 0 -at -1} {
    list [catch {tree0 insert 0 -at -1} msg] $msg
} {1 {bad value "-1": can't be negative}}

test datatable.35 {tree0 insert 0 -at 1000} {
    list [catch {tree0 insert 0 -at 1000} msg] $msg
} {0 4}

test datatable.36 {tree0 insert 0 -at (no arg)} {
    list [catch {tree0 insert 0 -at} msg] $msg
} {1 {value for "-at" missing}}

test datatable.37 {tree0 insert 0 -tags myTag} {
    list [catch {tree0 insert 0 -tags myTag} msg] $msg
} {0 5}

test datatable.38 {tree0 insert 0 -tags {myTag1 myTag2} } {
    list [catch {tree0 insert 0 -tags {myTag1 myTag2}} msg] $msg
} {0 6}

test datatable.39 {tree0 insert 0 -tags root} {
    list [catch {tree0 insert 0 -tags root} msg] $msg
} {1 {can't add reserved tag "root"}}

test datatable.40 {tree0 insert 0 -tags (missing arg)} {
    list [catch {tree0 insert 0 -tags} msg] $msg
} {1 {value for "-tags" missing}}

test datatable.41 {tree0 insert 0 -label myLabel -tags thisTag} {
    list [catch {tree0 insert 0 -label myLabel -tags thisTag} msg] $msg
} {0 8}

test datatable.42 {tree0 insert 0 -label (missing arg)} {
    list [catch {tree0 insert 0 -label} msg] $msg
} {1 {value for "-label" missing}}

test datatable.43 {tree0 insert 1 -tags thisTag} {
    list [catch {tree0 insert 1 -tags thisTag} msg] $msg
} {0 9}

test datatable.44 {tree0 insert 1 -data key (missing value)} {
    list [catch {tree0 insert 1 -data key} msg] $msg
} {1 {missing value for "key"}}

test datatable.45 {tree0 insert 1 -data {key value}} {
    list [catch {tree0 insert 1 -data {key value}} msg] $msg
} {0 11}

test datatable.46 {tree0 insert 1 -data {key1 value1 key2 value2}} {
    list [catch {tree0 insert 1 -data {key1 value1 key2 value2}} msg] $msg
} {0 12}

test datatable.47 {get} {
    list [catch {
	tree0 get 12
    } msg] $msg
} {0 {key1 value1 key2 value2}}

test datatable.48 {tree0 children} {
    list [catch {tree0 children} msg] $msg
} {1 {wrong # args: should be "tree0 children node ?first? ?last?"}}

test datatable.49 {tree0 children 0} {
    list [catch {tree0 children 0} msg] $msg
} {0 {1 2 3 4 5 6 8}}

test datatable.50 {tree0 children root} {
    list [catch {tree0 children root} msg] $msg
} {0 {1 2 3 4 5 6 8}}

test datatable.51 {tree0 children 1} {
    list [catch {tree0 children 1} msg] $msg
} {0 {9 11 12}}

test datatable.52 {tree0 insert myTag} {
    list [catch {tree0 insert myTag} msg] $msg
} {0 13}

test datatable.53 {tree0 children myTag} {
    list [catch {tree0 children myTag} msg] $msg
} {0 13}

test datatable.54 {tree0 children root 0 end} {
    list [catch {tree0 children root 0 end} msg] $msg
} {0 {1 2 3 4 5 6 8}}

test datatable.55 {tree0 children root 2} {
    list [catch {tree0 children root 2} msg] $msg
} {0 3}

test datatable.56 {tree0 children root 2 end} {
    list [catch {tree0 children root 2 end} msg] $msg
} {0 {3 4 5 6 8}}

test datatable.57 {tree0 children root end end} {
    list [catch {tree0 children root end end} msg] $msg
} {0 8}

test datatable.58 {tree0 children root 0 2} {
    list [catch {tree0 children root 0 2} msg] $msg
} {0 {1 2 3}}

test datatable.59 {tree0 children root -1 -20} {
    list [catch {tree0 children root -1 -20} msg] $msg
} {0 {}}

test datatable.60 {tree0 firstchild (missing arg)} {
    list [catch {tree0 firstchild} msg] $msg
} {1 {wrong # args: should be "tree0 firstchild node"}}

test datatable.61 {tree0 firstchild root} {
    list [catch {tree0 firstchild root} msg] $msg
} {0 1}

test datatable.62 {tree0 lastchild (missing arg)} {
    list [catch {tree0 lastchild} msg] $msg
} {1 {wrong # args: should be "tree0 lastchild node"}}

test datatable.63 {tree0 lastchild root} {
    list [catch {tree0 lastchild root} msg] $msg
} {0 8}

test datatable.64 {tree0 nextsibling (missing arg)} {
    list [catch {tree0 nextsibling} msg] $msg
} {1 {wrong # args: should be "tree0 nextsibling node"}}

test datatable.65 {tree0 nextsibling 1)} {
    list [catch {tree0 nextsibling 1} msg] $msg
} {0 2}

test datatable.66 {tree0 nextsibling 2)} {
    list [catch {tree0 nextsibling 2} msg] $msg
} {0 3}

test datatable.67 {tree0 nextsibling 3)} {
    list [catch {tree0 nextsibling 3} msg] $msg
} {0 4}

test datatable.68 {tree0 nextsibling 4)} {
    list [catch {tree0 nextsibling 4} msg] $msg
} {0 5}

test datatable.69 {tree0 nextsibling 5)} {
    list [catch {tree0 nextsibling 5} msg] $msg
} {0 6}

test datatable.70 {tree0 nextsibling 6)} {
    list [catch {tree0 nextsibling 6} msg] $msg
} {0 8}

test datatable.71 {tree0 nextsibling 8)} {
    list [catch {tree0 nextsibling 8} msg] $msg
} {0 -1}

test datatable.72 {tree0 nextsibling all)} {
    list [catch {tree0 nextsibling all} msg] $msg
} {1 {more than one node tagged as "all"}}

test datatable.73 {tree0 nextsibling badTag)} {
    list [catch {tree0 nextsibling badTag} msg] $msg
} {1 {can't find tag or id "badTag" in ::tree0}}

test datatable.74 {tree0 nextsibling -1)} {
    list [catch {tree0 nextsibling -1} msg] $msg
} {1 {can't find tag or id "-1" in ::tree0}}

test datatable.75 {tree0 prevsibling 2)} {
    list [catch {tree0 prevsibling 2} msg] $msg
} {0 1}

test datatable.76 {tree0 prevsibling 1)} {
    list [catch {tree0 prevsibling 1} msg] $msg
} {0 -1}

test datatable.77 {tree0 prevsibling -1)} {
    list [catch {tree0 prevsibling -1} msg] $msg
} {1 {can't find tag or id "-1" in ::tree0}}

test datatable.78 {tree0 root)} {
    list [catch {tree0 root} msg] $msg
} {0 0}

test datatable.79 {tree0 root badArg)} {
    list [catch {tree0 root badArgs} msg] $msg
} {1 {wrong # args: should be "tree0 root "}}

test datatable.80 {tree0 parent (missing arg))} {
    list [catch {tree0 parent} msg] $msg
} {1 {wrong # args: should be "tree0 parent node"}}

test datatable.81 {tree0 parent root)} {
    list [catch {tree0 parent root} msg] $msg
} {0 -1}

test datatable.82 {tree0 parent 1)} {
    list [catch {tree0 parent 1} msg] $msg
} {0 0}

test datatable.83 {tree0 parent myTag)} {
    list [catch {tree0 parent myTag} msg] $msg
} {0 0}

test datatable.84 {tree0 next (missing arg))} {
    list [catch {tree0 next} msg] $msg
} {1 {wrong # args: should be "tree0 next node"}}


test datatable.85 {tree0 next (extra arg))} {
    list [catch {tree0 next root root} msg] $msg
} {1 {wrong # args: should be "tree0 next node"}}

test datatable.86 {tree0 next root} {
    list [catch {tree0 next root} msg] $msg
} {0 1}

test datatable.87 {tree0 next 1)} {
    list [catch {tree0 next 1} msg] $msg
} {0 9}

test datatable.88 {tree0 next 2)} {
    list [catch {tree0 next 2} msg] $msg
} {0 3}

test datatable.89 {tree0 next 3)} {
    list [catch {tree0 next 3} msg] $msg
} {0 4}

test datatable.90 {tree0 next 4)} {
    list [catch {tree0 next 4} msg] $msg
} {0 5}

test datatable.91 {tree0 next 5)} {
    list [catch {tree0 next 5} msg] $msg
} {0 13}

test datatable.92 {tree0 next 6)} {
    list [catch {tree0 next 6} msg] $msg
} {0 8}

test datatable.93 {tree0 next 8)} {
    list [catch {tree0 next 8} msg] $msg
} {0 -1}

test datatable.94 {tree0 previous 1)} {
    list [catch {tree0 previous 1} msg] $msg
} {0 0}

test datatable.95 {tree0 previous 0)} {
    list [catch {tree0 previous 0} msg] $msg
} {0 -1}

test datatable.96 {tree0 previous 8)} {
    list [catch {tree0 previous 8} msg] $msg
} {0 6}

test datatable.97 {tree0 depth (no arg))} {
    list [catch {tree0 depth} msg] $msg
} {1 {wrong # args: should be "tree0 depth node"}}

test datatable.98 {tree0 depth root))} {
    list [catch {tree0 depth root} msg] $msg
} {0 0}

test datatable.99 {tree0 depth myTag))} {
    list [catch {tree0 depth myTag} msg] $msg
} {0 1}

test datatable.100 {tree0 depth myTag))} {
    list [catch {tree0 depth myTag} msg] $msg
} {0 1}

test datatable.101 {tree0 dump (missing arg)))} {
    list [catch {tree0 dump} msg] $msg
} {1 {wrong # args: should be "tree0 dump node"}}

test datatable.102 {tree0 dump root} {
    list [catch {tree0 dump root} msg] $msg
} {0 {-1 0 {::tree0} {} {}
0 1 {::tree0 node1} {} {}
1 9 {::tree0 node1 node9} {} {thisTag}
1 11 {::tree0 node1 node11} {key value} {}
1 12 {::tree0 node1 node12} {key1 value1 key2 value2} {}
0 2 {::tree0 node2} {} {}
0 3 {::tree0 node3} {} {}
0 4 {::tree0 node4} {} {}
0 5 {::tree0 node5} {} {myTag}
5 13 {::tree0 node5 node13} {} {}
0 6 {::tree0 node6} {} {myTag2 myTag1}
0 8 {::tree0 myLabel} {} {thisTag}
}}

test datatable.103 {tree0 dump 1} {
    list [catch {tree0 dump 1} msg] $msg
} {0 {-1 1 {node1} {} {}
1 9 {node1 node9} {} {thisTag}
1 11 {node1 node11} {key value} {}
1 12 {node1 node12} {key1 value1 key2 value2} {}
}}

test datatable.104 {tree0 dump this} {
    list [catch {tree0 dump myTag} msg] $msg
} {0 {-1 5 {node5} {} {myTag}
5 13 {node5 node13} {} {}
}}

test datatable.105 {tree0 dump 1 badArg (too many args)} {
    list [catch {tree0 dump 1 badArg} msg] $msg
} {1 {wrong # args: should be "tree0 dump node"}}

test datatable.106 {tree0 dump 11} {
    list [catch {tree0 dump 11} msg] $msg
} {0 {-1 11 {node11} {key value} {}
}}

test datatable.107 {tree0 dump all} {
    list [catch {tree0 dump all} msg] $msg
} {1 {more than one node tagged as "all"}}

test datatable.108 {tree0 dump all} {
    list [catch {tree0 dump all} msg] $msg
} {1 {more than one node tagged as "all"}}

test datatable.109 {tree0 dumpfile 0 test.dump} {
    list [catch {tree0 dumpfile 0 test.dump} msg] $msg
} {0 {}}

test datatable.110 {tree0 get 9} {
    list [catch {tree0 get 9} msg] $msg
} {0 {}}

test datatable.111 {tree0 get all} {
    list [catch {tree0 get all} msg] $msg
} {1 {more than one node tagged as "all"}}

test datatable.112 {tree0 get root} {
    list [catch {tree0 get root} msg] $msg
} {0 {}}

test datatable.113 {tree0 get 9 key} {
    list [catch {tree0 get root} msg] $msg
} {0 {}}

test datatable.114 {tree0 get 12} {
    list [catch {tree0 get 12} msg] $msg
} {0 {key1 value1 key2 value2}}

test datatable.115 {tree0 get 12 key1} {
    list [catch {tree0 get 12 key1} msg] $msg
} {0 value1}

test datatable.116 {tree0 get 12 key2} {
    list [catch {tree0 get 12 key2} msg] $msg
} {0 value2}

test datatable.117 {tree0 get 12 key1 defValue } {
    list [catch {tree0 get 12 key1 defValue} msg] $msg
} {0 value1}

test datatable.118 {tree0 get 12 key100 defValue } {
    list [catch {tree0 get 12 key100 defValue} msg] $msg
} {0 defValue}

test datatable.119 {tree0 index (missing arg) } {
    list [catch {tree0 index} msg] $msg
} {1 {wrong # args: should be "tree0 index label|list"}}

test datatable.120 {tree0 index 0 10 (extra arg) } {
    list [catch {tree0 index 0 10} msg] $msg
} {1 {wrong # args: should be "tree0 index label|list"}}

test datatable.121 {tree0 index 0} {
    list [catch {tree0 index 0} msg] $msg
} {0 0}

test datatable.122 {tree0 index root} {
    list [catch {tree0 index root} msg] $msg
} {0 0}

test datatable.123 {tree0 index all} {
    list [catch {tree0 index all} msg] $msg
} {0 -1}

test datatable.124 {tree0 index myTag} {
    list [catch {tree0 index myTag} msg] $msg
} {0 5}

test datatable.125 {tree0 index thisTag} {
    list [catch {tree0 index thisTag} msg] $msg
} {0 -1}

test datatable.126 {tree0 is (no args)} {
    list [catch {tree0 is} msg] $msg
} {1 {wrong # args: should be one of...
  tree0 is ancestor node1 node2
  tree0 is before node1 node2
  tree0 is leaf node
  tree0 is root node}}

test datatable.127 {tree0 is badOp} {
    list [catch {tree0 is badOp} msg] $msg
} {1 {bad operation "badOp": should be one of...
  tree0 is ancestor node1 node2
  tree0 is before node1 node2
  tree0 is leaf node
  tree0 is root node}}

test datatable.128 {tree0 is before} {
    list [catch {tree0 is before} msg] $msg
} {1 {wrong # args: should be "tree0 is before node1 node2"}}

test datatable.129 {tree0 is before 0 10 20} {
    list [catch {tree0 is before 0 10 20} msg] $msg
} {1 {wrong # args: should be "tree0 is before node1 node2"}}

test datatable.130 {tree0 is before 0 12} {
    list [catch {tree0 is before 0 12} msg] $msg
} {0 1}

test datatable.131 {tree0 is before 12 0} {
    list [catch {tree0 is before 12 0} msg] $msg
} {0 0}

test datatable.132 {tree0 is before 0 0} {
    list [catch {tree0 is before 0 0} msg] $msg
} {0 0}

test datatable.133 {tree0 is before root 0} {
    list [catch {tree0 is before root 0} msg] $msg
} {0 0}

test datatable.134 {tree0 is before 0 all} {
    list [catch {tree0 is before 0 all} msg] $msg
} {1 {more than one node tagged as "all"}}

test datatable.135 {tree0 is ancestor} {
    list [catch {tree0 is ancestor} msg] $msg
} {1 {wrong # args: should be "tree0 is ancestor node1 node2"}}

test datatable.136 {tree0 is ancestor 0 12 20} {
    list [catch {tree0 is ancestor 0 12 20} msg] $msg
} {1 {wrong # args: should be "tree0 is ancestor node1 node2"}}

test datatable.137 {tree0 is ancestor 0 12} {
    list [catch {tree0 is ancestor 0 12} msg] $msg
} {0 1}

test datatable.138 {tree0 is ancestor 12 0} {
    list [catch {tree0 is ancestor 12 0} msg] $msg
} {0 0}

test datatable.139 {tree0 is ancestor 1 2} {
    list [catch {tree0 is ancestor 1 2} msg] $msg
} {0 0}

test datatable.140 {tree0 is ancestor root 0} {
    list [catch {tree0 is ancestor root 0} msg] $msg
} {0 0}

test datatable.141 {tree0 is ancestor 0 all} {
    list [catch {tree0 is ancestor 0 all} msg] $msg
} {1 {more than one node tagged as "all"}}

test datatable.142 {tree0 is root (missing arg)} {
    list [catch {tree0 is root} msg] $msg
} {1 {wrong # args: should be "tree0 is root node"}}

test datatable.143 {tree0 is root 0 20 (extra arg)} {
    list [catch {tree0 is root 0 20} msg] $msg
} {1 {wrong # args: should be "tree0 is root node"}}

test datatable.144 {tree0 is root 0} {
    list [catch {tree0 is root 0} msg] $msg
} {0 1}

test datatable.145 {tree0 is root 12} {
    list [catch {tree0 is root 12} msg] $msg
} {0 0}

test datatable.146 {tree0 is root 1} {
    list [catch {tree0 is root 1} msg] $msg
} {0 0}

test datatable.147 {tree0 is root root} {
    list [catch {tree0 is root root} msg] $msg
} {0 1}

test datatable.148 {tree0 is root all} {
    list [catch {tree0 is root all} msg] $msg
} {1 {more than one node tagged as "all"}}

test datatable.149 {tree0 is leaf (missing arg)} {
    list [catch {tree0 is leaf} msg] $msg
} {1 {wrong # args: should be "tree0 is leaf node"}}

test datatable.150 {tree0 is leaf 0 20 (extra arg)} {
    list [catch {tree0 is leaf 0 20} msg] $msg
} {1 {wrong # args: should be "tree0 is leaf node"}}

test datatable.151 {tree0 is leaf 0} {
    list [catch {tree0 is leaf 0} msg] $msg
} {0 0}

test datatable.152 {tree0 is leaf 12} {
    list [catch {tree0 is leaf 12} msg] $msg
} {0 1}

test datatable.153 {tree0 is leaf 1} {
    list [catch {tree0 is leaf 1} msg] $msg
} {0 0}

test datatable.154 {tree0 is leaf root} {
    list [catch {tree0 is leaf root} msg] $msg
} {0 0}

test datatable.155 {tree0 is leaf all} {
    list [catch {tree0 is leaf all} msg] $msg
} {1 {more than one node tagged as "all"}}

test datatable.156 {tree0 is leaf 1000} {
    list [catch {tree0 is leaf 1000} msg] $msg
} {1 {can't find tag or id "1000" in ::tree0}}

test datatable.157 {tree0 is leaf badTag} {
    list [catch {tree0 is leaf badTag} msg] $msg
} {1 {can't find tag or id "badTag" in ::tree0}}

test datatable.158 {tree0 set (missing arg)} {
    list [catch {tree0 set} msg] $msg
} {1 {wrong # args: should be "tree0 set node ?key value...?"}}

test datatable.159 {tree0 set 0 (missing arg)} {
    list [catch {tree0 set 0} msg] $msg
} {0 {}}

test datatable.160 {tree0 set 0 key (missing arg)} {
    list [catch {tree0 set 0 key} msg] $msg
} {1 {missing value for field "key"}}

test datatable.161 {tree0 set 0 key value} {
    list [catch {tree0 set 0 key value} msg] $msg
} {0 {}}

test datatable.162 {tree0 set 0 key1 value1 key2 value2 key3 value3} {
    list [catch {tree0 set 0 key1 value1 key2 value2 key3 value3} msg] $msg
} {0 {}}

test datatable.163 {tree0 set 0 key1 value1 key2 (missing arg)} {
    list [catch {tree0 set 0 key1 value1 key2} msg] $msg
} {1 {missing value for field "key2"}}

test datatable.164 {tree0 set 0 key value} {
    list [catch {tree0 set 0 key value} msg] $msg
} {0 {}}

test datatable.165 {tree0 set 0 key1 value1 key2 (missing arg)} {
    list [catch {tree0 set 0 key1 value1 key2} msg] $msg
} {1 {missing value for field "key2"}}

test datatable.166 {tree0 set all} {
    list [catch {tree0 set all} msg] $msg
} {0 {}}

test datatable.167 {tree0 set all abc 123} {
    list [catch {tree0 set all abc 123} msg] $msg
} {0 {}}

test datatable.168 {tree0 set root} {
    list [catch {tree0 set root} msg] $msg
} {0 {}}

test datatable.169 {tree0 restore stuff} {
    list [catch {
	set data [tree0 dump root]
	blt::tree create
	tree1 restore root $data
	set data [tree1 dump root]
	blt::tree destroy tree1
	set data
	} msg] $msg
} {0 {-1 0 {::tree0} {key value key1 value1 key2 value2 key3 value3 abc 123} {}
0 1 {::tree0 node1} {abc 123} {}
1 9 {::tree0 node1 node9} {abc 123} {thisTag}
1 11 {::tree0 node1 node11} {key value abc 123} {}
1 12 {::tree0 node1 node12} {key1 value1 key2 value2 abc 123} {}
0 2 {::tree0 node2} {abc 123} {}
0 3 {::tree0 node3} {abc 123} {}
0 4 {::tree0 node4} {abc 123} {}
0 5 {::tree0 node5} {abc 123} {myTag}
5 13 {::tree0 node5 node13} {abc 123} {}
0 6 {::tree0 node6} {abc 123} {myTag2 myTag1}
0 8 {::tree0 myLabel} {abc 123} {thisTag}
}}

test datatable.170 {tree0 restorefile 0 test.dump} {
    list [catch {
	blt::tree create
	tree1 restorefile root test.dump
	set data [tree1 dump root]
	blt::tree destroy tree1
	set data
	} msg] $msg
} {0 {-1 0 {::tree0} {} {}
0 1 {::tree0 node1} {} {}
1 9 {::tree0 node1 node9} {} {thisTag}
1 11 {::tree0 node1 node11} {key value} {}
1 12 {::tree0 node1 node12} {key1 value1 key2 value2} {}
0 2 {::tree0 node2} {} {}
0 3 {::tree0 node3} {} {}
0 4 {::tree0 node4} {} {}
0 5 {::tree0 node5} {} {myTag}
5 13 {::tree0 node5 node13} {} {}
0 6 {::tree0 node6} {} {myTag2 myTag1}
0 8 {::tree0 myLabel} {} {thisTag}
}}


test datatable.171 {tree0 unset 0 key1} {
    list [catch {tree0 unset 0 key1} msg] $msg
} {0 {}}

test datatable.172 {tree0 get 0} {
    list [catch {tree0 get 0} msg] $msg
} {0 {key value key2 value2 key3 value3 abc 123}}

test datatable.173 {tree0 unset 0 key2 key3} {
    list [catch {tree0 unset 0 key2 key3} msg] $msg
} {0 {}}

test datatable.174 {tree0 get 0} {
    list [catch {tree0 get 0} msg] $msg
} {0 {key value abc 123}}

test datatable.175 {tree0 unset 0} {
    list [catch {tree0 unset 0} msg] $msg
} {0 {}}

test datatable.176 {tree0 get 0} {
    list [catch {tree0 get 0} msg] $msg
} {0 {}}

test datatable.177 {tree0 unset all abc} {
    list [catch {tree0 unset all abc} msg] $msg
} {0 {}}

test datatable.178 {tree0 restore stuff} {
    list [catch {
	set data [tree0 dump root]
	blt::tree create tree1
	tree1 restore root $data
	set data [tree1 dump root]
	blt::tree destroy tree1
	set data
	} msg] $msg
} {0 {-1 0 {::tree0} {} {}
0 1 {::tree0 node1} {} {}
1 9 {::tree0 node1 node9} {} {thisTag}
1 11 {::tree0 node1 node11} {key value} {}
1 12 {::tree0 node1 node12} {key1 value1 key2 value2} {}
0 2 {::tree0 node2} {} {}
0 3 {::tree0 node3} {} {}
0 4 {::tree0 node4} {} {}
0 5 {::tree0 node5} {} {myTag}
5 13 {::tree0 node5 node13} {} {}
0 6 {::tree0 node6} {} {myTag2 myTag1}
0 8 {::tree0 myLabel} {} {thisTag}
}}

test datatable.179 {tree0 restore (missing arg)} {
    list [catch {tree0 restore} msg] $msg
} {1 {wrong # args: should be "tree0 restore node data ?switches?"}}

test datatable.180 {tree0 restore 0 badString} {
    list [catch {tree0 restore 0 badString} msg] $msg
} {1 {line #1: wrong # elements in restore entry}}

test datatable.181 {tree0 restore 0 {} arg (extra arg)} {
    list [catch {tree0 restore 0 {} arg} msg] $msg
} {1 {unknown switch "arg"}}


test datatable.182 {tree0 size (missing arg)} {
    list [catch {tree0 size} msg] $msg
} {1 {wrong # args: should be "tree0 size node"}}

test datatable.183 {tree0 size 0} {
    list [catch {tree0 size 0} msg] $msg
} {0 12}

test datatable.184 {tree0 size all} {
    list [catch {tree0 size all} msg] $msg
} {1 {more than one node tagged as "all"}}

test datatable.185 {tree0 size 0 10 (extra arg)} {
    list [catch {tree0 size 0 10} msg] $msg
} {1 {wrong # args: should be "tree0 size node"}}

test datatable.186 {tree0 delete (missing arg)} {
    list [catch {tree0 delete} msg] $msg
} {1 {wrong # args: should be "tree0 delete node ?node...?"}}

test datatable.187 {tree0 delete 11} {
    list [catch {tree0 delete 11} msg] $msg
} {0 {}}

test datatable.188 {tree0 delete 11} {
    list [catch {tree0 delete 11} msg] $msg
} {1 {can't find tag or id "11" in ::tree0}}

test datatable.189 {tree0 delete 9 12} {
    list [catch {tree0 delete 9 12} msg] $msg
} {0 {}}

test datatable.190 {tree0 dump 0} {
    list [catch {tree0 dump 0} msg] $msg
} {0 {-1 0 {::tree0} {} {}
0 1 {::tree0 node1} {} {}
0 2 {::tree0 node2} {} {}
0 3 {::tree0 node3} {} {}
0 4 {::tree0 node4} {} {}
0 5 {::tree0 node5} {} {myTag}
5 13 {::tree0 node5 node13} {} {}
0 6 {::tree0 node6} {} {myTag2 myTag1}
0 8 {::tree0 myLabel} {} {thisTag}
}}

test datatable.191 {delete all} {
    list [catch {
	set data [tree0 dump root]
	blt::tree create
	tree1 restore root $data
	tree1 delete all
	set data [tree1 dump root]
	blt::tree destroy tree1
	set data
	} msg] $msg
} {0 {-1 0 {::tree0} {} {}
}}

test datatable.192 {delete all all} {
    list [catch {
	set data [tree0 dump root]
	blt::tree create
	tree1 restore root $data
	tree1 delete all all
	set data [tree1 dump root]
	blt::tree destroy tree1
	set data
	} msg] $msg
} {0 {-1 0 {::tree0} {} {}
}}

test datatable.193 {tree0 apply (missing arg)} {
    list [catch {tree0 apply} msg] $msg
} {1 {wrong # args: should be "tree0 apply node ?switches?"}}

test datatable.194 {tree0 apply 0} {
    list [catch {tree0 apply 0} msg] $msg
} {0 {}}

test datatable.195 {tree0 apply 0 -badSwitch} {
    list [catch {tree0 apply 0 -badSwitch} msg] $msg
} {1 {unknown switch "-badSwitch"}}

test datatable.196 {tree0 apply badTag} {
    list [catch {tree0 apply badTag} msg] $msg
} {1 {can't find tag or id "badTag" in ::tree0}}

test datatable.197 {tree0 apply all} {
    list [catch {tree0 apply all} msg] $msg
} {1 {more than one node tagged as "all"}}

test datatable.198 {tree0 apply myTag -precommand lappend} {
    list [catch {
	set mylist {}
	tree0 apply myTag -precommand {lappend mylist}
	set mylist
    } msg] $msg
} {0 {5 13}}

test datatable.199 {tree0 apply root -precommand lappend} {
    list [catch {
	set mylist {}
	tree0 apply root -precommand {lappend mylist}
	set mylist
    } msg] $msg
} {0 {0 1 2 3 4 5 13 6 8}}

test datatable.200 {tree0 apply -precommand -postcommand} {
    list [catch {
	set mylist {}
	tree0 apply root -precommand {lappend mylist} \
		-postcommand {lappend mylist}
	set mylist
    } msg] $msg
} {0 {0 1 1 2 2 3 3 4 4 5 13 13 5 6 6 8 8 0}}

test datatable.201 {tree0 apply root -precommand lappend -depth 1} {
    list [catch {
	set mylist {}
	tree0 apply root -precommand {lappend mylist} -depth 1
	set mylist
    } msg] $msg
} {0 {0 1 2 3 4 5 6 8}}


test datatable.202 {tree0 apply root -precommand -depth 0} {
    list [catch {
	set mylist {}
	tree0 apply root -precommand {lappend mylist} -depth 0
	set mylist
    } msg] $msg
} {0 0}

test datatable.203 {tree0 apply root -precommand -tag myTag} {
    list [catch {
	set mylist {}
	tree0 apply root -precommand {lappend mylist} -tag myTag
	set mylist
    } msg] $msg
} {0 5}


test datatable.204 {tree0 apply root -precommand -key key1} {
    list [catch {
	set mylist {}
	tree0 set myTag key1 0.0
	tree0 apply root -precommand {lappend mylist} -key key1
	tree0 unset myTag key1
	set mylist
    } msg] $msg
} {0 5}

test datatable.205 {tree0 apply root -postcommand -regexp node.*} {
    list [catch {
	set mylist {}
	tree0 set myTag key1 0.0
	tree0 apply root -precommand {lappend mylist} -regexp {node5} 
	tree0 unset myTag key1
	set mylist
    } msg] $msg
} {0 5}

test datatable.206 {tree0 find (missing arg)} {
    list [catch {tree0 find} msg] $msg
} {1 {wrong # args: should be "tree0 find node ?switches?"}}

test datatable.207 {tree0 find 0} {
    list [catch {tree0 find 0} msg] $msg
} {0 {1 2 3 4 13 5 6 8 0}}

test datatable.208 {tree0 find root} {
    list [catch {tree0 find root} msg] $msg
} {0 {1 2 3 4 13 5 6 8 0}}

test datatable.209 {tree0 find 0 -glob node*} {
    list [catch {tree0 find root -glob node*} msg] $msg
} {0 {1 2 3 4 13 5 6}}

test datatable.210 {tree0 find 0 -glob nobody} {
    list [catch {tree0 find root -glob nobody} msg] $msg
} {0 {}}

test datatable.211 {tree0 find 0 -regexp {node[0-3]}} {
    list [catch {tree0 find root -regexp {node[0-3]}} msg] $msg
} {0 {1 2 3 13}}

test datatable.212 {tree0 find 0 -regexp {.*[A-Z].*}} {
    list [catch {tree0 find root -regexp {.*[A-Z].*}} msg] $msg
} {0 8}

test datatable.213 {tree0 find 0 -exact myLabel} {
    list [catch {tree0 find root -exact myLabel} msg] $msg
} {0 8}

test datatable.214 {tree0 find 0 -exact myLabel -invert} {
    list [catch {tree0 find root -exact myLabel -invert} msg] $msg
} {0 {1 2 3 4 13 5 6 0}}

test datatable.215 {tree0 find 3 -exact node3} {
    list [catch {tree0 find 3 -exact node3} msg] $msg
} {0 3}

test datatable.216 {tree0 find 0 -nocase -exact mylabel} {
    list [catch {tree0 find 0 -nocase -exact mylabel} msg] $msg
} {0 8}

test datatable.217 {tree0 find 0 -nocase} {
    list [catch {tree0 find 0 -nocase} msg] $msg
} {0 {1 2 3 4 13 5 6 8 0}}

test datatable.218 {tree0 find 0 -path -nocase -glob *node1* } {
    list [catch {tree0 find 0 -path -nocase -glob *node1*} msg] $msg
} {0 {1 13}}

test datatable.219 {tree0 find 0 -count 5 } {
    list [catch {tree0 find 0 -count 5} msg] $msg
} {0 {1 2 3 4 13}}

test datatable.220 {tree0 find 0 -count -5 } {
    list [catch {tree0 find 0 -count -5} msg] $msg
} {1 {bad value "-5": can't be negative}}

test datatable.221 {tree0 find 0 -count badValue } {
    list [catch {tree0 find 0 -count badValue} msg] $msg
} {1 {expected integer but got "badValue"}}

test datatable.222 {tree0 find 0 -count badValue } {
    list [catch {tree0 find 0 -count badValue} msg] $msg
} {1 {expected integer but got "badValue"}}

test datatable.223 {tree0 find 0 -leafonly} {
    list [catch {tree0 find 0 -leafonly} msg] $msg
} {0 {1 2 3 4 13 6 8}}

test datatable.224 {tree0 find 0 -leafonly -glob {node[18]}} {
    list [catch {tree0 find 0 -glob {node[18]} -leafonly} msg] $msg
} {0 1}

test datatable.225 {tree0 find 0 -depth 0} {
    list [catch {tree0 find 0 -depth 0} msg] $msg
} {0 0}

test datatable.226 {tree0 find 0 -depth 1} {
    list [catch {tree0 find 0 -depth 1} msg] $msg
} {0 {1 2 3 4 5 6 8 0}}

test datatable.227 {tree0 find 0 -depth 2} {
    list [catch {tree0 find 0 -depth 2} msg] $msg
} {0 {1 2 3 4 13 5 6 8 0}}

test datatable.228 {tree0 find 0 -depth 20} {
    list [catch {tree0 find 0 -depth 20} msg] $msg
} {0 {1 2 3 4 13 5 6 8 0}}

test datatable.229 {tree0 find 1 -depth 0} {
    list [catch {tree0 find 1 -depth 0} msg] $msg
} {0 1}

test datatable.230 {tree0 find 1 -depth 1} {
    list [catch {tree0 find 1 -depth 1} msg] $msg
} {0 1}

test datatable.231 {tree0 find 1 -depth 2} {
    list [catch {tree0 find 1 -depth 2} msg] $msg
} {0 1}

test datatable.232 {tree0 find all} {
    list [catch {tree0 find all} msg] $msg
} {1 {more than one node tagged as "all"}}

test datatable.233 {tree0 find badTag} {
    list [catch {tree0 find badTag} msg] $msg
} {1 {can't find tag or id "badTag" in ::tree0}}

test datatable.234 {tree0 find 0 -addtag hi} {
    list [catch {tree0 find 0 -addtag hi} msg] $msg
} {0 {1 2 3 4 13 5 6 8 0}}

test datatable.235 {tree0 find 0 -addtag all} {
    list [catch {tree0 find 0 -addtag all} msg] $msg
} {0 {1 2 3 4 13 5 6 8 0}}

test datatable.236 {tree0 find 0 -addtag root} {
    list [catch {tree0 find 0 -addtag root} msg] $msg
} {1 {can't add reserved tag "root"}}

test datatable.237 {tree0 find 0 -exec {lappend list} -leafonly} {
    list [catch {
	set list {}
	tree0 find 0 -exec {lappend list} -leafonly
	set list
	} msg] $msg
} {0 {1 2 3 4 13 6 8}}

test datatable.238 {tree0 find 0 -tag root} {
    list [catch {tree0 find 0 -tag root} msg] $msg
} {0 0}

test datatable.239 {tree0 find 0 -tag myTag} {
    list [catch {tree0 find 0 -tag myTag} msg] $msg
} {0 5}

test datatable.240 {tree0 find 0 -tag badTag} {
    list [catch {tree0 find 0 -tag badTag} msg] $msg
} {0 {}}

test datatable.241 {tree0 tag (missing args)} {
    list [catch {tree0 tag} msg] $msg
} {1 {wrong # args: should be "tree0 tag args..."}}

test datatable.242 {tree0 tag badOp} {
    list [catch {tree0 tag badOp} msg] $msg
} {1 {bad operation "badOp": should be one of...
  tree0 tag add tag ?node...?
  tree0 tag delete tag node...
  tree0 tag dump tag...
  tree0 tag exists node tag...
  tree0 tag forget tag...
  tree0 tag get node ?pattern...?
  tree0 tag names ?node...?
  tree0 tag nodes tag ?tag...?
  tree0 tag set node tag...
  tree0 tag unset node tag...}}

test datatable.243 {tree0 tag add} {
    list [catch {tree0 tag add} msg] $msg
} {1 {wrong # args: should be "tree0 tag add tag ?node...?"}}

test datatable.244 {tree0 tag add newTag} {
    list [catch {tree0 tag add newTag} msg] $msg
} {0 {}}

test datatable.245 {tree0 tag add tag badNode} {
    list [catch {tree0 tag add tag badNode} msg] $msg
} {1 {can't find tag or id "badNode" in ::tree0}}

test datatable.246 {tree0 tag add newTag root} {
    list [catch {tree0 tag add newTag root} msg] $msg
} {0 {}}

test datatable.247 {tree0 tag add newTag all} {
    list [catch {tree0 tag add newTag all} msg] $msg
} {0 {}}

test datatable.248 {tree0 tag add tag2 0 1 2 3 4} {
    list [catch {tree0 tag add tag2 0 1 2 3 4} msg] $msg
} {0 {}}

test datatable.249 {tree0 tag add tag2 0 1 2 3 4 1000} {
    list [catch {tree0 tag add tag2 0 1 2 3 4 1000} msg] $msg
} {1 {can't find tag or id "1000" in ::tree0}}

test datatable.250 {tree0 tag names} {
    list [catch {tree0 tag names} msg] [lsort $msg]
} {0 {all hi myTag myTag1 myTag2 newTag root tag2 thisTag}}

test datatable.251 {tree0 tag names badNode} {
    list [catch {tree0 tag names badNode} msg] $msg
} {1 {can't find tag or id "badNode" in ::tree0}}

test datatable.252 {tree0 tag names all} {
    list [catch {tree0 tag names all} msg] $msg
} {1 {more than one node tagged as "all"}}

test datatable.253 {tree0 tag names root} {
    list [catch {tree0 tag names root} msg] [lsort $msg]
} {0 {all hi newTag root tag2}}

test datatable.254 {tree0 tag names 0 1} {
    list [catch {tree0 tag names 0 1} msg] [lsort $msg]
} {0 {all hi newTag root tag2}}

test datatable.255 {tree0 tag nodes (missing arg)} {
    list [catch {tree0 tag nodes} msg] $msg
} {1 {wrong # args: should be "tree0 tag nodes tag ?tag...?"}}

test datatable.256 {tree0 tag nodes root badTag} {
    list [catch {tree0 tag nodes root badTag} msg] $msg
} {1 {can't find a tag "badTag"}}

test datatable.257 {tree0 tag nodes root tag2} {
    list [catch {tree0 tag nodes root tag2} msg] [lsort $msg]
} {0 {0 1 2 3 4}}

test datatable.258 {tree0 ancestor (missing arg)} {
    list [catch {tree0 ancestor} msg] $msg
} {1 {wrong # args: should be "tree0 ancestor node1 node2"}}

test datatable.259 {tree0 ancestor 0 (missing arg)} {
    list [catch {tree0 ancestor 0} msg] $msg
} {1 {wrong # args: should be "tree0 ancestor node1 node2"}}

test datatable.260 {tree0 ancestor 0 10} {
    list [catch {tree0 ancestor 0 10} msg] $msg
} {1 {can't find tag or id "10" in ::tree0}}

test datatable.261 {tree0 ancestor 0 4} {
    list [catch {tree0 ancestor 0 4} msg] $msg
} {0 0}

test datatable.262 {tree0 ancestor 1 8} {
    list [catch {tree0 ancestor 1 8} msg] $msg
} {0 0}

test datatable.263 {tree0 ancestor root 0} {
    list [catch {tree0 ancestor root 0} msg] $msg
} {0 0}

test datatable.264 {tree0 ancestor 8 8} {
    list [catch {tree0 ancestor 8 8} msg] $msg
} {0 8}

test datatable.265 {tree0 ancestor 0 all} {
    list [catch {tree0 ancestor 0 all} msg] $msg
} {1 {more than one node tagged as "all"}}

test datatable.266 {tree0 ancestor 7 9} {
    list [catch {
	set n1 1; set n2 1;
	for { set i 0 } { $i < 4 } { incr i } {
	    set n1 [tree0 insert $n1]
	    set n2 [tree0 insert $n2]
	}
	tree0 ancestor $n1 $n2
	} msg] $msg
} {0 1}

test datatable.267 {tree0 path (missing arg)} {
    list [catch {tree0 path} msg] $msg
} {1 {wrong # args: should be "tree0 path node"}}

test datatable.268 {tree0 path root} {
    list [catch {tree0 path root} msg] $msg
} {0 {}}

test datatable.269 {tree0 path 0} {
    list [catch {tree0 path 0} msg] $msg
} {0 {}}

test datatable.270 {tree0 path 15} {
    list [catch {tree0 path 15} msg] $msg
} {0 {node1 node15}}

test datatable.271 {tree0 path all} {
    list [catch {tree0 path all} msg] $msg
} {1 {more than one node tagged as "all"}}

test datatable.272 {tree0 path 0 1 2 4 (extra args)} {
    list [catch {tree0 path 0 1 2 4} msg] $msg
} {1 {wrong # args: should be "tree0 path node"}}

test datatable.273 {tree0 tag forget} {
    list [catch {tree0 tag forget} msg] $msg
} {1 {wrong # args: should be "tree0 tag forget tag..."}}

test datatable.274 {tree0 tag forget badTag} {
    list [catch {
	tree0 tag forget badTag
	lsort [tree0 tag names]
    } msg] $msg
} {0 {all hi myTag myTag1 myTag2 newTag root tag2 thisTag}}

test datatable.275 {tree0 tag forget hi} {
    list [catch {
	tree0 tag forget hi
	lsort [tree0 tag names]
    } msg] $msg
} {0 {all myTag myTag1 myTag2 newTag root tag2 thisTag}}

test datatable.276 {tree0 tag forget tag1 tag2} {
    list [catch {
	tree0 tag forget myTag1 myTag2
	lsort [tree0 tag names]
    } msg] $msg
} {0 {all myTag newTag root tag2 thisTag}}

test datatable.277 {tree0 tag forget all} {
    list [catch {
	tree0 tag forget all
	lsort [tree0 tag names]
    } msg] $msg
} {0 {all myTag newTag root tag2 thisTag}}

test datatable.278 {tree0 tag forget root} {
    list [catch {
	tree0 tag forget root
	lsort [tree0 tag names]
    } msg] $msg
} {0 {all myTag newTag root tag2 thisTag}}

test datatable.279 {tree0 tag delete} {
    list [catch {tree0 tag delete} msg] $msg
} {1 {wrong # args: should be "tree0 tag delete tag node..."}}

test datatable.280 {tree0 tag delete tag} {
    list [catch {tree0 tag delete tag} msg] $msg
} {1 {wrong # args: should be "tree0 tag delete tag node..."}}

test datatable.281 {tree0 tag delete tag 0} {
    list [catch {tree0 tag delete tag 0} msg] $msg
} {0 {}}

test datatable.282 {tree0 tag delete root 0} {
    list [catch {tree0 tag delete root 0} msg] $msg
} {1 {can't delete reserved tag "root"}}

test datatable.283 {tree0 move} {
    list [catch {tree0 move} msg] $msg
} {1 {wrong # args: should be "tree0 move node newParent ?switches?"}}

test datatable.284 {tree0 move 0} {
    list [catch {tree0 move 0} msg] $msg
} {1 {wrong # args: should be "tree0 move node newParent ?switches?"}}

test datatable.285 {tree0 move 0 0} {
    list [catch {tree0 move 0 0} msg] $msg
} {1 {can't move root node}}

test datatable.286 {tree0 move 0 badNode} {
    list [catch {tree0 move 0 badNode} msg] $msg
} {1 {can't find tag or id "badNode" in ::tree0}}

test datatable.287 {tree0 move 0 all} {
    list [catch {tree0 move 0 all} msg] $msg
} {1 {more than one node tagged as "all"}}

test datatable.288 {tree0 move 1 0 -before 2} {
    list [catch {
	tree0 move 1 0 -before 2
	tree0 children 0
    } msg] $msg
} {0 {1 2 3 4 5 6 8}}

test datatable.289 {tree0 move 1 0 -after 2} {
    list [catch {
	tree0 move 1 0 -after 2
	tree0 children 0
    } msg] $msg
} {0 {2 1 3 4 5 6 8}}

test datatable.290 {tree0 move 1 2} {
    list [catch {
	tree0 move 1 2
	tree0 children 0
    } msg] $msg
} {0 {2 3 4 5 6 8}}

test datatable.291 {tree0 move 0 2} {
    list [catch {tree0 move 0 2} msg] $msg
} {1 {can't move root node}}

test datatable.292 {tree0 move 1 17} {
    list [catch {tree0 move 1 17} msg] $msg
} {1 {can't move node: "1" is an ancestor of "17"}}

test datatable.293 {tree0 attach} {
    list [catch {tree0 attach} msg] $msg
} {0 ::tree0}

test datatable.294 {tree0 attach tree2 tree3} {
    list [catch {tree0 attach tree2 tree3} msg] $msg
} {1 {wrong # args: should be "tree0 attach ?tree?"}}

test datatable.295 {tree1 attach tree0} {
    list [catch {
	blt::tree create
	tree1 attach tree0
	tree1 dump 0
	} msg] $msg
} {0 {-1 0 {::tree0} {} {}
0 2 {::tree0 node2} {} {}
2 1 {::tree0 node2 node1} {} {}
1 14 {::tree0 node2 node1 node14} {} {}
14 16 {::tree0 node2 node1 node14 node16} {} {}
16 18 {::tree0 node2 node1 node14 node16 node18} {} {}
18 20 {::tree0 node2 node1 node14 node16 node18 node20} {} {}
1 15 {::tree0 node2 node1 node15} {} {}
15 17 {::tree0 node2 node1 node15 node17} {} {}
17 19 {::tree0 node2 node1 node15 node17 node19} {} {}
19 21 {::tree0 node2 node1 node15 node17 node19 node21} {} {}
0 3 {::tree0 node3} {} {}
0 4 {::tree0 node4} {} {}
0 5 {::tree0 node5} {} {}
5 13 {::tree0 node5 node13} {} {}
0 6 {::tree0 node6} {} {}
0 8 {::tree0 myLabel} {} {}
}}

test datatable.296 {tree1 attach} {
    list [catch {tree1 attach} msg] $msg
} {0 ::tree0}


test datatable.297 {blt::tree destroy tree1} {
    list [catch {blt::tree destroy tree1} msg] $msg
} {0 {}}

test datatable.298 {tree0 find root -badSwitch} {
    list [catch {tree0 find root -badSwitch} msg] $msg
} {1 {unknown switch "-badSwitch"}}

test datatable.299 {tree0 find root -order} {
    list [catch {tree0 find root -order} msg] $msg
} {1 {value for "-order" missing}}

test datatable.300 {tree0 find root ...} {
    list [catch {tree0 find root -order preorder -order postorder -order inorder} msg] $msg
} {0 {20 18 16 14 1 21 19 17 15 2 0 3 4 13 5 6 8}}

test datatable.301 {tree0 find root -order preorder} {
    list [catch {tree0 find root -order preorder} msg] $msg
} {0 {0 2 1 14 16 18 20 15 17 19 21 3 4 5 13 6 8}}

test datatable.302 {tree0 find root -order postorder} {
    list [catch {tree0 find root -order postorder} msg] $msg
} {0 {20 18 16 14 21 19 17 15 1 2 3 4 13 5 6 8 0}}

test datatable.303 {tree0 find root -order inorder} {
    list [catch {tree0 find root -order inorder} msg] $msg
} {0 {20 18 16 14 1 21 19 17 15 2 0 3 4 13 5 6 8}}

test datatable.304 {tree0 find root -order breadthfirst} {
    list [catch {tree0 find root -order breadthfirst} msg] $msg
} {0 {0 2 3 4 5 6 8 1 13 14 15 16 17 18 19 20 21}}

test datatable.305 {tree0 set all key1 myValue} {
    list [catch {tree0 set all key1 myValue} msg] $msg
} {0 {}}

test datatable.306 {tree0 set 15 key1 123} {
    list [catch {tree0 set 15 key1 123} msg] $msg
} {0 {}}

test datatable.307 {tree0 set 16 key1 1234 key2 abc} {
    list [catch {tree0 set 16 key1 123 key2 abc} msg] $msg
} {0 {}}

test datatable.308 {tree0 find root -key } {
    list [catch {tree0 find root -key} msg] $msg
} {1 {value for "-key" missing}}

test datatable.309 {tree0 find root -key noKey} {
    list [catch {tree0 find root -key noKey} msg] $msg
} {0 {}}

test datatable.310 {tree0 find root -key key1} {
    list [catch {tree0 find root -key key1} msg] $msg
} {0 {20 18 16 14 21 19 17 15 1 2 3 4 13 5 6 8 0}}

test datatable.311 {tree0 find root -key key2} {
    list [catch {tree0 find root -key key2} msg] $msg
} {0 16}

test datatable.312 {tree0 find root -key key2 -exact notThere } {
    list [catch {tree0 find root -key key2 -exact notThere } msg] $msg
} {0 {}}

test datatable.313 {tree0 find root -key key1 -glob notThere } {
    list [catch {tree0 find root -key key2 -exact notThere } msg] $msg
} {0 {}}

test datatable.314 {tree0 find root -key badKey -regexp notThere } {
    list [catch {tree0 find root -key key2 -exact notThere } msg] $msg
} {0 {}}

test datatable.315 {tree0 find root -key key1 -glob 12*} {
    list [catch {tree0 find root -key key1 -glob 12*} msg] $msg
} {0 {16 15}}

test datatable.316 {tree0 sort} {
    list [catch {tree0 sort} msg] $msg
} {1 {wrong # args: should be "tree0 sort node ?flags...?"}}

test datatable.317 {tree0 sort all} {
    list [catch {tree0 sort all} msg] $msg
} {1 {more than one node tagged as "all"}}

test datatable.318 {tree0 sort -recurse} {
    list [catch {tree0 sort -recurse} msg] $msg
} {1 {can't find tag or id "-recurse" in ::tree0}}

test datatable.319 {tree0 sort 0} {
    list [catch {tree0 sort 0} msg] $msg
} {0 {8 2 3 4 5 6}}

test datatable.320 {tree0 sort 0 -recurse} {
    list [catch {tree0 sort 0 -recurse} msg] $msg
} {0 {0 8 1 2 3 4 5 6 13 14 15 16 17 18 19 20 21}}

test datatable.321 {tree0 sort 0 -decreasing -key} {
    list [catch {tree0 sort 0 -decreasing -key} msg] $msg
} {1 {value for "-key" missing}}

test datatable.322 {tree0 sort 0 -re} {
    list [catch {tree0 sort 0 -re} msg] $msg
} {1 {ambiguous switch "-re"}}

test datatable.323 {tree0 sort 0 -decreasing} {
    list [catch {tree0 sort 0 -decreasing} msg] $msg
} {0 {6 5 4 3 2 8}}

test datatable.324 {tree0 sort 0} {
    list [catch {
	set list {}
	foreach n [tree0 sort 0] {
	    lappend list [tree0 label $n]
	}	
	set list
    } msg] $msg
} {0 {myLabel node2 node3 node4 node5 node6}}

test datatable.325 {tree0 sort 0 -decreasing} {
    list [catch {tree0 sort 0 -decreasing} msg] $msg
} {0 {6 5 4 3 2 8}}


test datatable.326 {tree0 sort 0 -decreasing -key} {
    list [catch {tree0 sort 0 -decreasing -key} msg] $msg
} {1 {value for "-key" missing}}

test datatable.327 {tree0 sort 0 -decreasing -key key1} {
    list [catch {tree0 sort 0 -decreasing -key key1} msg] $msg
} {0 {8 6 5 4 3 2}}

test datatable.328 {tree0 sort 0 -decreasing -recurse -key key1} {
    list [catch {tree0 sort 0 -decreasing -recurse -key key1} msg] $msg
} {0 {15 16 0 1 2 3 4 5 6 8 13 14 17 18 19 20 21}}

test datatable.329 {tree0 sort 0 -decreasing -key key1} {
    list [catch {
	set list {}
	foreach n [tree0 sort 0 -decreasing -key key1] {
	    lappend list [tree0 get $n key1]
	}
	set list
    } msg] $msg
} {0 {myValue myValue myValue myValue myValue myValue}}


test datatable.330 {tree0 index 1->firstchild} {
    list [catch {tree0 index 1->firstchild} msg] $msg
} {0 14}

test datatable.331 {tree0 index root->firstchild} {
    list [catch {tree0 index root->firstchild} msg] $msg
} {0 2}

test datatable.332 {tree0 label root->parent} {
    list [catch {tree0 label root->parent} msg] $msg
} {1 {can't find tag or id "root->parent" in ::tree0}}

test datatable.333 {tree0 index root->parent} {
    list [catch {tree0 index root->parent} msg] $msg
} {0 -1}

test datatable.334 {tree0 index root->lastchild} {
    list [catch {tree0 index root->lastchild} msg] $msg
} {0 8}

test datatable.335 {tree0 index root->next} {
    list [catch {tree0 index root->next} msg] $msg
} {0 2}

test datatable.336 {tree0 index root->previous} {
    list [catch {tree0 index root->previous} msg] $msg
} {0 -1}

test datatable.337 {tree0 label root->previous} {
    list [catch {tree0 label root->previous} msg] $msg
} {1 {can't find tag or id "root->previous" in ::tree0}}

test datatable.338 {tree0 index 1->previous} {
    list [catch {tree0 index 1->previous} msg] $msg
} {0 2}

test datatable.339 {tree0 label root->badModifier} {
    list [catch {tree0 label root->badModifier} msg] $msg
} {1 {can't find tag or id "root->badModifier" in ::tree0}}

test datatable.340 {tree0 index root->badModifier} {
    list [catch {tree0 index root->badModifier} msg] $msg
} {0 -1}

test datatable.341 {tree0 index root->firstchild->parent} {
    list [catch {tree0 index root->firstchild->parent} msg] $msg
} {0 0}

test datatable.342 {tree0 trace} {
    list [catch {tree0 trace} msg] $msg
} {1 {wrong # args: should be one of...
  tree0 trace create node key how command
  tree0 trace delete id...
  tree0 trace info id
  tree0 trace names }}


test datatable.343 {tree0 trace create} {
    list [catch {tree0 trace create} msg] $msg
} {1 {wrong # args: should be "tree0 trace create node key how command"}}

test datatable.344 {tree0 trace create root} {
    list [catch {tree0 trace create root} msg] $msg
} {1 {wrong # args: should be "tree0 trace create node key how command"}}

test datatable.345 {tree0 trace create root * } {
    list [catch {tree0 trace create root * } msg] $msg
} {1 {wrong # args: should be "tree0 trace create node key how command"}}

test datatable.346 {tree0 trace create root * rwuc} {
    list [catch {tree0 trace create root * rwuc} msg] $msg
} {1 {wrong # args: should be "tree0 trace create node key how command"}}

proc Doit args { global mylist; lappend mylist $args }

test datatable.347 {tree0 trace create all newKey rwuc Doit} {
    list [catch {tree0 trace create all newKey rwuc Doit} msg] $msg
} {0 trace0}

test datatable.348 {tree0 trace info trace0} {
    list [catch {tree0 trace info trace0} msg] $msg
} {0 {all newKey {} Doit}}

test datatable.349 {test create trace} {
    list [catch {
	set mylist {}
	tree0 set all newKey 20
	set mylist
	} msg] $msg
} {0 {{::tree0 0 newKey wc} {::tree0 2 newKey wc} {::tree0 1 newKey wc} {::tree0 14 newKey wc} {::tree0 16 newKey wc} {::tree0 18 newKey wc} {::tree0 20 newKey wc} {::tree0 15 newKey wc} {::tree0 17 newKey wc} {::tree0 19 newKey wc} {::tree0 21 newKey wc} {::tree0 3 newKey wc} {::tree0 4 newKey wc} {::tree0 5 newKey wc} {::tree0 13 newKey wc} {::tree0 6 newKey wc} {::tree0 8 newKey wc}}}

test datatable.350 {test read trace} {
    list [catch {
	set mylist {}
	tree0 get root newKey
	set mylist
	} msg] $msg
} {0 {{::tree0 0 newKey r}}}

test datatable.351 {test write trace} {
    list [catch {
	set mylist {}
	tree0 set all newKey 21
	set mylist
	} msg] $msg
} {0 {{::tree0 0 newKey w} {::tree0 2 newKey w} {::tree0 1 newKey w} {::tree0 14 newKey w} {::tree0 16 newKey w} {::tree0 18 newKey w} {::tree0 20 newKey w} {::tree0 15 newKey w} {::tree0 17 newKey w} {::tree0 19 newKey w} {::tree0 21 newKey w} {::tree0 3 newKey w} {::tree0 4 newKey w} {::tree0 5 newKey w} {::tree0 13 newKey w} {::tree0 6 newKey w} {::tree0 8 newKey w}}}

test datatable.352 {test unset trace} {
    list [catch {
	set mylist {}
	tree0 set all newKey 21
	set mylist
	} msg] $msg
} {0 {{::tree0 0 newKey w} {::tree0 2 newKey w} {::tree0 1 newKey w} {::tree0 14 newKey w} {::tree0 16 newKey w} {::tree0 18 newKey w} {::tree0 20 newKey w} {::tree0 15 newKey w} {::tree0 17 newKey w} {::tree0 19 newKey w} {::tree0 21 newKey w} {::tree0 3 newKey w} {::tree0 4 newKey w} {::tree0 5 newKey w} {::tree0 13 newKey w} {::tree0 6 newKey w} {::tree0 8 newKey w}}}

test datatable.353 {tree0 trace delete} {
    list [catch {tree0 trace delete} msg] $msg
} {0 {}}

test datatable.354 {tree0 trace delete badId} {
    list [catch {tree0 trace delete badId} msg] $msg
} {1 {unknown trace "badId"}}

test datatable.355 {tree0 trace delete trace0} {
    list [catch {tree0 trace delete trace0} msg] $msg
} {0 {}}

test datatable.356 {test create trace} {
    list [catch {
	set mylist {}
	tree0 set all newKey 20
	set mylist
	} msg] $msg
} {0 {}}

test datatable.357 {test unset trace} {
    list [catch {
	set mylist {}
	tree0 unset all newKey
	set mylist
	} msg] $msg
} {0 {}}


test datatable.358 {tree0 notify} {
    list [catch {tree0 notify} msg] $msg
} {1 {wrong # args: should be one of...
  tree0 notify create ?flags? command
  tree0 notify delete notifyId...
  tree0 notify info notifyId
  tree0 notify names }}


test datatable.359 {tree0 notify create} {
    list [catch {tree0 notify create} msg] $msg
} {1 {wrong # args: should be "tree0 notify create ?flags? command"}}

test datatable.360 {tree0 notify create -allevents} {
    list [catch {tree0 notify create -allevents Doit} msg] $msg
} {0 notify0}

test datatable.361 {tree0 notify info notify0} {
    list [catch {tree0 notify info notify0} msg] $msg
} {0 {notify0 {-create -delete -move -sort -relabel} {Doit}}}

test datatable.362 {tree0 notify info badId} {
    list [catch {tree0 notify info badId} msg] $msg
} {1 {unknown notify name "badId"}}

test datatable.363 {tree0 notify info} {
    list [catch {tree0 notify info} msg] $msg
} {1 {wrong # args: should be "tree0 notify info notifyId"}}

test datatable.364 {tree0 notify names} {
    list [catch {tree0 notify names} msg] $msg
} {0 notify0}


test datatable.365 {test create notify} {
    list [catch {
	set mylist {}
	tree0 insert 1 -tags test
	set mylist
	} msg] $msg
} {0 {{-create 22}}}

test datatable.366 {test move notify} {
    list [catch {
	set mylist {}
	tree0 move 8 test
	set mylist
	} msg] $msg
} {0 {{-move 8}}}

test datatable.367 {test sort notify} {
    list [catch {
	set mylist {}
	tree0 sort 0 -reorder 
	set mylist
	} msg] $msg
} {0 {{-sort 0}}}

test datatable.368 {test relabel notify} {
    list [catch {
	set mylist {}
	tree0 label test "newLabel"
	set mylist
	} msg] $msg
} {0 {{-relabel 22}}}

test datatable.369 {test delete notify} {
    list [catch {
	set mylist {}
	tree0 delete test
	set mylist
	} msg] $msg
} {0 {{-delete 8} {-delete 22}}}


test datatable.370 {tree0 notify delete badId} {
    list [catch {tree0 notify delete badId} msg] $msg
} {1 {unknown notify name "badId"}}


test datatable.371 {test create notify} {
    list [catch {
	set mylist {}
	tree0 set all newKey 20
	set mylist
	} msg] $msg
} {0 {}}

test datatable.372 {test delete notify} {
    list [catch {
	set mylist {}
	tree0 unset all newKey
	set mylist
	} msg] $msg
} {0 {}}

test datatable.373 {test delete notify} {
    list [catch {
	set mylist {}
	tree0 unset all newKey
	set mylist
	} msg] $msg
} {0 {}}

test datatable.374 {tree0 copy} {
    list [catch {tree0 copy} msg] $msg
} {1 {wrong # args: should be "tree0 copy parent ?tree? node ?switches?"}}

test datatable.375 {tree0 copy root} {
    list [catch {tree0 copy root} msg] $msg
} {1 {wrong # args: should be "tree0 copy parent ?tree? node ?switches?"}}

test datatable.376 {tree0 copy root 14} {
    list [catch {tree0 copy root 14} msg] $msg
} {0 23}

test datatable.377 {tree0 copy 14 root} {
    list [catch {tree0 copy 14 root} msg] $msg
} {0 24}

test datatable.378 {tree0 copy 14 root -recurse} {
    list [catch {tree0 copy 14 root -recurse} msg] $msg
} {1 {can't make cyclic copy: source node is an ancestor of the destination}}

test datatable.379 {tree0 copy 3 2 -recurse -tags} {
    list [catch {tree0 copy 3 2 -recurse -tags} msg] $msg
} {0 25}

test datatable.380 {copy tree to tree -recurse} {
    list [catch {
	blt::tree create tree1
	foreach node [tree0 children root] {
	    tree1 copy root tree0 $node -recurse 
	}
	foreach node [tree0 children root] {
	    tree1 copy root tree0 $node -recurse 
	}
	tree1 dump root
    } msg] $msg
} {0 {-1 0 {::tree1} {} {}
0 1 {::tree1 node2} {key1 myValue} {}
1 2 {::tree1 node2 node1} {key1 myValue} {}
2 3 {::tree1 node2 node1 node14} {key1 myValue} {}
3 4 {::tree1 node2 node1 node14 node16} {key1 123 key2 abc} {}
4 5 {::tree1 node2 node1 node14 node16 node18} {key1 myValue} {}
5 6 {::tree1 node2 node1 node14 node16 node18 node20} {key1 myValue} {}
3 7 {::tree1 node2 node1 node14 ::tree0} {key1 myValue} {}
2 8 {::tree1 node2 node1 node15} {key1 123} {}
8 9 {::tree1 node2 node1 node15 node17} {key1 myValue} {}
9 10 {::tree1 node2 node1 node15 node17 node19} {key1 myValue} {}
10 11 {::tree1 node2 node1 node15 node17 node19 node21} {key1 myValue} {}
0 12 {::tree1 node3} {key1 myValue} {}
12 13 {::tree1 node3 node2} {key1 myValue} {}
13 14 {::tree1 node3 node2 node1} {key1 myValue} {}
14 15 {::tree1 node3 node2 node1 node14} {key1 myValue} {}
15 16 {::tree1 node3 node2 node1 node14 node16} {key1 123 key2 abc} {}
16 17 {::tree1 node3 node2 node1 node14 node16 node18} {key1 myValue} {}
17 18 {::tree1 node3 node2 node1 node14 node16 node18 node20} {key1 myValue} {}
15 19 {::tree1 node3 node2 node1 node14 ::tree0} {key1 myValue} {}
14 20 {::tree1 node3 node2 node1 node15} {key1 123} {}
20 21 {::tree1 node3 node2 node1 node15 node17} {key1 myValue} {}
21 22 {::tree1 node3 node2 node1 node15 node17 node19} {key1 myValue} {}
22 23 {::tree1 node3 node2 node1 node15 node17 node19 node21} {key1 myValue} {}
0 24 {::tree1 node4} {key1 myValue} {}
0 25 {::tree1 node5} {key1 myValue} {}
25 26 {::tree1 node5 node13} {key1 myValue} {}
0 27 {::tree1 node6} {key1 myValue} {}
0 28 {::tree1 node14} {key1 myValue} {}
0 29 {::tree1 node2} {key1 myValue} {}
29 30 {::tree1 node2 node1} {key1 myValue} {}
30 31 {::tree1 node2 node1 node14} {key1 myValue} {}
31 32 {::tree1 node2 node1 node14 node16} {key1 123 key2 abc} {}
32 33 {::tree1 node2 node1 node14 node16 node18} {key1 myValue} {}
33 34 {::tree1 node2 node1 node14 node16 node18 node20} {key1 myValue} {}
31 35 {::tree1 node2 node1 node14 ::tree0} {key1 myValue} {}
30 36 {::tree1 node2 node1 node15} {key1 123} {}
36 37 {::tree1 node2 node1 node15 node17} {key1 myValue} {}
37 38 {::tree1 node2 node1 node15 node17 node19} {key1 myValue} {}
38 39 {::tree1 node2 node1 node15 node17 node19 node21} {key1 myValue} {}
0 40 {::tree1 node3} {key1 myValue} {}
40 41 {::tree1 node3 node2} {key1 myValue} {}
41 42 {::tree1 node3 node2 node1} {key1 myValue} {}
42 43 {::tree1 node3 node2 node1 node14} {key1 myValue} {}
43 44 {::tree1 node3 node2 node1 node14 node16} {key1 123 key2 abc} {}
44 45 {::tree1 node3 node2 node1 node14 node16 node18} {key1 myValue} {}
45 46 {::tree1 node3 node2 node1 node14 node16 node18 node20} {key1 myValue} {}
43 47 {::tree1 node3 node2 node1 node14 ::tree0} {key1 myValue} {}
42 48 {::tree1 node3 node2 node1 node15} {key1 123} {}
48 49 {::tree1 node3 node2 node1 node15 node17} {key1 myValue} {}
49 50 {::tree1 node3 node2 node1 node15 node17 node19} {key1 myValue} {}
50 51 {::tree1 node3 node2 node1 node15 node17 node19 node21} {key1 myValue} {}
0 52 {::tree1 node4} {key1 myValue} {}
0 53 {::tree1 node5} {key1 myValue} {}
53 54 {::tree1 node5 node13} {key1 myValue} {}
0 55 {::tree1 node6} {key1 myValue} {}
0 56 {::tree1 node14} {key1 myValue} {}
}}

puts stderr "done testing treecmd.tcl"

exit 0



