

/*
 * bltPs.h --
 *
 *	Copyright 1993-2004 George A Howlett.
 *
 *	Permission is hereby granted, free of charge, to any person
 *	obtaining a copy of this software and associated documentation
 *	files (the "Software"), to deal in the Software without
 *	restriction, including without limitation the rights to use,
 *	copy, modify, merge, publish, distribute, sublicense, and/or
 *	sell copies of the Software, and to permit persons to whom the
 *	Software is furnished to do so, subject to the following
 *	conditions:
 *
 *	The above copyright notice and this permission notice shall be
 *	included in all copies or substantial portions of the
 *	Software.
 *
 *	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 *	KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 *	WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 *	PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS
 *	OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 *	OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 *	OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 *	SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef _BLT_PS_H
#define _BLT_PS_H

typedef struct Blt_PostScriptStruct *Blt_PostScript;

extern Blt_PostScript Blt_GetPostScript(Tcl_Interp *interp, Tk_Window tkwin);

extern void Blt_FreePostScript(Blt_PostScript ps);

extern char *Blt_PostScriptValue(Blt_PostScript ps);

extern char *Blt_PostScriptScratchBuffer(Blt_PostScript ps);

extern void Blt_AppendToPostScript TCL_VARARGS(Blt_PostScript, ps);

extern void Blt_FormatToPostScript TCL_VARARGS(Blt_PostScript, ps);

extern void Blt_Draw3DRectangleToPostScript(Blt_PostScript ps,
	Tk_3DBorder border, double x, double y, int width, int height,
	int borderWidth, int relief);

extern void Blt_Fill3DRectangleToPostScript(Blt_PostScript ps, 
	Tk_3DBorder border, double x, double y, int width, int height,
	int borderWidth, int relief);

extern void Blt_BackgroundToPostScript(Blt_PostScript ps, XColor *colorPtr);

extern void Blt_BitmapDataToPostScript(Blt_PostScript ps, Display *display, 
	Pixmap bitmap, int width, int height);

extern void Blt_ClearBackgroundToPostScript(Blt_PostScript ps);

extern void Blt_ForegroundToPostScript(Blt_PostScript ps, XColor *colorPtr);

extern void Blt_FontToPostScript(Blt_PostScript ps, Blt_Font font);

extern void Blt_WindowToPostScript(Blt_PostScript ps, Tk_Window tkwin, 
	double x, double y);

extern void Blt_LineDashesToPostScript(Blt_PostScript ps, 
	Blt_Dashes *dashesPtr);

extern void Blt_LineWidthToPostScript(Blt_PostScript ps, int lineWidth);

extern void Blt_PathToPostScript(Blt_PostScript ps, Point2D *screenPts, 
	int nScreenPts);

extern void Blt_PhotoToPostScript(Blt_PostScript ps, Tk_PhotoHandle photoToken,
	double x, double y);

extern void Blt_PolygonToPostScript(Blt_PostScript ps, Point2D *screenPts, 
	int nScreenPts);

extern void Blt_LineToPostScript(Blt_PostScript ps, XPoint *points, 
	int nPoints);

extern void Blt_TextToPostScript(Blt_PostScript ps, char *string, 
	TextStyle *attrPtr, double x, double y);

extern void Blt_RectangleToPostScript(Blt_PostScript ps, double x,
	double y, int width, int height);

extern void Blt_RegionToPostScript(Blt_PostScript ps, double x, double y, 
	int width, int height);

extern void Blt_RectanglesToPostScript(Blt_PostScript ps, XRectangle *rects, 
	int nRects);

extern void Blt_BitmapToPostScript(Blt_PostScript ps, Display *display, 
	Pixmap bitmap, double scaleX, double scaleY);

extern void Blt_SegmentsToPostScript(Blt_PostScript ps, XSegment *segments, 
	int nSegments);

extern void Blt_StippleToPostScript(Blt_PostScript ps, Display *display, 
	Pixmap bitmap);

extern void Blt_LineAttributesToPostScript(Blt_PostScript ps, XColor *colorPtr,
	int lineWidth, Blt_Dashes *dashesPtr, int capStyle, int joinStyle);

extern int Blt_FileToPostScript(Tcl_Interp *interp, Blt_PostScript ps, 
	char *fileName);

extern void Blt_2DSegmentsToPostScript(Blt_PostScript ps, Segment2D *segments,
	int nSegments);

extern void Blt_PostScriptToInterp(Tcl_Interp *interp, Blt_PostScript ps);

#endif /* BLT_PS_H */
