
#define  XYDATA			0x01
#define  XYSIGYDATA		0x02
#define  XYSIGY1SIGY2DATA	0x04
#define  XSIGXYDATA		0x08
#define  XSIGX1SIGX2YDATA	0x10
#define  XSIGXYSIGYDATA		0x20
#define  XSIGX1SIGX2YSIGY1SIGY2DATA	0x40

#define  NONE           0x01
#define  LINEDATA       0x02
#define  SCATTERDATA    0x04
#define  LINESCATTER    0x06  /* Just add LINEDATA + SCATTERDATA */

#define  SYMCIRCLE   	0x0008
#define  SYMX        	0x0010
#define  SYMDIAMOND	0x0020
#define  SYMNTRI        0x0040
#define  SYMSTRI        0x0080
#define  SYMWTRI        0x0100
#define  SYMETRI        0x0200
#define  SYMSQUARE      0x0400
#define  SYMPLUS        0x0800
#define  SYMSTAR        0x1000
#define  SYMEBAR        0x2000

typedef struct Datapoint {
    double x;
    double y;

    double xsigh;
    double xsigl;
    double ysigh;
    double ysigl;
} Datapoint;

typedef struct Datatype {
    char datatypestr[32];
    int datatype;
    int data_size;

    int xindex;
    int yindex;
    int xsighindex;
    int xsiglindex;
    int ysighindex;
    int ysiglindex;
} Datatype;

static Datatype xyData = {
    "xy",	/* datatypestr   */
    XYDATA,	/* datatype      */
    2,		/* datasize      */
    0,		/* xindex        */
    1,		/* yindex        */
    -1,		/* xsighindex    */
    -1,		/* xsiglindex    */
    -1,		/* ysighindex    */
    -1		/* ysiglindex    */
};
static Datatype xysigyData = {
    "xysigy",	/* datatypestr   */
    XYSIGYDATA,	/* datatype      */
    3,		/* datasize      */
    0,		/* xindex        */
    1,		/* yindex        */
    -1,		/* xsighindex    */
    -1,		/* xsiglindex    */
    2,		/* ysighindex    */
    2		/* ysiglindex    */
};
static Datatype xysigy1sigy2Data = {
    "xysigy1sigy2",	/* datatypestr   */
    XYSIGY1SIGY2DATA,	/* datatype      */
    4,		/* datasize      */
    0,		/* xindex        */
    1,		/* yindex        */
    -1,		/* xsighindex    */
    -1,		/* xsiglindex    */
    2,		/* ysighindex    */
    3		/* ysiglindex    */
};
static Datatype xsigxyData = {
    "xsigxy",	/* datatypestr   */
    XSIGXYDATA,	/* datatype      */
    3,		/* datasize      */
    0,		/* xindex        */
    2,		/* yindex        */
    1,		/* xsighindex    */
    1,		/* xsiglindex    */
    -1,		/* ysighindex    */
    -1		/* ysiglindex    */
};
static Datatype xsigx1sigx2yData = {
    "xsigx1sigx2y",	/* datatypestr   */
    XSIGX1SIGX2YDATA,	/* datatype      */
    4,		/* datasize      */
    0,		/* xindex     */
    3,		/* yindex     */
    1,		/* xsighindex */
    2,		/* xsiglindex */
    -1,		/* ysighindex */
    -1		/* ysiglindex */
};
static Datatype xsigxysigyData = {
    "xsigxysigy",	/* datatypestr   */
    XSIGXYSIGYDATA,	/* datatype      */
    4,		/* datasize      */
    0,		/* xindex     */
    2,		/* yindex     */
    1,		/* xsighindex */
    1,		/* xsiglindex */
    3,		/* ysighindex */
    3		/* ysiglindex */
};
static Datatype xsigx1sigx2ysigy1sigy2Data = {
    "xsigx1sigx2ysigy1sigy2",	/* datatypestr   */
    XSIGX1SIGX2YSIGY1SIGY2DATA,	/* datatype      */
    6,		/* datasize      */
    0,		/* xindex     */
    3,		/* yindex     */
    1,		/* xsighindex */
    2,		/* xsiglindex */
    4,		/* ysighindex */
    5		/* ysiglindex */
};

/*
 * The structure below defines the record for each dataset item.
 */

typedef struct DatasetItem  {
    Tk_Item header;		/* Generic stuff that's the same for all
				 * types.  MUST BE FIRST IN STRUCTURE. */
    Tk_Outline outline;		/* Outline structure */
    Tk_Canvas canvas;		/* Canvas containing item.  Needed for
				 * parsing arrow shapes. */
    int numPoints;		/* Number of points in line (always >= 0). */
    Datapoint *errorPtr;	/* sigX and sigY values for data with errors */

    double *graphcoordPtr;
    double *canvascoordPtr;
    double *datacoordPtr;	/* Pointers to malloc-ed array containing
				 * x- and y-coords of all points in line.
				 * X-coords are even-valued indices, y-coords
				 * are corresponding odd-valued indices. If
				 * the line has arrowheads then the first
				 * and last points have been adjusted to refer
				 * to the necks of the arrowheads rather than
				 * their tips.  The actual endpoints are
				 * stored in the *firstArrowPtr and
				 * *lastArrowPtr, if they exist. */

    Datatype *datatype;	/* One of XYDATA, XYSIGYDATA, XSIGXYDATA,
                                 * XSIGXYSIGYDATA ... */
    int datastyle;		/* One of LINEDATA, SCATTERDATA, NONE */
    int symstyle;		/* One of SYMCIRCLE, SYMX, NONE */
    int symsize;		/* Size of the drawn points */
    int symopaque;		/* Size of the drawn points */
    Tk_Outline symoutline;	/* Outline for drawing the point symbols */

    int capStyle;		/* Cap style for line. */
    int joinStyle;		/* Join style for line. */
    GC arrowGC;			/* Graphics context for drawing arrowheads. */
    Tk_Uid arrow;		/* Indicates whether or not to draw arrowheads:
				 * "none", "first", "last", or "both". */
    float arrowShapeA;		/* Distance from tip of arrowhead to center. */
    float arrowShapeB;		/* Distance from tip of arrowhead to trailing
				 * point, measured along shaft. */
    float arrowShapeC;		/* Distance of trailing points from outside
				 * edge of shaft. */
    double *firstArrowPtr;	/* Points to array of PTS_IN_ARROW points
				 * describing polygon for arrowhead at first
				 * point in line.  First point of arrowhead
				 * is tip.  Malloc'ed.  NULL means no arrowhead
				 * at first point. */
    double *lastArrowPtr;	/* Points to polygon for arrowhead at last
				 * point in line (PTS_IN_ARROW points, first
				 * of which is tip).  Malloc'ed.  NULL means
				 * no arrowhead at last point. */
    int smooth;			/* Non-zero means draw line smoothed (i.e.
				 * with Bezier splines). */
    int splineSteps;		/* Number of steps in each spline segment. */
    GC bitmapGC;		/* Graphics context for drawing onto a bitmap
				 * mask. */
    double xmin, xmax;		/* Limits of the dataset */
    double ymin, ymax;		/* Limits of the dataset */
    GraphItem *graph;		/* Pointer to the graph in which the
				 * dataset is to be drawn.  If this is
				 * NULL, then don't draw the dataset. */
    int resize_id;		/* Id of the last graph resize.  If this
				 * does not match the value of resize_id
				 * in the graph, then we need to resize
				 * this dataset. */
    int delete_flag;		/* Set to 1 when the dataset item is being
				 * deleted or else we get a core dump when
				 * the application exits.
				 */
} DatasetItem;

