/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.BackSlashResult;
import tcl.lang.CallFrame;
import tcl.lang.CharPointer;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ParseResult;
import tcl.lang.StrtoulResult;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclParse;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TclToken;
import tcl.lang.Util;

class Parser {
    static final char TYPE_NORMAL = '\u0000';
    static final char TYPE_SPACE = '\u0001';
    static final char TYPE_COMMAND_END = '\u0002';
    static final char TYPE_SUBS = '\u0004';
    static final char TYPE_QUOTE = '\b';
    static final char TYPE_CLOSE_PAREN = '\u0010';
    static final char TYPE_CLOSE_BRACK = ' ';
    static final char TYPE_BRACE = '@';
    static char[] typeTable;
    static final int TCL_TOKEN_WORD = 1;
    static final int TCL_TOKEN_SIMPLE_WORD = 2;
    static final int TCL_TOKEN_TEXT = 4;
    static final int TCL_TOKEN_BS = 8;
    static final int TCL_TOKEN_COMMAND = 16;
    static final int TCL_TOKEN_VARIABLE = 32;
    static final int TCL_NO_EVAL = 65536;
    static final int TCL_EVAL_GLOBAL = 131072;
    static final int TCL_EVAL_DIRECT = 262144;
    static final int TCL_BRACKET_TERM = 1;
    static final int TCL_ALLOW_EXCEPTIONS = 4;
    static final int DELETED = 1;
    static final int ERR_IN_PROGRESS = 2;
    static final int ERR_ALREADY_LOGGED = 4;
    static final int ERROR_CODE_SET = 8;
    static final int EXPR_INITIALIZED = 16;
    static final int DONT_COMPILE_CMDS_INLINE = 32;
    static final int RAND_SEED_INITIALIZED = 64;
    static final int SAFE_INTERP = 128;
    static final int USE_EVAL_DIRECT = 256;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static TclParse parseCommand(Interp var0, CharPointer var1_1, int var2_2, String var3_3, int var4_4, boolean var5_5) {
        block40: {
            if (var2_2 < 0) {
                var2_2 = var1_1.length() - var1_1.index;
            }
            if ((var14_6 = var1_1.index + var2_2) > var1_1.length()) {
                var14_6 = var1_1.length();
            }
            var15_7 = var1_1.array[var14_6];
            var1_1.array[var14_6] = '\u0000';
            var11_8 = new TclParse(var0, var1_1.array, var14_6, var3_3, var4_4);
            var12_9 = var5_5 != false ? 34 : 2;
            var6_10 = new CharPointer(var1_1);
            try {
                block2: while (true) {
                    if (Parser.typeTable[var16_12 = var6_10.charAt()] == '\u0001' || var6_10.charAt() == '\n') {
                        ++var6_10.index;
                        continue;
                    }
                    if (var6_10.charAt() == '\\' && var6_10.charAt(1) == '\n') {
                        if (var6_10.index + 2 == var11_8.endIndex) {
                            var11_8.incomplete = true;
                        }
                        var6_10.index += 2;
                        continue;
                    }
                    if (var6_10.charAt() != '#') break;
                    if (var11_8.commentStart < 0) {
                        var11_8.commentStart = var6_10.index;
                    }
                    while (true) {
                        if (var6_10.index == var11_8.endIndex) {
                            var11_8.incomplete = true;
                            var11_8.commentSize = var6_10.index - var11_8.commentStart;
                            continue block2;
                        }
                        if (var6_10.charAt() == '\\') {
                            if (var6_10.charAt(1) == '\n' && var6_10.index + 2 == var11_8.endIndex) {
                                var11_8.incomplete = true;
                            }
                            var13_11 = Parser.backslash(var6_10);
                            var6_10.index = var13_11.nextIndex;
                            continue;
                        }
                        if (var6_10.charAt() == '\n') {
                            ++var6_10.index;
                            var11_8.commentSize = var6_10.index - var11_8.commentStart;
                            continue block2;
                        }
                        ++var6_10.index;
                    }
                    break;
                }
                var11_8.commandStart = var6_10.index;
                while (true) {
                    block42: {
                        block43: {
                            block41: {
                                var9_15 = var11_8.numTokens;
                                var8_14 = var11_8.getToken(var9_15);
                                var8_14.type = 1;
                                while (true) {
                                    if ((var7_13 = Parser.typeTable[var16_12 = var6_10.charAt()]) == '\u0001') {
                                        ++var6_10.index;
                                        continue;
                                    }
                                    if (var6_10.charAt() != '\\' || var6_10.charAt(1) != '\n') break;
                                    if (var6_10.index + 2 == var11_8.endIndex) {
                                        var11_8.incomplete = true;
                                    }
                                    var13_11 = Parser.backslash(var6_10);
                                    var6_10.index = var13_11.nextIndex;
                                }
                                if ((var7_13 & var12_9) != 0) {
                                    ++var6_10.index;
                                    break block40;
                                }
                                if (var6_10.index == var11_8.endIndex) break block40;
                                var8_14.script.array = var6_10.array;
                                var8_14.script.index = var6_10.index++;
                                ++var11_8.numTokens;
                                ++var11_8.numWords;
                                if (var6_10.charAt() != '\"') break block41;
                                var11_8 = Parser.parseTokens(var6_10, 8, var11_8);
                                if (var11_8.result != 0) {
                                    throw new TclException(var11_8.result);
                                }
                                if (var11_8.string[var11_8.termIndex] != '\"') {
                                    var11_8.termIndex = var6_10.index - 1;
                                    var11_8.incomplete = true;
                                    throw new TclException(var11_8.interp, "missing \"");
                                }
                                var6_10.index = var11_8.termIndex + 1;
                                break block42;
                            }
                            if (var6_10.charAt() != '{') break block43;
                            var8_14 = var11_8.getToken(var11_8.numTokens);
                            var8_14.type = 4;
                            var8_14.script.array = var6_10.array;
                            var8_14.script.index = ++var6_10.index;
                            var8_14.numComponents = 0;
                            var10_16 = 1;
                            if (true) ** GOTO lbl90
                        }
                        var11_8 = Parser.parseTokens(var6_10, 1 | var12_9, var11_8);
                        if (var11_8.result != 0) {
                            throw new TclException(var11_8.result);
                        }
                        var6_10.index = var11_8.termIndex;
                        break block42;
                        block6: while (true) {
                            ++var6_10.index;
lbl90:
                            // 2 sources

                            while (true) {
                                if (Parser.typeTable[var16_12 = var6_10.charAt()] == '\u0000') continue block6;
                                if (var6_10.charAt() == '}') {
                                    if (--var10_16 == 0) break block6;
                                    ++var6_10.index;
                                    continue;
                                }
                                if (var6_10.charAt() == '{') {
                                    ++var10_16;
                                    ++var6_10.index;
                                    continue;
                                }
                                if (var6_10.charAt() == '\\') {
                                    var13_11 = Parser.backslash(var6_10);
                                    if (var6_10.charAt(1) == '\n') {
                                        if (var6_10.index + 2 == var11_8.endIndex) {
                                            var11_8.incomplete = true;
                                        }
                                        var8_14.size = var6_10.index - var8_14.script.index;
                                        if (var8_14.size != 0) {
                                            ++var11_8.numTokens;
                                        }
                                        var8_14 = var11_8.getToken(var11_8.numTokens);
                                        var8_14.type = 8;
                                        var8_14.script.array = var6_10.array;
                                        var8_14.script.index = var6_10.index;
                                        var8_14.size = var13_11.nextIndex - var6_10.index;
                                        var8_14.numComponents = 0;
                                        ++var11_8.numTokens;
                                        var6_10.index = var13_11.nextIndex;
                                        var8_14 = var11_8.getToken(var11_8.numTokens);
                                        var8_14.type = 4;
                                        var8_14.script.array = var6_10.array;
                                        var8_14.script.index = var6_10.index;
                                        var8_14.numComponents = 0;
                                        continue;
                                    }
                                    var6_10.index = var13_11.nextIndex;
                                    continue;
                                }
                                if (var6_10.index == var11_8.endIndex) {
                                    var11_8.termIndex = var11_8.getToken((int)var9_15).script.index;
                                    var11_8.incomplete = true;
                                    throw new TclException(var0, "missing close-brace");
                                }
                                ++var6_10.index;
                            }
                            break;
                        }
                        if (var6_10.index != var8_14.script.index || var11_8.numTokens == var9_15 + 1) {
                            var8_14.size = var6_10.index - var8_14.script.index;
                            ++var11_8.numTokens;
                        }
                        ++var6_10.index;
                    }
                    var8_14 = var11_8.getToken(var9_15);
                    var8_14.size = var6_10.index - var8_14.script.index;
                    var8_14.numComponents = var11_8.numTokens - (var9_15 + 1);
                    if (var8_14.numComponents == 1 && var11_8.getToken((int)(var9_15 + 1)).type == 4) {
                        var8_14.type = 2;
                    }
                    if ((var7_13 = Parser.typeTable[var16_12 = var6_10.charAt()]) == '\u0001') {
                        ++var6_10.index;
                        continue;
                    }
                    if (var6_10.charAt() != '\\' || var6_10.charAt(1) != '\n') break;
                    if (var6_10.index + 2 == var11_8.endIndex) {
                        var11_8.incomplete = true;
                    }
                    var13_11 = Parser.backslash(var6_10);
                    var6_10.index = var13_11.nextIndex;
                }
                if ((var7_13 & var12_9) != 0) {
                    ++var6_10.index;
                } else if (var6_10.index != var11_8.endIndex) {
                    var11_8.termIndex = var6_10.index;
                    if (var6_10.charAt(-1) == '\"') {
                        throw new TclException(var0, "extra characters after close-quote");
                    }
                    throw new TclException(var0, "extra characters after close-brace");
                }
            }
            catch (TclException v0) {
                var1_1.array[var14_6] = var15_7;
                if (var11_8.commandStart < 0) {
                    var11_8.commandStart = var1_1.index;
                }
                var11_8.commandSize = var11_8.termIndex - var11_8.commandStart;
                var11_8.result = 1;
                return var11_8;
            }
        }
        var1_1.array[var14_6] = var15_7;
        var11_8.commandSize = var6_10.index - var11_8.commandStart;
        var11_8.result = 0;
        return var11_8;
    }

    static TclParse parseTokens(CharPointer charPointer, int n, TclParse tclParse) {
        int n2;
        CharPointer charPointer2;
        block18: {
            charPointer2 = new CharPointer(charPointer);
            n2 = tclParse.numTokens;
            while (true) {
                TclToken tclToken = tclParse.getToken(tclParse.numTokens);
                tclToken.script.array = charPointer2.array;
                tclToken.script.index = charPointer2.index++;
                tclToken.numComponents = 0;
                char c = charPointer2.charAt();
                char c2 = typeTable[c];
                if ((c2 & n) != 0) break block18;
                if ((c2 & 4) == 0) {
                    do {
                        ++charPointer2.index;
                    } while ((typeTable[c = charPointer2.charAt()] & (n | 4)) == 0);
                    tclToken.type = 4;
                    tclToken.size = charPointer2.index - tclToken.script.index;
                    ++tclParse.numTokens;
                    continue;
                }
                if (charPointer2.charAt() == '$') {
                    int n3 = tclParse.numTokens;
                    tclParse = Parser.parseVarName(tclParse.interp, charPointer2, tclParse.endIndex - charPointer2.index, tclParse, true);
                    if (tclParse.result != 0) {
                        return tclParse;
                    }
                    charPointer2.index += tclParse.getToken((int)n3).size;
                    continue;
                }
                if (charPointer2.charAt() == '[') {
                    block19: {
                        do {
                            TclParse tclParse2 = Parser.parseCommand(tclParse.interp, charPointer2, tclParse.endIndex - charPointer2.index, tclParse.fileName, tclParse.lineNum, true);
                            if (tclParse2.result != 0) {
                                tclParse.termIndex = tclParse2.termIndex;
                                tclParse.incomplete = tclParse2.incomplete;
                                tclParse.result = tclParse2.result;
                                return tclParse;
                            }
                            charPointer2.index = tclParse2.commandStart + tclParse2.commandSize;
                            if (charPointer2.charAt(-1) == ']' && !tclParse2.incomplete) break block19;
                        } while (charPointer2.index != tclParse.endIndex);
                        if (tclParse.interp != null) {
                            Interp interp = tclParse.interp;
                            if ("missing close-bracket" == null) {
                                interp.resetResult();
                            } else {
                                interp.setResult(TclString.newInstance("missing close-bracket"));
                            }
                        }
                        tclParse.termIndex = tclToken.script.index;
                        tclParse.incomplete = true;
                        tclParse.result = 1;
                        return tclParse;
                    }
                    tclToken.type = 16;
                    tclToken.size = charPointer2.index - tclToken.script.index;
                    ++tclParse.numTokens;
                    continue;
                }
                if (charPointer2.charAt() == '\\') {
                    if (charPointer2.charAt(1) == '\n') {
                        if (charPointer2.index + 2 == tclParse.endIndex) {
                            tclParse.incomplete = true;
                        }
                        if ((n & 1) != 0) break block18;
                    }
                    tclToken.type = 8;
                    BackSlashResult backSlashResult = Parser.backslash(charPointer2);
                    tclToken.size = backSlashResult.nextIndex - charPointer2.index;
                    ++tclParse.numTokens;
                    charPointer2.index += tclToken.size;
                    continue;
                }
                if (charPointer2.charAt() != '\u0000') break;
                if (charPointer2.index != tclParse.endIndex) {
                    tclToken.type = 4;
                    tclToken.size = 1;
                    ++tclParse.numTokens;
                    ++charPointer2.index;
                    continue;
                }
                break block18;
                break;
            }
            throw new TclRuntimeError("parseTokens encountered unknown character");
        }
        if (tclParse.numTokens == n2) {
            tclToken.type = 4;
            tclToken.size = 0;
            ++tclParse.numTokens;
        }
        tclParse.termIndex = charPointer2.index;
        tclParse.result = 0;
        return tclParse;
    }

    static void evalObjv(Interp interp, TclObject[] tclObjectArray, CharPointer charPointer, int n, int n2) throws TclException {
        interp.resetResult();
        if (tclObjectArray.length == 0) {
            return;
        }
        if (interp.deleted) {
            TclString.append(interp.getResult(), "attempt to call eval in deleted interpreter");
            interp.setErrorCode(TclString.newInstance("CORE IDELETE {attempt to call eval in deleted interpreter}"));
            throw new TclException(1);
        }
        if (interp.nestLevel >= interp.maxNestingDepth) {
            throw new TclException(interp, "too many nested calls to eval (infinite loop?)");
        }
        ++interp.nestLevel;
        try {
            Command command;
            TclObject tclObject = tclObjectArray[0];
            if (tclObject.stringRep == null) {
                tclObject.stringRep = tclObject.internalRep.toString();
            }
            if ((command = interp.getCommand(tclObject.stringRep)) == null) {
                TclObject[] tclObjectArray2 = new TclObject[tclObjectArray.length + 1];
                int n3 = tclObjectArray.length - 1;
                while (n3 >= 0) {
                    tclObjectArray2[n3 + 1] = tclObjectArray[n3];
                    --n3;
                }
                tclObjectArray2[0] = TclString.newInstance("unknown");
                tclObject = tclObjectArray2[0];
                if (tclObject.internalRep == null) {
                    throw new TclRuntimeError("Attempting to preserve object after it was deallocated");
                }
                ++tclObject.refCount;
                command = interp.getCommand("unknown");
                if (command == null) {
                    StringBuffer stringBuffer = new StringBuffer("invalid command name \"");
                    tclObject = tclObjectArray[0];
                    if (tclObject.stringRep == null) {
                        tclObject.stringRep = tclObject.internalRep.toString();
                    }
                    throw new TclException(interp, stringBuffer.append(tclObject.stringRep).append("\"").toString());
                }
                Parser.evalObjv(interp, tclObjectArray2, charPointer, n, 0);
                tclObjectArray2[0].release();
                Object var10_9 = null;
                --interp.nestLevel;
                return;
            }
            ++interp.cmdCount;
            CallFrame callFrame = interp.varFrame;
            if ((n2 & 0x20000) != 0) {
                interp.varFrame = interp.globalFrame;
            }
            command.cmdProc(interp, tclObjectArray);
            interp.varFrame = callFrame;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            --interp.nestLevel;
            throw throwable;
        }
        Object var10_10 = null;
        --interp.nestLevel;
    }

    static void logCommandInfo(Interp interp, CharPointer charPointer, int n, int n2, TclException tclException) {
        String string;
        int n3;
        if (interp.errAlreadyLogged) {
            return;
        }
        interp.errorLine = 1;
        int n4 = 0;
        while (n4 < n) {
            if (charPointer.array[n4] == '\n') {
                ++interp.errorLine;
            }
            ++n4;
        }
        if (n2 < 0) {
            n2 = charPointer.length() - n;
        }
        if (n2 > 150) {
            n3 = 150;
            string = "...";
        } else {
            n3 = n2;
            string = "";
        }
        String string2 = new String(charPointer.array, n, n3);
        if (!interp.errInProgress) {
            interp.addErrorInfo("\n    while executing\n\"" + string2 + string + "\"");
        } else {
            interp.addErrorInfo("\n    invoked from within\n\"" + string2 + string + "\"");
        }
        interp.errAlreadyLogged = false;
        tclException.errIndex = n + n3;
    }

    static TclObject evalTokens(Interp interp, TclToken[] tclTokenArray, int n, int n2) throws TclException {
        String string = null;
        TclObject tclObject = null;
        while (n2 > 0) {
            TclToken tclToken = tclTokenArray[n];
            TclObject tclObject2 = null;
            switch (tclToken.type) {
                case 4: {
                    string = tclToken.getTokenString();
                    break;
                }
                case 8: {
                    BackSlashResult backSlashResult = Parser.backslash(tclToken.script);
                    if (backSlashResult.isWordSep) {
                        string = "\\" + backSlashResult.c;
                        break;
                    }
                    Character c = new Character(backSlashResult.c);
                    string = c.toString();
                    break;
                }
                case 16: {
                    interp.evalFlags |= 1;
                    ++tclToken.script.index;
                    Parser.eval2(interp, tclToken.script, tclToken.size - 2, 0);
                    --tclToken.script.index;
                    tclObject2 = interp.getResult();
                    break;
                }
                case 32: {
                    TclObject tclObject3;
                    if (tclToken.numComponents == 1) {
                        tclObject3 = null;
                    } else {
                        tclObject3 = Parser.evalTokens(interp, tclTokenArray, n + 2, tclToken.numComponents - 1);
                        if (tclObject3 == null) {
                            return null;
                        }
                    }
                    String string2 = tclTokenArray[n + 1].getTokenString();
                    if (interp.noEval == 0) {
                        if (tclObject3 != null) {
                            try {
                                if (tclObject3.stringRep == null) {
                                    tclObject3.stringRep = tclObject3.internalRep.toString();
                                }
                                String string3 = tclObject3.stringRep;
                                tclObject2 = interp.varFrame.getVar(string2, string3, 0);
                            }
                            finally {
                                Object var12_13 = null;
                                tclObject3.release();
                            }
                        } else {
                            tclObject2 = interp.varFrame.getVar(string2, null, 0);
                        }
                    } else {
                        tclObject2 = TclString.newInstance("");
                        if (tclObject2.internalRep == null) {
                            throw new TclRuntimeError("Attempting to preserve object after it was deallocated");
                        }
                        ++tclObject2.refCount;
                    }
                    n2 -= tclToken.numComponents;
                    n += tclToken.numComponents;
                    break;
                }
                default: {
                    throw new TclRuntimeError("unexpected token type in evalTokens");
                }
            }
            if (tclObject == null) {
                tclObject = tclObject2 != null ? tclObject2 : TclString.newInstance(string);
                if (tclObject.internalRep == null) {
                    throw new TclRuntimeError("Attempting to preserve object after it was deallocated");
                }
                ++tclObject.refCount;
            } else {
                tclObject = tclObject.takeExclusive();
                if (tclObject2 != null) {
                    if (tclObject2.stringRep == null) {
                        tclObject2.stringRep = tclObject2.internalRep.toString();
                    }
                    string = tclObject2.stringRep;
                }
                TclString.append(tclObject, string);
            }
            ++n;
            --n2;
        }
        return tclObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void eval2(Interp interp, CharPointer charPointer, int n, int n2) throws TclException {
        int n3 = 0;
        if (n < 0) {
            n = charPointer.length() - charPointer.index;
        }
        interp.resetResult();
        CallFrame callFrame = interp.varFrame;
        if ((n2 & 0x20000) != 0) {
            interp.varFrame = interp.globalFrame;
        }
        CharPointer charPointer2 = new CharPointer(charPointer);
        int n4 = n;
        TclObject[] tclObjectArray = null;
        boolean bl = (interp.evalFlags & 1) != 0;
        interp.evalFlags &= 0xFFFFFFFE;
        do {
            TclParse tclParse;
            block23: {
                tclParse = Parser.parseCommand(interp, charPointer2, n4, null, 0, bl);
                if (tclParse.result != 0) {
                    throw new TclException(tclParse.result);
                }
                if (tclParse.numWords > 0 && interp.noEval == 0) {
                    Object var17_15;
                    int n5;
                    try {
                        try {
                            int n6 = 0;
                            TclToken tclToken = tclParse.getToken(n6);
                            if (tclObjectArray == null || tclObjectArray.length != tclParse.numWords) {
                                tclObjectArray = new TclObject[tclParse.numWords];
                            }
                            n3 = 0;
                            while (true) {
                                if (n3 >= tclParse.numWords) {
                                    try {
                                        Parser.evalObjv(interp, tclObjectArray, charPointer2, n4, 0);
                                        break;
                                    }
                                    catch (StackOverflowError stackOverflowError) {
                                        interp.setResult(TclString.newInstance("too many nested calls to eval (infinite loop?)"));
                                        throw new TclException(1);
                                    }
                                }
                                tclObjectArray[n3] = Parser.evalTokens(interp, tclParse.tokenList, n6 + 1, tclToken.numComponents);
                                if (tclObjectArray[n3] == null) {
                                    throw new TclException(1);
                                }
                                tclToken = tclParse.getToken(n6 += tclToken.numComponents + 1);
                                ++n3;
                            }
                            n5 = 0;
                            while (true) {
                                if (n5 >= n3) {
                                    n3 = 0;
                                    break;
                                }
                                tclObjectArray[n5].release();
                                ++n5;
                            }
                        }
                        catch (TclException tclException) {
                            if (tclException.getCompletionCode() == 1 && !interp.errAlreadyLogged) {
                                int n7 = tclParse.commandSize;
                                if (tclParse.commandStart + n7 != charPointer.index + n) {
                                    --n7;
                                }
                                interp.varFrame = callFrame;
                                Parser.logCommandInfo(interp, charPointer, tclParse.commandStart, n7, tclException);
                            }
                            throw tclException;
                        }
                        var17_15 = null;
                        n5 = 0;
                    }
                    catch (Throwable throwable) {
                        var17_15 = null;
                        n5 = 0;
                    }
                    while (n5 < n3) {
                        tclObjectArray[n5].release();
                        ++n5;
                    }
                    break block23;
                    while (true) {
                        if (n5 >= n3) {
                            throw throwable;
                        }
                        tclObjectArray[n5].release();
                        ++n5;
                    }
                }
            }
            int n8 = tclParse.commandStart + tclParse.commandSize;
            n4 -= n8 - charPointer2.index;
            charPointer2.index = n8;
            if (!bl || charPointer2.index <= 1 || charPointer2.charAt(-1) != ']') continue;
            interp.termOffset = charPointer2.index - 1 - charPointer.index;
            interp.varFrame = callFrame;
            return;
        } while (n4 > 0);
        interp.termOffset = charPointer2.index - charPointer.index;
        interp.varFrame = callFrame;
    }

    static TclParse parseVarName(Interp interp, CharPointer charPointer, int n, TclParse tclParse, boolean bl) {
        int n2 = n >= 0 ? charPointer.index + n : charPointer.length();
        if (!bl) {
            tclParse = new TclParse(interp, charPointer.array, n2, null, -1);
        }
        CharPointer charPointer2 = new CharPointer(charPointer);
        TclToken tclToken = tclParse.getToken(tclParse.numTokens);
        tclToken.type = 32;
        tclToken.script.array = charPointer2.array;
        tclToken.script.index = charPointer2.index++;
        int n3 = tclParse.numTokens++;
        if (charPointer2.index >= n2) {
            tclToken.type = 4;
            tclToken.size = 1;
            tclToken.numComponents = 0;
            tclParse.result = 0;
            return tclParse;
        }
        TclToken tclToken2 = tclToken;
        tclToken = tclParse.getToken(tclParse.numTokens);
        if (charPointer2.charAt() == '{') {
            ++charPointer2.index;
            tclToken.type = 4;
            tclToken.script.array = charPointer2.array;
            tclToken.script.index = charPointer2.index;
            tclToken.numComponents = 0;
            while (true) {
                if (charPointer2.index == n2) {
                    if (interp != null) {
                        if ("missing close-brace for variable name" == null) {
                            interp.resetResult();
                        } else {
                            interp.setResult(TclString.newInstance("missing close-brace for variable name"));
                        }
                    }
                    tclParse.termIndex = tclToken.script.index - 1;
                    tclParse.incomplete = true;
                    tclParse.result = 1;
                    return tclParse;
                }
                if (charPointer2.charAt() == '}') break;
                ++charPointer2.index;
            }
            tclToken.size = charPointer2.index - tclToken.script.index;
            tclToken2.size = charPointer2.index - tclToken2.script.index;
            ++tclParse.numTokens;
            ++charPointer2.index;
        } else {
            tclToken.type = 4;
            tclToken.script.array = charPointer2.array;
            tclToken.script.index = charPointer2.index;
            tclToken.numComponents = 0;
            while (charPointer2.index != n2) {
                if (Character.isLetterOrDigit(charPointer2.charAt()) || charPointer2.charAt() == '_') {
                    ++charPointer2.index;
                    continue;
                }
                if (charPointer2.charAt() != ':' || charPointer2.index + 1 == n2 || charPointer2.charAt(1) != ':') break;
                charPointer2.index += 2;
                while (charPointer2.index != n2 && charPointer2.charAt() == ':') {
                    ++charPointer2.index;
                }
            }
            tclToken.size = charPointer2.index - tclToken.script.index;
            if (tclToken.size == 0) {
                tclToken2.type = 4;
                tclToken2.size = 1;
                tclToken2.numComponents = 0;
                tclParse.result = 0;
                return tclParse;
            }
            ++tclParse.numTokens;
            if (charPointer2.index != n2 && charPointer2.charAt() == '(') {
                ++charPointer2.index;
                tclParse = Parser.parseTokens(charPointer2, 16, tclParse);
                if (tclParse.result != 0) {
                    return tclParse;
                }
                if (tclParse.termIndex == n2 || tclParse.string[tclParse.termIndex] != ')') {
                    if (interp != null) {
                        if ("missing )" == null) {
                            interp.resetResult();
                        } else {
                            interp.setResult(TclString.newInstance("missing )"));
                        }
                    }
                    tclParse.termIndex = charPointer2.index - 1;
                    tclParse.incomplete = true;
                    tclParse.result = 1;
                    return tclParse;
                }
                charPointer2.index = tclParse.termIndex + 1;
            }
        }
        tclToken2.size = charPointer2.index - tclToken2.script.index;
        tclToken2.numComponents = tclParse.numTokens - (n3 + 1);
        tclParse.result = 0;
        return tclParse;
    }

    static ParseResult parseVar(Interp interp, String string) throws TclException {
        TclParse tclParse = null;
        CharPointer charPointer = new CharPointer(string);
        tclParse = Parser.parseVarName(interp, charPointer, -1, tclParse, false);
        if (tclParse.numTokens == 1) {
            return new ParseResult("$", 1);
        }
        TclObject tclObject = Parser.evalTokens(interp, tclParse.tokenList, 0, tclParse.numTokens);
        if (tclObject.refCount <= 1) {
            throw new TclRuntimeError("parseVar got temporary object from evalTokens");
        }
        tclObject.release();
        return new ParseResult(tclObject, tclParse.tokenList[0].size);
    }

    static boolean commandComplete(String string, int n) {
        TclParse tclParse;
        CharPointer charPointer = new CharPointer(string);
        int n2 = charPointer.index + n;
        do {
            tclParse = Parser.parseCommand(null, charPointer, n2 - charPointer.index, null, 0, false);
            charPointer.index = tclParse.commandStart + tclParse.commandSize;
            if (charPointer.index >= n2) break;
            ++charPointer.index;
        } while (tclParse.result == 0);
        return !tclParse.incomplete;
    }

    static boolean objCommandComplete(TclObject tclObject) {
        if (tclObject.stringRep == null) {
            tclObject.stringRep = tclObject.internalRep.toString();
        }
        String string = tclObject.stringRep;
        return Parser.commandComplete(string, string.length());
    }

    static BackSlashResult backslash(CharPointer charPointer) {
        CharPointer charPointer2 = new CharPointer(charPointer);
        ++charPointer2.index;
        int n = charPointer2.length();
        if (charPointer2.index == n) {
            return new BackSlashResult('\\', charPointer2.index);
        }
        char c = charPointer2.charAt();
        switch (c) {
            case 'a': {
                return new BackSlashResult('\u0007', charPointer2.index + 1);
            }
            case 'b': {
                return new BackSlashResult('\b', charPointer2.index + 1);
            }
            case 'f': {
                return new BackSlashResult('\f', charPointer2.index + 1);
            }
            case 'n': {
                return new BackSlashResult('\n', charPointer2.index + 1);
            }
            case 'r': {
                return new BackSlashResult('\r', charPointer2.index + 1);
            }
            case 't': {
                return new BackSlashResult('\t', charPointer2.index + 1);
            }
            case 'v': {
                return new BackSlashResult('\u000b', charPointer2.index + 1);
            }
            case 'x': {
                ++charPointer2.index;
                if (charPointer2.index < n && ((c = charPointer2.charAt()) >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
                    String string = new String(charPointer2.array, charPointer2.index, n - charPointer2.index);
                    StrtoulResult strtoulResult = Util.strtoul(string, 0, 16);
                    if (strtoulResult.errno == 0) {
                        byte by = (byte)(strtoulResult.value & 0xFFL);
                        return new BackSlashResult((char)by, charPointer2.index + strtoulResult.index);
                    }
                }
                return new BackSlashResult('x', charPointer2.index);
            }
            case 'u': {
                int n2 = 0;
                int n3 = 0;
                while (n3 < 4) {
                    ++charPointer2.index;
                    c = charPointer2.charAt();
                    if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f') && (c < 'A' || c > 'F')) break;
                    int n4 = c - 48;
                    if (n4 > 9) {
                        n4 = n4 + 48 + 10 - 65;
                    }
                    if (n4 > 16) {
                        n4 = n4 + 65 - 97;
                    }
                    n2 = (n2 << 4) + n4;
                    ++n3;
                }
                if (n3 == 0) {
                    n2 = 117;
                }
                return new BackSlashResult((char)n2, charPointer2.index);
            }
            case '\n': 
            case '\r': {
                if (c == '\r' && charPointer2.index + 1 < n && charPointer2.charAt(1) == '\n') {
                    ++charPointer2.index;
                }
                do {
                    ++charPointer2.index;
                } while (charPointer2.index < n && (charPointer2.charAt() == ' ' || charPointer2.charAt() == '\t'));
                return new BackSlashResult(' ', charPointer2.index);
            }
            case '\u0000': {
                return new BackSlashResult('\\', charPointer2.index + 1);
            }
        }
        if (c >= '0' && c <= '9') {
            int n5 = c - 48;
            ++charPointer2.index;
            if (charPointer2.index != n && (c = charPointer2.charAt()) >= '0' && c <= '9') {
                n5 = n5 * 8 + (c - 48);
                ++charPointer2.index;
                if (charPointer2.index != n && (c = charPointer2.charAt()) >= '0' && c <= '9') {
                    n5 = n5 * 8 + (c - 48);
                    ++charPointer2.index;
                }
            }
            return new BackSlashResult((char)(n5 & 0xFF), charPointer2.index);
        }
        return new BackSlashResult(c, charPointer2.index + 1);
    }

    static char charType(char c) {
        return typeTable[c];
    }

    Parser() {
    }

    static {
        char[] cArray = new char[256];
        cArray[0] = 4;
        cArray[9] = '\u0001';
        cArray[10] = 2;
        cArray[11] = '\u0001';
        cArray[12] = '\u0001';
        cArray[13] = '\u0001';
        cArray[32] = '\u0001';
        cArray[34] = 8;
        cArray[36] = 4;
        cArray[41] = 16;
        cArray[59] = 2;
        cArray[91] = 4;
        cArray[92] = 4;
        cArray[93] = 32;
        cArray[123] = 64;
        cArray[125] = 64;
        typeTable = cArray;
    }
}

