/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.Interp;
import tcl.lang.Procedure;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TclVarException;
import tcl.lang.TraceRecord;
import tcl.lang.Util;
import tcl.lang.Var;
import tcl.lang.VarTrace;

class CallFrame {
    static final String noSuchVar = "no such variable";
    static final String isArray = "variable is array";
    static final String needArray = "variable isn't array";
    static final String noSuchElement = "no such element in array";
    static final String danglingUpvar = "upvar refers to element in deleted array";
    protected static final int CRT_PART1 = 1;
    protected static final int CRT_PART2 = 2;
    protected Interp interp;
    protected Hashtable varTable;
    TclObject[] m_argv;
    protected CallFrame caller;
    protected CallFrame callerVar;
    protected int m_level;

    CallFrame(Interp interp) {
        this.interp = interp;
        this.varTable = new Hashtable();
        this.caller = null;
        this.callerVar = null;
        this.m_argv = null;
        this.m_level = 0;
    }

    CallFrame(Interp interp, Procedure procedure, TclObject[] tclObjectArray) throws TclException {
        this.interp = interp;
        this.varTable = new Hashtable();
        try {
            this.chain(procedure, tclObjectArray);
            return;
        }
        catch (TclException tclException) {
            this.dispose();
            throw tclException;
        }
    }

    void chain(Procedure procedure, TclObject[] tclObjectArray) throws TclException {
        this.m_argv = tclObjectArray;
        this.m_level = this.interp.varFrame.m_level + 1;
        this.caller = this.interp.frame;
        this.callerVar = this.interp.varFrame;
        this.interp.frame = this;
        this.interp.varFrame = this;
        int n = procedure.argList.length;
        if (!procedure.isVarArgs && tclObjectArray.length - 1 > n) {
            throw new TclException(this.interp, "called \"" + tclObjectArray[0] + "\" with too many arguments");
        }
        int n2 = 0;
        int n3 = 1;
        while (n2 < n) {
            TclObject tclObject = procedure.argList[n2][0];
            TclObject tclObject2 = null;
            if (n2 == n - 1 && procedure.isVarArgs) {
                tclObject2 = TclList.newInstance();
                tclObject2.preserve();
                int n4 = n3;
                while (n4 < tclObjectArray.length) {
                    TclList.append(this.interp, tclObject2, tclObjectArray[n4]);
                    ++n4;
                }
                Interp interp = this.interp;
                interp.varFrame.setVar(tclObject, tclObject2, 0);
                tclObject2.release();
            } else {
                if (n3 < tclObjectArray.length) {
                    tclObject2 = tclObjectArray[n3];
                } else if (procedure.argList[n2][1] != null) {
                    tclObject2 = procedure.argList[n2][1];
                } else {
                    throw new TclException(this.interp, "no value given for parameter \"" + tclObject + "\" to \"" + tclObjectArray[0] + "\"");
                }
                Interp interp = this.interp;
                interp.varFrame.setVar(tclObject, tclObject2, 0);
            }
            ++n2;
            ++n3;
        }
    }

    Var[] lookupVar(String string, String string2, int n, String string3, int n2, boolean bl) throws TclException {
        Var var;
        Object[] objectArray;
        Object object;
        int n3;
        int n4 = string.length();
        if (n4 > 0 && string.charAt(n4 - 1) == ')' && (n3 = string.indexOf(40)) != -1) {
            if (string2 != null) {
                throw new TclVarException(this.interp, string, string2, string3, needArray);
            }
            if (n3 < n4 - 2) {
                object = new char[n3];
                objectArray = new char[n4 - 2 - n3];
                string.getChars(0, n3, (char[])object, 0);
                string.getChars(n3 + 1, n4 - 1, (char[])objectArray, 0);
                string = new String((char[])object);
                string2 = new String((char[])objectArray);
            }
        }
        Hashtable hashtable = (n & 1) != 0 ? this.interp.globalFrame.varTable : this.interp.varFrame.varTable;
        if ((n2 & 1) != 0) {
            var = (Var)hashtable.get(string);
            if (var == null) {
                var = new Var();
                var.table = hashtable;
                var.hashKey = string;
                hashtable.put(string, var);
            }
        } else {
            var = (Var)hashtable.get(string);
            if (var == null) {
                if (bl) {
                    throw new TclVarException(this.interp, string, string2, string3, noSuchVar);
                }
                return null;
            }
        }
        if ((var.flags & 2) != 0) {
            var = (Var)var.value;
        }
        if (string2 == null) {
            Var[] varArray = new Var[]{var, null};
            return varArray;
        }
        if ((var.flags & 4) != 0) {
            if ((n2 & 1) == 0) {
                if (bl) {
                    throw new TclVarException(this.interp, string, string2, string3, noSuchVar);
                }
                return null;
            }
            var.flags = 1;
            var.value = new Hashtable();
        } else if ((var.flags & 1) == 0) {
            if (bl) {
                throw new TclVarException(this.interp, string, string2, string3, needArray);
            }
            return null;
        }
        Var var2 = var;
        object = (Hashtable)var2.value;
        if ((n2 & 2) != 0) {
            var = (Var)((Hashtable)object).get(string2);
            if (var == null) {
                var = new Var();
                var.table = object;
                var.hashKey = string2;
                ((Hashtable)object).put(string2, var);
                var.sidVec = null;
            }
        } else {
            var = (Var)((Hashtable)object).get(string2);
            if (var == null) {
                if (bl) {
                    throw new TclVarException(this.interp, string, string2, string3, noSuchElement);
                }
                return null;
            }
        }
        objectArray = new Var[2];
        objectArray[0] = (char)var;
        objectArray[1] = (char)var2;
        return objectArray;
    }

    TclObject setVar(TclObject tclObject, TclObject tclObject2, int n) throws TclException {
        return this.setVar(tclObject.toString(), null, tclObject2, n);
    }

    TclObject setVar(String string, TclObject tclObject, int n) throws TclException {
        return this.setVar(string, null, tclObject, n);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    TclObject setVar(String string, String string2, TclObject tclObject, int n) throws TclException {
        TclObject tclObject2;
        Var[] varArray = this.lookupVar(string, string2, n, "set", 3, true);
        Var var = varArray[0];
        Var var2 = varArray[1];
        if (var.table == null) {
            throw new TclVarException(this.interp, string, string2, "set", danglingUpvar);
        }
        if ((var.flags & 1) != 0) {
            throw new TclVarException(this.interp, string, string2, "set", isArray);
        }
        boolean bl = var.traces != null || var2 != null && var2.traces != null;
        try {
            String string3;
            void var12_16;
            String string4;
            if ((n & 4) != 0 && bl && (string4 = this.callTraces(var2, var, string, string2, n & 1 | 0x10)) != null) {
                throw new TclVarException(this.interp, string, string2, "read", string4);
            }
            TclObject tclObject3 = (TclObject)var.value;
            if (tclObject3 == null) {
                if ((n & 8) == 0) {
                    TclObject tclObject4 = tclObject;
                    tclObject4.preserve();
                } else {
                    TclObject tclObject5 = TclList.newInstance();
                    tclObject5.preserve();
                    TclList.append(this.interp, tclObject5, tclObject);
                }
            } else if ((n & 4) == 0) {
                if (tclObject3 != tclObject) {
                    tclObject3.release();
                    TclObject tclObject6 = tclObject;
                    tclObject6.preserve();
                }
            } else if ((n & 8) == 0) {
                TclObject tclObject7 = tclObject3.takeExclusive();
                TclString.append((TclObject)tclObject7, (TclObject)tclObject);
            } else {
                TclObject tclObject8 = tclObject3.takeExclusive();
                TclList.append(this.interp, tclObject8, tclObject);
            }
            if (var2 != null && (var.flags & 4) != 0) {
                var2.sidVec = null;
            }
            var.value = var12_16;
            var.flags &= 0xFFFFFFFB;
            if (bl && (string3 = this.callTraces(var2, var, string, string2, n & 1 | 0x20)) != null) {
                throw new TclVarException(this.interp, string, string2, "set", string3);
            }
            if ((var.flags & 7) == 0) {
                TclObject tclObject9 = (TclObject)var.value;
                Object var11_20 = null;
                if ((var.flags & 4) == 0) return tclObject9;
                this.cleanupVar(var, var2);
                return tclObject9;
            }
            tclObject2 = TclString.newInstance((String)"");
        }
        catch (Throwable throwable) {
            Object var11_22 = null;
            if ((var.flags & 4) == 0) throw throwable;
            this.cleanupVar(var, var2);
            throw throwable;
        }
        Object var11_21 = null;
        if ((var.flags & 4) == 0) return tclObject2;
        this.cleanupVar(var, var2);
        return tclObject2;
    }

    TclObject getVar(TclObject tclObject, int n) throws TclException {
        return this.getVar(tclObject.toString(), null, n);
    }

    TclObject getVar(String string, int n) throws TclException {
        return this.getVar(string, null, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    TclObject getVar(String string, String string2, int n) throws TclException {
        TclObject tclObject;
        Var var;
        Var var2;
        block10: {
            TclObject tclObject2;
            block9: {
                boolean bl = (n & 0x800) == 0;
                Var[] varArray = this.lookupVar(string, string2, n, "read", 2, bl);
                if (varArray == null) {
                    return null;
                }
                var2 = varArray[0];
                var = varArray[1];
                try {
                    String string3;
                    if ((var2.traces != null || var != null && var.traces != null) && (string3 = this.callTraces(var, var2, string, string2, n & 1 | 0x10)) != null) {
                        if (bl) {
                            throw new TclVarException(this.interp, string, string2, "read", string3);
                        }
                        TclObject tclObject3 = null;
                        Object var10_12 = null;
                        if ((var2.flags & 4) == 0) return tclObject3;
                        this.cleanupVar(var2, var);
                        return tclObject3;
                    }
                    if ((var2.flags & 7) == 0) {
                        tclObject2 = (TclObject)var2.value;
                        break block9;
                    }
                    if (bl) {
                        if ((var2.flags & 4) != 0 && var != null && (var.flags & 4) == 0) {
                            string3 = noSuchElement;
                            throw new TclVarException(this.interp, string, string2, "read", string3);
                        }
                        if ((var2.flags & 1) != 0) {
                            string3 = isArray;
                            throw new TclVarException(this.interp, string, string2, "read", string3);
                        }
                        string3 = noSuchVar;
                        throw new TclVarException(this.interp, string, string2, "read", string3);
                    }
                    tclObject = null;
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    if ((var2.flags & 4) == 0) throw throwable;
                    this.cleanupVar(var2, var);
                    throw throwable;
                }
            }
            Object var10_13 = null;
            if ((var2.flags & 4) == 0) return tclObject2;
            this.cleanupVar(var2, var);
            return tclObject2;
        }
        Object var10_14 = null;
        if ((var2.flags & 4) == 0) return tclObject;
        this.cleanupVar(var2, var);
        return tclObject;
    }

    void unsetVar(TclObject tclObject, int n) throws TclException {
        this.unsetVar(tclObject.toString(), null, n);
    }

    void unsetVar(String string, int n) throws TclException {
        this.unsetVar(string, null, n);
    }

    void unsetVar(String string, String string2, int n) throws TclException {
        boolean bl;
        Var[] varArray = this.lookupVar(string, string2, n, "unset", 0, true);
        Var var = varArray[0];
        Var var2 = varArray[1];
        boolean bl2 = bl = (var.flags & 4) != 0;
        if (var2 != null) {
            var2.sidVec = null;
        }
        if (var.value != null && var.value instanceof TclObject) {
            ((TclObject)var.value).release();
            var.value = null;
        }
        Var var3 = new Var();
        var3.value = var.value;
        var3.traces = var.traces;
        var3.flags = var.flags;
        var3.hashKey = var.hashKey;
        var3.table = var.table;
        var3.refCount = var.refCount;
        var.flags = 4;
        var.traces = null;
        var.value = null;
        var.sidVec = null;
        if (var3.traces != null || var2 != null && var2.traces != null) {
            ++var.refCount;
            var3.flags &= 0xFFFFFFEF;
            this.callTraces(var2, var3, string, string2, n & 1 | 0x40);
            var3.traces = null;
            --var.refCount;
        }
        if ((var3.flags & 1) != 0) {
            this.deleteArray(string, var3, n & 1 | 0x40);
        }
        this.cleanupVar(var, var2);
        if (bl) {
            throw new TclVarException(this.interp, string, string2, "unset", var2 == null ? noSuchVar : noSuchElement);
        }
    }

    void traceVar(TclObject tclObject, VarTrace varTrace, int n) throws TclException {
        this.traceVar(tclObject.toString(), null, varTrace, n);
    }

    void traceVar(String string, VarTrace varTrace, int n) throws TclException {
        this.traceVar(string, null, varTrace, n);
    }

    void traceVar(String string, String string2, VarTrace varTrace, int n) throws TclException {
        Var[] varArray = this.lookupVar(string, string2, n, "trace", 3, true);
        Var var = varArray[0];
        Var var2 = varArray[1];
        if (var.traces == null) {
            var.traces = new Vector();
        }
        TraceRecord traceRecord = new TraceRecord();
        traceRecord.flags = n;
        traceRecord.trace = varTrace;
        var.traces.insertElementAt(traceRecord, 0);
        if (var2 != null && (var.flags & 4) != 0) {
            var2.sidVec = null;
        }
    }

    void untraceVar(TclObject tclObject, VarTrace varTrace, int n) {
        this.untraceVar(tclObject.toString(), null, varTrace, n);
    }

    void untraceVar(String string, VarTrace varTrace, int n) {
        this.untraceVar(string, null, varTrace, n);
    }

    void untraceVar(String string, String string2, VarTrace varTrace, int n) {
        Var[] varArray;
        try {
            varArray = this.lookupVar(string, string2, n, "trace", 3, false);
            if (varArray == null) {
                return;
            }
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
        Var var = varArray[0];
        if (var.traces != null) {
            int n2 = var.traces.size();
            int n3 = 0;
            while (n3 < n2) {
                TraceRecord traceRecord = (TraceRecord)var.traces.elementAt(n3);
                if (traceRecord.trace == varTrace) {
                    var.traces.removeElementAt(n3);
                    return;
                }
                ++n3;
            }
        }
    }

    protected Vector getTraces(TclObject tclObject, int n) throws TclException {
        return this.getTraces(tclObject.toString(), null, n);
    }

    protected Vector getTraces(String string, int n) throws TclException {
        return this.getTraces(string, null, n);
    }

    protected Vector getTraces(String string, String string2, int n) throws TclException {
        Var[] varArray = this.lookupVar(string, string2, n &= 1, "lookup", 0, false);
        if (varArray == null) {
            return null;
        }
        Var var = varArray[0];
        return var.traces;
    }

    protected void makeUpVar(CallFrame callFrame, TclObject tclObject, String string, int n) throws TclException {
        this.makeUpVar(callFrame, tclObject.toString(), null, string, n);
    }

    protected void makeUpVar(CallFrame callFrame, String string, String string2, int n) throws TclException {
        this.makeUpVar(callFrame, string, null, string2, n);
    }

    protected void makeUpVar(CallFrame callFrame, String string, String string2, String string3, int n) throws TclException {
        CallFrame callFrame2 = this.interp.varFrame;
        this.interp.varFrame = callFrame;
        Var[] varArray = this.lookupVar(string, string2, n, "access", 3, true);
        this.interp.varFrame = callFrame2;
        Var var = varArray[0];
        Hashtable hashtable = (n & 1) != 0 ? this.interp.globalFrame.varTable : this.interp.varFrame.varTable;
        Var var2 = (Var)hashtable.get(string3);
        if (var2 == null) {
            var2 = new Var();
            var2.table = hashtable;
            var2.hashKey = string3;
            hashtable.put(string3, var2);
        } else {
            if (var2 == var) {
                throw new TclException(this.interp, "can't upvar from variable to itself");
            }
            if ((var2.flags & 2) != 0) {
                Var var3 = (Var)var2.value;
                if (var3 == var) {
                    return;
                }
                --var3.refCount;
                if ((var3.flags & 4) != 0) {
                    this.cleanupVar(var3, null);
                }
            } else {
                if ((var2.flags & 4) == 0) {
                    throw new TclException(this.interp, "variable \"" + string3 + "\" already exists");
                }
                if (var2.traces != null) {
                    throw new TclException(this.interp, "variable \"" + string3 + "\" has traces: can't use for upvar");
                }
            }
        }
        var2.flags = var2.flags & 0xFFFFFFFB | 2;
        var2.value = var;
        ++var.refCount;
    }

    boolean exists(String string) {
        try {
            Var[] varArray = this.lookupVar(string, null, 0, "lookup", 0, false);
            if (varArray == null) {
                return false;
            }
            return (varArray[0].flags & 4) == 0;
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
    }

    Vector getVarNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.varTable.elements();
        while (enumeration.hasMoreElements()) {
            Var var = (Var)enumeration.nextElement();
            if ((var.flags & 4) != 0) continue;
            vector.addElement(var.hashKey);
        }
        return vector;
    }

    Vector getLocalVarNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.varTable.elements();
        while (enumeration.hasMoreElements()) {
            Var var = (Var)enumeration.nextElement();
            if ((var.flags & 6) != 0) continue;
            vector.addElement(var.hashKey);
        }
        return vector;
    }

    CallFrame getFrame(String string) throws TclException {
        int n;
        Object object;
        int n2 = -1;
        if (string.length() > 0 && string.charAt(0) == '#') {
            object = string.substring(1, string.length());
            n = Util.getInt(this.interp, (String)object);
            if (n < 0) {
                throw new TclException(this.interp, "bad level \"" + string + "\"");
            }
            n2 = this.m_level - n;
        } else {
            try {
                n2 = Util.getInt(this.interp, string);
            }
            catch (TclException tclException) {
                if (this.interp.varFrame == this.interp.globalFrame) {
                    throw new TclException(this.interp, "bad level \"" + string + "\"");
                }
                return null;
            }
        }
        if (n2 < 0) {
            throw new TclException(this.interp, "bad level \"" + string + "\"");
        }
        object = this.interp.varFrame;
        n = 0;
        while (n < n2) {
            if (object == this.interp.globalFrame) {
                throw new TclException(this.interp, "bad level \"" + string + "\"");
            }
            object = ((CallFrame)object).callerVar;
            ++n;
        }
        return object;
    }

    protected String callTraces(Var var, Var var2, String string, String string2, int n) {
        Object object;
        int n2;
        int n3;
        if ((var2.flags & 0x10) != 0) {
            return null;
        }
        var2.flags |= 0x10;
        ++var2.refCount;
        if (string2 == null && (n3 = string.length()) > 0 && string.charAt(n3 - 1) == ')') {
            n2 = 0;
            while (n2 < n3 - 1) {
                if (string.charAt(n2) == '(') break;
                ++n2;
            }
            if (n2 < n3 - 1 && n2 < n3 - 2) {
                object = new char[n2];
                char[] cArray = new char[n3 - 2 - n2];
                string.getChars(0, n2, (char[])object, 0);
                string.getChars(n2 + 1, n3 - 1, cArray, 0);
                string = new String((char[])object);
                string2 = new String(cArray);
            }
        }
        TclObject tclObject = this.interp.getResult();
        tclObject.preserve();
        this.interp.resetResult();
        try {
            TraceRecord traceRecord;
            if (var != null) {
                ++var.refCount;
            }
            if (var != null && var.traces != null) {
                n2 = 0;
                while (var.traces != null && n2 < var.traces.size()) {
                    block21: {
                        traceRecord = (TraceRecord)var.traces.elementAt(n2);
                        if ((traceRecord.flags & n) != 0) {
                            try {
                                traceRecord.trace.traceProc(this.interp, string, string2, n);
                            }
                            catch (TclException tclException) {
                                if ((n & 0x40) != 0) break block21;
                                object = this.interp.getResult().toString();
                                Object var10_13 = null;
                                if (var != null) {
                                    --var.refCount;
                                }
                                var2.flags &= 0xFFFFFFEF;
                                --var2.refCount;
                                this.interp.setResult(tclObject);
                                tclObject.release();
                                return object;
                            }
                        }
                    }
                    ++n2;
                }
            }
            if ((n & 0x40) != 0) {
                n |= 0x80;
            }
            n2 = 0;
            while (var2.traces != null && n2 < var2.traces.size()) {
                block22: {
                    traceRecord = (TraceRecord)var2.traces.elementAt(n2);
                    if ((traceRecord.flags & n) != 0) {
                        try {
                            traceRecord.trace.traceProc(this.interp, string, string2, n);
                        }
                        catch (TclException tclException) {
                            if ((n & 0x40) != 0) break block22;
                            object = this.interp.getResult().toString();
                            Object var10_14 = null;
                            if (var != null) {
                                --var.refCount;
                            }
                            var2.flags &= 0xFFFFFFEF;
                            --var2.refCount;
                            this.interp.setResult(tclObject);
                            tclObject.release();
                            return object;
                        }
                    }
                }
                ++n2;
            }
            object = null;
            Object var10_15 = null;
            if (var != null) {
                --var.refCount;
            }
            var2.flags &= 0xFFFFFFEF;
            --var2.refCount;
            this.interp.setResult(tclObject);
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            if (var != null) {
                --var.refCount;
            }
            var2.flags &= 0xFFFFFFEF;
            --var2.refCount;
            this.interp.setResult(tclObject);
            tclObject.release();
            throw throwable;
        }
        tclObject.release();
        return object;
    }

    protected void dispose() {
        this.interp.frame = this.caller;
        this.interp.varFrame = this.callerVar;
        this.caller = null;
        this.callerVar = null;
        int n = 64;
        if (this == this.interp.globalFrame) {
            n |= 0x101;
        }
        Enumeration enumeration = this.varTable.elements();
        while (enumeration.hasMoreElements()) {
            Var var = (Var)enumeration.nextElement();
            if ((var.flags & 2) != 0) {
                Var var2 = (Var)var.value;
                --var2.refCount;
                if (var2.refCount == 0 && (var2.flags & 4) != 0 && var2.traces == null && var2.table != null && var2.table != this.varTable) {
                    var2.table.remove(var2.hashKey);
                    var2.table = null;
                }
            }
            if (var.traces != null) {
                this.callTraces(null, var, var.hashKey, null, n);
            }
            if ((var.flags & 1) != 0) {
                this.deleteArray(var.hashKey, var, n);
            } else if (var.value != null && var.value instanceof TclObject) {
                ((TclObject)var.value).release();
            }
            var.value = null;
            var.traces = null;
            var.flags = 4;
            var.table = null;
            var.hashKey = null;
        }
        this.varTable = null;
    }

    protected void deleteArray(String string, Var var, int n) {
        var.sidVec = null;
        Hashtable hashtable = (Hashtable)var.value;
        Var var2 = null;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Var var3 = (Var)enumeration.nextElement();
            TclObject tclObject = (TclObject)var3.value;
            if (tclObject != null) {
                tclObject.release();
            }
            var3.table = null;
            if (var3.traces != null) {
                if (var2 == null) {
                    var2 = new Var();
                }
                var2.traces = var3.traces;
                var2.flags = var3.flags;
                var2.flags &= 0xFFFFFFEF;
                var3.traces = null;
                ++var3.refCount;
                this.callTraces(null, var2, string, var3.hashKey, n);
                --var3.refCount;
            }
            var3.flags = 4;
        }
        var.value = null;
    }

    protected void cleanupVar(Var var, Var var2) {
        if ((var.flags & 4) != 0 && var.refCount == 0 && var.traces == null && var.table != null) {
            var.table.remove(var.hashKey);
            var.table = null;
        }
        if (var2 != null && (var2.flags & 4) != 0 && var2.refCount == 0 && var2.traces == null && var2.table != null) {
            var2.table.remove(var2.hashKey);
            var2.table = null;
        }
    }
}

