'\" 
'\" Copyright (c) 2000 Andreas Kupries
'\" Copyright (c) 2000 Zveno Pty Ltd
'\" 
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" SCCS: @(#) uri.n
'\" 
.so man.macros
.TH "uri" n 8.2 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
uri \- URI utilities
.SH "SYNOPSIS"
\fB uri::split      \fIurl\fR
\fB uri::join       \fR?\fIkey\fR \fIvalue\fR?...
\fB uri::resolve    \fIbase\fR \fIurl\fR
\fB uri::isrelative \fIurl\fR
\fB uri::geturl     \fIurl\fR ?\fIoptions\fR...?
\fB uri::canonicalize \fIuri\fR
.BE
.SH "DESCRIPTION"
.PP
This package contains two parts. First it provides regular expressions
for a number of url/uri schemes. Second it provides a number of
commands for manipulating urls/uris and fetching data specified by
them. For the latter this package analyses the requested url/uri and
then dispatches it to the appropriate package (http, ftp, ...) for
actual fetching.
.SH "COMMANDS"
\fBuri::split\fR takes a single \fIurl\fR, decodes it and then returns
a list of key/value pairs suitable for \fBarray set\fR containing
the constituents of the \fIurl\fR. If the scheme is missing from the
url it defaults to \fBhttp\fR. Currently only the schemes
\fBhttp\fR, \fBftp\fR, \fBmailto\fR and \fBfile\fR are
supported. See section EXTENDING on how to expand that range.
.PP
\fBuri::join\fR takes a list of key/value pairs (generated by
\fBuri::split\fR, for example) and returns the canonical url they
represent. Currently only the schemes \fBhttp\fR, \fBftp\fR,
\fBmailto\fR and \fBfile\fR are supported. See section EXTENDING
on how to expand that range.
.PP
\fBuri::isrelative\fR determines whether the specified \fIurl\fR is
absolute or relative.
.PP
\fBuri::resolve\fR resolves the specified \fIurl\fR relative to
\fIbase\fR. In other words: A non-relative \fIurl\fR is returned
unchanged, whereas for a relative \fIurl\fR the missing parts are
taken from \fIbase\fR and prepended to it. The result of this
operation is returned. For an empty \fIurl\fR the result is
\fIbase\fR.
.PP
\fBuri::geturl\fR decodes the specified \fIurl\fR and then dispatches
the request to the package appropriate for the scheme found in the
url. The command assumes that the package to handle the given scheme
has the same name as the scheme itself (including possible
capitalization). It further assumes that the package provides a
\fBgeturl\fR-command in the namespace of the same name as the package
itself. This command is called with the given \fIurl\fR and all given
\fIoptions\fR. Currently \fBgeturl\fR does not handle any options
itself.
.PP
\fBNote:\fR \fBfile\fR-urls are an exception to the rule described
above. They are handled internally.
.PP
It is not possible to specify results of the command. They depend on
the \fBgeturl\fR-command for the scheme the request was dispatched to.
.PP
\fBuri::canonicalize\fR returns the canonical form of a URI.
The canonical form of a URI is one where relative path specifications,
ie. . and .., have been resolved.
.SH "SCHEMES"
In addition to the commands mentioned above this package provides
regular expression to recognize urls for a number of url schemes.
.PP
For each supported scheme a namespace of the same name as the scheme
itself is provided inside of the namespace \fBuri\fR containing the
variable \fBurl\fR whose contents are a regular expression to
recognize urls of that scheme. Additional variables may contain
regular expressions for parts of urls for that scheme.
.PP
The variable boldt uri::schemes] contains a list of all supported
schemes. Currently these are \fBftp\fR, \fBfile\fR, \fBhttp\fR,
\fBgopher\fR, \fBmailto\fR, \fBnews\fR, \fBwais\fR and
\fBprospero\fR.
.SH "EXTENDING"
Extending the range of schemes supported by \fBuri::split\fR and
\fBuri::join\fR is easy because both commands do not handle the
request by themselves but dispatch it to another command in the
\fBuri\fR namespace using the scheme of the url as criterion.
.PP
\fBuri:split\fR and \fBuri:join\fR call Split[string totitle <scheme>]
and Join[string totitle <scheme>] respectively.
.SH "SEE ALSO"
.SH "CREDITS"
Original code by Andreas Kupries.  Modularisation by Steve Ball.
.PP
.SH "KEYWORDS"
uri, url, fetching information, www, http, ftp, mailto, gopher, wais, prospero, file
