/* supertcl.c */
#include <stdio.h>
#include <tk.h>
#include <tclExtend.h>

extern char *exp_argv0;		/* For expect */

int Tcl_AppInit(Tcl_Interp *interp);

/* 
 * Our clock widget.
 */
int ClockCmd(ClientData clientData,
				Tcl_Interp *interp,
				int argc, char *argv[]);
/*
 * Our pixmap image type.
 */
extern Tk_ImageType tkPixmapImageType;

main(int argc, char *argv[]) {
	/*
	 * Save arguments for expect and its debugger.
	 */
	exp_argv0 = argv[0];	/* Needed by expect */
	Dbg_ArgcArgv(argc, argv, 1);
	/*
	 * Create the main window. This calls
	 * back into Tcl_AppInit.
	 */
	Tk_Main(argc, argv, Tcl_AppInit);
	exit(0);
}

int
Tcl_AppInit(Tcl_Interp *interp) {
	char *value;
	Tk_Window main = Tk_MainWindow(interp);
	/*
	 * Initialize extensions
	*/
	if (TclX_Init(interp) == TCL_ERROR) {
		/* TclX_Init is called instead of Tcl_Init */
		return TCL_ERROR;
	}
	if (Tk_Init(interp) == TCL_ERROR) {
		return TCL_ERROR;
	}
	if (Tdp_Init(interp) == TCL_ERROR) {	/* Tcl-DP */
		return TCL_ERROR;
	}
	if (Blt_Init(interp) == TCL_ERROR) {	/* BLT */
		return TCL_ERROR;
	}
	if (Exp_Init(interp) == TCL_ERROR) {	/* Expect */
		return TCL_ERROR;
	}
	/*
	 * Our own extra commands.
	 */
	Tcl_CreateCommand(interp, "clock", ClockCmd,
		(ClientData)Tk_MainWindow(interp), (Tcl_CmdDeleteProc *)NULL);

	Tk_CreateImageType(&tkPixmapImageType);
	/* 
	 * This information is returned by the infox command.
	 */
	tclAppName = "SuperTcl";
	tclAppLongname = "Tcl-Tk-TclX-DP-BLT-Expect-[incr tcl]";
	tclAppVersion = "1.0";
	/*
	 * This affects X resource names.
	 */
	Tk_SetClass(main, "SuperTcl");
	/*
	* If we are going to be interactive,
	* Setup SIGINT handling.
	*/
	value = Tcl_GetVar (interp, "tcl_interactive",
		 TCL_GLOBAL_ONLY);
	if ((value != NULL) && (value [0] != '0'))
		Tcl_SetupSigInt ();

	return TCL_OK;
}
#undef Tcl_DStringTrunc
void
Tcl_DStringTrunc(Tcl_DString *dsPtr, int len) {
    Tcl_DStringSetLength(dsPtr, len);
}
