'\" Copyright 1989 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /sprite/src/lib/tcl/RCS/Tcl_SplitList.man,v 1.2 89/03/24 14:16:23 ouster Exp $ SPRITE (Berkeley)
'\" 
.so \*(]ltmac.sprite
.HS Tcl_SplitList tcl
.BS
.SH NAME
Tcl_SplitList \- break a Tcl list up into fields
.SH SYNOPSIS
.nf
\fB#include <tcl.h>\fR
.sp
int
\fBTcl_SplitList\fR(\fIinterp, list, argcPtr, argvPtr\fR)
.AS Tcl_Interp *argvPtr
.SH ARGUMENTS
.AP Tcl_Interp *interp out
Interpreter to use for error reporting.
.AP char *list in
Pointer to a string with proper list structure.
.AP int *argcPtr out
Filled in with number of elements in \fIlist\fR.
.AP char ***argvPtr out
\fI*argvPtr\fR will be filled in with the address of an array of
pointers to the strings that are the extracted elements of \fIlist\fR.
There will be \fI*argcPtr\fR valid entries in the array.
.BE

.SH DESCRIPTION
.PP
\fBTcl_SplitList\fR is the inverse of \fBTcl_Merge\fR.  Given a list, it extracts
all of the elements of the list and returns an array of pointers to
them using \fIargcPtr\fR and \fIargvPtr\fR.  While extracting the
arguments, \fBTcl_SplitList\fR obeys the usual
rules for backslash substitutions and braces.  The area of
memory pointed to by \fI*argvPtr\fR is dynamically allocated;  in
addition to the array of pointers, it
also holds copies of all the list elements.  It is the caller's
responsibility to free up all of this storage by calling
.DS
free((char *) \fI*argvPtr\fR)
.DE
when the list elements are no longer needed.
.PP
\fBTcl_SplitList\fR normally returns \fBTCL_OK\fR, which means the list was
successfully parsed.
If there was a syntax error in \fIlist\fR, then \fBTCL_ERROR\fR is returned
and \fIinterp->result\fR will point to an error message describing the problem.

.SH KEYWORDS
list, split, strings
