#include <tkgs.h>
#include <tkgsInt.h>

#include "tkgsCanvas.h"

#include <string.h>

/*
 * Prototypes for procedures defined later in this file:
 */

/* Driver */

static TkGS_GetDrawableProc		CanvasTkGS_GetDrawable;
static TkGSUpdateDrawableStateProc	CanvasTkGSUpdateDrawableState;

static TkGS_DrawRectangleProc		CanvasTkGS_DrawRectangle;
static TkGS_DrawRectanglesProc		CanvasTkGS_DrawRectangles;
static TkGS_FillRectangleProc		CanvasTkGS_FillRectangle;
static TkGS_FillRectanglesProc		CanvasTkGS_FillRectangles;
static TkGS_DrawEllipseProc		CanvasTkGS_DrawEllipse;
static TkGS_DrawEllipsesProc		CanvasTkGS_DrawEllipses;

static TkGS_DrawCharsUtfProc		CanvasTkGS_DrawCharsUtf;

static TkGS_EnumerateFontFamiliesProc	CanvasTkGS_EnumerateFontFamilies;


/* CanvasDrawable */

static void		FreeCanvasDrawableIntRep _ANSI_ARGS_((TkGS_InternalRep *intRepPtr));


/*
 * Driver
 */

TkGS_DeviceDriver CanvasDeviceDriver = {
    "Canvas",

    CanvasTkGS_GetDrawable,

    CanvasTkGSUpdateDrawableState,

    /* Line & shape primitives */
    CanvasTkGS_DrawRectangle,
    CanvasTkGS_DrawRectangles,
    CanvasTkGS_FillRectangle,
    CanvasTkGS_FillRectangles,
    CanvasTkGS_DrawEllipse,
    CanvasTkGS_DrawEllipses,

    /* Fonts and text primitives: */
    NULL,
    NULL,
    CanvasTkGS_EnumerateFontFamilies,
    NULL,

    /*  - Unicode */
    NULL,
    NULL,
    NULL,
    NULL,

    /*  - UTF-8 */
    NULL,
    NULL,
    CanvasTkGS_DrawCharsUtf,
    NULL,

    /*  - System-specific */
    NULL,
    NULL,
    NULL,
    NULL,

    /*  - Multi-font Unicode system */
    0,					/* Native Unicode */
    0,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL
};



/*
 * CanvasDrawable
 */

TkGS_ObjType CanvasDrawableType = {
    "CanvasDrawable",
    NULL,				/* Base type, initialized at runtime */

    FreeCanvasDrawableIntRep,		/* freeIntRepProc */
    NULL				/* setFromAnyProc */
					/* NULL means immutable */
};

/* Accessors */
#define CanvasDrawable_AppendResultProc(intRepPtr) \
    ((CanvasDrawableAppendResultProc*) intRepPtr->value.twoValue.value1.otherValuePtr)
#define CanvasDrawable_ClientData(intRepPtr) \
    ((ClientData) intRepPtr->value.twoValue.value2.longValue)

#define CanvasDrawable_Append(intRepPtr,string,length) \
    (CanvasDrawable_AppendResultProc(intRepPtr))( \
	CanvasDrawable_ClientData(intRepPtr), (string), (length))

/*
    *CanvasDrawable_StringPtr((intRepPtr)) = (char *) Tcl_Realloc(*CanvasDrawable_StringPtr((intRepPtr)), \
					CanvasDrawable_Length((intRepPtr))+(length)+1); \
    memcpy(*CanvasDrawable_StringPtr((intRepPtr))+CanvasDrawable_Length((intRepPtr)), \
	(string), (length)+1); \
    CanvasDrawable_Length((intRepPtr)) += (length);
*/

/* Object type procs */

static void
FreeCanvasDrawableIntRep(intRepPtr)
    TkGS_InternalRep *intRepPtr;
{
    /* Nothing to do */
}

int
CanvasTkGSUpdateDrawableState(d, valueMask)
    TkGS_Drawable d;
    unsigned long valueMask;
{
    /* 
     * Nothing to do, the Canvas driver only uses the public structures 
     * and holds no state 
     */

    return TKGS_OK;
}




/*
 * Drawable-related driver procs
 */

TkGS_Drawable
CanvasTkGS_GetDrawable(clientData)
    ClientData clientData;
{
    CanvasDrawableCreateData *cd = (CanvasDrawableCreateData *) clientData;
    TkGS_Drawable d = TkGSNewDrawable(&CanvasDeviceDriver);
    TkGS_InternalRep intRep;
    register TkGS_InternalRep *intRepPtr = &intRep;

    /* 
     * Initialize internal rep
     */

    CanvasDrawable_AppendResultProc(intRepPtr) = cd->appendResultProc;
    CanvasDrawable_ClientData(intRepPtr) = cd->clientData;

    intRepPtr->typePtr = &CanvasDrawableType;

    /*
     * Add internal rep to object
     */

    TkGS_PushInternalRep((TkGS_Obj *) d, intRepPtr);

    return d;
}


/*
 * Drawing primitives
 */

#define DECLAREDRAWINGVARS(d, intRepPtr, gcValues) \
    register TkGS_GCValues *gcValues = &TkGSDrawable_GCValues(d); \
    register TkGS_InternalRep *intRepPtr = TkGS_FindInternalRep((TkGS_Obj *) (d), &CanvasDrawableType);


void
CanvasTkGS_DrawRectangle(d, filled, x, y, width, height)
    TkGS_Drawable	d;
    int			filled;
    int			x;
    int			y;
    unsigned int	width;
    unsigned int	height;
{
    DECLAREDRAWINGVARS(d, intRepPtr, gcValues)
    char buf[256];
    int length;
    unsigned short r, g, b;

    TkGS_GetRGBColorValues(gcValues->foreground, &r, &g, &b);

    if (filled) {
	sprintf(buf, 
	    "$canvas create rectangle %d %d %d %d"
	    " -fill #%04x%04x%04x"
	    " -outline \"\""
	    "\n",
	    x, y, x+width, y+height,
	    r, g, b);
    } else {
	sprintf(buf, 
	    "$canvas create rectangle %d %d %d %d"
	    " -outline #%04x%04x%04x"
	    " -width %d"
	    " -fill \"\""
	    "\n",
	    x, y, x+width, y+height,
	    r, g, b,
	    gcValues->lineWidth);
    }
    length = strlen(buf);

    /* Append canvas command to the existing string */
    CanvasDrawable_Append(intRepPtr,buf,length);
}

void
CanvasTkGS_DrawRectangles(d, filled, rectangles, nbRectangles) 
    TkGS_Drawable	d;
    int			filled;
    TkGS_Rectangle*	rectangles;
    int			nbRectangles;
{
    int i;
    for (i=0; i<nbRectangles; i++) {
	CanvasTkGS_DrawRectangle(d, filled, rectangles[i].x, rectangles[i].y,
				 rectangles[i].width, rectangles[i].height);
    }
}

void
CanvasTkGS_FillRectangle(d, color, x, y, width, height)
    TkGS_Drawable	d;
    TkGS_Color		color;
    int			x;
    int			y;
    unsigned int	width;
    unsigned int	height;
{
    DECLAREDRAWINGVARS(d, intRepPtr, gcValues)
    char buf[256];
    int length;
    unsigned short r, g, b;

    TkGS_GetRGBColorValues(color, &r, &g, &b);

    sprintf(buf, 
	"$canvas create rectangle %d %d %d %d"
	" -fill #%04x%04x%04x"
	" -outline \"\""
	"\n",
	x, y, x+width, y+height,
	r, g, b);
    length = strlen(buf);

    /* Append canvas command to the existing string */
    CanvasDrawable_Append(intRepPtr,buf,length);
}

void
CanvasTkGS_FillRectangles(d, color, rectangles, nbRectangles) 
    TkGS_Drawable	d;
    TkGS_Color		color;
    TkGS_Rectangle*	rectangles;
    int			nbRectangles;
{
    int i;
    for (i=0; i<nbRectangles; i++) {
	CanvasTkGS_FillRectangle(d, color, rectangles[i].x, rectangles[i].y,
				 rectangles[i].width, rectangles[i].height);
    }
}

void
CanvasTkGS_DrawEllipse(d, filled, x, y, width, height)
    TkGS_Drawable	d;
    int			filled;
    int			x;
    int			y;
    unsigned int	width;
    unsigned int	height;
{
    DECLAREDRAWINGVARS(d, intRepPtr, gcValues)
    char buf[256];
    int length;
    unsigned short r, g, b;

    TkGS_GetRGBColorValues(gcValues->foreground, &r, &g, &b);

    if (filled) {
	sprintf(buf, 
	    "$canvas create oval %d %d %d %d"
	    " -fill #%04x%04x%04x"
	    " -outline \"\""
	    "\n",
	    x, y, x+width, y+height,
	    r, g, b);
    } else {
	sprintf(buf, 
	    "$canvas create oval %d %d %d %d"
	    " -outline #%04x%04x%04x"
	    " -width %d"
	    " -fill \"\""
	    "\n",
	    x, y, x+width, y+height,
	    r, g, b,
	    gcValues->lineWidth);
    }
    length = strlen(buf);

    /* Append canvas command to the existing string */
    CanvasDrawable_Append(intRepPtr,buf,length);
}

void
CanvasTkGS_DrawEllipses(d, filled, ellipses, nbEllipses) 
    TkGS_Drawable	d;
    int			filled;
    TkGS_Rectangle*	ellipses;
    int			nbEllipses;
{
    int i;
    for (i=0; i<nbEllipses; i++) {
	CanvasTkGS_DrawEllipse(d, filled, ellipses[i].x, ellipses[i].y,
			       ellipses[i].width, ellipses[i].height);
    }
}


void
CanvasTkGS_DrawCharsUtf(d, string, length, x, y, widthPtr)
    TkGS_Drawable	d;
    CONST char		*string;
    int			length;
    int			x;
    int			y;
    int			*widthPtr;
{
    DECLAREDRAWINGVARS(d, intRepPtr, gcValues)
    char buf[256], font[256];
    int l;
    char *faceName;
    unsigned short r, g, b;
    TkGS_FontAttributes fa;

    TkGS_GetRGBColorValues(gcValues->foreground, &r, &g, &b);

    /* TODO: font managing */
    if (!gcValues->font) {
	sprintf(font, "system");
    } else {
	TkGS_GetFontAttributes(gcValues->font, &fa);
	/* 
	 * TODO: manage multiple font family specifiers. For now only take 
	 * the first.
	 */

	faceName = TkGSFontFaces_Names(fa.faces)[0];

	sprintf(font, 
	    "{%s} %d {%s%s%s%s}",
	    faceName, 
	    fa.size,
	    (fa.weight == TKGS_FW_BOLD ? " bold " : ""),
	    ((  fa.slant  == TKGS_FS_ITALIC 
	     || fa.slant  == TKGS_FS_OBLIQUE) ? " italic " : ""),
	    (fa.underline  ? " underline "  : ""),
	    (fa.overstrike ? " overstrike " : "")
	);
    }

    /* TODO: proper escaping of special chars in font name, ie "\[]$ */
    sprintf(buf, 
	"$canvas create text %d [expr {%d+[font metrics \"%s\" -descent]}]"
	" -anchor sw"
	" -font \"%s\""
	" -fill #%04x%04x%04x",
	x, y,
	font, font,
	r, g, b);
    l = strlen(buf);
    CanvasDrawable_Append(intRepPtr,buf,l);

    /* TODO: proper escaping of special chars, ie "\[]$ */
    strcpy(buf, " -text \"");
    l = strlen(buf);
    CanvasDrawable_Append(intRepPtr,buf,l);

    CanvasDrawable_Append(intRepPtr,(char *) string,length);

    strcpy(buf, "\"\n");
    l = strlen(buf);
    CanvasDrawable_Append(intRepPtr,buf,l);

    if (widthPtr) {
	/* No computed width */
	*widthPtr = 0;
    }
}



void
CanvasTkGS_EnumerateFontFamilies(d, name, enumProc, clientData)
    TkGS_Drawable		d;
    CONST char			*name;
    TkGS_FontFamiliesEnumProc	*enumProc;
    ClientData			clientData;
{
    /* TODO */
}




/*
 * Initialization code
 */

static void
CanvasTkGSInit()
{
    CanvasDrawableType.baseTypePtr = TkGS_GetDrawableBaseType();

    TkGS_RegisterDeviceDriver(&CanvasDeviceDriver);
}

void
CanvasTkGS_StaticPackage(interp)
    Tcl_Interp *interp;
{  
    Tcl_StaticPackage(interp, "Canvastkgs", Canvastkgs_Init, Canvastkgs_SafeInit);
}


/*
 *----------------------------------------------------------------------
 *
 * Canvastkgs_Init --
 *
 *	This function is used to initialize the package. Here we check
 *	dependencies with other packages (eg Tcl), create new commands,
 *	and register our packages
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	New commands created, and package registered (see documentation).
 *
 *----------------------------------------------------------------------
 */

int Canvastkgs_Init(interp)
    Tcl_Interp *interp;
{  
#ifdef USE_TCL_STUBS
    if (Tcl_InitStubs(interp, "8.3", 0) == NULL) {
	return TCL_ERROR;
    }
#endif

#ifdef USE_TK_STUBS
    if (Tk_InitStubs(interp, "8.3", 0) == NULL) {
	return TCL_ERROR;
    }
#endif

    /* Dependencies */
    if (Tcl_PkgRequire(interp, "TkGS", "1.0", 0) == NULL)
	return TCL_ERROR;

    /* Package provided */
    if (Tcl_PkgProvide(interp, "CanvasTkGS", "1.0") == TCL_ERROR)
	return TCL_ERROR;

    CanvasTkGSInit();

    return TCL_OK;
}


/*
 *----------------------------------------------------------------------
 *
 * Canvastkgs_SafeInit --
 *
 *	This function is used to initialize the package in the special case
 *	of safe interpreters (like the Tcl Plugin). Here we check
 *	dependencies with other packages (eg Tcl), create new commands,
 *	and register our packages
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	New commands created, and package registered (see documentation).
 *
 *----------------------------------------------------------------------
 */

int Canvastkgs_SafeInit(interp)
    Tcl_Interp *interp;
{  
    /* For now, do the same as with unsafe interpreters */
    return Canvastkgs_Init(interp);
}
