#!/bin/sh
# The next line is executed by /bin/sh, but not tcl \
  exec wish8.4 "$0" ${1+"$@"}
 
## Check Tk version:
package require Tk 8.3

if {$::tcl_version == "8.3" && ![package vsatisfies $::tcl_patchLevel 8.3.3]} {
    tk_messageBox -type ok -icon error \
	    -message "  =====> TkDND requires at least tk8.3.3! <====="
    exit 1
}

## Load tkdnd package...
set DIR [file dirname [file normalize [info script]]]
## Make sure that we can find the tkdnd package even if the user has not yet
## installed the package.
lappend auto_path [file dirname $DIR] [file dirname $DIR]/lib
package require tkdnd
after idle "init"


#------------------------------------------------------------------------------
#	Step 1: A simple Drag & Drop
#------------------------------------------------------------------------------

# create the source window
label .source -text "source" -relief groove -bd 2 -width 20
pack .source -pady 5
# tells the DND protocol source can deliver textual data
dnd bindsource .source text/plain {return "testing DND"}
# bind the DND operation on left button
bind .source <1> { dnd drag %W }

# defines the target window
label .target1 -text "drop text" -relief raised -bd 1 -width 20
pack .target1 -pady 5
# tells the DND protocol target can handle textual data
dnd bindtarget .target1 text/plain <Drop> {status "\[target1\] type='%T', data='%D', action='%A'"}


#------------------------------------------------------------------------------
#	Step 2: Management of multiple types on the source
#------------------------------------------------------------------------------

# defines an other type on source
dnd bindsource .source TK_COLOR {return "pink"}

# defines a target window
label .target2 -text "drop color" -relief raised -bd 1 -width 20 \
		-bg lightyellow
pack .target2 -pady 5

# tells the DND protocol target can handle color data
dnd bindtarget .target2 TK_COLOR <Drop> {
	status "\[target2\] type='%T', data='%D', action='%A'"
	.target2 configure -bg %D
	after 2000 ".target2 configure -bg lightyellow"
}


#------------------------------------------------------------------------------
#	Step 3: Management of multiples types on target
#------------------------------------------------------------------------------

# defines an other type on source
dnd bindsource .source TK_PATH {return ".source"}

# bind the DND operation on others buttons
bind .source <2> { dnd drag %W }
bind .source <3> { dnd drag %W }

# add bindings with others buttons on target 1
dnd bindtarget .target1 TK_PATH <Button2-Drop> {status "\[target1\] \[Button2\] type='%T', data='%D', action='%A'"}
dnd bindtarget .target1 TK_COLOR <Button3-Drop> {status "\[target1\] \[Button3\] type='%T', data='%D', action='%A'"}
dnd bindtarget .target1 TK_PATH <Shift-Button3-Drop> {status "\[target1\] \[Shift-Button3\] type='%T', data='%D', action='%A'"}

# refine binding on target2 to allow change of Foreground if drop with Shift
dnd bindtarget .target2 TK_COLOR <Shift-Drop> {
	status "\[target2\] \[Shift\] type='%T', data='%D', action='%A'"
	.target2 configure -fg %D
	after 2000 ".target2 configure -fg black"
}



#==============================================================================
#	END
#==============================================================================

proc status {msg} {
	.status configure -text $msg
}

proc help {} {
	toplevel .help
	wm title .help "Help for tutorial"
	text .help.t -font {Helvetica -12}
	bindtags .help.t {.t .help all}
	pack .help.t -fill both -expand true
	.help.t tag configure bigbold -font {Helvetica -16 bold}
	.help.t tag configure bold -font {Helvetica -12 bold}
	.help.t insert end "Source\n" bigbold \
			"\nHandles the following types:\n\n    text/plain = \"testing DND\"\n    TK_COLOR = pink\n    TK_PATH = .source" normal

	.help.t insert end "\n\nDrop text, color or path \[target1\]\n" bigbold \
			"\nAccepts:\n    text/plain (Button1)\n    TK_PATH (Button2 or Shift-Button3)\n    TK_COLOR (Button3)" normal

	.help.t insert end "\n\nDrop color \[target2\]\n" bigbold \
			"\nAccepts:\n    TK_COLOR (Button) = change Background\n    TK_COLOR (Shift-Button) = change Foreground" normal
}

proc init {} {
	wm title . "Tutorial 1: The basics"

	label .status -relief sunken -bd 1 -width 60 -anchor w
	pack .status -side bottom -fill x
	pack [frame .sep -height 10] -side bottom -fill x
	pack propagate .status 0

	help
}
