/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;

class StringCmd
implements Command {
    private static final String[] validCmds = new String[]{"compare", "first", "index", "last", "length", "match", "range", "tolower", "toupper", "trim", "trimleft", "trimright", "wordend", "wordstart"};
    private static final int OPT_COMMAND = 0;
    private static final int OPT_FIRST = 1;
    private static final int OPT_INDEX = 2;
    private static final int OPT_LAST = 3;
    private static final int OPT_LENGTH = 4;
    private static final int OPT_MATCH = 5;
    private static final int OPT_RANGE = 6;
    private static final int OPT_TOLOWER = 7;
    private static final int OPT_TOUPPER = 8;
    private static final int OPT_TRIM = 9;
    private static final int OPT_TRIMLEFT = 10;
    private static final int OPT_TRIMRIGHT = 11;
    private static final int OPT_WORDEND = 12;
    private static final int OPT_WORDSTART = 13;

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "option arg ?arg ...?");
        }
        int n = TclIndex.get((Interp)interp, (TclObject)tclObjectArray[1], (String[])validCmds, (String)"option", (int)0);
        switch (n) {
            case 0: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "compare string1 string2");
                }
                if (tclObjectArray[2] == tclObjectArray[3]) {
                    interp.setResult(TclInteger.newInstance((int)0));
                    return;
                }
                int n2 = tclObjectArray[2].toString().compareTo(tclObjectArray[3].toString());
                if (n2 > 0) {
                    interp.setResult(TclInteger.newInstance((int)1));
                    return;
                }
                if (n2 < 0) {
                    interp.setResult(TclInteger.newInstance((int)-1));
                    return;
                }
                interp.setResult(TclInteger.newInstance((int)0));
                return;
            }
            case 3: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "last string1 string2");
                }
                String string = tclObjectArray[2].toString();
                String string2 = tclObjectArray[3].toString();
                int n3 = string2.lastIndexOf(string);
                interp.setResult(TclInteger.newInstance((int)n3));
                return;
            }
            case 1: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "first string1 string2");
                }
                String string = tclObjectArray[2].toString();
                if (string.length() == 0) {
                    interp.setResult(TclInteger.newInstance((int)-1));
                    return;
                }
                String string3 = tclObjectArray[3].toString();
                int n4 = string3.indexOf(string);
                interp.setResult(TclInteger.newInstance((int)n4));
                return;
            }
            case 2: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "index string charIndex");
                }
                int n5 = TclInteger.get((Interp)interp, (TclObject)tclObjectArray[3]);
                if (n5 < 0 || n5 >= tclObjectArray[2].toString().length()) {
                    interp.resetResult();
                    return;
                }
                char[] cArray = new char[]{tclObjectArray[2].toString().charAt(n5)};
                String string = new String(cArray);
                if (string == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance((String)string));
                return;
            }
            case 4: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "length string");
                }
                int n6 = tclObjectArray[2].toString().length();
                interp.setResult(TclInteger.newInstance((int)n6));
                return;
            }
            case 5: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "match pattern string");
                }
                boolean bl = Util.stringMatch(tclObjectArray[3].toString(), tclObjectArray[2].toString());
                interp.setResult(TclBoolean.newInstance((boolean)bl));
                return;
            }
            case 6: {
                int n7;
                if (tclObjectArray.length != 5) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "range string first last");
                }
                String string = tclObjectArray[2].toString();
                int n8 = string.length();
                int n9 = TclInteger.getForIndex((Interp)interp, (TclObject)tclObjectArray[3], (int)(n8 - 1));
                if (n9 < 0) {
                    n9 = 0;
                }
                if ((n7 = TclInteger.getForIndex((Interp)interp, (TclObject)tclObjectArray[4], (int)(n8 - 1))) >= n8) {
                    n7 = n8 - 1;
                }
                if (n9 > n7) {
                    interp.resetResult();
                    return;
                }
                String string4 = string.substring(n9, n7 + 1);
                if (string4 == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance((String)string4));
                return;
            }
            case 7: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "tolower string");
                }
                String string = tclObjectArray[2].toString().toLowerCase();
                if (string == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance((String)string));
                return;
            }
            case 8: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "toupper string");
                }
                String string = tclObjectArray[2].toString().toUpperCase();
                if (string == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance((String)string));
                return;
            }
            case 9: {
                if (tclObjectArray.length == 3) {
                    String string = tclObjectArray[2].toString().trim();
                    if (string == null) {
                        interp.resetResult();
                        return;
                    }
                    interp.setResult(TclString.newInstance((String)string));
                    return;
                }
                if (tclObjectArray.length == 4) {
                    String string = Util.TrimLeft(tclObjectArray[2].toString(), tclObjectArray[3].toString());
                    String string5 = Util.TrimRight(string, tclObjectArray[3].toString());
                    if (string5 == null) {
                        interp.resetResult();
                        return;
                    }
                    interp.setResult(TclString.newInstance((String)string5));
                    return;
                }
                throw new TclNumArgsException(interp, 1, tclObjectArray, "trim string ?chars?");
            }
            case 10: {
                if (tclObjectArray.length == 3) {
                    String string = tclObjectArray[2].toString();
                    if ((string = Util.TrimLeft(string, " \n\t\r")) == null) {
                        interp.resetResult();
                        return;
                    }
                    interp.setResult(TclString.newInstance((String)string));
                    return;
                }
                if (tclObjectArray.length == 4) {
                    String string = Util.TrimLeft(tclObjectArray[2].toString(), tclObjectArray[3].toString());
                    if (string == null) {
                        interp.resetResult();
                        return;
                    }
                    interp.setResult(TclString.newInstance((String)string));
                    return;
                }
                throw new TclNumArgsException(interp, 1, tclObjectArray, "trimleft string ?chars?");
            }
            case 11: {
                if (tclObjectArray.length == 3) {
                    String string = tclObjectArray[2].toString();
                    if ((string = Util.TrimRight(string, " \n\t\r")) == null) {
                        interp.resetResult();
                        return;
                    }
                    interp.setResult(TclString.newInstance((String)string));
                    return;
                }
                if (tclObjectArray.length == 4) {
                    String string = Util.TrimRight(tclObjectArray[2].toString(), tclObjectArray[3].toString());
                    if (string == null) {
                        interp.resetResult();
                        return;
                    }
                    interp.setResult(TclString.newInstance((String)string));
                    return;
                }
                throw new TclNumArgsException(interp, 1, tclObjectArray, "trimright string ?chars?");
            }
            case 12: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "wordend string index");
                }
                String string = tclObjectArray[2].toString();
                char[] cArray = string.toCharArray();
                int n10 = string.length();
                int n11 = TclInteger.get((Interp)interp, (TclObject)tclObjectArray[3]);
                if (n11 < 0) {
                    n11 = 0;
                }
                if (n11 > n10) {
                    interp.setResult(TclInteger.newInstance((int)n10));
                    return;
                }
                int n12 = n11;
                while (n12 < n10) {
                    char c = cArray[n12];
                    if (!Util.isLetterOrDigit(c) && c != '_') break;
                    ++n12;
                }
                if (n12 == n11) {
                    n12 = n11 + 1;
                }
                interp.setResult(TclInteger.newInstance((int)n12));
                return;
            }
            case 13: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "wordstart string index");
                }
                String string = tclObjectArray[2].toString();
                char[] cArray = string.toCharArray();
                int n13 = string.length();
                int n14 = TclInteger.get((Interp)interp, (TclObject)tclObjectArray[3]);
                if (n14 > n13) {
                    n14 = n13 - 1;
                }
                if (n14 < 0) {
                    interp.setResult(TclInteger.newInstance((int)0));
                    return;
                }
                int n15 = n14;
                while (n15 >= 0) {
                    char c = cArray[n15];
                    if (!Util.isLetterOrDigit(c) && c != '_') break;
                    --n15;
                }
                if (n15 != n14) {
                    ++n15;
                }
                interp.setResult(TclInteger.newInstance((int)n15));
                return;
            }
        }
        throw new TclRuntimeError("TclIndex.get() error");
    }

    StringCmd() {
    }
}

