# Allgemeine Prozeduren fr xtem_texmenu
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen

proc datime {} {# liefert Uhrzeit als Return-Wert!
#
  set hhmmss [fmtclock [getclock] +%H:%M:%S]
  return $hhmmss
} 



proc cat_file {dnam f} {# Anlisten der Datei dnam im Fenster f
#
  global vv
  $f configure -state normal
  $f insert end "----- $vv(aus5): $dnam -----\n";### this line may be removed
  set fid [open "$dnam" r]
  set haus [read $fid]
  close $fid
  $f insert end $haus;   $f insert end "@";  $f insert end "\n"
  $f configure -state disabled
} 



proc cat_file0 {dnam f} {# Anlisten der Datei dnam im Fenster f
#			   nach vorherigem Lschen des bisherigen Fensterinhalts
  global anl0 vv

  set fid [open "$dnam" r]
  set haus [read $fid]
  close $fid

  if {($anl0 == 1) && ($f == ".d.tt")} {# Anlisten "mit Vorsicht"!
                                          # (Es luft derzeit ein Programm)

    $f configure -state normal
    $f insert end "\n\n***** $vv(ut1)\n"
    $f insert end $haus
    $f insert end "\n***** $vv(ut2)\n\n"
    $f configure -state disabled

  } else {# Anlisten normal, es luft derzeit kein Programm

    $f configure -state normal
    $f delete 0.0 end
    $f insert end "----- $vv(aus5): $dnam -----\n";### this line may be removed
    $f insert end $haus;   $f insert end "@";  $f insert end "\n"
    $f yview 0
    $f configure -state disabled

  }

} 



proc clearscr {f} {# Lschen des Textfensters f
#
  $f configure -state normal
  $f delete 0.0 end
  $f configure -state disabled
}


proc bell {} {#		Hupe oder anderes auffallendes akustisches Signal,
#			ersatzweise optische auffallendes Signal
  puts -nonewline stdout "\007"
} 



proc testfilename {dnam win suf} {# Test, ob der Dateiname dnam 
#				     nur aus Buchstaben und Ziffern besteht
  global vv
  if {"$dnam" == ""} {
    writescr  $win "$vv(ut3)\n"
    bell
    $win yview 0
    return 1
  }
  if {![regexp {^[a-zA-Z0-9]+$} $dnam]} {
    bell
    writescr  $win "$vv(ut4) <$dnam> $vv(ut5)\n         $vv(ut6)"
    if {$suf != ""} {writescr $win "$vv(ut7) \"$suf\""}
    writescr   $win "\n"
    if {[string match "* *" $dnam]} {
      writescr $win "\n***** $vv(ut8)\n"
    } 
    $win yview 0
    return 1
  }
}



proc mtest {str pos var} {# Testen und Setzen einer Variablen
#                           (ohne trailing Blanks)
#                           wenn $var in $str enthalten, ab $pos -> ...
  upvar 1 $var v
  set pat $var
  if {[string match "$pat*" $str]} {
    set v [string trim [string range $str $pos end]] 
  }
}



proc progback {prog back} {# Testen, ob Programm $prog im Hintergrund 
#                            aufgerufen werden soll,
#                            Setzen von $back und korrigieren von $prog
  upvar 1 $prog programm
  upvar 1 $back background

  set bpos [string last & "$programm"]
  if {$bpos > 0} {
    set programm [string trim [string range $programm 0 [expr {$bpos - 1}]]]
    set background & 
  } else {
    set background ""
  }
  set $programm [string trim $programm]
}



proc writescr {w args} {# Ausgabe einer variablen Anzahl von Strings 
#                        (aus $args) im Textfenster $w
  $w configure -state normal
  foreach i $args {$w insert end "$i"}
  $w yview -pickplace end
  $w configure -state disabled
} 



proc writescr0 {w args} {# Ausgabe einer variablen Anzahl von Strings 
#                         (aus $args) im Textfenster $w
#			  nach vorherigem Lschen des bisherigen Fensterinhalts
  $w configure -state normal
  $w delete 0.0 end
  foreach i $args {$w insert end "$i"}
  $w yview -pickplace end
  $w configure -state disabled
} 



proc getscl {foid e} {# filter for call of gets, but line breaks by "\" allowed
#
  upvar 1 $e ein

  set ret [gets $foid z];  set z [string trimright $z]
  set ein "$z"
  set lm1 [expr [string length $z]-1]
  while {($lm1>=0) && ([string last \\ $z]==$lm1)} { 
    set ein [string range $ein 0 [expr [string length $ein]-2]]
    set ret [gets $foid z];  set z [string trimright $z]
    set lm1 [expr [string length $z]-1]
    set ein "$ein$z"
  }
  return $ret
}


proc getscl0 {foid e} {# like getscl, but blanks at contin.-line-begin deleted
#                
  upvar 1 $e ein

  set ret [gets $foid z];  set z [string trimright $z]
  set ein "$z"
  set lm1 [expr [string length $z]-1]
  while {($lm1>=0) && ([string last \\ $z]==$lm1)} { 
    set ein [string range $ein 0 [expr [string length $ein]-2]]
    set ret [gets $foid z];  set z [string trimright $z]
    set lm1 [expr [string length $z]-1]
    set ein "$ein[string trimleft $z]"
  }
  return $ret
}


proc fillbox {w dat} {# listbox $w fllen aus .vst-Datei $dat
#
  set foid [open_vst $dat]
  while {[getscl $foid ein] > 0} {$w insert end $ein}
  close $foid
}


proc fillboxsep {w dat} {# listbox $w fllen aus .vst-Datei $dat und Separator
#                                     bestimmen (1. Zeichen ungleich Blank)
  set foid [open_vst $dat]
  getscl $foid ein;  set sep [string index [string trim $ein] 0]
  while {[getscl $foid ein] > 0} {$w insert end $ein}
  close $foid
  return $sep
}


proc alternative {dv t1 t2} {# Hilfsprozedur fr alternative Ausgabe 
#
  if {$dv == ""} {return $t1} else {return $t2}
}



proc request {t frage aus abb helpdatei w} {# Abfrage-Men (Fragetext und zwei
#                                                            Antwort-Buttons)
  global  hlp_dir vv
  wm title $t "$vv(utvor)" 
  label $t.dv -width 80 -anchor w  -text "$frage" 
  pack configure $t.dv -in $t -padx 37 -pady 13
  frame $t.bv -relief raised -borderwidth 0
  pack configure $t.bv -in $t -padx 13 -pady 13
  button $t.bv.aus -text "$aus"
  button $t.bv.abb -text "$abb"
  pack configure $t.bv.aus $t.bv.abb -in $t.bv -side left -anchor n -padx 13 -pady 3
  bind $t.bv.aus <Button-3> "+ cat_file0 ${hlp_dir}${helpdatei} $w"
  bind $t.bv.abb <Button-3> "+ cat_file0 ${hlp_dir}${helpdatei} $w"
}



proc mdtest {hd stex sdvi aus} {# Test, welche von zwei Dateien lter ist
#                                  ( $hd$sdvi sollte neuere Datei sein!)
  upvar 1 $aus a
  global vv
  if {$hd == ""} {
    bell
    set a "\n***** $vv(ut9)\n"
    return -1
  }
  if {[file exists $hd$sdvi] == 0} {
    bell
    set a "\n***** $vv(ut10) $hd$sdvi $vv(ut100)\n"
    return -1
  }

  if {[file exists $hd$stex] == 0} {
    bell
    set a "$vv(ut11) $hd$stex $vv(ut12)\n"
    return 1
  }

  set t1 [file mtime $hd$stex]
  set t2 [file mtime $hd$sdvi]
  if {$t1 > $t2} {
    bell
    set a\
    "$vv(ut11) $hd$stex $vv(ut13) $hd$sdvi $vv(ut14)\n"
   return 0
  }
  return 1
}




proc getvalue {zeile n separator} {# aus der Zeile den n-ten Wert zurckgeben

  set tmp $zeile
  set count 0
  while {$count < $n} {
    set pos [string first $separator $tmp]
    if {$pos >= 0} {
      set tmp [string range $tmp [expr $pos+1] end]
    } else {
      set tmp ""
    }
    incr count
  }

  set pos [string first $separator $tmp]
  if {$pos >= 0} {
    set tmp [string range $tmp 0 [expr $pos-1]]
  }
  incr count
  return [string trim $tmp]
}



proc checksum {} {# Ermittlung der Prfsumme fr die .aux-Dateien
# 
  global dir sub
  set prsum 0
  foreach i [glob -nocomplain -- *] {
    if {[file isfile $i] && [string match "*.aux" $i]} {
      if {[file size $i] > 0} {
        ##############################
        # Alternativ einen der beiden folgenden Aufrufe zur Prfsummenermittlung:
        # a) Prfsummenermittlung rein in Tcl (nicht Rechenzeit-effizient!)
        #   set prsumd [checksum_file $i]
        # b) Prfsummenermittlung mit Unix-Kommando (System V und UCB)
        #     [schneller als Lsung a)!]
            set p [exec sum $i]
            lock;  update idletasks;  set sub 1
            set prsumd [string range $p 0 [string first " " $p]]
            set prsumd [string trimleft [string trim $prsumd] 0]
        ##############################
      } else {
        set prsumd 0
      }
      set prsum [expr "$prsum+$prsumd"]
    }
  }
  return $prsum
}



proc checksum_file {datei} {# Ermittlung der Prfsumme einer Datei rein in Tcl
#
  set fileid [open $datei r]
  set filesize [file size $datei]
  if {"$filesize" == 0} { # Datei hat Lnge 0
           close $fileid
           return 0
  } else {                  # Datei hat Lnge > 0
           set chars         "abcdefghijklmnopqrstuvwxyz"
           set chars "${chars}ABCEDFGHIJKLMNOPQRSTUVWXYZ"
           set chars "${chars}1234567890.':<>|`~!@#%^&*()-_=+"
           set chars "${chars}\[\]\$\ \;\"\{\}\\\n\b"
           set prs 0
           set bytegel 0
           set faktor 1
           while {"$bytegel" < "$filesize"} {
             set byte [read $fileid 1] 
             set bytegel [expr "$bytegel+1"]
             set i [string first $byte $chars]
             set prs [expr "$prs+($i*$faktor)"]
             if {$faktor == 1} {set faktor 2} else {set faktor 1}
           }
          close $fileid
          return $prs
  }
}



proc vst_getvalues {w vstdat} {# Voreinstellungen lesen - Werte aus Datei lesen
#
  global  vv vst_dir
  global  version_vst texsuffix esuff
  global  editor edtext edxterm edoptions edsyntaxhelp
  global  index intext inoptions
  global  logform logtext logxterm logoptions
  global  preview prtext prsuffix proptions prformat prpreopt
  global  printer lpcmd lpopt prtdriver prtselstr prtoptions
  global          prtsuf prtfilperm prtpresel prmtext prmsel prmrelabs
  global  spcmd sptext splang spcorr spselect spoptions
  global  syntax sytext syoptions
  global  texfmt texmem texmtext texmax
  global  aufmax aufsuff auftoggle
  global  mkcommand
  global  hlp_bmsuppr

  if {$vstdat == ""} {
    set foid [open_vst default.vst]
    if {$w != ""} {writescr0 $w "$vv(ut15) $vst_dir/default.vst\n\n"}
  } else {
    if {$w != ""} {writescr0 $w "$vv(ut15) $vstdat\n\n"}
    set foid [open $vstdat r]
    global efile
  }
  while {[gets $foid z]>0} {set [string trim [string range $z 0 18]] [string trim [string range $z 19 end]]}
  close $foid

}

proc vst_read {w vst_file} {# Voreinstellungen lesen
#
  global  version_vst main_file dir efile env vstdat prvformat prformat opsep
  global  prtoptions olsep lpopt editor edback preview prback logform logback
  global  logxterm edxterm logoptions edoptions version_incompatible language
  global  vst_dir

  set version_vst 0.00
  if {$vst_file == "default.vst"}  {# "Grund-Voreinst."
    set vstdat ""
  } else                            {# "Start/eigene Voreinst."
    if {($main_file == "") && [file exists .lastxtem]} {
       set foid [open ".lastxtem" r]
       while {[gets $foid ein] > 0} {
         mtest $ein 19 dir
         mtest $ein 19 main_file
         mtest $ein 19 efile
       }
       close $foid
       if {$efile == ""} {set efile $main_file}
    }
    if {($main_file != "") && [file exists "${main_file}_$language.vst"] \
         && ($vst_file != ".xtem_$language.vst")} {
     set vstdat ${main_file}_$language.vst
    } elseif {[file exists "$env(HOME)/.xtem_$language.vst"]} {
      set vstdat "$env(HOME)/.xtem_$language.vst"
    } else {
      set vstdat ""
    }
  }
  vst_getvalues $w $vstdat
  if {$vstdat == ""} {set vstdat $vst_dir/default.vst}
  update_prtformat
  set prvformat $prformat
  set opsep [string index $prtoptions 0]
  set olsep [string index $lpopt 0]
  progback  editor  edback
  progback  preview prback
  progback  logform logback
  if {$logform=="\$editor"} {
    set logform $editor; set logxterm $edxterm; set logoptions $edoptions
  }
  if {$w != ""} {disp_prefs1 $w}
  if {[string range $version_vst 0 3] <= $version_incompatible} {
      if {"$vstdat"!="$vst_dir/default.vst"} {
        frename $vstdat $vstdat.bak 
      } else {
	puts stdout "Warning: inform local administrator to check \
                     \"version_vst\"  in file  $vst_dir/default.vst"
      }
    return $vstdat
  } else {
    return 0
  }
}


proc update_prtformat {} {
  global  prtselstr prtformat
  set prtformat [string trim [lindex [split $prtselstr ","] 3]]
}


proc vst_write {win} {# Voreinstellungen sichern
#
  global  vv dir main_file efile env language

  vst_write_file "$env(HOME)/.xtem_$language.vst"
  if {[string length $main_file]>0} {
    set strhd  "\n$vv(ut0)  ${main_file}_$language.vst"
    vst_write_file "${main_file}_$language.vst"
    set foid [open ".lastxtem" w]
    puts $foid "dir                $dir"
    puts $foid "main_file          $main_file"
    puts $foid "efile              $efile"
    close $foid
  } else    {
    set strhd "" 
  }
  writescr0 $win "$vv(ut16)  $env(HOME)/.xtem_$language.vst$strhd $vv(ut17)\n\n"
  disp_prefs1 $win
}



proc vst_write_file {vst_file} {# Voreinstellungen in vst-Datei schreiben
#
  global  mkcommand version dir main_file efile edback prback env language
  global  editor edtext edxterm edoptions edsyntaxhelp esuff
  global  printer prtselstr prtdriver prtpresel prtoptions prtsuf
  global  lpcmd lpopt
  global  spcmd sptext splang spoptions spcorr spselect
  global  index intext inoptions syntax sytext syoptions
  global  preview prsuffix proptions prformat prtext prpreopt
  global  texfmt texmtext texmem texmax texsuffix
  global  aufmax aufsuff auftoggle logform logtext logxterm logoptions logback
  global  prmtext prmsel prmrelabs prtfilperm
  global  hlp_bmsuppr

  set foid [open "$vst_file" w]
  puts $foid "version_vst        $version"
  if {"$vst_file" != "$env(HOME)/.xtem_$language.vst"} {
    puts $foid "dir                $dir"
    puts $foid "main_file          $main_file"
    puts $foid "efile              $efile"
  }
  puts $foid "editor             $editor$edback"
  puts $foid "edtext             $edtext"
  puts $foid "edxterm            $edxterm"
  puts $foid "edoptions          $edoptions"
  puts $foid "edsyntaxhelp       $edsyntaxhelp"
  puts $foid "esuff              $esuff"
  puts $foid "index              $index"
  puts $foid "intext             $intext"
  puts $foid "inoptions          $inoptions"
  puts $foid "logform            $logform$logback"
  puts $foid "logtext            $logtext"
  puts $foid "logxterm           $logxterm"
  puts $foid "logoptions         $logoptions"
  puts $foid "preview            $preview$prback"
  puts $foid "prtext             $prtext"
  puts $foid "prsuffix           $prsuffix"
  puts $foid "proptions          $proptions"
  puts $foid "prformat           $prformat"
  puts $foid "prpreopt           $prpreopt"
  puts $foid "printer            $printer"
  puts $foid "lpcmd              $lpcmd"
  puts $foid "lpopt              $lpopt"
  puts $foid "prtdriver          $prtdriver"
  puts $foid "prtselstr          $prtselstr"
  puts $foid "prtoptions         $prtoptions"
  puts $foid "prtsuf             $prtsuf"
  puts $foid "prtfilperm         $prtfilperm"
  puts $foid "prtpresel          $prtpresel"
  puts $foid "prmtext            $prmtext"
  puts $foid "prmsel             $prmsel"
  puts $foid "prmrelabs          $prmrelabs"
  puts $foid "spcmd              $spcmd"
  puts $foid "sptext             $sptext"
  puts $foid "splang             $splang"
  puts $foid "spcorr             $spcorr"
  puts $foid "spselect           $spselect"
  puts $foid "spoptions          $spoptions"
  puts $foid "syntax             $syntax"
  puts $foid "sytext             $sytext"
  puts $foid "syoptions          $syoptions"
  puts $foid "texfmt             $texfmt"
  puts $foid "texmem             $texmem"
  puts $foid "texmtext           $texmtext"
  puts $foid "texmax             $texmax"
  puts $foid "texsuffix          $texsuffix"
  puts $foid "aufmax             $aufmax"
  puts $foid "aufsuff            $aufsuff"
  puts $foid "auftoggle          $auftoggle"
  puts $foid "mkcommand          $mkcommand"
  puts $foid "hlp_bmsuppr        $hlp_bmsuppr"
  close $foid
}



proc disp_prefs1 {win} {# aktuelle Einstellungen anzeigen (ohne Dateien)
#
  global  vv editor edback edtext esuff texfmt texmtext texmax preview prback
  global  logform logback printer prtdriver prmtext spcmd syntax index bibtex
  global  mkcommand prformat prtformat

  writescr .d.tt " $vv(ut20) $editor$edback  $edtext" \
                 [alternative $edback "\n" "   $vv(ut21)\n"] \
                 "    $vv(ut200)" [alternative $esuff " *\n" " $esuff\n"] \
                 " $vv(ut22) $texfmt\n" \
                 "    $vv(ut23) $texmtext\n" \
                 "    $vv(ut24) $texmax\n" \
                 " $vv(ut25) $preview$prback" \
                 [alternative $prback "" "   $vv(ut21)"]  ", $prformat\n" \
                 " $vv(ut26) $logform$logback\n" \
                 " $vv(ut27) $printer\n" \
                 " $vv(ut28) $prtdriver,  $prtformat\n" \
                 " $vv(ut29) $prmtext\n" \
                 " $vv(ut30) $spcmd\n" \
                 " $vv(ut31) $syntax\n" \
                 " $vv(ut34) $index\n" \
                 " $vv(ut32) $bibtex\n" \
                 " $vv(ut33) $mkcommand\n\n"
}



proc disp_prefs2 {win} {# aktuelle Einstellungen anzeigen (mit Dateien)
#
  global  vv main_file efile texfmt esuff tsuff

  disp_prefs1 $win
  writescr .d.tt [alternative $efile " $vv(bad1)\n" " $vv(bad2) $efile$esuff\n"] \
                 [alternative $main_file \
                   " $vv(tvbad1) $texfmt $vv(tvbad3)\n" \
                   " $vv(tvbad2) $texfmt $vv(tvbad3): $main_file$tsuff\n"]
}



proc lock {} {# Verriegeln aller Buttons des Hauptmenues
#
  global gesliste anl0

  set anl0 1
  set nmax [llength $gesliste]
  while {$nmax > 0} {
    incr nmax -1 
    set ll [lindex $gesliste $nmax]
    $ll configure -state disabled
  }
}


proc unlock {args} {# Entriegeln der angegebenen Buttons (bel. viele)
#
  global sub anl0

  foreach i $args {
    set k [llength $i]
    while {$k > 0} {
      incr k -1 
      set ll [lindex $i $k]
      $ll configure -state normal
    }
  }
  set sub 0
  set anl0 0
}


proc unlock_list {} {# Entriegeln der Buttons der globalen Liste
#
  global liste edsubback prsubback

  if {([edactiv]==0) && ($edsubback>0)} {
    set edsubback 0
    if {[lsearch $liste .c.1.ed]<0} {
      set liste [linsert $liste 1 .c.1.ed]
    }
  }
  if {([practiv]==0) && ($prsubback>0)} {
    set prsubback 0
    if {[lsearch $liste .c.1.pf]<0} {
      set liste [linsert $liste 1 .c.1.pf]
    }
  }
  unlock $liste
}


proc edactiv {} {#  Kontrolle, wieviele Editor-Prozesse im Background aktiv
#
  global edliste

  set l [llength $edliste]
  while {$l > 0} {
   incr l -1
   set p [lindex $edliste $l]
   if {[process $p]!=0} { #Prozess $p nicht mehr aktiv!
     set edliste [lreplace $edliste $l $l]
    }
  }
  return [llength $edliste]
}


proc practiv {} {#  Kontrolle, wieviele Editor-Prozesse im Background aktiv
#
  global prliste

  set l [llength $prliste]
  while {$l > 0} {
    incr l -1
    set p [lindex $prliste $l]
    if {[process $p]!=0} { #Prozess $p nicht mehr aktiv!
      set prliste [lreplace $prliste $l $l]
    }
  }
  return [llength $prliste]
}


proc kill_list {prozessliste} {# kill processes
#
  
  if {[llength $prozessliste] != 0} {
    foreach pi $prozessliste {killprocess $pi}
    exec sleep 1
  }

}


proc open_vst {filename} {# open for a .vst-file
#
  global xtem_path vst_dir language env 

  if {[info exists env(XTEMVSTDIR)]} {
    if {[file exists $env(XTEMVSTDIR)/$filename]} {
      set f [open "$env(XTEMVSTDIR)/$filename" r]
      set vst_dir $env(XTEMVSTDIR)
    } else {
      set f [open "$xtem_path/locals_$language/$filename" r]
      set vst_dir $xtem_path/locals_$language
    }
  } else {
    set f [open "$xtem_path/locals_$language/$filename" r]
    set vst_dir $xtem_path/locals_$language
  }
  return $f

}



proc format_switch {w fmtneu mod} {# switch format (e.g. portrait/landscape)
                                   # for preview and printing
  global vv  prformat prtext prvformat prvfmtli  prtselstr prtformat prtfmtli

  set fmtlisten 0

  if {"$w" == ".dv.d.tt"} {
    if {[winfo exists .pv]} {writescr0 .pv.d.tt ""}
  } else {
    if {[winfo exists .dv]} {writescr0 .dv.d.tt ""}
  }

  set prfmtalt "$prvformat"
  if {($mod==1) || ($mod==3)} {
    if {"$fmtneu" == "$prfmtalt"} {# no format change necessary (old = new)
      writescr $w "$prvformat $vv(pvfe)\n"
    } else {# format has to be changed (old /= new)
      set prres [prv_select "{$prtext, $prformat}" "$fmtneu"]
      set prvformat $fmtneu
      if {$prres} {# preview format changed
        if {"$w" == ".dv.d.tt"} {writescr $w "$vv(ut35) $prtext, $prformat\n\n"}
        if {[winfo exists .pv]} prvlistfill
      } else {# preview format could not be changed; only update preview list
        writescr $w "$vv(ut37);\n$vv(ut38) $vv(ut39)!\n\n"
        if {[winfo exists .pv]} prvlistfill
        bell; set fmtlisten 1
      }
    }
  }

  set prtfmtalt "$prtformat"
  if {$mod>=2} {
    if {"$fmtneu" == "$prtfmtalt"} {# no format change necessary (old = new)
      writescr $w "$prtformat $vv(dvfe)\n"
    } else {# format has to be changed (old /= new)
      set prtres [prt_select "{$prtselstr}" "$fmtneu"]
      if {$prtres} {# printer format changed
        if {"$w" == ".pv.d.tt"} {writescr $w "$vv(ut36) $prtselstr\n\n"}
      } else {# printer format could not be changed
        writescr $w "$vv(ut40);\n$vv(ut41) $vv(ut42)!\n\n"
        bell; set fmtlisten 1
      }
    }
  }

  if {$fmtlisten} {
    writescr $w "$vv(ut43) ($prtext):$prvfmtli"
    writescr $w "$vv(ut44) ($prtselstr):$prtfmtli"
  }
}
