# Drucker-Vorauswahl
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen

proc ds  {} {

global  vv hlp_dir prtpresel prtselmaxl 
global  drselmax drsel drseltit drseln fontsli drselanz dvsep drselli drselnm


toplevel .ds
wm title .ds "$vv(dsvor)"
wm minsize .ds 0 0
# wm geometry .ds =+150+500
set tyh 21

proc drselfill {} {# fills the criteria selection widgets
  global  drselmax drselli

  for {set n 0} {$n<$drselmax} {incr n} {
    .ds.c.$n.f.li delete 0 end
    .ds.c.$n.f.li insert end "*"
    foreach i $drselli($n) {.ds.c.$n.f.li insert end $i}
  }
}


for {set n 0} {$n<$drselmax} {incr n} {
  set drselli($n) " ";set drselanz($n) 1
  set dsw($n) [string length $drseltit($n)]
}
set foid [open_vst printing.vst]
getscl $foid ein
set drselnm 0
while {[getscl $foid ein] > 0} {
  set z [split $ein $dvsep]
  set sn [string trim [lindex $z 1]]
  if {[string first "$sn " "$drselli(0)"] < "0"} {
     set drselli(0) "$drselli(0) $sn " 
     incr drselanz(0)
     set l [string length $sn]
     if {$l > $dsw(0)} {set dsw(0) $l}
  }
  set sn "[string trim [lindex $z 2]]:[string trim [lindex $z 3]]"
  if {[string first "$sn " "$drselli(1)"] < "0"} {
     set drselli(1) "$drselli(1) $sn " 
     incr drselanz(1)
     set l [string length $sn]
     if {$l > $dsw(1)} {set dsw(1) $l}
  }
  set zmult 1
  for {set n 2} {$n<$drselmax} {incr n} {
    set sn [split [string trim [lindex $z [expr $n+9]]] ","]
    set asn [llength $sn]; # number of elements in a criterium 
    set zmult [expr "$zmult*$asn"]
    foreach i $sn {
      regsub -all "\{" $i " \{" lien
      set crit [lindex $lien 0]
      if {[string first "$crit " "$drselli($n)"] < "0"} {
        set drselli($n) "$drselli($n) $crit " 
        incr drselanz($n)
        set l [string length $crit]
        if {$l > $dsw($n)} {set dsw($n) $l}
      }
    }
  }
  incr drselnm $zmult
}
close $foid

for {set n 0} {$n<$drselmax} {incr n} {incr dsw($n)}

set prtselm 0
for {set n 0} {$n<$drselmax} {incr n} {
  if {$prtselm  < $drselanz($n)} {set prtselm $drselanz($n)}
  set drselli($n) [lsort $drselli($n)] 
}
if {$prtselm  < $prtselmaxl} {set prtselmaxl $prtselm}


# Bereich a fuer erste Buttons

frame .ds.a
pack configure .ds.a -in .ds -pady 5 -anchor w -fill x

frame .ds.a.1 -relief raised -borderwidth 1
frame .ds.a.2 -relief raised -borderwidth 1
pack configure .ds.a.1 -in .ds.a -side left -anchor w -pady 3
pack configure .ds.a.2 -in .ds.a -side right -padx 3
 
button .ds.a.1.e -text "$vv(ae)"
bind   .ds.a.1.e <Button-3> {+ cat_file0 "${hlp_dir}ds_vstquit.hlp" .dv.d.tt}
button .ds.a.1.h -text "$vv(ah)" 
bind   .ds.a.1.h <Any-Button> {+ cat_file0 "${hlp_dir}ds_h.hlp" .dv.d.tt}
button .ds.a.1.g -text "$vv(ag)" -command {
  set foid [open_vst default.vst]
  while {[getscl $foid ein] > 0} {mtest $ein 19 prtpresel}
  close $foid
  writescr0 .dv.d.tt "$vv(ausg1)\n\n $vv(dv5)  $prtpresel\n\n"
  set n 0
  while {$n < $drselmax} {set drsel($n) [lindex $prtpresel $n]; incr n}
  drlistfill
}
bind   .ds.a.1.g <Button-3> {+ cat_file0 "${hlp_dir}ds_grund.hlp" .dv.d.tt}
pack configure .ds.a.1.e .ds.a.1.h .ds.a.1.g -in .ds.a.1 -side left -padx 3 -pady 3


frame .ds.b
pack configure .ds.b -in .ds -anchor nw

label .ds.b.n -text "$vv(dsb1)  $drseln  $vv(dsb2)  $drselnm  $vv(dsb3)" \
              -width 70 -anchor w
bind  .ds.b.n <Button-3> {+ cat_file0 "${hlp_dir}ds_selnums.hlp" .dv.d.tt}
pack configure .ds.b.n -in .ds.b -anchor w


# Bereich fuer drselmax Boxen

frame .ds.c
pack configure .ds.c -in .ds -pady 5 -anchor n

for {set n 0} {$n<$drselmax} {incr n} {

  frame .ds.c.$n -relief raised -borderwidth 1
  pack configure .ds.c.$n -in .ds.c -side left

  label .ds.c.$n.l -text "$drseltit($n)" -width $dsw($n) -anchor c
  bind  .ds.c.$n.l <Button-3> {+ cat_file0 "${hlp_dir}ds_selstrg.hlp" .dv.d.tt}
  label .ds.c.$n.d -text "$drsel($n)" -width $dsw($n) -anchor c -font $fontsli
  bind  .ds.c.$n.d <Button-3> {+ cat_file0 "${hlp_dir}ds_selstrg.hlp" .dv.d.tt}
  frame .ds.c.$n.f -relief raised -borderwidth 1
  pack configure .ds.c.$n.l .ds.c.$n.d .ds.c.$n.f -in .ds.c.$n -anchor n
  if {$prtselmaxl < $drselanz($n)} {
    scrollbar .ds.c.$n.f.sb -command ".ds.c.$n.f.li yview"
    bind .ds.c.$n.f.sb <Button-3> {+ cat_file0 "${hlp_dir}ds_sellist.hlp" .dv.d.tt}
    listbox .ds.c.$n.f.li -yscroll ".ds.c.$n.f.sb set" -geometry $dsw($n)x$prtselmaxl
    pack configure .ds.c.$n.f.sb .ds.c.$n.f.li -in .ds.c.$n.f -side right -fill y
  } else {
    listbox .ds.c.$n.f.li -geometry $dsw($n)x$prtselmaxl
    pack configure .ds.c.$n.f.li -in .ds.c.$n.f -side right -fill y
  }

  bind .ds.c.$n.f.li <Double-Button-1> {
    set ii [catch {selection get} i]
    if {!$ii} {
      set n [lindex [split %W "."] 3]
      set drsel($n) $i
      set nn 0; set prtpresel ""
      while {$nn < $drselmax} {set prtpresel "$prtpresel $drsel($nn)"; incr nn}
      drlistfill
      writescr0 .dv.d.tt \
            "\n$vv(dsb4) \"$drseltit($n)\" $vv(dsb1) $drsel($n)\n\n$prtpresel\n"
    }
  }
  bind .ds.c.$n.f.li <Button-3> {cat_file0 "${hlp_dir}ds_sellist.hlp" .dv.d.tt}
}

.dv.a.2.s configure -state disabled; update idletasks
drselfill

}

