#
# 
#  Copyright (c) 1994 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: rolodex.t,v 1.2 1995/07/17 01:13:20 andy Exp $
#
# Make a rolodex-like window for user to choose a fax number.
#

proc rolodex { t w } {

    global phonedb 
    global phonelist

    # If the cache was not initialized, initialize it.
    if {[ff_checkCacheDB $phonedb phonelist]} {
	return
    }

    catch {destroy $t}
    toplevel $t

    set fn {*courier*bold-r*12*}

    wm title $t "FAX Numbers"
    wm minsize $t 100 100
    wm geometry $t 695x280

    global clen
    global plen
    global nlen

    ut_mkFrame $t {f {} {} oper {-relief sunken} {-side bottom -fill x}}
    set style "%-${nlen}.${nlen}s  %-${clen}.${clen}s  %${plen}.${plen}s"
    set hdr [format "$style" "Name" "Company" "Phone"]
    set hdr_attr [list $hdr -font $fn -padx 20] 
    ut_mkLabel $t.f [list l_rolodex $hdr_attr {-side top -fill x}]

    scrollbar $t.f.scr -relief sunken -command "$t.f.bx yview"
    listbox $t.f.bx -yscroll "$t.f.scr set" -relief sunken -font $fn \
	-selectmode single
    ut_mkButton $t.oper [list \
	b_rescan "RESCAN -command \{rescan_rolodex $t.f.bx\}" {} \
	b_search "SEARCH -command \{ut_searchEntries \
	    -entryRelief [entryRelief] -listbox $t.f.bx\}" {} \
	b_cancel "DISMISS -command \{destroy $t\}" {}]
    pack $t.f.scr -side left -fill y 
    pack $t.f.bx -side right -fill both -expand 1
    ut_mkMenu $t.f.bx [list {Add to Batch} "load_batch $t.f.bx" \
			    {Load Cover Sheet} "load_cover $t.f.bx $w" \
			    {Remove From Database} "remove_entry $t.f.bx"]

    set l [lsort [array names phonelist]]
    foreach i $l {
	set company [lindex $phonelist($i) 0]
	set phone [lindex $phonelist($i) 1]
	set entry [format "$style" $i $company $phone]
	$t.f.bx insert end $entry
    }
}

proc remove_entry { w } {

    global nlen
    global phonedb
    global phonelist

    set idx [$w curselection]
    if {$idx == ""} {
	return
    }
    set entry [$w get $idx]
    set name [string trim [string range $entry 0 $nlen]]

    unset "phonelist($name)"
    
    # Update database on disk
    ff_updateDB $phonedb phonelist

    # Show updated fax database
    #rescan_rolodex $w
    $w delete $idx 
}

proc load_batch { w } {

    global batch_destinations

    set idx [$w curselection]
    if {$idx == ""} {
	return
    }
    set entry [$w get $idx]

    # Make batch phone number list
    lappend batch_destinations $entry

    # Remove highlight
    $w select clear 0 end

    # Update the batch listbox 
    if {[winfo exists .viewbatch]} {
	.viewbatch.f.bx insert end $entry
    }
}

proc rescan_rolodex { w } {

    global phonelist
    global phonedb
    global clen
    global plen
    global nlen

    # If the cache was not initialized, initialize it.
    if {[ff_checkCacheDB $phonedb phonelist]} {
	return
    }

    # Remove whats already in the listbox
    $w delete 0 end

    set style "%-${nlen}.${nlen}s  %-${clen}.${clen}s  %${plen}.${plen}s"

    set l [lsort [array name phonelist]]
    foreach i $l {
	set company [lindex $phonelist($i) 0]
	set phone [lindex $phonelist($i) 1]
	set entry [format "$style" $i $company $phone]
	$w insert end $entry
    }
}

proc load_cover { w cvr } {

    global clen
    global plen
    global nlen

    set idx [$w curselection]
    if {$idx == ""} {
	return
    }
    set entry [$w get $idx]
    # Extract the name, company and phone from the selected item.
    set name [string trim [string range $entry 0 $nlen]]
    ut_updateEntry $cvr.name.entry $name 

    set start [expr $nlen+1]
    set end [expr $nlen+$clen]
    set company [string trim [string range $entry $start $end]]
    ut_updateEntry $cvr.company.entry $company 

    set start [expr $nlen+$clen+1]
    set phone [string trim [string range $entry $start end]] 
    ut_updateEntry $cvr.phone.entry $phone 

    # Remove highlight
    $w select clear 0 end
}
