#
# 
#  Copyright (c) 1994 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: ut_mkFrame.t,v 1.1.1.1 1995/06/06 14:16:00 andy Exp $
#
# Make a frame.
#

proc ut_mkFrame { p flist } {

    set items_per_widget 3
    set llen [llength $flist]

    for {set i 0} {$i < $llen} {incr i $items_per_widget} {
	set l [lrange $flist $i [expr $i+$items_per_widget-1]]
	set c [lindex $l 0]
	# This is a toplevel frame
	if {$p == "."} {
	    frame .$c -relief raised -borderwidth 1
	    pack .$c -side top -fill both -expand 1 -anchor nw
	    return
	}
	# Create frame with defaults
	frame $p.$c -relief raised -borderwidth 1
	# Configure with user values if any
	set wattr  [lindex $l 1]
	if {[string length $wattr] > 0} {
	    eval $p.$c configure $wattr 
	}
	set pattr [lindex $l 2]
	if {[string length $pattr] > 0} {
	     eval pack $p.$c $pattr 
	} else {
	     pack $p.$c -side top -fill both -expand 1 
	}
    }
} 
