#
#  Copyright (c) 1995 A & A Custom Software.
#  All rights reserved.
#
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its
#     contributors may be used to endorse or promote products derived from this
#     software without specific prior written permission.
#
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
#  POSSIBILITY OF SUCH DAMAGE.
#
# $Id: ff_getCoverPages.t,v 1.1 1995/08/31 06:28:37 andy Exp $
#
# Make a list of all possible cover pages.
#

proc ff_getCoverPages { coverpath } {

    set l {}
    set dirs [split $coverpath ":"]
    foreach d $dirs {
	if {![file isdir $d] || ![file readable $d]} {
	    continue
	}
	set files [exec ls $d]
	foreach f $files {
	    if {[ff_isPostscriptFile $d/$f] > 0} {
		lappend l $d/$f
	    }
	}
    }
    return $l
}

proc ff_isPostscriptFile { fname } {
    # File exists.
    if {![file exists $fname]} {
        return -1	
    }

    # File is plain.
    if {![file isfile $fname]} {
        return -2 
    }
 
    # Open file.
    set in [open $fname {RDONLY}] 
 
    # The file is opened now. Read its first line and close the file.
    if {[gets $in ln] < 0} {
	# Can't read file.
	close $in
        return -3
    }

    # Test the first line to see if this is a Postscript file.
    if {[regexp {^%!} $ln]} {
	# OK, this is a Postscript file,
	close $in
	return 1
    }
 
    # No, this is not a Postscript file.
    return 0

}
