#!/usr/local/bin/wish -f

# tkgoodstuff version 4.0, $TKG_releasedate@

# See the doc/ subdirectory (of the distribution or of the installed
# tkgoodstuff library directory) for extensive html documentation, or
# browse on the web:
# http://www.umich.edu/~markcrim/tkgoodstuff/tkgoodstuff.html

# By Mark Crimmins (markcrim@umich.edu), copyright (C) 1995, all rights reserved.
# Void where prohibited.  Your mileage may vary.

 #Seriously, enjoy but don't sue me if there's a bug:
 #
 #    This program is free software; you can redistribute it and/or modify
 #    it under the terms of the GNU General Public License as published by
 #    the Free Software Foundation (version 2 of the License).
 #
 #    This program is distributed in the hope that it will be useful,
 #    but WITHOUT ANY WARRANTY; without even the implied warranty of
 #    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 #    GNU General Public License for more details.
 #
 #    For a copy of the GNU General Public License, write to the Free Software
 #    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

set source_dir @tkgoodstuff_library@
if { [ string index $source_dir 0 ] == "@" } {
  if [file exists ./tkgoodstuff.tcl] {
      eval set source_dir [exec pwd]
  } else {
    set source_dir /usr/local/lib/TKGsrc
  }
}
set TKG_version "4.0"
set TKG_releasedate "Sep 14, 1995"
set TKGlogging 0
set TKGlogfile $env(HOME)/.tkgoodstuff-log
set TKG_geometry -5+2
set TKG_orientation vertical
set images $source_dir/images
set TKG_imagetypelist {bitmap photo pixmap}
set TKG_tmp_dir /tmp
set labelsonly 0
set iconsonly 0
set TKG_imageside top
set TKG_border 0
set TKG_nobeep 0
set TKG_nonotices 0
set TKG_browser netscape
set TKG_webpage "http://www.umich.edu/~markcrim/tkgoodstuff/tkgoodstuff.html"

set TKGbackground #b0a8ac
set TKGforeground black

set TKGgeneralfont   "-*-Helvetica-bold-r-*-*-14-*-*-*-*-*-*-*"
set TKGcombofont     "-*-Helvetica-bold-o-*-*-12-*-*-*-*-*-*-*" 
set TKGlabelonlyfont "-*-Helvetica-bold-o-*-*-14-*-*-*-*-*-*-*" 
set TKGlabelboxfont  "-*-Helvetica-bold-r-*-*-16-*-*-*-*-*-*-*"
set TKGdialogfont    "-*-Helvetica-medium-r-*-*-16-*-*-*-*-*-*-*"
set TKGdialogtitlefont "-*-Helvetica-bold-r-*-*-18-*-*-*-*-*-*-*"

proc TKG_setresources {} { uplevel {
    setifunset TKGbuttonbackground [tkgDarken $TKGbackground 85]
    setifunset TKGbuttonforeground $TKGforeground
    set bg [winfo rgb . $TKGbackground]       
    #this stolen from palette.tcl in tk4.0
    foreach i {0 1 2} {
	set light($i) [expr [lindex $bg $i]/256]
	set inc1 [expr ($light($i)*15)/100]
	set inc2 [expr (255-$light($i))/3]
	if {$inc1 > $inc2} {
	    incr light($i) $inc1
	} else {
	    incr light($i) $inc2
	}
	if {$light($i) > 255} {
	    set light($i) 255
	}
    }
    setifunset TKGactivebackground [format #%02x%02x%02x $light(0) \
                $light(1) $light(2)]
    setifunset TKGactiveforeground $TKGbuttonforeground
    setifunset TKGhighlight $TKGactiveforeground
    setifunset TKGlabelboxbackground [tkgDarken $TKGbackground 115]
    setifunset TKGtextbackground [tkgDarken $TKGbackground 115]
    setifunset TKGlabelboxforeground $TKGforeground
    setifunset TKGmenutitleforeground \#8b0000
    setifunset TKGnoticetitleforeground \#8b0000
    setifunset TKGscrollbartrough [tkgDarken $TKGbackground 115]
    setifunset TKGentrybackground \#add8e6
    setifunset TKGbordercolor $TKGbackground


    option add *font            $TKGgeneralfont   widgetDefault
    option add *combotext.font       $TKGcombofont     widgetDefault
    option add *Button.font     $TKGlabelonlyfont     widgetDefault
    option add *Menu*font       $TKGlabelonlyfont     widgetDefault
    option add *plate*font      $TKGlabelboxfont  widgetDefault
    option add *view.text.font  $TKGdialogfont    widgetDefault
    option add *message.font    $TKGdialogfont    widgetDefault
    option add *title.title.font $TKGdialogtitlefont widgetDefault

    option add *background                $TKGbackground
    option add *Button.background         $TKGbuttonbackground
    option add *Button.foreground         $TKGforeground
    option add *activeBackground          $TKGactivebackground
    option add *activeForeground          $TKGactiveforeground
    option add *highlightBackground	  $TKGbackground
    option add *highlightColor		  $TKGhighlight
    option add *Label.foreground	  $TKGforeground
    option add *image*foreground          $TKGbuttonforeground
    option add *image.background          $TKGbuttonbackground
    option add *text.foreground           $TKGbuttonforeground
    option add *plate*background          $TKGlabelboxbackground
    option add *plate*foreground          $TKGlabelboxforeground
    option add *text.background           $TKGtextbackground
    option add *Scrollbar.troughColor     $TKGscrollbartrough
    option add *Entry.background          $TKGentrybackground
}
}

#part of standard tk4.0 library, copied here in case it disappers
proc tkgDarken {color percent} {
    set l [winfo rgb . $color]
    set red [expr [lindex $l 0]/256]
    set green [expr [lindex $l 1]/256]
    set blue [expr [lindex $l 2]/256]
    set red [expr ($red*$percent)/100]
    if {$red > 255} {
        set red 255
    }
    set green [expr ($green*$percent)/100]
    if {$green > 255} {
        set green 255
    }
    set blue [expr ($blue*$percent)/100]
    if {$blue > 255} {
        set blue 255
    }
    format #%02x%02x%02x $red $green $blue
}
    
proc DEBUG { string } {
  global logfileid TKGlogging TKGLog
  if $TKGlogging {
    puts $logfileid $string
    flush $logfileid
  }
  append TKGLog "$string\n"
  if [winfo exists .tkglog] {
    .tkglog.view.text configure -state normal
    .tkglog.view.text insert end "$string\n"
    .tkglog.view.text configure -state disabled
    .tkglog.view.text see end
  }
}

proc TKGViewLog {} {
  global TKGLog
  TKGDialog tkglog\
      -wmtitle "tkgoodstuff Log"\
      -title "tkgoodstuff Log"\
      -text "$TKGLog"
  .tkglog.view.text see end
}

proc iconify {} {
    wm iconify .
}

proc restart {} {
  global source_dir argv
  catch {close $logfileid}
  eval exec tkgoodstuff $argv &
  destroy .
}

proc quit {} {
  catch {close $logfileid}
  destroy .
}

proc setifunset { varname value } {
    set dontdoit [ uplevel [list info exists $varname ] ]
    if { ! $dontdoit } {
	uplevel [list set $varname $value]
    }
}


# Procedures called in rc files:

proc Client { tkg_client { optionlist {} } } {
    global Clients CreateClientWindows source_dir 
    lappend Clients $tkg_client
    lappend CreateClientWindows "create-$tkg_client-window"
    uplevel 1 "source $source_dir/$tkg_client.tcl"
}

proc AddButton args {
    global CreateClientWindows 
    if { [ set i [lsearch $args "-imagefile"]] != -1 } {
	SetImage [lindex $args 0]-image [lindex $args [expr $i + 1]]
	set args [lreplace $args [expr $i] [expr $i +1] -image [lindex $args 0]-image]
    }
    foreach switch {foreground background activeforeground activebackground} {
	if { [ set i [lsearch $args -$switch]] != -1 } {
	    set args [lreplace $args $i $i -[set switch](normal)]
	}
    }
    lappend CreateClientWindows "TKGButton $args"
}

proc AddLabelBox args {
    global CreateClientWindows 
    lappend CreateClientWindows "create-label-box $args"
}

proc SubStack args {
    global CreateClientWindows
    lappend CreateClientWindows "StartStack $args"
}

proc EndSubStack args {
    global CreateClientWindows
    lappend CreateClientWindows "FinishStack $args"
}


# Procedures to draw and configure client buttons

proc StartStack { {stackorientation vertical} {borderwidth 0} {color "" }} {
  global StackIndex TKG_stackprefix TKG_stackside TKG_pedigree
  global CurrentSide
  incr StackIndex
  lappend TKG_pedigree $StackIndex
  set TKG_stackprefix $TKG_stackprefix.stack$StackIndex
  if { $stackorientation == "vertical" } {
    set TKG_stackside($StackIndex) top
  } else {
    set TKG_stackside($StackIndex) left
  }
  set CurrentSide $TKG_stackside($StackIndex)
  if {$color != ""} {
      frame $TKG_stackprefix -relief ridge \
	      -borderwidth $borderwidth -background $color
  } else {
      frame $TKG_stackprefix -relief ridge \
	      -borderwidth $borderwidth
  }
}

proc FinishStack {} {
  global StackIndex TKG_stackprefix TKG_stackside TKG_pedigree
  global CurrentSide

  set childstack $TKG_stackprefix
  set TKG_pedigree [split [lrange $TKG_pedigree 0 [expr ([llength $TKG_pedigree] -2)]]]
  set parentindex [lindex $TKG_pedigree end ]
  set lastperiod [expr [string last . $TKG_stackprefix ] - 1] 
  if {$lastperiod > -1} {
    set TKG_stackprefix [string range $TKG_stackprefix 0 $lastperiod ]
  } else {
    set TKG_stackprefix ""
  }
  set CurrentSide $TKG_stackside($parentindex)
  pack $childstack -side $CurrentSide -fill both -expand y
}

proc TKGButton args {
    global labelsonly iconsonly TKGlabelonlyfont
    global TKG_stackprefix CurrentSide
    global TKGbuttonbackground TKGbuttonforeground TKGactivebackground
    global TKGactiveforeground TKG_imageside

    set name [lindex $args 0]
    global $name-params
    set lcname [string tolower $name]
    set labelvar [set name]-msg
    global $labelvar
    if ![info exists $name-params(window)] {
	set pathname $TKG_stackprefix.$lcname
    } else {
	set pathname [set $name-params(window)]
    }
    global [set name]_window
    set [set name]_window $pathname
    set $name-params(window) $pathname

    # Parse switches
    setifunset $name-params(text) ""
    setifunset $name-params(image) ""
    setifunset $name-params(imageside) $TKG_imageside
    setifunset $name-params(state) normal
    setifunset $name-params(mode) normal
    set simple-switches {text image unixcmd tclcmd staydown imageside \
			 state mode } 
    set modesensitive-switches  { foreground background \
			 activeforeground activebackground } 
    foreach switch [set simple-switches] {
	set config-$switch 0
    }
    set config-colors 0
    for { set i 1 } { $i < [llength $args] } {incr i 2} {
	set parsed 0
	foreach switch [set simple-switches] {
	    if { [lindex $args $i] == "-$switch" } {
		set $name-params($switch) [lindex $args [expr $i + 1]]
		set config-$switch 1
		set parsed 1
		break
	    }
	}
	foreach switch [set modesensitive-switches] {
	    if [regexp -- "-$switch\\((.*)\\)" [lindex $args $i] whatever s] {
		set $name-params([set switch]($s)) [lindex $args [expr $i + 1]]
		set parsed 1
		if [string match [set $name-params(mode)] $s] {
		    set config-colors 1
		}
	    }
	}
	if !$parsed  {
	    tkerror "Unknown switch to button \"$name\": [lindex $args $i]"
	}
    }
	
    # Create button if we haven't already
    if ![winfo exists $pathname] {
	DEBUG "creating $pathname"
	setifunset $name-params(foreground(normal)) $TKGbuttonforeground
	setifunset $name-params(background(normal)) $TKGbuttonbackground
	setifunset $name-params(activeforeground(normal)) $TKGactiveforeground
	setifunset $name-params(activebackground(normal)) $TKGactivebackground
	set config-colors 1
	set stackside $CurrentSide
	frame $pathname \
	    -relief raised -borderwidth 3
	pack $pathname -side $stackside -fill both -expand y
	bind $pathname <Enter> "
            TKGButton $name -state active
        "
	bind $pathname <Leave> "
           TKGButton $name -state normal
        "
    }

    # Handle the config flags
    set configflags ""
    if [set config-image] {
	if {!$labelsonly || ( [set $name-params(text)] == "" ) } {
	    if { [set $name-params(image)] != ""  } {
		if ![winfo exists $pathname.image] {
		    label $pathname.image -image [set $name-params(image)]
		    pack $pathname.image -expand y -fill both \
			-side [set $name-params(imageside)]
		} else {
		    $pathname.image config -image [set $name-params(image)]
		} 
		set config-colors 1
	    } else {
		catch "destroy $pathname.image"
	    }
	}
    }
    if [set config-text] {
	if { (!$iconsonly) || ( [set $name-params(image)] == "" ) } {
	    if { [set $name-params(text)] !=  "" } {
		if ![winfo exists $pathname.combotext] {
		    label $pathname.combotext -textvariable $name-params(text)
		    if { $labelsonly || ( "[set $name-params(image)]" == "" ) } {
			$pathname.combotext configure -font $TKGlabelonlyfont
			set expand "-expand y"
		    } else {
			set expand "-expand n"
		    }
		    eval pack $pathname.combotext -anchor s $expand -fill both \
			 -side [set $name-params(imageside)]
		}
	    } else {
		catch "destroy $pathname.combotext"
	    }
	}
    }
    if [set config-unixcmd] {
	RecursiveBind $pathname <1> "\
		 if !\[info exists $name-params(pid)\] \{
		      $pathname configure -relief sunken
		      set $name-params(pid) \[ eval exec \[set $name-params(unixcmd)\] & \]
              set TKG_async_map($name-waitpid) \[list 3 \$TKGcounter \"TKG_pidgone $name\"\]
           \}
        "       
	setifunset $name-params(staydown) 1
	set config-staydown 1
    }
    if [set config-tclcmd] {
	RecursiveBind $pathname <1> "\
           if \{ \[$pathname cget -relief\] != \"sunken\" \} \{
              $pathname configure -relief sunken
              [set $name-params(tclcmd)]
           \}
        "       
	set $name-params(staydown) 0
	set config-staydown 1
    }
    if [set config-staydown] {
	switch [set $name-params(staydown)] {
	    0 {
		RecursiveBind $pathname <ButtonRelease-1> \
		    "after 750 \{ $pathname configure -relief raised \}"
	    } 1 {
	    RecursiveBind $pathname <ButtonRelease-1> \
               "if !\[info exists $name-params(pid)\] \{
                  after 750 \{ $pathname configure -relief raised \}
               \}"
	    }
	}
    }
    if { [set config-state ] || [set config-mode] } {
	set config-colors 1
    }
    if [set config-colors] {
	foreach coltype  "foreground background activeforeground activebackground" {
	    if [info exists $name-params([set coltype]([set $name-params(mode)]))] {
		set our$coltype [set $name-params([set coltype]([set $name-params(mode)]))] 
	    } else { 
		set our$coltype [set $name-params([set coltype](normal))]
	    }
	}
	switch [set $name-params(state)] {
	    normal {
		ColorConfig $pathname $ourforeground $ourbackground
		catch { 
		    [set $name-params(image)] configure -foreground $ourforeground
		    [set $name-params(image)] configure -background $ourbackground
		}
	    } active {
		ColorConfig $pathname $ouractiveforeground $ouractivebackground
		catch { 
		    [set $name-params(image)] configure -foreground $ouractiveforeground
		    [set $name-params(image)] configure -background $ouractivebackground
		}
	    }
	}
    }
}

proc TKG_pidgone {name} {
    global $name-params TKG_async_map
    if [info exists $name-params(pid)] {
	catch "exec ps [set $name-params(pid)]" line
	if ![string match *[set $name-params(pid)]* $line] {
	    unset $name-params(pid)
	    unset TKG_async_map($name-waitpid)
	    [set $name-params(window)] config -relief raised
	}
    }
}

proc create-label-box { name label {labelvarlist {} } } {
    global TKG_stackprefix CurrentSide 

    set lcname [string tolower $name]
    set window $TKG_stackprefix.$lcname
    DEBUG "creating $window"
    global [set name]_window
    set [set name]_window $window
    frame $window -relief raised -borderwidth 2
    frame $window.plate -relief sunken -borderwidth 1

    if { "$label" != "-" } { 
	lappend labelvarlist "$lcname-main-label"
	global $lcname-main-label
	set $lcname-main-label $label
     }
    foreach labelvar $labelvarlist {
	frame $window.plate.$labelvar
	label $window.plate.$labelvar.msg \
		-textvariable $labelvar
	pack $window.plate.$labelvar.msg -expand y
	pack $window.plate.$labelvar -fill both -expand y 
    }
    pack $window.plate -fill both -expand y
    pack $window -side $CurrentSide -expand y -fill both
}

proc SetImage { name file } {
    global TKG_imagetypelist
    foreach imagetype $TKG_imagetypelist {
	if {! [catch { image create $imagetype $name -file $file }]} {
	    return $imagetype
	} 
    }
    tkerror "File $file does not contain an image we can parse."
}    
  
proc TKGCenter {w} {
    update
    set x [expr ([winfo screenwidth $w] - [winfo reqwidth $w] )/2]
    set y [expr ([winfo screenheight $w] - [winfo reqheight $w] )/2]
    wm geometry $w +$x+$y
    wm deiconify $w
}

proc ColorConfig { pathname fore back } {
    foreach child [winfo children $pathname] {
      ColorConfig $child $fore $back
    }
  if { "$fore" != "-" } { 
    catch "$pathname configure -foreground $fore"
  }
  if { "$back" != "-" } { 
    catch "$pathname configure -background $back"
  }
}

proc RecursiveBind { pathname seq command } {
    foreach window [winfo children $pathname] {
	RecursiveBind $window $seq $command
    }
    bind $pathname $seq $command
}


# Procedure to create a dialog with buttons and (optionally) a title (with image if
# wanted), message (box with a message widget), and text (a text widget with
# scrollbar)

proc TKGDialog args {
    global TKGbackground TKGforeground
    
    set name [lindex $args 0]
    set wmtitle "tkgoodstuff Notice"
    set image ""
    set title ""
    set titlebg $TKGbackground
    set titlefg $TKGforeground
    set bitmapfg $TKGforeground
    set message ""
    set text "-"
    set buttons {}
    set switches {wmtitle image title titlebg titlefg \
		      bitmapfg message text buttons}
    foreach switch $switches {
	if { [ set i [lsearch $args "-$switch"]] != -1 } {
	    set $switch [lindex $args [expr $i + 1]]
	}
    }
    catch {destroy .$name}
    set oldfocus [focus]
    toplevel .$name 
    wm withdraw .$name
    wm title .$name "$wmtitle"
    wm minsize .$name 20 10
    if { ! ( $image == "" && $title == "" ) } {
	frame .$name.title -background $titlebg
	if { $image != "" } {
	    if {[SetImage $name-image $image] == "bitmap"} {
		set imageoption "-bitmap @$image"
	    } else {
		set imageoption "-image $name-image"
	    }
	    eval label .$name.title.icon $imageoption \
		-foreground $bitmapfg -background $titlebg
	    pack .$name.title.icon -side left -padx 20 -pady 6 
	}
	if { $title != "" } {
	    label .$name.title.title -text "$title" \
		-foreground $titlefg -background $titlebg
	    pack .$name.title.title -side left -padx 6 -pady 8 
	}
	pack .$name.title -fill x -expand y
    }
    if { $message != "" } {
	message .$name.message  -text $message \
	    -relief ridge -borderwidth 3 \
	    -width 18c
	pack .$name.message -padx 10 -pady 10
    }
    if { $text  != "-" } {
	frame .$name.view
	text .$name.view.text -width 80 -height 20 \
	    -takefocus 0 -yscrollcommand ".$name.view.scrollbar set" \
	    -relief sunken -borderwidth 2 -state disabled
	pack .$name.view.text -side left -fill both -expand 1
	scrollbar .$name.view.scrollbar -command ".$name.view.text yview"
	pack .$name.view.scrollbar -side left -fill y -padx 3
	pack .$name.view -side top -fill both -expand 1 -padx 5
	.$name.view.text configure -state normal
	.$name.view.text insert end "$text"
	.$name.view.text configure -state disabled
    }
    frame .$name.buttons
    foreach button $buttons {
	set buttonname [lindex $button 0]
	button .$name.buttons.$buttonname \
	    -text [lindex $button 1] \
	    -command [lindex $button 2]
	pack .$name.buttons.$buttonname -side left -expand yes -padx 10
    }
    if { [lsearch $args "-nodismiss"] == -1 } {
	button .$name.buttons.dismiss -text Dismiss \
	    -command "destroy .$name ; focus $oldfocus"
	pack .$name.buttons.dismiss -side left -expand yes -padx 10
    }
    pack .$name.buttons -fill x -padx 12 -pady 10 -side bottom
    TKGCenter .$name
    DEBUG "creating popup: .$name"
    catch {focus .$name.buttons.dismiss}
}

proc TKGError string {
    global images
    TKGDialog tkgerror -image $images/warning -title "Error:"\
	-message $string
}


# Main Window

proc TKGcreatemainwindow {} {
  global TKG_geometry geometry TKG_border TKGbordercolor argv 
  global CurrentSide TKG_stackside TKG_orientation
  
  . config -bg $TKGbordercolor
  . config -relief ridge -borderwidth $TKG_border
  wm minsize . 10 10
  if [ info exists geometry ] { set TKG_geometry $geometry }
  wm geometry . $TKG_geometry
  wm title . tkgoodstuff
  wm iconname . tkgoodstuff
  bind . <Q> quit
  bind . <Control-c> quit
  bind . <i> {wm iconify .}

  if { $TKG_orientation == "horizontal" } {
    set TKG_stackside(0) left
  } else { 
    set TKG_stackside(0) top
  }
  set CurrentSide $TKG_stackside(0)
}


# Loop for all background processing.
# TKG_async_map is an array each of whose values is a list of:
#   (0) an interval (in seconds) between executions
#   (1) an offset (in seconds) between program start and first execution
#   (2) the command to execute at that interval after that offset

proc TKG_async {} {
    global TKG_async_map TKGcounter

    after 1000 {incr TKGcounter; TKG_async}

    foreach tkg_entry [array names TKG_async_map] {
	set TKGinterval [lindex $TKG_async_map($tkg_entry) 0]
	set TKGoffset [lindex $TKG_async_map($tkg_entry) 1]
	if { ( $TKGcounter - $TKGoffset >= 0 ) && ( ($TKGcounter - $TKGoffset) % $TKGinterval == 0 ) } {
	    eval [lindex $TKG_async_map($tkg_entry) 2]
	}
    }
} 


# Set up popup menu (clients add items to it; Clock client binds it to
# a mouse button; probably I should add some binding for users who don't
# want the clock).

proc TKGPopupInit {} {
  global TKGmenutitleforeground TKGpopupplace

  menu .tkgpopup  -disabledforeground $TKGmenutitleforeground

  .tkgpopup add command -state disabled -label "+++ TkGoodStuff Menu +++"
  .tkgpopup add separator
  .tkgpopup add command \
      -label "About tkgoodstuff (help)" -command { TKGAbout }
  .tkgpopup add command \
      -label "View tkgoodstuff Log" -command { TKGViewLog }
  .tkgpopup add separator
  set TKGpopupplace "No Notices"
  .tkgpopup add checkbutton -label "$TKGpopupplace" -variable TKG_nonotices
  .tkgpopup add checkbutton -label "No Beeps" -variable TKG_nobeep
  .tkgpopup add separator
  .tkgpopup add command \
	  -label "Iconify tkgoodstuff" -command iconify
  .tkgpopup add command \
      -label "Restart tkgoodstuff" -command restart
  .tkgpopup add command \
      -label "Exit tkgoodstuff" -command quit
  .tkgpopup add separator
}

proc TKGPopupPost {x y} {
    global TKG_orientation
    set wx [winfo x .]
    set wy [winfo y .]
    set nx $wx
    set ny $wy
    if {$TKG_orientation == "horizontal"} {
	if {$wy < ([winfo screenheight .]/2)} {
	    set ny [expr $wy + [winfo height .]]
	} 
    } else {
	if {$x < ([winfo screenwidth .]/2)} {
	    set nx [expr $wx + [winfo width .]]
	}
    }
    # give ourselves room for cascades
    if { $nx > ( [winfo screenwidth .] - 450 ) } {
	set nx [expr [winfo screenwidth .] - 450 ]
    }
	
  tk_popup .tkgpopup $nx $ny
}

proc TKGPopupAdd args {
  global TKGpopupplace
  eval .tkgpopup insert \"$TKGpopupplace\" $args
}

proc TKGPopupAddClient {client} {
  global TKGpopupplace
  .tkgpopup insert "$TKGpopupplace" cascade\
	  -label "[string toupper $client]:" \
	  -menu ".tkgpopup.[string tolower $client]"
  .tkgpopup insert "$TKGpopupplace" separator
  menu ".tkgpopup.[string tolower $client]" -tearoff 0 -tearoff 0
}

proc TKGAbout {} {
    global TKG_version TKG_releasedate source_dir TKG_browser TKG_webpage
    set message "
tkgoodstuff version $TKG_version, $TKG_releasedate, copyright 1995 Mark Crimmins (markcrim@umich.edu).

Documentation exists only in html form.  Launch $TKG_browser to view\
either the documentation on your local system or the up-to-date\
documentation on the tkgoodstuff web page by clicking on the\
corresponding button.
"
    TKGDialog about \
	-wmtitle "About tkgoodstuff"\
	-title "About tkgoodstuff"\
	-buttons { 
	    { localdoc
		"Local\ndocumentation" 
		{exec $TKG_browser $source_dir/doc/tkgoodstuff.html &
                 destroy .about
                }
	    }
	    { webdoc
		"Net\ndocumentation" 
		{exec $TKG_browser $TKG_webpage &
                 destroy .about
                }
	    }
	} \
    -message $message
}


##############################################################
# Main Program:
##############################################################

# initialize some variables
set TKGcounter 0
set Clients ""
set CreateClientWindows ""
set StackIndex 0
set TKG_stackprefix ""
set TKG_pedigree {0}
set TKGLog ""

# open log file if wanted
if $TKGlogging {
  set logfileid [open $TKGlogfile w+]
}
DEBUG "TKG Log starting."

# find setup config file
set cmdlinepos [expr [ lsearch $argv "-f" ] + 1]
if { $cmdlinepos != 0 } {
  set TKG_configfile [lindex $argv $cmdlinepos ]
} elseif [expr ( [ lsearch [array names env ] TKGOODSTUFFRC ] != -1 )] {
      set TKG_configfile $env(TKGOODSTUFFRC)
} elseif [file exists $env(HOME)/.tkgoodstuffrc] {
    set TKG_configfile $env(HOME)/.tkgoodstuffrc
} else {
    set TKG_configfile $source_dir/system-tkgoodstuffrc
}
if ![file exists $TKG_configfile] {
    TKGError "Configuration file $TKG_configfile does not exist; cannot start."
}
if ![file readable $TKG_configfile] {
    TKGError "Configuration file $TKG_configfile is not readable; cannot start."
}               
      
#check if xpm's are handled by the interpreter
if ![catch { image create pixmap tempimage -file $images/biffno.xpm }] {
    set TKG_defformat xpm
    DEBUG "This interpreter can parse xpm's"
    image delete tempimage
} else {
    set TKG_defformat xbm
    DEBUG "This interpreter cannot parse xpm's"
} 
      
# get the setup info
source $TKG_configfile

# set resources 
TKG_setresources

# initialize the popup menu
TKGPopupInit

# initialize the main window
TKGcreatemainwindow

# wait till we're pretty
wm withdraw .

# be sure we have a client
if {$Clients == ""} {
    Client Clock
}

foreach command $CreateClientWindows {
   eval $command
}

# now show the world
update
wm deiconify .

# Run periodic commands in background
after 0 TKG_async
