# Ical (calendar program) alarm and launching Client for tkgoodstuff
# Does not draw own button: requires Clock client for tkgoodstuff

# Mark Crimmins (markcrim@umich.edu)

# These settings can be overridden in ~/.tkgoodstuffrc

set Ical_file "$env(HOME)/.calendar"

set Ical_enablealarms 1
set Ical_nobeep 0

# How often to check calendar file for new items? (in seconds)
set Ical_fetch_interval 120
set Ical_check_interval 60

set Ical_fetch_offset 10

set Ical_items_command {ical -list}

set Ical_script $source_dir/Ical-fetch.tcl

setifunset ClockForeground chartreuse1

# initialize variables
set Ical_itemlist {}
set Ical_ignore {}
set Ical_filesize 0
set Ical_oldfilesize 0

if { [lsearch $Clients Clock ] == -1 } {
    error {'Client Clock' must be before 'Client Ical' in your ~/.tkgoodstuffrc}
}

proc create-Ical-window {} {
    global Ical_file
    if ![file exists $Ical_file] {
	TKGError "File \"$Ical_file\" (the value of the variable Ical_file) does\
not exist.  Aborting Ical support." 
	return 0
    }
    if ![file readable $Ical_file] {
	TKGError "File \"$Ical_file\" (the value of the variable Ical_file) is\
not readable.  Aborting Ical support." 
	return 0
    }
    # Arrange async processing
    global Ical_fetch_interval Ical_fetch_offset Ical_fetch
    set TKG_async_map(Ical_fetch) [ list $Ical_fetch_interval $Ical_fetch_offset Ical_fetch ]

    # we make a ring around the clock to show we're loaded
    global TKGbuttonbackground Clock_window ClockForeground
    $Clock_window configure -background $ClockForeground
    RecursiveBind $Clock_window <2> Ical_launch
    TKGPopupAddClient Ical
    .tkgpopup.ical add  command \
	-label "Today's Calendar Items" \
	-command {Ical_list_items}
    .tkgpopup.ical  add command \
	-label "View Calendar" \
	-command {Ical_launch}
    .tkgpopup.ical add checkbutton \
	-label "Enable Alarms" \
	-variable {Ical_enablealarms}
    return 1
}

proc Ical_list_items {} {
    global Ical_items_command source_dir TKG_tmp_dir 
    global TKGcounter TKG_async_map images

    set id [pid]
    exec sh -c "( $Ical_items_command | cut -c 1-80 \
		> $TKG_tmp_dir/tkg_ical_tmp.$id \; \
		mv -f $TKG_tmp_dir/tkg_ical_tmp.$id \
		   $TKG_tmp_dir/tkg_ical_done.$id) " &
    set TKG_async_map(Ical_postlist) [list 3 [expr $TKGcounter +3] [list Ical_postlist $id ]]
    set TKG_async_map(Ical_listfail) [list 1 [expr $TKGcounter +30] [list Ical_listfail $id] ]
    TKGDialog ical_items \
	-wmtitle "tkgoodstuff: Calendar Items" \
	-title "Calendar Items" \
	-image $images/calendar.xbm\
	-message "Reading calendar . . ."
}

proc Ical_listfail {id} {
    global TKG_tmp_dir TKG_async_map
    DEBUG "Ical list fetch failed"
    unset TKG_async_map(Ical_postlist)
    unset TKG_async_map(Ical_listfail)
    TKGDialog ical_items \
	-wmtitle "tkgoodstuff: Calendar Items" \
	-title "Error"\
	-message "Sorry, something went wrong with fetching today's items: \
they never showed up in the file $TKG_tmp_dir/tkg_ical_done.$id"
}

proc Ical_postlist {id} {
    global TKG_tmp_dir images TKG_async_map
    if [ file exists $TKG_tmp_dir/tkg_ical_done.$id ] {
	DEBUG "Ical list fetch succeeded"
	unset TKG_async_map(Ical_postlist)
	unset TKG_async_map(Ical_listfail)
	catch {exec cat $TKG_tmp_dir/tkg_ical_done.$id } ical_items_text
	catch {exec rm -f $TKG_tmp_dir/tkg_ical_done.$id } 
	if { $ical_items_text == "" } {
	    set ical_items_text "No items in the calendar for today."
	}
	TKGDialog ical_items \
	    -wmtitle "tkgoodstuff: Calendar Items" \
	    -title "Calendar Items" \
	    -image $images/calendar.xbm\
	    -message $ical_items_text \
	    -buttons {
		{ 
		    view "View Calendar" {
			destroy .ical_items
			Ical_launch
		    }
		}
	    }
    }
}

proc Ical_launch {} {
    exec ical &
}

proc Ical_fetch {} {
  global Ical_script Ical_itemlist Ical_ignore
  global Ical_filesize Ical_oldfilesize Ical_file
  global Ical_check_interval TKGcounter  TKG_async_map
  global Ical_enablealarms TKG_tmp_dir

  if {$Ical_enablealarms == 0} {return}

  if [ catch {set Ical_filesize [eval file size $Ical_file] } errtxt ] {
    # calendar file doesn't exist
    DEBUG $errtxt
    unset TKG_async_map(Ical_fetch)
    catch unset TKG_async_map(Ical_check)
  }
  if { $Ical_filesize != $Ical_oldfilesize } {
    set Ical_itemlist {}
    DEBUG "Starting Ical fetch in background.  Wish us luck."
      set id [pid]
    exec sh -c "( ical -f $Ical_script > $TKG_tmp_dir/tkg_icalf_tmp.$id \; \
		mv -f $TKG_tmp_dir/tkg_icalf_tmp.$id \
		   $TKG_tmp_dir/tkg_icalf_done.$id) " &
    set TKG_async_map(Ical_finishfetch) [list 3 [expr $TKGcounter +3] [list Ical_finishfetch $id ]]
    set TKG_async_map(Ical_fetchfail) [list 1 [expr $TKGcounter +20] [list Ical_fetchfail $id] ]
  }
  set Ical_oldfilesize $Ical_filesize
}
    
proc Ical_fetchfail {id} {
    global TKG_tmp_dir TKG_async_map
    DEBUG "Ical list fetch failed"
    unset TKG_async_map(Ical_finishfetch)
    unset TKG_async_map(Ical_fetchfail)
    TKGDialog ical_items \
	-wmtitle "tkgoodstuff: Ical fetch" \
	-title "Error"\
	-message "Sorry, something went wrong with fetching today's items: \
they never showed up in the file $TKG_tmp_dir/tkg_icalf_done.$id"
}

proc Ical_finishfetch {id} {
    global TKG_tmp_dir images TKG_async_map TKGcounter Ical_check_interval
    global Ical_check_offset Ical_itemlist Clock_offset
    if [ file exists $TKG_tmp_dir/tkg_icalf_done.$id ] {
	DEBUG "Ical fetch succeeded"
	unset TKG_async_map(Ical_finishfetch)
	unset TKG_async_map(Ical_fetchfail)
	catch {exec cat $TKG_tmp_dir/tkg_icalf_done.$id } Ical_fetch_out
	catch {exec rm -f $TKG_tmp_dir/tkg_icalf_done.$id } 
	eval $Ical_fetch_out
	if { $Ical_fetch_out != "" } {
	    DEBUG "Ical fetch output:"
	    DEBUG $Ical_fetch_out
	    DEBUG "   (end fetch output)"
	} else {
	    DEBUG "No output from Ical fetch (hopefully, because no calendar items)."
	}
	set check_offset [expr $TKGcounter + 1]
	set TKG_async_map(Ical_check) [ list $Ical_check_interval $Clock_offset Ical_check ]
    } 
}

proc Ical_check {} {
    global Ical_itemlist Ical_ignore
    global Ical_enablealarms TKG_nonotices

    if { ( (!$Ical_enablealarms) || $TKG_nonotices )} {return}

    #get minutes since midnight today
    scan [ exec date {+%k %M}] "%s %s" nowhour nowminute
    set now [expr ( ( $nowhour * 60 ) + ( [expr \"a$nowminute\" == \"a00\"] ? 0: [string trimleft $nowminute {0} ] ) ) ]

if [llength $Ical_itemlist] {
    set alarmlist {}
     foreach item $Ical_itemlist {
	 set start [lindex $item 0]
	 set alarms [lindex $item 1]
	 foreach t $alarms {
	     if  { $start - $t == $now && [lsearch $Ical_ignore $item] == -1} {
		 lappend alarmlist $item
	     }
	 }
     }
     if [llength $alarmlist] {
	 Ical_alarm $alarmlist
     }
 }
}

proc Ical_alarm { alarmlist } {
    global Ical_oldalarmlist Ical_oldfocus formatted_items 
    global Ical_nobeep TKG_nobeep Clock_prettytime images

    set formatted_items {}
    foreach item [lsort $alarmlist] {
	set start [lindex $item 0]
	set text [lindex $item 2]
	set realhour [expr ((($start/60)%12) == 0) ? 12 : (($start/60)%12)] 
	set realtime "$realhour:[format %02i [expr $start % 60]]"
	lappend formatted_items [list $realtime $text $item]
    }

    TKGDialog ical_alarm \
	-wmtitle "tkgoodstuff: Ical Alarm" \
	-image $images/warning \
        -title "Ical Alarm        It's $Clock_prettytime" \
	-nodismiss \
	-buttons {
	    {
		dismiss
		Dismiss
		{ 
		    for {set j 0} {$j <  [llength $formatted_items]} {incr j} {
			if [eval "expr \$item$j"] {
			    eval "lappend Ical_ignore \
                              [list [lindex [lindex $formatted_items $j] 2]]"
			    DEBUG "TKG Ical: ignoring [lindex [lindex $formatted_items $j] 2]"
			}
		    }   
		    destroy .ical_alarm
		}
	    } {
		noalarms
		"No Alarms!"
		{
		    set Ical_enablealarms 0
		    destroy .ical_alarm
		}
	    } {
		view
		"View Calendar"
		{
		    destroy .ical_alarm
		    Ical_launch
		}
	    }
	}

    frame .ical_alarm.items -relief ridge -borderwidth 3
    set i 0
    foreach item $formatted_items {
	frame .ical_alarm.items.item$i
	set item$i 0
	checkbutton .ical_alarm.items.item$i.time$i -text [lindex $item 0] \
		-variable item$i
	label .ical_alarm.items.item$i.text$i -text [lindex $item 1] 
	pack .ical_alarm.items.item$i.time$i -anchor nw -side left
	pack .ical_alarm.items.item$i.text$i -anchor nw -side top 
	pack .ical_alarm.items.item$i -fill x
	incr i
    }
    label .ical_alarm.instr -text "Check box to stop alarms for this item.\
	    \nClick on Dismiss when done."
    ColorConfig .ical_alarm.title black red
    pack .ical_alarm.items -after .ical_alarm.title -fill x -padx 3 -pady 3
    pack .ical_alarm.instr -after .ical_alarm.items -fill x -padx 3 -pady 3
    if { !($Ical_nobeep || $TKG_nobeep) } { bell }
}

DEBUG "Loaded Ical.tcl"
