#
# This is the tk4.1 text.tcl file modified in a way so that the keys are
# compatible with "tkedit". This gives ALL tk-text widgets the same behavior as
# with tkedit !
# So that there should be no need to use "emacs" keys everywhere...
#

proc tkTextClipboardKeysyms {copy cut paste} {
    bind Text <$copy> {
	if {[selection own -displayof %W] == "%W"} {
	    clipboard clear -displayof %W
	    catch {
		clipboard append -displayof %W [selection get -displayof %W]
	    }
	}
    }
    bind Text <$cut> {
	if {[selection own -displayof %W] == "%W"} {
	    clipboard clear -displayof %W
	    catch {
		clipboard append -displayof %W [selection get -displayof %W]
		%W delete sel.first sel.last
	    }
	}
    }
    bind Text <$paste> {
	catch {
	    %W insert insert [selection get -displayof %W \
		    -selection CLIPBOARD]
	}
    }
}

#-------------------------------------------------------------------------
# The code below creates the default class bindings for entries.
#-------------------------------------------------------------------------

    # Standard Motif bindings:

bind Text <1> {
    tkTextButton1 %W %x %y
}
bind Text <B1-Motion> {
    set tkPriv(x) %x
    set tkPriv(y) %y
    tkTextSelectTo %W %x %y
}
bind Text <Double-1> {
    set tkPriv(selectMode) word
    tkTextSelectTo %W %x %y
    catch {%W mark set insert sel.first}
}
bind Text <Triple-1> {
    set tkPriv(selectMode) line
    tkTextSelectTo %W %x %y
    catch {%W mark set insert sel.first}
}
bind Text <Shift-1> {
    tkTextResetAnchor %W @%x,%y
    set tkPriv(selectMode) char
    tkTextSelectTo %W %x %y
}
bind Text <Double-Shift-1>	{
    set tkPriv(selectMode) word
    tkTextSelectTo %W %x %y
}
bind Text <Triple-Shift-1>	{
    set tkPriv(selectMode) line
    tkTextSelectTo %W %x %y
}
bind Text <B1-Leave> {
    set tkPriv(x) %x
    set tkPriv(y) %y
    tkTextAutoScan %W
}
bind Text <B1-Enter> {
    tkCancelRepeat
}
bind Text <ButtonRelease-1> {
    tkCancelRepeat
}
bind Text <Control-1> {
    %W mark set insert @%x,%y
}
bind Text <Left> {
    tkTextSetCursor %W [%W index {insert - 1c}]
}
bind Text <Right> {
    tkTextSetCursor %W [%W index {insert + 1c}]
}
bind Text <Up> {
    tkTextSetCursor %W [tkTextUpDownLine %W -1]
}
bind Text <Down> {
    tkTextSetCursor %W [tkTextUpDownLine %W 1]
}
bind Text <Shift-Left> {
    tkTextSetCursor %W [%W index {insert - 1c wordstart}]
}
bind Text <Shift-Right> {
    tkTextSetCursor %W [%W index {insert wordend}]
}
bind Text <Shift-Up> {
    tkTextSetCursor %W [tkTextPrevPara %W insert]
}
bind Text <Shift-Down> {
    tkTextSetCursor %W [tkTextNextPara %W insert]
}
bind Text <Control-Left> {
    tkTextSetCursor %W [%W index {insert linestart}]
}
bind Text <Control-Right> {
    tkTextSetCursor %W [%W index {insert lineend}]
}
bind Text <Control-Up> {
    tkTextSetCursor %W 1.0
}
bind Text <Control-Down> {
    tkTextSetCursor %W [%W index end]
}
bind Text <Shift-Control-Left> {
    tkTextKeySelect %W [%W index {insert - 1c wordstart}]
}
bind Text <Shift-Control-Right> {
    tkTextKeySelect %W [%W index {insert wordend}]
}
bind Text <Shift-Control-Up> {
    tkTextKeySelect %W [tkTextPrevPara %W insert]
}
bind Text <Shift-Control-Down> {
    tkTextKeySelect %W [tkTextNextPara %W insert]
}
bind Text <Prior> {
    tkTextSetCursor %W [tkTextScrollPages %W -1]
}
bind Text <Shift-Prior> {
    tkTextKeySelect %W [tkTextScrollPages %W -1]
}
bind Text <Next> {
    tkTextSetCursor %W [tkTextScrollPages %W 1]
}
bind Text <Shift-Next> {
    tkTextKeySelect %W [tkTextScrollPages %W 1]
}
bind Text <Control-Prior> {
    %W xview scroll -1 page
}
bind Text <Control-Next> {
    %W xview scroll 1 page
}

bind Text <Home> {
    tkTextSetCursor %W {insert linestart}
}
bind Text <Shift-Home> {
    tkTextKeySelect %W {insert linestart}
}
bind Text <End> {
    tkTextSetCursor %W {insert lineend}
}
bind Text <Shift-End> {
    tkTextKeySelect %W {insert lineend}
}
bind Text <Control-Home> {
    tkTextSetCursor %W 1.0
}
bind Text <Control-Shift-Home> {
    tkTextKeySelect %W 1.0
}
bind Text <Control-End> {
    tkTextSetCursor %W {end - 1 char}
}
bind Text <Control-Shift-End> {
    tkTextKeySelect %W {end - 1 char}
}

bind Text <Tab> {
    tkTextInsert %W \t
    focus %W
    break
}
bind Text <Shift-Tab> {
    # Needed only to keep <Tab> binding from triggering;  doesn't
    # have to actually do anything.
}
bind Text <Control-Tab> {
    focus [tk_focusNext %W]
}
bind Text <Control-Shift-Tab> {
    focus [tk_focusPrev %W]
}
bind Text <Control-i> {
    tkTextInsert %W \t
}
bind Text <Return> {
    tkTextInsert %W \n
}
bind Text <Delete> {
    if {[%W tag nextrange sel 1.0 end] != ""} {
	%W delete sel.first sel.last
    } else {
	%W delete insert
	%W see insert
    }
}
bind Text <BackSpace> {
    if {[%W tag nextrange sel 1.0 end] != ""} {
	%W delete sel.first sel.last
    } elseif [%W compare insert != 1.0] {
	%W delete insert-1c
	%W see insert
    }
}

bind Text <Control-space> {
    %W mark set anchor insert
}
bind Text <Select> {
    %W mark set anchor insert
}
bind Text <Control-Shift-space> {
    set tkPriv(selectMode) char
    tkTextKeyExtend %W insert
}
bind Text <Shift-Select> {
    set tkPriv(selectMode) char
    tkTextKeyExtend %W insert
}
bind Text <Control-slash> {
    %W delete "insert linestart" "insert - 1c"
}
bind Text <Control-backslash> {
    %W tag remove sel 1.0 end
}
tkTextClipboardKeysyms F16 F20 F18
bind Text <Insert> {
    catch {tkTextInsert %W [selection get -displayof %W]}
}
bind Text <KeyPress> {
    tkTextInsert %W %A
}

# Ignore all Alt, Meta, and Control keypresses unless explicitly bound.
# Otherwise, if a widget binding for one of these is defined, the
# <KeyPress> class binding will also fire and insert the character,
# which is wrong.  Ditto for <Escape>.

bind Text <Alt-KeyPress> {# nothing }
bind Text <Meta-KeyPress> {# nothing}
bind Text <Control-KeyPress> {# nothing}
bind Text <Escape> {# nothing}
bind Text <KP_Enter> {# nothing}

# Additional emacs-like bindings
# changed also to tkedit bindings !

   bind Text <Escape> {
      %W tag delete found match
      selection clear %W
   }
   bind Text <3> {
      %W tag delete found match
      selection clear %W
   }
    bind Text <Control-a> {
        set tk_fnam [exec FileSelect]
        if {$tk_fnam != ""} {
         set f [open $tk_fnam w]
         puts $f [%W get 1.0 end]
         close $f
        }
    }
    bind Text <Control-b> {
	%W mark set sel.first insert
    }
    bind Text <Control-c> {
        %W mark set sel.last insert
        tk_ToPaste [%W get sel.first sel.last]
        selection clear %W
        %W delete sel.first sel.last
	%W see insert
    }
    bind Text <Control-d> {
        set tk_YankBuffer [%W get "insert wordstart" "insert wordend"]
	%W delete "insert wordstart" "insert wordend"
	%W see insert
    }
    bind Text <Control-e> {
        %W mark set sel.last insert
        %W tag add sel sel.first sel.last
        tk_ToPaste [%W get sel.first sel.last]
    }
    bind Text <Control-g> {
      set l [tk_Ask "LineNumber ?"]
      if {$l != ""} {%W mark set insert $l.0}
      focus %W
      %W see insert
    }
    bind Text <Control-k> {
        set tk_YankBuffer [%W get "insert linestart" "insert lineend + 1c"]
	%W delete "insert linestart" "insert lineend + 1c"
	%W see insert
    }
    bind Text <Control-l> {
      tk_ReplaceNext %W
    }
    bind Text <Control-m> {
      tk_MatchBracket %W
    }
    bind Text <Control-n> {
	tk_SearchNext %W
    }
    bind Text <Control-o> {
        set tk_fnam [exec FileSelect]
        if {$tk_fnam != ""} {
          if {[file exists $tk_fnam]} {
            set f [open $tk_fnam]
            while {![eof $f]} {
               %W insert end [read $f 8192]
            }
            close $f
         }
        }
        %W see insert
    }
    bind Text <Control-p> {
	tk_SearchPrev %W
    }
    bind Text <Control-q> {exit}
    bind Text <Control-r> {
      tk_AskSearch %W
    }
    bind Text <Control-s> {
      tk_AskSearch %W
    }
    bind Text <Control-t> {
# tables not supported here in this version
    }
    bind Text <Control-u> {
# undo is not supported in this Version
    }
    bind Text <Control-v> {
	tk_PasteFromClip %W
	%W see insert
    }
    bind Text <Control-w> {
        if {![info exists tk_fnam]} {set tk_fnam [exec FileSelect]}
        if {$tk_fnam != ""} {
         set f [open $tk_fnam w]
         puts $f [%W get 1.0 end]
         close $f
        }
    }
    bind Text <Control-x> {
        set tk_YankBuffer [%W get sel.first sel.last]
	%W delete sel.first sel.last
	%W see insert
    }
    bind Text <Control-y> {
        if {[info exists tk_YankBuffer]} {
            %W insert insert $tk_YankBuffer
        }
	%W see insert
    }
    bind Text <Control-z> {
# What shall we do here ?
    }
    bind Text <Control-period> {
        set tk_YankBuffer [%W get insert "insert lineend"]
	%W delete insert "insert lineend"
	%W see insert
    }
    bind Text <Control-comma> {
        set tk_YankBuffer [%W get insert "insert wordend"]
	%W delete insert "insert wordend"
	%W see insert
    }
    bind Text <Control-equal> {
	%W delete insert
	%W see insert
    }
    bind Text <Control-greater> {tk_Capitalize %W}
    bind Text <Control-less> {tk_LowerCase %W}
    bind Text <Meta-b> {
	tkTextSetCursor %W {insert - 1c wordstart}
    }
    bind Text <Meta-d> {
	%W delete insert {insert wordend}
    }
    bind Text <Meta-f> {
	tkTextSetCursor %W {insert wordend}
    }
    bind Text <Meta-less> {
	tkTextSetCursor %W 1.0
    }
    bind Text <Meta-greater> {
	tkTextSetCursor %W end-1c
    }
    bind Text <Meta-BackSpace> {
	%W delete {insert -1c wordstart} insert
    }
    bind Text <Meta-Delete> {
	%W delete {insert -1c wordstart} insert
    }
#    tkTextClipboardKeysyms Meta-w Control-w Control-y

    # A few additional bindings of my own.

    bind Text <Control-h> {
	if [%W compare insert != 1.0] {
	    %W delete insert-1c
	    %W see insert
	}
    }
    bind Text <2> {
	%W scan mark %x %y
	set tkPriv(x) %x
	set tkPriv(y) %y
	set tkPriv(mouseMoved) 0
    }
    bind Text <B2-Motion> {
	if {(%x != $tkPriv(x)) || (%y != $tkPriv(y))} {
	    set tkPriv(mouseMoved) 1
	}
	if $tkPriv(mouseMoved) {
	    %W scan dragto %x %y
	}
    }
    bind Text <ButtonRelease-2> {
	if !$tkPriv(mouseMoved) {
	    catch {
		%W insert @%x,%y [selection get -displayof %W]
	    }
	}
    }
set tkPriv(prevPos) {}

# tkTextButton1 --
# This procedure is invoked to handle button-1 presses in text
# widgets.  It moves the insertion cursor, sets the selection anchor,
# and claims the input focus.
#
# Arguments:
# w -		The text window in which the button was pressed.
# x -		The x-coordinate of the button press.
# y -		The x-coordinate of the button press.

proc tkTextButton1 {w x y} {
    global tkPriv

    set tkPriv(selectMode) char
    set tkPriv(mouseMoved) 0
    set tkPriv(pressX) $x
    $w mark set insert @$x,$y
    $w mark set anchor insert
    if {[$w cget -state] == "normal"} {focus $w}
}

# tkTextSelectTo --
# This procedure is invoked to extend the selection, typically when
# dragging it with the mouse.  Depending on the selection mode (character,
# word, line) it selects in different-sized units.  This procedure
# ignores mouse motions initially until the mouse has moved from
# one character to another or until there have been multiple clicks.
#
# Arguments:
# w -		The text window in which the button was pressed.
# x -		Mouse x position.
# y - 		Mouse y position.

proc tkTextSelectTo {w x y} {
    global tkPriv

    set cur [$w index @$x,$y]
    if [catch {$w index anchor}] {
	$w mark set anchor $cur
    }
    set anchor [$w index anchor]
    if {[$w compare $cur != $anchor] || (abs($tkPriv(pressX) - $x) >= 3)} {
	set tkPriv(mouseMoved) 1
    }
    switch $tkPriv(selectMode) {
	char {
	    if [$w compare $cur < anchor] {
		set first $cur
		set last anchor
	    } else {
		set first anchor
		set last [$w index "$cur + 1c"]
	    }
	}
	word {
	    if [$w compare $cur < anchor] {
		set first [$w index "$cur wordstart"]
		set last [$w index "anchor - 1c wordend"]
	    } else {
		set first [$w index "anchor wordstart"]
		set last [$w index "$cur wordend"]
	    }
	}
	line {
	    if [$w compare $cur < anchor] {
		set first [$w index "$cur linestart"]
		set last [$w index "anchor - 1c lineend + 1c"]
	    } else {
		set first [$w index "anchor linestart"]
		set last [$w index "$cur lineend + 1c"]
	    }
	}
    }
    if {$tkPriv(mouseMoved) || ($tkPriv(selectMode) != "char")} {
	$w tag remove sel 0.0 $first
	$w mark set sel.first $first
	$w mark set sel.last $last
	$w tag add sel $first $last
	$w tag remove sel $last end
	$w mark set insert $last
	update idletasks
    }
}

# tkTextKeyExtend --
# This procedure handles extending the selection from the keyboard,
# where the point to extend to is really the boundary between two
# characters rather than a particular character.
#
# Arguments:
# w -		The text window.
# index -	The point to which the selection is to be extended.

proc tkTextKeyExtend {w index} {
    global tkPriv

    set cur [$w index $index]
    if [catch {$w index anchor}] {
	$w mark set anchor $cur
    }
    set anchor [$w index anchor]
    if [$w compare $cur < anchor] {
	set first $cur
	set last anchor
    } else {
	set first anchor
	set last $cur
    }
    $w tag remove sel 0.0 $first
    $w tag add sel $first $last
    $w tag remove sel $last end
}

# tkTextAutoScan --
# This procedure is invoked when the mouse leaves a text window
# with button 1 down.  It scrolls the window up, down, left, or right,
# depending on where the mouse is (this information was saved in
# tkPriv(x) and tkPriv(y)), and reschedules itself as an "after"
# command so that the window continues to scroll until the mouse
# moves back into the window or the mouse button is released.
#
# Arguments:
# w -		The text window.

proc tkTextAutoScan {w} {
    global tkPriv
    if {$tkPriv(y) >= [winfo height $w]} {
	$w yview scroll 2 units
    } elseif {$tkPriv(y) < 0} {
	$w yview scroll -2 units
    } elseif {$tkPriv(x) >= [winfo width $w]} {
	$w xview scroll 2 units
    } elseif {$tkPriv(x) < 0} {
	$w xview scroll -2 units
    } else {
	return
    }
    tkTextSelectTo $w $tkPriv(x) $tkPriv(y)
    set tkPriv(afterId) [after 50 tkTextAutoScan $w]
}

# tkTextSetCursor
# Move the insertion cursor to a given position in a text.  Also
# clears the selection, if there is one in the text, and makes sure
# that the insertion cursor is visible.  Also, don't let the insertion
# cursor appear on the dummy last line of the text.
#
# Arguments:
# w -		The text window.
# pos -		The desired new position for the cursor in the window.

proc tkTextSetCursor {w pos} {
    global tkPriv

    if [$w compare $pos == end] {
	set pos {end - 1 chars}
    }
    $w mark set insert $pos
    $w see insert
}

# tkTextKeySelect
# This procedure is invoked when stroking out selections using the
# keyboard.  It moves the cursor to a new position, then extends
# the selection to that position.
#
# Arguments:
# w -		The text window.
# new -		A new position for the insertion cursor (the cursor hasn't
#		actually been moved to this position yet).

proc tkTextKeySelect {w new} {
    global tkPriv

    if {[$w tag nextrange sel 1.0 end] == ""} {
	if [$w compare $new < insert] {
	    $w tag add sel $new insert
	} else {
	    $w tag add sel insert $new
	}
	$w mark set anchor insert
    } else {
	if [$w compare $new < anchor] {
	    set first $new
	    set last anchor
	} else {
	    set first anchor
	    set last $new
	}
	$w tag remove sel 1.0 $first
	$w tag add sel $first $last
	$w tag remove sel $last end
    }
    $w mark set insert $new
    $w see insert
    update idletasks
}

# tkTextResetAnchor --
# Set the selection anchor to whichever end is farthest from the
# index argument.  One special trick: if the selection has two or
# fewer characters, just leave the anchor where it is.  In this
# case it doesn't matter which point gets chosen for the anchor,
# and for the things like Shift-Left and Shift-Right this produces
# better behavior when the cursor moves back and forth across the
# anchor.
#
# Arguments:
# w -		The text widget.
# index -	Position at which mouse button was pressed, which determines
#		which end of selection should be used as anchor point.

proc tkTextResetAnchor {w index} {
    global tkPriv

    if {[$w tag ranges sel] == ""} {
	$w mark set anchor $index
	return
    }
    set a [$w index $index]
    set b [$w index sel.first]
    set c [$w index sel.last]
    if [$w compare $a < $b] {
	$w mark set anchor sel.last
	return
    }
    if [$w compare $a > $c] {
	$w mark set anchor sel.first
	return
    }
    scan $a "%d.%d" lineA chA
    scan $b "%d.%d" lineB chB
    scan $c "%d.%d" lineC chC
    if {$lineB < $lineC+2} {
	set total [string length [$w get $b $c]]
	if {$total <= 2} {
	    return
	}
	if {[string length [$w get $b $a]] < ($total/2)} {
	    $w mark set anchor sel.last
	} else {
	    $w mark set anchor sel.first
	}
	return
    }
    if {($lineA-$lineB) < ($lineC-$lineA)} {
	$w mark set anchor sel.last
    } else {
	$w mark set anchor sel.first
    }
}

# tkTextInsert --
# Insert a string into a text at the point of the insertion cursor.
# If there is a selection in the text, and it covers the point of the
# insertion cursor, then delete the selection before inserting.
#
# Arguments:
# w -		The text window in which to insert the string
# s -		The string to insert (usually just a single character)

proc tkTextInsert {w s} {
    if {($s == "") || ([$w cget -state] == "disabled")} {
	return
    }
    catch {
	if {[$w compare sel.first <= insert]
		&& [$w compare sel.last >= insert]} {
	    $w delete sel.first sel.last
	}
    }
    $w insert insert $s
    $w see insert
}

# tkTextUpDownLine --
# Returns the index of the character one line above or below the
# insertion cursor.  There are two tricky things here.  First,
# we want to maintain the original column across repeated operations,
# even though some lines that will get passed through don't have
# enough characters to cover the original column.  Second, don't
# try to scroll past the beginning or end of the text.
#
# Arguments:
# w -		The text window in which the cursor is to move.
# n -		The number of lines to move: -1 for up one line,
#		+1 for down one line.

proc tkTextUpDownLine {w n} {
    global tkPriv

    set i [$w index insert]
    scan $i "%d.%d" line char
    if {[string compare $tkPriv(prevPos) $i] != 0} {
	set tkPriv(char) $char
    }
    set new [$w index [expr $line + $n].$tkPriv(char)]
    if {[$w compare $new == end] || [$w compare $new == "insert linestart"]} {
	set new $i
    }
    set tkPriv(prevPos) $new
    return $new
}

# tkTextPrevPara --
# Returns the index of the beginning of the paragraph just before a given
# position in the text (the beginning of a paragraph is the first non-blank
# character after a blank line).
#
# Arguments:
# w -		The text window in which the cursor is to move.
# pos -		Position at which to start search.

proc tkTextPrevPara {w pos} {
    set pos [$w index "$pos linestart"]
    while 1 {
	if {(([$w get "$pos - 1 line"] == "\n") && ([$w get $pos] != "\n"))
		|| ($pos == "1.0")} {
	    if [regexp -indices {^[ 	]+(.)} [$w get $pos "$pos lineend"] \
		    dummy index] {
		set pos [$w index "$pos + [lindex $index 0] chars"]
	    }
	    if {[$w compare $pos != insert] || ($pos == "1.0")} {
		return $pos
	    }
	}
	set pos [$w index "$pos - 1 line"]
    }
}

# tkTextNextPara --
# Returns the index of the beginning of the paragraph just after a given
# position in the text (the beginning of a paragraph is the first non-blank
# character after a blank line).
#
# Arguments:
# w -		The text window in which the cursor is to move.
# start -	Position at which to start search.

proc tkTextNextPara {w start} {
    set pos [$w index "$start linestart + 1 line"]
    while {[$w get $pos] != "\n"} {
	if [$w compare $pos == end] {
	    return [$w index "end - 1c"]
	}
	set pos [$w index "$pos + 1 line"]
    }
    while {[$w get $pos] == "\n"} {
	set pos [$w index "$pos + 1 line"]
	if [$w compare $pos == end] {
	    return [$w index "end - 1c"]
	}
    }
    if [regexp -indices {^[ 	]+(.)} [$w get $pos "$pos lineend"] \
	    dummy index] {
	return [$w index "$pos + [lindex $index 0] chars"]
    }
    return $pos
}

# tkTextScrollPages --
# This is a utility procedure used in bindings for moving up and down
# pages and possibly extending the selection along the way.  It scrolls
# the view in the widget by the number of pages, and it returns the
# index of the character that is at the same position in the new view
# as the insertion cursor used to be in the old view.
#
# Arguments:
# w -		The text window in which the cursor is to move.
# count -	Number of pages forward to scroll;  may be negative
#		to scroll backwards.

proc tkTextScrollPages {w count} {
    set bbox [$w bbox insert]
    $w yview scroll $count pages
    if {$bbox == ""} {
	return [$w index @[expr [winfo height $w]/2],0]
    }
    return [$w index @[lindex $bbox 0],[lindex $bbox 1]]
}

# tkTextTranspose --
# This procedure implements the "transpose" function for text widgets.
# It tranposes the characters on either side of the insertion cursor,
# unless the cursor is at the end of the line.  In this case it
# transposes the two characters to the left of the cursor.  In either
# case, the cursor ends up to the right of the transposed characters.
#
# Arguments:
# w -		Text window in which to transpose.

proc tkTextTranspose w {
    set pos insert
    if [$w compare $pos != "$pos lineend"] {
	set pos [$w index "$pos + 1 char"]
    }
    set new [$w get "$pos - 1 char"][$w get  "$pos - 2 char"]
    if [$w compare "$pos - 1 char" == 1.0] {
	return
    }
    $w delete "$pos - 2 char" $pos
    $w insert insert $new
    $w see insert
}

proc tk_Ask_ text {
   global tk_Ready
   catch {destroy .tk_askwin}
   toplevel .tk_askwin -class Dialog
   frame .tk_askwin.top -relief raised -bd 1
   pack .tk_askwin.top -side top -expand 1 -fill both
   frame .tk_askwin.bot -relief raised -bd 1
   pack .tk_askwin.bot -side bottom
   entry .tk_askwin.answer -width 20 -textvariable tk_Answer
   set tk_Answer ""
   bind .tk_askwin.answer <Return> {
      destroy .tk_askwin
      set tk_Ready 1
   }
   pack .tk_askwin.answer -in .tk_askwin.top -side top -expand 1 -fill both
   button .tk_askwin.cancel -text "Cancel" -command {
      destroy .tk_askwin
      set tk_Answer ""
      set tk_Ready 1
   }
   button .tk_askwin.ok -text "OK" -command {
      destroy .tk_askwin
      set tk_Ready 1
   }
   pack .tk_askwin.cancel .tk_askwin.ok -in .tk_askwin.bot -side left
   focus .tk_askwin.answer
}

proc tk_Ask text {
   global tk_Ready tk_Answer
   set tk_Ready 0
   tk_Ask_ $text
   while {!$tk_Ready} {
      after 50
      update
   }
   return $tk_Answer
}

proc tk_AskSearch AWin {
   global tk_SearchString tk_SearchCaseYN tk_Result tk_AWin

   set tk_AWin $AWin
   catch {destroy .tk_searchwin}
   toplevel .tk_searchwin -class Dialog
   frame .tk_searchwin.top -relief raised -bd 1
   pack .tk_searchwin.top -side top -expand 1 -fill both
   frame .tk_searchwin.bot -relief raised -bd 1
   pack .tk_searchwin.bot -side bottom
   label .tk_searchwin.search_txt -text "Search For"
   entry .tk_searchwin.search -width 20 -textvariable tk_SearchString
   set tk_SearchString ""
   bind .tk_searchwin.search <Return> { tk_SearchNext $tk_AWin }
   label .tk_searchwin.replace_txt -text "Replace With"
   entry .tk_searchwin.replace -width 20 -textvariable tk_ReplaceString
   set tk_ReplaceString ""
   bind .tk_searchwin.replace <Return> { tk_ReplaceNext $tk_AWin }
   pack .tk_searchwin.search_txt .tk_searchwin.search \
         .tk_searchwin.replace_txt .tk_searchwin.replace \
         -in .tk_searchwin.top -side top -expand 1 -fill both
   set tk_SearchCaseYN 0
   checkbutton .tk_searchwin.case -text "Case" -variable tk_SearchCaseYN
   button .tk_searchwin.quit -text "Dismiss" -command {destroy .tk_searchwin}
   button .tk_searchwin.next -text "S-Next" -command {tk_SearchNext $tk_AWin}
   button .tk_searchwin.prev -text "S-Prev" -command {tk_SearchPrev $tk_AWin}
   pack .tk_searchwin.quit .tk_searchwin.case .tk_searchwin.next .tk_searchwin.prev\
         -in .tk_searchwin.bot -side left
   focus .tk_searchwin.search
}

proc tk_ReplaceNext AWin {
   global tk_SearchString tk_ReplaceString tk_Result
   
   set tk_Result 0
   set xl [string length $tk_ReplaceString]
   if {[$AWin index insert] != 1.0} {
      $AWin mark set insert "insert - 1 char"
      tk_SearchNext $AWin
   }
   if {$tk_Result} {
      $AWin delete found1 found2
      $AWin insert insert $tk_ReplaceString
      $AWin mark set found1 "insert - $xl char"
      $AWin mark set found2 insert
      $AWin tag add found found1 found2
      $AWin tag configure found -background "#ffa0a0"
   }
   $AWin yview -pickplace insert
   focus $AWin
}

proc tk_SearchNext AWin {
   global tk_SearchString tk_SearchCaseYN tk_Result
   set tk_Result 0
   if {$tk_SearchCaseYN} {
      set SearchFor $tk_SearchString
   } else {
      set SearchFor "[string tolower "$tk_SearchString"]"
   }
   set xl [string length $SearchFor]
   if {$xl > 0} {set xl [expr $xl - 1]}
   $AWin mark set last "insert + 1 char"
   if {[$AWin index insert] == 1.0} {
      catch {
         scan [$AWin index found2] %d.%d l c
         set c [expr $c - 1]
         if {($c != $xl) || ($l != 1)} {
            $AWin mark set last 1.0
         }
      }
   }
   $AWin tag delete found
   scan [$AWin index insert] %d.%d line char
   scan [$AWin index end] %d numLines
   if {$tk_SearchCaseYN} {
      set s "[$AWin get last end]"
   } else {
      set s "[string tolower [$AWin get last end]]"
   }
   set x [string first "$SearchFor" "$s"]
   if {$x >= 0} {
      $AWin mark set found1 "last + $x chars"
      $AWin mark set found2 "last + [expr $x + $xl + 1] chars"
      $AWin mark set insert found1
      $AWin tag add found found1 found2
      $AWin tag configure found -background "#ffa0a0"
      set tk_Result 1
   }
   $AWin yview -pickplace insert
}


proc tk_SearchPrev AWin {
   global tk_SearchString tk_SearchCaseYN tk_Result
          
   if {$tk_SearchCaseYN} {
      set SearchFor $tk_SearchString
   } else {
      set SearchFor [string tolower "$tk_SearchString"]
   }
   set tk_Result 0
   set xl [string length $SearchFor]
   if {$xl > 0} {set xl [expr $xl - 1]}
   $AWin mark set last1 insert
   $AWin tag delete found
   scan [$AWin index insert] %d.%d line char
   set numLines $line
   for {set i $line} {$i > 0} {set i [expr $i - 1]} {
      $AWin mark set last $i.0
      if {$line == $i} {
         set z [$AWin get last $i.$char]
      } else {
         set z [$AWin get last "last lineend"]
      }
      if {$tk_SearchCaseYN} {
         set s $z
      } else {
         set s "[string tolower $z]"
      }
      set x [string last $SearchFor $s]
      if {$x >= 0} {
         $AWin mark set found1 "last + $x chars"
         $AWin mark set found2 "last + [expr $x + $xl + 1] chars"
         $AWin mark set insert found1
         $AWin tag add found found1 found2
         $AWin tag configure found -background "#ffa0a0"
         set tk_Result 1
         break
      }
   }
   $AWin yview -pickplace insert
}

proc tk_MatchBracket AWin {
   global Cancel
   
   $AWin tag delete match
   set c [$AWin get insert]
   switch $c {
      "("  {tk_MatchBracketFWD $AWin "(" ")"}
      "\{" {tk_MatchBracketFWD $AWin "\{" "\}"}
      "\[" {tk_MatchBracketFWD $AWin "\[" "\]"}
      ")"  {tk_MatchBracketBWD $AWin ")" "("}
      "\}" {tk_MatchBracketBWD $AWin "\}" "\{"}
      "\]" {tk_MatchBracketBWD $AWin "\]" "\["}
   }
}

proc tk_MatchBracketBWD {AWin c y} {
   global Cancel

   $AWin mark set match2 "insert + 1 char"
   $AWin mark set match1 match2
   set Cancel 0
   set i 1
   while {!$Cancel} {
      set i [string last $y [$AWin get 1.0 "match1 - 1 char"]]
      if {$i <= 0} {set i 1 ; break}
      incr i
      $AWin mark set match1 "1.0 + $i char"
      set s [$AWin get match1 insert]
      set i [string last $c $s]
      if {$i >= 0} {
         $AWin mark set insert "match1 + $i char"
      } else {
         $AWin mark set match1 "match1 - 1 char"
         $AWin mark set insert match2
         $AWin tag add match match1 match2
         $AWin tag configure match -background "#a0ffa0"
         $AWin mark set insert match1
         break
      }
   }
   if {($i >= 0) || ($Cancel)} {$AWin mark set insert "match2 - 1 char"}
   $AWin yview -pickplace insert
}

proc tk_MatchBracketFWD {AWin c y} {
   global Cancel

   $AWin mark set match1 insert
   $AWin mark set match2 "match1 + 1 char"
   $AWin mark set insert match2
   set Cancel 0
   set i 1
   while {!$Cancel} {
      set i [string first $y [$AWin get match2 end]]
      incr i
      if {$i <= 0} {set i 1 ; break}
      $AWin mark set match2 "match2 + $i char"
      set s [$AWin get insert match2]
      set i [string first $c $s]
      if {$i >= 0} {
         incr i
         $AWin mark set insert "insert + $i char"
      } else {
         $AWin mark set insert "match2 - 1 char"
         $AWin tag add match match1 match2
         $AWin tag configure match -background "#a0ffa0"
         break
      }
   }
   if {($i >= 0) || ($Cancel)} {$AWin mark set insert match1}
   $AWin yview -pickplace insert
}

proc tk_ToPaste text {
   global env
   set f [open $env(HOME)/.pastebuffer w]
   puts -nonewline $f "$text"
   close $f
}

proc tk_FromPaste { } {
   global env
   set x ""
   set f [open $env(HOME)/.pastebuffer]
   while {![eof $f]} {
      set x "$x[read $f 1000]"
   }   
   close $f
   return $x
}

proc tk_GetXSelect { } {
   if {[catch {set s [selection get STRING]}]} {
      set s ""
   }
   return "$s"
}

proc tk_PasteFromClip AWin {
   scan [$AWin index insert] %d lastl
   set t ""
   catch {set t [selection get TARGETS]}
   if {[lsearch $t STRING] >= 0} {
      $AWin insert insert [tk_GetXSelect]
   } else {
      $AWin insert insert [tk_FromPaste]
   }
   $AWin yview -pickplace insert
}

proc tk_Capitalize AWin {
   global tk_YankBuffer
   
   set tk_YankBuffer [$AWin get "insert wordstart" "insert wordend"]
   $AWin delete "insert wordstart" "insert wordend"
   set tk_YankBuffer [string toupper $tk_YankBuffer]
   $AWin insert insert "$tk_YankBuffer"
}
proc tk_LowerCase AWin {
   global tk_YankBuffer
   
   set tk_YankBuffer [$AWin get "insert wordstart" "insert wordend"]
   $AWin delete "insert wordstart" "insert wordend"
   set tk_YankBuffer [string tolower $tk_YankBuffer]
   $AWin insert insert "$tk_YankBuffer"
}





