' $Id: dbconnect.n,v 1.3 1995/07/11 19:59:22 jfontain Exp $
.TH dbconnect tcl
.BS
.SH NAME
dbconnect \- connect to a SQL database
.SH SYNOPSIS
\fBdbconnect \fIengine name ?debugLevel?\fR
.SH DESCRIPTION
.PP
Connect to an existing database named \fIname\fR using the specified \fIengine\fR. If successful, a unique connection identifier is returned, which may be used for accessing the database (see \fBdbsql\fR, \fBdbcursor\fR, ... manual pages).
.PP
The number of simultaneous connections depends on the database engine. Usually at least 4 are allowed at one time.
.PP
An error occurs if the database does not exist or cannot be accessed.
.PP
The format of the database name depends on the \fIengine\fR. The name must be inclosed in simple quotes, as in other SQL transactions involving strings.
.PP
The debug level can optionally be set for this transaction (see \fBdbdebug\fR manual page).
.SH EXAMPLES
.PP
set connection [\fBdbconnect \fIshql '/usr/database/main'\fR]
.PP
set connection [\fBdbconnect \fIoracle7 'accounts'\fR]
.SH KEYWORDS
.PP
dbconnect, dbsql, dbcursor, dbdebug, SQL, jdb, shql

