pack $win...
	-fill -expand
	-after -before -in
	-padx -pady -ipadx -ipady
	-anchor -side

-after sibling_win
Instead of using the parent of 
^S^win
 as its master, use the parent of 
^S^sibling_win
 as the master. 
^S^win
 will be inserted in the packing order after 
^S^sibling_win
, which affects the way events are processed. See the 
^I^tcl/tk
 documentation for more details on packing order. See also 
^B^-in
 and 
^B^-before
.

-before sibling_win
Similar to 
^B^-after, but 
^S^win
 is inserted in the packing order before 
^S^sibling_win
. See also 
^S^-in
.

-in master_win
Normally, a window's master (containing) window is its parent, but the
^B^-in
 option can be used to specify a different master window. This is commonly 
used with frames, so that a window may be placed in a master frame which 
forces some sort of alignment on it, but still be parented (logically 
controlled) by the window which "conceptually" contains it--usually an 
ancestor of the frame. See also 
^B^-before
 and 
^B^-after
.

-ipadx dist
Inserts extra padding at each side of the widget, but inside the widget. 
For example, a button showing the text "OK" will need to be a certain width 
in order to display its label. Using the 
^B^-ipadx
 option requests  more space within the button on each side of the "OK" label, which will 
make the entire button wider.

-ipady dist
Similar to 
^B^-ipadx
, but requests more internal padding at the top and 
bottom of the widget(s) being packed.

-side side
Defines which side of a containing window 
^S^win
 will be packed into.  For example, if buttons 
^S^win1
, 
^S^win2
, and 
^S^win3
 are packed into a window 
^S^container
 with 
^B^-side
 set to 
^B^left
, then 
^S^win1
 will first be packed into the left side of 
^S^container
, leaving the remaining free space in 
^S^container
 to its right; then 
^S^win2
 will be packed in the left side of that remaining free space, and finally 
^S^win3
 will be packed in the free space left by 
^S^win2
, so that 
^S^win1
, 
^S^win2
, and 
^S^win3
 will display left-to-right on the screen.

-expand bool
Controls whether 
^S^win
 will expand its zone to use up the extra space around 
it. If used in conjunction with 
^B^-fill
, this will cause 
^S^win
 (and its siblings packed using the same 
^B^pack
 command--remember, 
^B^pack 
can be used to pack any number of windows at one time) to 
actually expand to use free space, otherwise it will cause them to be distributed 
evenly throughout the free space. Note that 
^B^-expand
 will only cause vertical expansion for windows packed using 
^B^-top 
or 
^B^-bottom
, and will only cause horizontal expansion for windows packed using 
^B^-left
 or 
^B^-right
.

-fill fstyle
Controls whether 
^S^win
 will fill space in the 
^I^x
 or 
^I^y
 (or both) directions. 
For example, 
^P^
^T^
^TW^pack 
^S^win
^TW^ -side top -fill x 
^P^
will ensure that 
^S^win
 is as wide as its containing frame. Note that 
^P^
^T^
^TW^pack 
^S^win
^TW^ -side left -fill x 
^P^will 
^I^not
 make 
^S^win
 the width of its enclosing frame, because the free space to the 
right of 
^S^win
 is considered space that can still be filled by further pack 
commands, and hence need not be filled by 
^S^win
.







