^TI^'
^TITW^exec 
^TIS^arg...
^TI^' Command
^P^
^B^exec
 causes one or more 
^I^subprocesses
 to be started. Subprocesses are entirely seperate programs or pieces of 
executing code, which can carry out computations independently of the 
original Tcl program. The exact format and capabilities of 
^B^exec
 may depend on the system (i.e. PC, UNIX, etc.) you are running it on. 
The descriptions below are for UNIX.
^P^
The arguments to 
^B^exec
 specify the subprocesses to execute; they take 
the form of a standard shell pipeline where each 
^S^arg
 becomes one word of a command, and each distinct command 
becomes a subprocess.
^P^
If an 
^S^arg
 (or pair of 
^S^arg
s) has one of the forms described below then it is used by 
^B^exec
 to control the 
flow of input and output among the subprocess(es). Such 
arguments will not be passed to the subprocess(es). In 
forms such as "
^B^< 
^S^fileName
", 
^S^fileName
 may either be in a separate argument from "<", or in the same argument with 
no intervening space (i.e. "
^B^<
^S^fileName
"). The following are the redirection characters/strings which may be used 
in this way:
^P^
^B^|
 : Separates distinct commands in the 
pipeline. The standard output of the preceding command will be piped 
into the standard input of the next command.
^P^
^B^|&
 : Separates distinct commands in the 
pipeline. Both standard output and standard error of the preceding 
command will be piped into the standard input of the next command. This 
form of redirection overrides forms such as 
^B^2>
 and 
^B^>&
.
^P^
^B^< 
^S^fileName
 : The file named by 
^S^fileName
 is opened and used as the standard input for the first 
command in the pipeline.
^P^
^B^<@ 
^S^fileId
 : 
^S^fileId
 must be the identifier for an open file, such as the return value 
from a previous call to 
^B^open
. It is used as the standard input for the first command in the pipeline. 
^S^fileId
 must have been opened for  reading.
^P^
^B^<< 
^S^value
 : 
^S^value
 is passed to the first command as the command's  standard input.
^P^
^B^> 
^S^fileName
 : Standard output from the last command is redirected to the file named 
^S^fileName
, overwriting its previous contents.
^P^
^B^2> 
^S^fileName
 : Standard error from all commands in the pipeline is redirected to the 
file named 
^S^fileName
, overwriting its previous contents. 
^P^
^B^>& 
^S^fileName
 : Both standard output from the last command and standard error from 
all commands are redirected to the file named 
^S^fileName
, overwriting its previous contents.
^P^
^B^>> 
^S^fileName
 : Standard output from the last command is redirected to the file named 
^S^fileName
,  appending to it rather than overwriting it. 
^P^
^B^2>> 
^S^fileName
 : Standard error from all commands in the pipeline is redirected to the 
file named 
^S^fileName
, appending to it rather than over writing it. 
^P^
^B^>>& 
^S^fileName
 : Both standard output from the last command and standard error from all 
commands are redirected to the file named 
^S^fileName
, appending to it rather than overwriting it. 
^P^
^B^>@ 
^S^fileId
 : 
^S^fileId
 must be the identifier for an open file, such as the return value from a 
pre vious call to 
^B^open
. Standard output from the last command is redirected to 
^B^fileId
's  file, which must have been opened for writing. 
^P^
^B^2>@ 
^S^fileId
 : 
^S^fileId
 must be the identifier for an open  file, such as the return value from a 
previous call to 
^B^open
. Standard error from all commands in the pipeline is redirected to 
^S^fileId
's file. The file must have been opened for writing. 
^P^
^B^>&@ 
^S^fileId
 : 
^S^fileId
 must be the identifier for an open file, such as the return value from a 
previous call to 
^B^open
. Both standard output from the last command and standard error 
from all commands are redirected to 
^S^fileId
's file. The file must have been opened for writing.
^P^
If standard output has not been redirected then the 
^B^exec
 command returns the standard output from the last command 
in the pipeline. If any of the commands in the pipeline 
exit abnormally or are killed or suspended, then 
^B^exec
 will return an error and the error message will include the 
pipeline's output followed by error messages describing 
the abnormal terminations; the 
^B^errorCode
 variable will contain additional information about the last abnormal 
termination encountered. If any of the commands writes to 
its standard error file and that standard error isn't 
redirected, then 
^B^exec
 will return an error; the error 
message will include the pipeline's standard output, followed by messages 
about abnormal terminations (if any), 
followed by the standard error output.
^P^
If standard input isn't redirected with "<" or "<<" or 
"<@" then the standard input for the first command in 
the pipeline is taken from the application's current standard input.
^P^
If the last arg is "&" then the pipeline will be exe- 
cuted in background. In this case the 
^B^exec
 command will return a list whose elements are the process identifiers 
for all of the subprocesses in the pipeline. The standard 
output from the last command in the pipeline will go to 
the application's standard output if it hasn't been redirected, 
and error output from all of the commands in the 
pipeline will go to the application's standard error file 
unless redirected.
^P^
The first word in each command is taken as the command 
name; tilde-substitution is performed on it, and if the 
result contains no slashes then the directories in the 
^B^PATH
 environment variable are searched for an executable 
by the given name. If the name contains a slash then it 
must refer to an executable reachable from the current 
directory. No "glob" expansion or other shell-like substitutions 
are performed on the arguments to commands.












