# Canvas.tcl - itcl class based on the Tk canvas widget
# 
# Usage: Canvas $this.c [options]
# (see public variables for options)
#
# You can access the underlying canvas widget as $this.c.canvas...
#
# Copyright (C) 1994 Allan Brighton (allan@piano.sta.sub.org)


itcl_class Canvas {
    inherit FrameWidget

    # create the canvas and scrollbars

    constructor {config} {
	FrameWidget::constructor

	set canvas_ [canvas $this.canvas -scrollregion {0 0 0 0}]
	scrollbar $this.vscroll \
		-relief sunken \
		-command "$this.canvas yview"
	scrollbar $this.hscroll \
		-orient horiz \
		-relief sunken \
		-command "$this.canvas xview"
	$this.canvas config \
		-xscrollcommand "$this.hscroll set" \
		-yscrollcommand "$this.vscroll set"
	
	bind $canvas_ <ButtonPress-2> "$canvas_ scan mark %x %y"
	bind $canvas_ <B2-Motion> "$canvas_ scan dragto %x %y"

	pack $this.hscroll -side bottom -fill x
	pack $this.vscroll -side right -fill y
	pack $canvas_ -fill both -expand 1

	#  Explicitly handle config's that may have been ignored earlier
	foreach attr $config {
	    config -$attr [set $attr]
	}
    }


    # -- public variables --

    
    # pass these options on to the canvas widget
    foreach i {width height bg bd relief} {
	public $i {} [format {
	    if {[winfo exists $this.canvas]} {
		$this.canvas config -%s $%s
	    }
	} $i $i]
    }

    # -- protected variables --

    # canvas widget
    protected canvas_
}
