# ButtonFrame.tcl - itcl widget for displaying a frame with the standard
#                 buttons like "OK Cancel", with options for
#                 configuring other labels and actions
#
# Copyright (c) 1994 Allan Brighton (allan@piano.sta.sub.org)
#


itcl_class ButtonFrame {
    inherit FrameWidget


    # add a button to the row 

    method append {label cmd} {
	pack [button $this.but$seq_ -text $label -command $cmd] \
		-side left -fill x -expand 1 -padx 3m -pady 1m
	incr seq_
    }

    
    # create a row with 3 buttons

    constructor {config} {
	FrameWidget::constructor

	if {"$cancel_cmd" == ""} {
	    set cancel_cmd "destroy [winfo toplevel $this]"
	}
	
	append $ok_label $ok_cmd
	append $cancel_label $cancel_cmd
    }


    # public member variables

    # labels and commands for the standard buttons
    public ok_label {OK}
    public ok_cmd {}

    public cancel_label {Cancel}
    public cancel_cmd {}


    # protected vars

    # counter for button names
    protected seq_ {0}
}

