# Choice.tcl - itcl megawidget for choosing options using a label and radiobuttons
#              (uses blt_table to arrange the buttons in rows and columns)
#
# Copyright (C) 1994 Allan Brighton (allan@piano.sta.sub.org)
#


itcl_class Choice {
    inherit FrameWidget

    
    # return the current value of this option

    method get {} {
	global $this.choice
	return [set value [set $this.choice]]
    }

    
    # return true if the value has changed since it was last 
    # configured or read

    method changed {} {
	global $this.choice
	return [expr {"[set $this.choice]" != "$value"}]
    }

    # configure the individual buttons by name

    method itemconfig {name args} {
	eval "$but_($name) config $args"
    }

    
    constructor {config} {
	FrameWidget::constructor
	global $this.choice

	if {"$text" != ""} {
	    pack [label $this.label -text $text] \
		    -side $side_ -ipadx 1m -fill x
	}

	pack [set f [frame $this.rowcols]] -side $side_ -padx $padx -pady $pady -fill x
	blt_table $f

	set row 0
	set col 0
	set i 0
	set n [llength $choice]

	# determine how many rows and columns
	if {$rows != 0} {
	    set cols [expr $n/$rows+1]
	} elseif {$cols != 0} {
	    set rows [expr $n/$cols+1]
	} elseif {"$layout" == "horizontal"} {
	    set rows 1
	    set cols $n
	} else {
	    set rows $n
	    set cols 1
	}

	for {set row 0} {$row < $rows} {incr row} {
	    for {set col 0} {$col < $cols} {incr col} {
		set name [lindex $choice $i]
		set but_($name) \
		    [radiobutton $f.choice$i \
			 -text $name \
			 -value $name \
			 -variable $this.choice \
			 -command $command \
			 -state $state \
			 -anchor w]
		blt_table $f $but_($name) $row,$col -fill x
		if {[incr i] == $n} {
		    break
		}
	    }
	    if {$i == $n} {
		break
	    }
	}
	
	# set default value
	if {"$value" == ""} {
	    set $this.choice [lindex $choice 0]
	}

	#  Explicitly handle config's that may have been ignored earlier
	foreach attr $config {
	    config -$attr [set $attr]
	}
    }


    # public member variables


    # label for option
    public text {}

    # value to display
    public value {} {
	global $this.choice
	set $this.choice $value
    }

    # list of choices
    public choice {}

    # command to run when value is changed (new value is appended)
    public command {} {
	if {"$command" != ""} {
	    append command [format { ${%s}} $this.choice]
	}
    }
    
    # determines position for label and default layout for buttons
    public layout {horizontal} {
	if {"$layout" == "horizontal"} {
	    set side_ left
	} else {
	    set side_ top
	}
    }

    # max number of rows to display (0 for unlimited) 
    # note: specify either -rows OR -cols, but not both
    public rows 0

    # max number of columns to display (0 for unlimited)
    # note: specify either -rows OR -cols, but not both
    public cols 0

    # button states: normal, disabled
    public state {normal} {
	if {[info exists but_]} {
	    foreach i [array names but_] {
		$but_($i) config -state $state
	    }
	}
    }


    # set the width for  displaying the label
    public labelWidth {} {
	if {[winfo exists $this.label]} {
	    $this.label config -width $labelWidth
	}
    }
    
    # set the label anchor
    public anchor {w} {
	if {[winfo exists $this.label]} {
	    $this.label config -anchor $anchor
	}
    }

    # packing options for first button
    public padx {0}
    public pady {0}

    
    # protected members
    
    # array(name) of button widgets
    protected but_

    # pack option
    protected side_ {left}
}

