#!/usr/bin/tcl

#
# Copyright (c) 1994 Open Software Foundation, Inc.
# 
# Permission is hereby granted to use, copy, modify and freely distribute
# the software in this file and its documentation for any purpose without
# fee, provided that the above copyright notice appears in all copies, and
# that both the copyright notice and this permission notice appear in
# supporting documentation.  Further, provided that the name of Open
# Software Foundation, Inc. ("OSF") not be used in advertising or
# publicity pertaining to distribution of the software without prior
# written permission from OSF.  OSF makes no representations about the
# suitability of this software for any purpose.  It is provided "AS IS"
# without express or implied warranty.
#

proc print { str } {
    puts stdout $str
}


proc showCmd { function project criteria } {

    return [format {time %s -p%s %s > /dev/null} $function $project $criteria]
}


proc formCmd { function project criteria } {

    return [format {[exec sh -c {time %s -p%s %s > /dev/null}]} $function $project $criteria]

}

proc oneIteration { func iter } {

    global cmd proj res

#    catch { set a [exec sh -c {time ot_bugs -x '[desc tool] && [stat open]' > /dev/null}] } b

    foreach j [lsort [array names cmd]] {
	print [format {%s\n} [showCmd $func $proj $cmd($j)]]
#	print [formCmd $func $proj $cmd($j)]

	set b ""

	catch [concat set a [formCmd $func $proj $cmd($j)]] b
#	print -->$a<--
#	print -->$b<--

	regsub (.*)\nreal $b "\nreal" y

	scan $y "\nreal\t%s\nuser\t%s\nsys\t%s" \
		    res(c$j,i$iter,r) res(c$j,i$iter,u) res(c$j,i$iter,s)

	print [format {     real\t%s} $res(c$j,i$iter,r)]
	print [format {     user\t%s} $res(c$j,i$iter,u)]
	print [format {     sys \t%s\n} $res(c$j,i$iter,s)]

    }
}


proc dispSummary { func repeat } {

    global cmd proj res

    foreach j [lsort [array names cmd]] {
	print [showCmd $func $proj $cmd($j)]
        print [format {\n\treal\t\t\tuser\t\t\tsys\n}]

	foreach k "r u s" {
	    set sum($k,totsec) 0
	}

    # Print out results per command and accumulate sums of times

	for {set i 1} {$i <= $repeat} {incr i 1} {
	    print [format {\t%s\t\t\t%s\t\t\t%s} $res(c$j,i$i,r) $res(c$j,i$i,u) $res(c$j,i$i,s)]
	    foreach k "r u s" {
		set sum($k,totsec) [expr {$sum($k,totsec)+$res(c$j,i$i,$k)}]
	    }
	}

    # Calculate average time for a command and print it out

	foreach k "r u s" {
	    set av($k,sum) 0
	    set av($k,min) 0
	    set av($k,sec) 0
	
	    set av($k,totsec) [expr $sum($k,totsec)/$repeat.0]
	    set av($k,sum) [expr $av($k,totsec)/60.0]

	    scan $av($k,sum) "%d.%s" av($k,min) junk
	    set av($k,sec) [expr {$av($k,totsec)-($av($k,min)*60)}]

	    set dot [string first . $av($k,sec)]
	    set av($k,sec) [string range $av($k,sec) 0 [expr $dot+2]]
	}

	print "      ---------------------------------------------------------"
	print [format { aver:\t%s\t\t\t%s\t\t\t%s} $av(r,totsec) $av(u,totsec) $av(s,totsec)]
	print [format {\t%sm%ss   \t\t%sm%ss   \t\t%sm%ss\n\n} $av(r,min) $av(r,sec) $av(u,min) $av(u,sec) $av(s,min) $av(s,sec)]

    }
    return
}



proc perfTestOTB { proj repeat chkpoint } {

    set func "ot_bugs"

    print [format {\n%s\n} [exec date]]
    set str "Running ot_bugs Performance Test for project"
    print [format {%s '%s' (%d times, check point %d)\n\n} $str $proj $repeat $chkpoint]

    set i $repeat
    set j 0
    while { $i > 0 } {
	set num [expr $repeat-$i+1]
	print [format {          ***** ITERATION %d *****\n} $num]
	print [format {%s\n} [exec date]]

	oneIteration $func $num

	set i [expr $i-1]
	incr j

	print [format {\n%s\n} [exec date]]

	if {$j < $chkpoint} {
	    if {$i > 0} {
	        print [format {\f}]
	    } else {
	        print [format {\n\nPerformance Test completed\n%s} [exec date]]
	    }
	} else {
	    set j 0
	    print [format {\f\n         ***** INTERMEDIATE SUMMARY (%s iterations) *****\n} $num]
	    dispSummary $func $num
	    print [format {\f}]
	}
    }

#   print [format {Performance Test completed\n%s} [exec date]]


# Print out performance summary 
    print [format {\f\n        * * *  P E R F O R M A N C E     T E S T     S U M M A R Y  * * *\n}]
    dispSummary $func $repeat
    return
}


proc perfTestOT { proj } {

    global cmd 

    set func "ot"

    print [format {\n%s\n} [exec date]]
    print [format {Running OT Performance Test for project '%s' \n\n} $proj ]

#    set logfp [open ~nata/perfTestLog a]
#    puts $logfp [format {\n%s\n} [exec date]]
#    puts $logfp [format {Running OT Performance Test for project '%s' \n\n} $proj ]

#    catch { set a [exec sh -c {time ot_bugs -x '[desc tool] && [stat open]' > /dev/null}] } b

    foreach j [lsort [array names cmd]] {
	print [format {%s\n} [showCmd $func $proj $cmd($j)]]
#	puts $logfp [format {%s\n} [showCmd $func $proj $cmd($j)]]

	set b ""
	set otmsg ""
	set tm ""
	catch [concat set a [formCmd $func $proj $cmd($j)]] b

#	puts $logfp [format {-**->%s<-**-\n} $b]
#       print -**->$b<-**-

	regsub (.*)\nreal $b "\nreal" tm
	regsub \nreal(.*)\nuser(.*)\nsys(.*) $b "" otmsg

#       print -**->$tm<--**-

	scan $tm "\nreal\t%s\nuser\t%s\nsys\t%s" \
		    res(c$j,r) res(c$j,u) res(c$j,s)
	
	print $otmsg
	print [format {\t\treal\t%s} $res(c$j,r)]
	print [format {\t\tuser\t%s} $res(c$j,u)]
	print [format {\t\tsys \t%s\n\n} $res(c$j,s)]

    }

#    puts $logfp [format {\n\nPerformance Test completed\n%s} [exec date]]
#    close $logfp
    
    print [format {\n%s\n} [exec date]]
    print [format {\n\nPerformance Test completed\n%s} [exec date]]
}
