/* 
 * Copyright (c) 1994 Open Software Foundation, Inc.
 * 
 * Permission is hereby granted to use, copy, modify and freely distribute
 * the software in this file and its documentation for any purpose without
 * fee, provided that the above copyright notice appears in all copies, and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.  Further, provided that the name of Open
 * Software Foundation, Inc. ("OSF") not be used in advertising or
 * publicity pertaining to distribution of the software without prior
 * written permission from OSF.  OSF makes no representations about the
 * suitability of this software for any purpose.  It is provided "AS IS"
 * without express or implied warranty.
 */ 

/*
 * OT 3.0.2
 */

/*
 *	otNotify.c
 *
 */


/*
#include <stdlib.h>
*/
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <tcl.h>
#include <tclInt.h>
#include "ot.h"
#include "otInt.h"


#ifndef LINT
static char RCSid_otNotify[] =
    "$RCSfile: otNotify.c,v $ $Revision: 1.1.4.2 $ $Date: 1993/11/11 20:20:16 $";

#endif



/*
 *		List of functions defined in the otNotify.c
 *
 *	    otNotify()
 *	    otGetSubjectLine()
 *
 */



/*
 *                               otNotify
 *
 * Send notification as appropriate.
 *
 * Do various after-the-fact processing, including sending mail
 * about whatever has changed, and also creating a Summary file
 * containing all CRs in this directory..  Creating the Sum file
 * is done by calling the ot_make_sum program (we call the server
 * to do the work).
 *
 * All this is done asynchronously in a child...
 */

void
otNotify(proj, template, fname, rcsname, op, notify, msg, subject)
OTProject * proj;          /* project info */
OTTemplate * template;     /* validated template info */
OTFilen fname;             /* template file to append to e-mail */
OTFilen rcsname;           /* directory to run ot_make_sum on */
OTOperation op;            /* operation */
bool notify;               /* (in) TRUE or FALSE notification indicator */
char *msg;		   /* (in) change summary for mail message */
char *subject;		   /* (in) subject line for mail message */
{
    register int i, j, k;
    register char * result, *cp;
    register OTCompMail * cMp;
    int size;
    char maillist[NAMELEN*5];
    char mailcmd[NAMELEN];
    char command[COMMAND];
    char pipefn[COMMAND];
    struct stat statbuf;
    FILE *mail_fp, *fp;
    char *pipe_memp;
    OTErr notErr;
    Tcl_Interp *interp;
    OTErr err = OT_SUCCESS;


    interp = otCB->cb_pcb->pcb_interp;
#ifdef notdef
    if (!fork())    {


        /* Create a summary file first, so, even if notification fails, */
	/* Sum file will be up to date */

	sprintf(command, "%s: make_sum: %s %s\n", otCB->cb_pcb->pcb_uName, 
		proj->name, rcsname.dir);

	/* have server do ot_make_sum */
	result = otClient(proj, command, &err);   

#ifdef NATA
report an error if err != OT_SUCCESS ???
#endif

	sprintf(command, "%s: close: bye bye\n", otCB->cb_pcb->pcb_uName);
	result = otClient(proj, command, &err);    /* close up the connection */
#endif
        if (notify) {

	    maillist[0] = 0;
	    notErr = otTclEvalProc("notifyExplicit");
            if ( OT_WARN( notErr ) || OT_SYSTEM( notErr ) ) {
	        /*
		 * right now this never returns, so now they'll never know...
		 */
	    }
	    else if (notErr == OT_SUCCESS && interp->result[0]) {
		strcpy(maillist, interp->result);
		strcat(maillist, " ");
	    }
	    else if (notErr == OT_SUCCESS && !(interp->result[0])) {
		/* Means administrator sends no notif.for this CR */
	    }
	    else if (notErr == OT_TCL_NOPROC) {
		notErr = otTclEvalProc("notifyDepend");
		if ( OT_WARN( notErr ) || OT_SYSTEM( notErr ) ) {
		}
		else if (notErr == OT_SUCCESS && interp->result[0]) {
		    strcpy(maillist, interp->result);
		    strcat(maillist, " ");
		}
		else if (notErr == OT_SUCCESS && !(interp->result[0])) {
		    /* Means administrator sends no notif.for this CR */
		}
		else if (notErr == OT_TCL_NOPROC) {
		    /* no consequences */
		}

		/*
		 * Do default notification:  construct list of mail 
		 * recipients
		 */
		if (proj->proj_leader[0] != '#') {
		    strcat(maillist, proj->proj_leader);
		    strcat(maillist, " ");
		}
		k = strlen(maillist);

		for (i=0; template->tr[i].field && template->tr[i].field[0]; i++) {
		    if (template->tr[i].value &&
			(template->tr[i].type == TYPE_MAILNAME)) {
			for (j=0;  template->tr[i].value[j] &&
			    (template->tr[i].value[j] != '#'); j++)
			    maillist[k++] = template->tr[i].value[j];
			maillist[k++] = ' ';
			maillist[k] = 0;
		    }
		}

		/*
		 * Add anyone associated with the Component Name in the 
		 * project.def file.
		 */
		if (cp = otGetHeaderFieldValue("Component Name", template)) {
		    for (cMp=proj->cMlist;  cMp && strcmp(cMp->compName, cp);
			 cMp=cMp->next)	;
		    if (cMp) /* found an entry */
			strcat(maillist, cMp->unames);	/* add to mail names */
		}
	    }

	    for (i=0; maillist[i]; i++) {
		if (maillist[i] == ',')
		    maillist[i] = ' ';
	    }

	    if (!stat("/usr/bin/mailx", &statbuf)) 	/* send it... */
		strcpy(mailcmd, "mailx");
	    else
		strcpy(mailcmd, "Mail");

	    sprintf(command, "%s -s '%s' %s", mailcmd, subject, maillist);
	    strdelete(command, "#");
	    sprintf(pipefn, "%s%s", fname.dir, fname.name);

	    if ( (mail_fp = popen(command, "w")) == NULL ) {
		otPutPostedMessage(OT_POPEN);
		err = OT_POPEN;
#ifdef NATA
need to fnd a way to return an error to the caller rather than exit
#endif
		exit(1);
	    }

	    fprintf(mail_fp, "%s\n\n\n", msg);
	    if (stat(pipefn, &statbuf) != 0) {
		otPutPostedMessage(OT_STAT, pipefn);
		err = OT_STAT;
#ifdef NATA
need to fnd a way to return an error to the caller rather than exit
#endif
		exit(1);
	    }
	    size = statbuf.st_size;
	    if ( pipe_memp = (char *)malloc(size) ) {
		fp = fopen(pipefn, "r");
		fread(pipe_memp, size, 1, fp);
		fwrite(pipe_memp, size, 1, mail_fp);
	    } 
	    else {
		otPutPostedMessage(OT_MALLOC_LOCATION, "otNotify");
		err = OT_MALLOC_LOCATION;
#ifdef NATA
need to fnd a way to return an error to the caller rather than exit
#endif
		exit(1);
	    }

	    fclose(fp);
	    pclose(mail_fp);
	    free(pipe_memp);

	} /* end of if (notify) */
#ifdef notdef
	otCleanup();
	exit(0);

    } /* end of fork */
#endif
}



/*
 *                       otGetSubjectLine 
 *
 * TODO - no longer need fname argument.
 */
char *
otGetSubjectLine(origtStruct, tStruct, fname, operation, proj)
OTTemplate *origtStruct;
OTTemplate *tStruct;
OTFilen fname;
OTOperation operation;
OTProject *proj;
{
    static char subject[COMMAND];
    char *sp = &(subject[0]);
    char *cp;
    char *orig_status, *curr_status, *subject_status;
    char *desc, *verb;

    if ( !(desc = otGetHeaderFieldValue("Short Description", tStruct)) )
        desc = "(no desc)";
    orig_status = curr_status = subject_status = 0;
    if ( origtStruct && tStruct && 
	 (orig_status = otGetHeaderFieldValue("Status", origtStruct)) && 
	 (curr_status = otGetHeaderFieldValue("Status", tStruct)) ) {
	if (strcmp(orig_status, curr_status))
	    subject_status = curr_status;
    }

    for (cp=fname.name; *cp && ((*cp == 'c') || (*cp == '0')); cp++) ;
    if (operation == ENTER)
	verb = "created";
    else if (operation == CLOSE)
        verb = "closed";
    else if (operation == DELETE)
	verb = "deleted";
    else if (subject_status)
	verb = subject_status;
    else
        verb = "updated";

    sprintf(subject, "OT %s %s %ld %s: ", proj->name, proj->object_name,
	otGetIDNumValue(tStruct), verb);

    for ( cp = subject + strlen(subject); *desc; ) {
	if ( (*desc == '\n') || (*desc == '\t') ) {
	    *cp++ = ' ';
	    desc++;
	}
	else if ( *desc == '\'' )
	    desc++;
	else
	    *cp++ = *desc++;
    }
    *cp = 0;

    return sp;
}

