#--------------------dv--------------Wosql-Kommunikationsroutinen-------------

#-----------------------------------------------------------------------------
# getfromwosql {} laedt eine Tabelle vom Datenanzeigefenster des Programms 
#                 Wosql ein
#                 dp : Diagrammkennung des zu ladenen Diagramms 
#-----------------------------------------------------------------------------
#
proc getfromwosql {dp} {

   # Diagrammvariablen sichtbar machen
   #
   global diagdata

   # aktuelle Diagrammkennung
   #
   set adp $diagdata(diagram)

   set diagdata($dp.status) undefined
 
   # Prozedur nach WOSQL schicken, die beim Aufruf einen Ausschnitt des
   # Ergebnisfensters zurueckschickt
   # Das Ergebnis ist eine Liste von Tabellenzeilen
   #
   send wosql {
      proc dv_getlines {from to} {
         set package {}
         while {$from < $to} {
            lappend  package [.m.o.out get $from]
            incr from
         }
         return $package
      }
   }

   # Zeilenanzahl feststellen
   #
   set size [send wosql .m.o.out size]
   if {$size == 0} { 
      error "WOSQL result window is empty"
      # Anmerkung: hierhin wird nicht zurueckverzweigt
   }

   # Ladeanzeige initialisieren
   #
   createloadview $adp\_main.loadview "Get data from WOSQL..."

   # erstes Packet (Titelzeile) holen
   #
   set line [send wosql dv_getlines 0 1]

   # Spaltenanzahl nach colnum und ins Diagrammdatenfeld
   #
   set labels [string trim $line \{\}]
   set diagdata($dp.table) $line ;# Zeile in Tabelle 
   set colnum [llength $labels]
   set diagdata($dp.colnum) $colnum

   # Spaltentitel in Diagrammdatenfeld
   #
   set i 0
   foreach coltitle $labels {
      set diagdata($dp.coltitle$i) $coltitle
      incr i
   }

   # Spaltenlisten initialisieren
   #
   loop i 0 $colnum {
      set diagdata($dp.col$i) ""
   }

   # zweite Zeile holen
   #
   set line [send wosql dv_getlines 1 2]
   set line [string trim $line \{\}]
   lappend diagdata($dp.table) $line ;# Zeile in Tabelle 

   # Restlichen Zeilen in Packeten a 20 Zeilen einlesen
   #
   set lpos 2
   while {$lpos < $size} {
         
      # Daten Packetweise anfordern
      # 
      set from $lpos
      set to   [expr $lpos+20]
      if {$to > $size} {
         # Obere Grenze des Packetes ist groesser als Gesamtgroesse
         # => Obere Grenze auf Gesamtgroesse setzen
         set to $size
      }
      set package [send wosql dv_getlines $from $to]

      # Ladeanzeige aktualisieren
      #
      setloadview $adp\_main.loadview $to $size

      # Packet in Diagrammdatenstruktur einlesen
      #
      foreach line $package {
         lappend diagdata($dp.table) $line ;# Zeile in Tabelle 
         set i 0
         foreach colelem $line {
            # Spaltenelemente in zugehoerige Liste eintragen
            #
            lappend diagdata($dp.col$i) $colelem
            incr i
         }
      }
      incr lpos 20
   } ; # while $lpos < $size

   # Zeilenanzahl speichern
   #
   set diagdata($dp.rownum) $size

   # Ladeanzeige zerstoeren
   #
   destroyloadview $adp\_main.loadview

   # Spaltentypenlisten setzen
   #
   diagdatatype $dp

   # Status sichern
   #
   set diagdata($dp.status) defined
}

#------------------------------------------------------------------------------
# loadfromwosql {} Routine, die Daten vom Ergebnisfenster des Programms Wosql
#                  einlaedt 
#                  dp : widgetpfad des aktuellen diagramms
#------------------------------------------------------------------------------
#
proc loadfromwosql {dp} {

   # Diagrammvariablen sichtbar machen
   #
   global diagdata

   busy {

     # Daten aus Ergebnisfenster laden
     #
     getfromwosql $dp

     # Datenspalten in korrespondierenden Diagrammdatensatz kopieren
     #
     set db $diagdata($dp.diagrambuf)
     copyallcols $dp $db

     # Datensatz je nach domain transformieren
     #
     $diagdata($dp.transform) $db $dp

     # Fensterrefresh durchfuehren
     #
     refreshwindows $dp .
   }
}

#------------------------------------------------------------------------------
# concatfromwosql {} Routine, die Daten vom Ergebnisfenster des Programms Wosql
#                    an den aktuellen Datensatz anhaengt; dabei wird die
#                    neue Tabelle rechts neben die alte Tabelle gestellt
#                    dp : widgetpfad des Diagramms, an dem die Tabelle 
#                         angehaengt wird 
#------------------------------------------------------------------------------
#
proc concatfromwosql {dp} {

   # Diagrammvariablen sichtbar machen
   #
   global diagdata

   # alten Puffer loeschen
   #
   diagdatadelete .buffer

   # Tabelle aus dem Ergebnisfenster von WOSQL in Puffer Laden
   #
   busy {
      getfromwosql .buffer
      # Anmerkung: bei einem Einlesefehler wird hierhin nicht zurueckverzweigt

      # Tabelle an die Tabelle des aktuellen Diagramms anhaengen
      #
      if {$diagdata(.buffer.status) == "defined"} {
         # Daten wurden erfolgreich geladen =>
         # Puffer Daten anhaengen
         #
         set db $diagdata($dp.diagrambuf) 
         concattabels  $dp .buffer ;# Daten an aktuellen Datensatz haengen
         appendallcols $db .buffer ;# Datenspalten an korresp. Datensatz haengen

         # Datensatz je nach domain transformieren
         #
         $diagdata($dp.transform) $db $dp

         # Fensterrefresh durchfuehren
         #
         refreshwindows $dp .

      } ;# Daten definiert
   } ;# busy
} 
